// third_party/blink/public/mojom/messaging/user_activation_snapshot.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_USER_ACTIVATION_SNAPSHOT_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_USER_ACTIVATION_SNAPSHOT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/messaging/user_activation_snapshot.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/messaging/user_activation_snapshot.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/messaging/user_activation_snapshot.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/core/core_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {





class CORE_EXPORT UserActivationSnapshot {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UserActivationSnapshot, T>::value>;
  using DataView = UserActivationSnapshotDataView;
  using Data_ = internal::UserActivationSnapshot_Data;

  template <typename... Args>
  static UserActivationSnapshotPtr New(Args&&... args) {
    return UserActivationSnapshotPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UserActivationSnapshotPtr From(const U& u) {
    return mojo::TypeConverter<UserActivationSnapshotPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserActivationSnapshot>::Convert(*this);
  }


  UserActivationSnapshot();

  UserActivationSnapshot(
      bool has_been_active,
      bool was_active);


  ~UserActivationSnapshot();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UserActivationSnapshotPtr>
  UserActivationSnapshotPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UserActivationSnapshot::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UserActivationSnapshot::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UserActivationSnapshot::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserActivationSnapshot::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserActivationSnapshot::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserActivationSnapshot::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UserActivationSnapshot_UnserializedMessageContext<
            UserType, UserActivationSnapshot::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UserActivationSnapshot::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UserActivationSnapshot::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UserActivationSnapshot_UnserializedMessageContext<
            UserType, UserActivationSnapshot::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UserActivationSnapshot::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool has_been_active;
  
  bool was_active;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UserActivationSnapshot::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UserActivationSnapshot::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UserActivationSnapshot::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UserActivationSnapshot::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
UserActivationSnapshotPtr UserActivationSnapshot::Clone() const {
  return New(
      mojo::Clone(has_been_active),
      mojo::Clone(was_active)
  );
}

template <typename T, UserActivationSnapshot::EnableIfSame<T>*>
bool UserActivationSnapshot::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->has_been_active, other_struct.has_been_active))
    return false;
  if (!mojo::Equals(this->was_active, other_struct.was_active))
    return false;
  return true;
}

template <typename T, UserActivationSnapshot::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.has_been_active < rhs.has_been_active)
    return true;
  if (rhs.has_been_active < lhs.has_been_active)
    return false;
  if (lhs.was_active < rhs.was_active)
    return true;
  if (rhs.was_active < lhs.was_active)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::UserActivationSnapshot::DataView,
                                         ::blink::mojom::blink::UserActivationSnapshotPtr> {
  static bool IsNull(const ::blink::mojom::blink::UserActivationSnapshotPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::UserActivationSnapshotPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::UserActivationSnapshot::has_been_active) has_been_active(
      const ::blink::mojom::blink::UserActivationSnapshotPtr& input) {
    return input->has_been_active;
  }

  static decltype(::blink::mojom::blink::UserActivationSnapshot::was_active) was_active(
      const ::blink::mojom::blink::UserActivationSnapshotPtr& input) {
    return input->was_active;
  }

  static bool Read(::blink::mojom::blink::UserActivationSnapshot::DataView input, ::blink::mojom::blink::UserActivationSnapshotPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_USER_ACTIVATION_SNAPSHOT_MOJOM_BLINK_H_