// third_party/blink/public/mojom/messaging/transferable_message.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/messaging/transferable_message.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var array_buffer_contents$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/array_buffer/array_buffer_contents.mojom', '../array_buffer/array_buffer_contents.mojom.js');
  }
  var serialized_blob$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/serialized_blob.mojom', '../blob/serialized_blob.mojom.js');
  }
  var cloneable_message$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/messaging/cloneable_message.mojom', 'cloneable_message.mojom.js');
  }
  var delegated_capability$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/messaging/delegated_capability.mojom', 'delegated_capability.mojom.js');
  }
  var message_port_descriptor$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/messaging/message_port_descriptor.mojom', 'message_port_descriptor.mojom.js');
  }
  var user_activation_snapshot$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/messaging/user_activation_snapshot.mojom', 'user_activation_snapshot.mojom.js');
  }
  var task_attribution_id$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/messaging/task_attribution_id.mojom', 'task_attribution_id.mojom.js');
  }
  var static_bitmap_image$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/messaging/static_bitmap_image.mojom', 'static_bitmap_image.mojom.js');
  }



  function TransferableMessage(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TransferableMessage.prototype.initDefaults_ = function() {
    this.message = null;
    this.ports = null;
    this.streamChannels = null;
    this.arrayBufferContentsArray = null;
    this.imageBitmapContentsArray = null;
    this.userActivation = null;
    this.delegatedCapability = delegated_capability$.DelegatedCapability.kNone;
    this.taskStateId = null;
  };
  TransferableMessage.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TransferableMessage.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableMessage.message
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, cloneable_message$.CloneableMessage, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableMessage.ports
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(message_port_descriptor$.MessagePortDescriptor), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableMessage.streamChannels
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(message_port_descriptor$.MessagePortDescriptor), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableMessage.arrayBufferContentsArray
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(array_buffer_contents$.SerializedArrayBufferContents), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableMessage.imageBitmapContentsArray
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 16, static_bitmap_image$.SerializedStaticBitmapImage, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableMessage.userActivation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, user_activation_snapshot$.UserActivationSnapshot, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableMessage.delegatedCapability
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 48, delegated_capability$.DelegatedCapability);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableMessage.taskStateId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, task_attribution_id$.TaskAttributionId, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TransferableMessage.encodedSize = codec.kStructHeaderSize + 64;

  TransferableMessage.decode = function(decoder) {
    var packed;
    var val = new TransferableMessage();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.message =
        decoder.decodeStructPointer(cloneable_message$.CloneableMessage);
    val.ports =
        decoder.decodeArrayPointer(new codec.PointerTo(message_port_descriptor$.MessagePortDescriptor));
    val.streamChannels =
        decoder.decodeArrayPointer(new codec.PointerTo(message_port_descriptor$.MessagePortDescriptor));
    val.arrayBufferContentsArray =
        decoder.decodeArrayPointer(new codec.PointerTo(array_buffer_contents$.SerializedArrayBufferContents));
    val.imageBitmapContentsArray =
        decoder.decodeArrayPointer(static_bitmap_image$.SerializedStaticBitmapImage);
    val.userActivation =
        decoder.decodeStructPointer(user_activation_snapshot$.UserActivationSnapshot);
    val.delegatedCapability =
        decoder.decodeStruct(new codec.Enum(delegated_capability$.DelegatedCapability));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.taskStateId =
        decoder.decodeStructPointer(task_attribution_id$.TaskAttributionId);
    return val;
  };

  TransferableMessage.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TransferableMessage.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(cloneable_message$.CloneableMessage, val.message);
    encoder.encodeArrayPointer(new codec.PointerTo(message_port_descriptor$.MessagePortDescriptor), val.ports);
    encoder.encodeArrayPointer(new codec.PointerTo(message_port_descriptor$.MessagePortDescriptor), val.streamChannels);
    encoder.encodeArrayPointer(new codec.PointerTo(array_buffer_contents$.SerializedArrayBufferContents), val.arrayBufferContentsArray);
    encoder.encodeArrayPointer(static_bitmap_image$.SerializedStaticBitmapImage, val.imageBitmapContentsArray);
    encoder.encodeStructPointer(user_activation_snapshot$.UserActivationSnapshot, val.userActivation);
    encoder.encodeStruct(codec.Int32, val.delegatedCapability);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(task_attribution_id$.TaskAttributionId, val.taskStateId);
  };
  exports.TransferableMessage = TransferableMessage;
})();