// third_party/blink/public/mojom/messaging/transferable_message.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_TRANSFERABLE_MESSAGE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_TRANSFERABLE_MESSAGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/array_buffer/array_buffer_contents.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/delegated_capability.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/message_port_descriptor.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/user_activation_snapshot.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/task_attribution_id.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TransferableMessageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TransferableMessageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TransferableMessage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::CloneableMessageDataView>(
      in_message,
      message_fragment);

    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->message.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in TransferableMessage struct");

    decltype(Traits::ports(input)) in_ports = Traits::ports(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ports)::BaseType>
        ports_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& ports_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::MessagePortDescriptorDataView>>(
      in_ports,
      ports_fragment,
      &ports_validate_params);

    fragment->ports.Set(
        ports_fragment.is_null() ? nullptr : ports_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ports.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ports in TransferableMessage struct");

    decltype(Traits::stream_channels(input)) in_stream_channels = Traits::stream_channels(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stream_channels)::BaseType>
        stream_channels_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& stream_channels_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::MessagePortDescriptorDataView>>(
      in_stream_channels,
      stream_channels_fragment,
      &stream_channels_validate_params);

    fragment->stream_channels.Set(
        stream_channels_fragment.is_null() ? nullptr : stream_channels_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->stream_channels.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stream_channels in TransferableMessage struct");

    decltype(Traits::array_buffer_contents_array(input)) in_array_buffer_contents_array = Traits::array_buffer_contents_array(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->array_buffer_contents_array)::BaseType>
        array_buffer_contents_array_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& array_buffer_contents_array_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SerializedArrayBufferContentsDataView>>(
      in_array_buffer_contents_array,
      array_buffer_contents_array_fragment,
      &array_buffer_contents_array_validate_params);

    fragment->array_buffer_contents_array.Set(
        array_buffer_contents_array_fragment.is_null() ? nullptr : array_buffer_contents_array_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->array_buffer_contents_array.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null array_buffer_contents_array in TransferableMessage struct");

    decltype(Traits::image_bitmap_contents_array(input)) in_image_bitmap_contents_array = Traits::image_bitmap_contents_array(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_bitmap_contents_array)::BaseType>
        image_bitmap_contents_array_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& image_bitmap_contents_array_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SerializedStaticBitmapImageDataView>>(
      in_image_bitmap_contents_array,
      image_bitmap_contents_array_fragment,
      &image_bitmap_contents_array_validate_params);

    fragment->image_bitmap_contents_array.Set(
        image_bitmap_contents_array_fragment.is_null() ? nullptr : image_bitmap_contents_array_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image_bitmap_contents_array.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image_bitmap_contents_array in TransferableMessage struct");

    decltype(Traits::user_activation(input)) in_user_activation = Traits::user_activation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_activation)::BaseType> user_activation_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::UserActivationSnapshotDataView>(
      in_user_activation,
      user_activation_fragment);

    fragment->user_activation.Set(
        user_activation_fragment.is_null() ? nullptr : user_activation_fragment.data());

    
    mojo::internal::Serialize<::blink::mojom::DelegatedCapability>(
      Traits::delegated_capability(input),
      &fragment->delegated_capability);

    decltype(Traits::task_state_id(input)) in_task_state_id = Traits::task_state_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->task_state_id)::BaseType> task_state_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::TaskAttributionIdDataView>(
      in_task_state_id,
      task_state_id_fragment);

    fragment->task_state_id.Set(
        task_state_id_fragment.is_null() ? nullptr : task_state_id_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::TransferableMessage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TransferableMessageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void TransferableMessageDataView::GetMessageDataView(
    ::blink::mojom::CloneableMessageDataView* output) {
  auto pointer = data_->message.Get();
  *output = ::blink::mojom::CloneableMessageDataView(pointer, message_);
}
inline void TransferableMessageDataView::GetPortsDataView(
    mojo::ArrayDataView<::blink::mojom::MessagePortDescriptorDataView>* output) {
  auto pointer = data_->ports.Get();
  *output = mojo::ArrayDataView<::blink::mojom::MessagePortDescriptorDataView>(pointer, message_);
}
inline void TransferableMessageDataView::GetStreamChannelsDataView(
    mojo::ArrayDataView<::blink::mojom::MessagePortDescriptorDataView>* output) {
  auto pointer = data_->stream_channels.Get();
  *output = mojo::ArrayDataView<::blink::mojom::MessagePortDescriptorDataView>(pointer, message_);
}
inline void TransferableMessageDataView::GetArrayBufferContentsArrayDataView(
    mojo::ArrayDataView<::blink::mojom::SerializedArrayBufferContentsDataView>* output) {
  auto pointer = data_->array_buffer_contents_array.Get();
  *output = mojo::ArrayDataView<::blink::mojom::SerializedArrayBufferContentsDataView>(pointer, message_);
}
inline void TransferableMessageDataView::GetImageBitmapContentsArrayDataView(
    mojo::ArrayDataView<::blink::mojom::SerializedStaticBitmapImageDataView>* output) {
  auto pointer = data_->image_bitmap_contents_array.Get();
  *output = mojo::ArrayDataView<::blink::mojom::SerializedStaticBitmapImageDataView>(pointer, message_);
}
inline void TransferableMessageDataView::GetUserActivationDataView(
    ::blink::mojom::UserActivationSnapshotDataView* output) {
  auto pointer = data_->user_activation.Get();
  *output = ::blink::mojom::UserActivationSnapshotDataView(pointer, message_);
}
inline void TransferableMessageDataView::GetTaskStateIdDataView(
    ::blink::mojom::TaskAttributionIdDataView* output) {
  auto pointer = data_->task_state_id.Get();
  *output = ::blink::mojom::TaskAttributionIdDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_TRANSFERABLE_MESSAGE_MOJOM_SHARED_H_