// third_party/blink/public/mojom/messaging/static_bitmap_image.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/messaging/static_bitmap_image.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var bitmap$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/bitmap.mojom', '../../../../../skia/public/mojom/bitmap.mojom.js');
  }
  var exported_shared_image$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/exported_shared_image.mojom', '../../../../../gpu/ipc/common/exported_shared_image.mojom.js');
  }
  var sync_token$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/sync_token.mojom', '../../../../../gpu/ipc/common/sync_token.mojom.js');
  }
  var image_info$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/image_info.mojom', '../../../../../skia/public/mojom/image_info.mojom.js');
  }
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../../../mojo/public/mojom/base/values.mojom.js');
  }



  function AcceleratedStaticBitmapImage(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AcceleratedStaticBitmapImage.prototype.initDefaults_ = function() {
    this.sharedImage = null;
    this.syncToken = null;
    this.alphaType = 0;
    this.releaseCallback = new ImageReleaseCallbackPtr();
  };
  AcceleratedStaticBitmapImage.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AcceleratedStaticBitmapImage.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AcceleratedStaticBitmapImage.sharedImage
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, exported_shared_image$.ExportedSharedImage, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AcceleratedStaticBitmapImage.syncToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, sync_token$.SyncToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AcceleratedStaticBitmapImage.alphaType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, image_info$.AlphaType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AcceleratedStaticBitmapImage.releaseCallback
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 20, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AcceleratedStaticBitmapImage.encodedSize = codec.kStructHeaderSize + 32;

  AcceleratedStaticBitmapImage.decode = function(decoder) {
    var packed;
    var val = new AcceleratedStaticBitmapImage();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sharedImage =
        decoder.decodeStructPointer(exported_shared_image$.ExportedSharedImage);
    val.syncToken =
        decoder.decodeStructPointer(sync_token$.SyncToken);
    val.alphaType =
        decoder.decodeStruct(new codec.Enum(image_info$.AlphaType));
    val.releaseCallback =
        decoder.decodeStruct(new codec.Interface(ImageReleaseCallbackPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AcceleratedStaticBitmapImage.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AcceleratedStaticBitmapImage.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(exported_shared_image$.ExportedSharedImage, val.sharedImage);
    encoder.encodeStructPointer(sync_token$.SyncToken, val.syncToken);
    encoder.encodeStruct(codec.Int32, val.alphaType);
    encoder.encodeStruct(new codec.Interface(ImageReleaseCallbackPtr), val.releaseCallback);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ImageReleaseCallback_Release_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImageReleaseCallback_Release_Params.prototype.initDefaults_ = function() {
    this.token = null;
  };
  ImageReleaseCallback_Release_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImageReleaseCallback_Release_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImageReleaseCallback_Release_Params.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, sync_token$.SyncToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ImageReleaseCallback_Release_Params.encodedSize = codec.kStructHeaderSize + 8;

  ImageReleaseCallback_Release_Params.decode = function(decoder) {
    var packed;
    var val = new ImageReleaseCallback_Release_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStructPointer(sync_token$.SyncToken);
    return val;
  };

  ImageReleaseCallback_Release_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImageReleaseCallback_Release_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(sync_token$.SyncToken, val.token);
  };

  function SerializedStaticBitmapImage(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  SerializedStaticBitmapImage.Tags = {
    bitmap: 0,
    acceleratedImage: 1,
  };

  SerializedStaticBitmapImage.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  SerializedStaticBitmapImage.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "bitmap",
        "acceleratedImage",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a SerializedStaticBitmapImage member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(SerializedStaticBitmapImage.prototype, "bitmap", {
    get: function() {
      if (this.$tag != SerializedStaticBitmapImage.Tags.bitmap) {
        throw new ReferenceError(
            "SerializedStaticBitmapImage.bitmap is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SerializedStaticBitmapImage.Tags.bitmap;
      this.$data = value;
    }
  });
  Object.defineProperty(SerializedStaticBitmapImage.prototype, "acceleratedImage", {
    get: function() {
      if (this.$tag != SerializedStaticBitmapImage.Tags.acceleratedImage) {
        throw new ReferenceError(
            "SerializedStaticBitmapImage.acceleratedImage is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SerializedStaticBitmapImage.Tags.acceleratedImage;
      this.$data = value;
    }
  });


    SerializedStaticBitmapImage.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case SerializedStaticBitmapImage.Tags.bitmap:
          encoder.encodeStructPointer(bitmap$.BitmapN32, val.bitmap);
          break;
        case SerializedStaticBitmapImage.Tags.acceleratedImage:
          encoder.encodeStructPointer(AcceleratedStaticBitmapImage, val.acceleratedImage);
          break;
      }
      encoder.align();
    };


    SerializedStaticBitmapImage.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new SerializedStaticBitmapImage();
      var tag = decoder.readUint32();
      switch (tag) {
        case SerializedStaticBitmapImage.Tags.bitmap:
          result.bitmap = decoder.decodeStructPointer(bitmap$.BitmapN32);
          break;
        case SerializedStaticBitmapImage.Tags.acceleratedImage:
          result.acceleratedImage = decoder.decodeStructPointer(AcceleratedStaticBitmapImage);
          break;
      }
      decoder.align();

      return result;
    };


    SerializedStaticBitmapImage.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case SerializedStaticBitmapImage.Tags.bitmap:
          

    // validate SerializedStaticBitmapImage.bitmap
    err = messageValidator.validateStructPointer(data_offset, bitmap$.BitmapN32, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SerializedStaticBitmapImage.Tags.acceleratedImage:
          

    // validate SerializedStaticBitmapImage.acceleratedImage
    err = messageValidator.validateStructPointer(data_offset, AcceleratedStaticBitmapImage, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  SerializedStaticBitmapImage.encodedSize = 16;
  var kImageReleaseCallback_Release_Name = 0;

  function ImageReleaseCallbackPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ImageReleaseCallback,
                                                   handleOrPtrInfo);
  }

  function ImageReleaseCallbackAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ImageReleaseCallback, associatedInterfacePtrInfo);
  }

  ImageReleaseCallbackAssociatedPtr.prototype =
      Object.create(ImageReleaseCallbackPtr.prototype);
  ImageReleaseCallbackAssociatedPtr.prototype.constructor =
      ImageReleaseCallbackAssociatedPtr;

  function ImageReleaseCallbackProxy(receiver) {
    this.receiver_ = receiver;
  }
  ImageReleaseCallbackPtr.prototype.release = function() {
    return ImageReleaseCallbackProxy.prototype.release
        .apply(this.ptr.getProxy(), arguments);
  };

  ImageReleaseCallbackProxy.prototype.release = function(token) {
    var params_ = new ImageReleaseCallback_Release_Params();
    params_.token = token;
    var builder = new codec.MessageV0Builder(
        kImageReleaseCallback_Release_Name,
        codec.align(ImageReleaseCallback_Release_Params.encodedSize));
    builder.encodeStruct(ImageReleaseCallback_Release_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ImageReleaseCallbackStub(delegate) {
    this.delegate_ = delegate;
  }
  ImageReleaseCallbackStub.prototype.release = function(token) {
    return this.delegate_ && this.delegate_.release && this.delegate_.release(token);
  }

  ImageReleaseCallbackStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kImageReleaseCallback_Release_Name:
      var params = reader.decodeStruct(ImageReleaseCallback_Release_Params);
      this.release(params.token);
      return true;
    default:
      return false;
    }
  };

  ImageReleaseCallbackStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateImageReleaseCallbackRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kImageReleaseCallback_Release_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ImageReleaseCallback_Release_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateImageReleaseCallbackResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ImageReleaseCallback = {
    name: 'blink.mojom.ImageReleaseCallback',
    kVersion: 0,
    ptrClass: ImageReleaseCallbackPtr,
    proxyClass: ImageReleaseCallbackProxy,
    stubClass: ImageReleaseCallbackStub,
    validateRequest: validateImageReleaseCallbackRequest,
    validateResponse: null,
  };
  ImageReleaseCallbackStub.prototype.validator = validateImageReleaseCallbackRequest;
  ImageReleaseCallbackProxy.prototype.validator = null;
  exports.AcceleratedStaticBitmapImage = AcceleratedStaticBitmapImage;
  exports.SerializedStaticBitmapImage = SerializedStaticBitmapImage;
  exports.ImageReleaseCallback = ImageReleaseCallback;
  exports.ImageReleaseCallbackPtr = ImageReleaseCallbackPtr;
  exports.ImageReleaseCallbackAssociatedPtr = ImageReleaseCallbackAssociatedPtr;
})();