// third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_STATIC_BITMAP_IMAGE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_STATIC_BITMAP_IMAGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "skia/public/mojom/image_info.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AcceleratedStaticBitmapImageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AcceleratedStaticBitmapImageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AcceleratedStaticBitmapImage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::shared_image(input)) in_shared_image = Traits::shared_image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shared_image)::BaseType> shared_image_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::ExportedSharedImageDataView>(
      in_shared_image,
      shared_image_fragment);

    fragment->shared_image.Set(
        shared_image_fragment.is_null() ? nullptr : shared_image_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->shared_image.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shared_image in AcceleratedStaticBitmapImage struct");

    decltype(Traits::sync_token(input)) in_sync_token = Traits::sync_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sync_token)::BaseType> sync_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
      in_sync_token,
      sync_token_fragment);

    fragment->sync_token.Set(
        sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sync_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sync_token in AcceleratedStaticBitmapImage struct");

    
    mojo::internal::Serialize<::skia::mojom::AlphaType>(
      Traits::alpha_type(input),
      &fragment->alpha_type);

    decltype(Traits::release_callback(input)) in_release_callback = Traits::release_callback(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ImageReleaseCallbackInterfaceBase>>(
      in_release_callback,
      &fragment->release_callback,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->release_callback)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid release_callback in AcceleratedStaticBitmapImage struct");
  }

  static bool Deserialize(::blink::mojom::internal::AcceleratedStaticBitmapImage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AcceleratedStaticBitmapImageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SerializedStaticBitmapImageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::SerializedStaticBitmapImageDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::SerializedStaticBitmapImage_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::SerializedStaticBitmapImageDataView::Tag::kBitmap: {
    decltype(Traits::bitmap(input))
    in_bitmap = Traits::bitmap(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_bitmap)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
  in_bitmap,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null bitmap in SerializedStaticBitmapImage union");
    fragment->data.f_bitmap.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::SerializedStaticBitmapImageDataView::Tag::kAcceleratedImage: {
    decltype(Traits::accelerated_image(input))
    in_accelerated_image = Traits::accelerated_image(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_accelerated_image)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::AcceleratedStaticBitmapImageDataView>(
  in_accelerated_image,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null accelerated_image in SerializedStaticBitmapImage union");
    fragment->data.f_accelerated_image.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::SerializedStaticBitmapImage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SerializedStaticBitmapImageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void AcceleratedStaticBitmapImageDataView::GetSharedImageDataView(
    ::gpu::mojom::ExportedSharedImageDataView* output) {
  auto pointer = data_->shared_image.Get();
  *output = ::gpu::mojom::ExportedSharedImageDataView(pointer, message_);
}
inline void AcceleratedStaticBitmapImageDataView::GetSyncTokenDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->sync_token.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, message_);
}


inline void SerializedStaticBitmapImageDataView::GetBitmapDataView(
    ::skia::mojom::BitmapN32DataView* output) const {
  CHECK(is_bitmap());
  *output = ::skia::mojom::BitmapN32DataView(data_->data.f_bitmap.Get(), message_);
}
inline void SerializedStaticBitmapImageDataView::GetAcceleratedImageDataView(
    AcceleratedStaticBitmapImageDataView* output) const {
  CHECK(is_accelerated_image());
  *output = AcceleratedStaticBitmapImageDataView(data_->data.f_accelerated_image.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_STATIC_BITMAP_IMAGE_MOJOM_SHARED_H_