// third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_STATIC_BITMAP_IMAGE_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_STATIC_BITMAP_IMAGE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "skia/public/mojom/image_info.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"


namespace blink::mojom {
class AcceleratedStaticBitmapImageDataView;

class SerializedStaticBitmapImageDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AcceleratedStaticBitmapImageDataView> {
  using Data = ::blink::mojom::internal::AcceleratedStaticBitmapImage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SerializedStaticBitmapImageDataView> {
  using Data = ::blink::mojom::internal::SerializedStaticBitmapImage_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class ImageReleaseCallbackInterfaceBase {};

using ImageReleaseCallbackPtrDataView =
    mojo::InterfacePtrDataView<ImageReleaseCallbackInterfaceBase>;
using ImageReleaseCallbackRequestDataView =
    mojo::InterfaceRequestDataView<ImageReleaseCallbackInterfaceBase>;
using ImageReleaseCallbackAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ImageReleaseCallbackInterfaceBase>;
using ImageReleaseCallbackAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ImageReleaseCallbackInterfaceBase>;


class AcceleratedStaticBitmapImageDataView {
 public:
  AcceleratedStaticBitmapImageDataView() = default;

  AcceleratedStaticBitmapImageDataView(
      internal::AcceleratedStaticBitmapImage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSharedImageDataView(
      ::gpu::mojom::ExportedSharedImageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedImage(UserType* output) {
    
    auto* pointer = data_->shared_image.Get();
    return mojo::internal::Deserialize<::gpu::mojom::ExportedSharedImageDataView>(
        pointer, output, message_);
  }
  inline void GetSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncToken(UserType* output) {
    
    auto* pointer = data_->sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAlphaType(UserType* output) const {
    auto data_value = data_->alpha_type;
    return mojo::internal::Deserialize<::skia::mojom::AlphaType>(
        data_value, output);
  }
  ::skia::mojom::AlphaType alpha_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::skia::mojom::AlphaType>(data_->alpha_type));
  }
  template <typename UserType>
  UserType TakeReleaseCallback() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::ImageReleaseCallbackInterfaceBase>>(
            &data_->release_callback, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::AcceleratedStaticBitmapImage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SerializedStaticBitmapImageDataView {
 public:
  using Tag = internal::SerializedStaticBitmapImage_Data::SerializedStaticBitmapImage_Tag;

  SerializedStaticBitmapImageDataView() = default;

  SerializedStaticBitmapImageDataView(
      internal::SerializedStaticBitmapImage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_bitmap() const { return data_->tag == Tag::kBitmap; }
  inline void GetBitmapDataView(
      ::skia::mojom::BitmapN32DataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBitmap(UserType* output) const {
    
    CHECK(is_bitmap());
    return mojo::internal::Deserialize<::skia::mojom::BitmapN32DataView>(
        data_->data.f_bitmap.Get(), output, message_);
  }
  bool is_accelerated_image() const { return data_->tag == Tag::kAcceleratedImage; }
  inline void GetAcceleratedImageDataView(
      AcceleratedStaticBitmapImageDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadAcceleratedImage(UserType* output) const {
    
    CHECK(is_accelerated_image());
    return mojo::internal::Deserialize<::blink::mojom::AcceleratedStaticBitmapImageDataView>(
        data_->data.f_accelerated_image.Get(), output, message_);
  }

 private:
  internal::SerializedStaticBitmapImage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_STATIC_BITMAP_IMAGE_MOJOM_DATA_VIEW_H_