// third_party/blink/public/mojom/messaging/cloneable_message.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_CLONEABLE_MESSAGE_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_CLONEABLE_MESSAGE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"


namespace blink::mojom {
class CloneableMessageDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::CloneableMessageDataView> {
  using Data = ::blink::mojom::internal::CloneableMessage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class CloneableMessageDataView {
 public:
  CloneableMessageDataView() = default;

  CloneableMessageDataView(
      internal::CloneableMessage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEncodedMessageDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncodedMessage(UserType* output) {
    
    auto* pointer = !data_->encoded_message.is_null() ? &data_->encoded_message : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
  inline void GetBlobsDataView(
      mojo::ArrayDataView<::blink::mojom::SerializedBlobDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlobs(UserType* output) {
    
    auto* pointer = data_->blobs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SerializedBlobDataView>>(
        pointer, output, message_);
  }
  inline void GetSenderOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSenderOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `sender_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSenderOrigin` instead "
    "of `ReadSenderOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->sender_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  uint64_t stack_trace_id() const {
    return data_->stack_trace_id;
  }
  int64_t stack_trace_debugger_id_first() const {
    return data_->stack_trace_debugger_id_first;
  }
  int64_t stack_trace_debugger_id_second() const {
    return data_->stack_trace_debugger_id_second;
  }
  bool stack_trace_should_pause() const {
    return data_->stack_trace_should_pause;
  }
  inline void GetSenderAgentClusterIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSenderAgentClusterId(UserType* output) {
    
    auto* pointer = data_->sender_agent_cluster_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  bool locked_to_sender_agent_cluster() const {
    return data_->locked_to_sender_agent_cluster;
  }
  inline void GetFileSystemAccessTokensDataView(
      mojo::ArrayDataView<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileSystemAccessTokens(UserType* output) {
    
    auto* pointer = data_->file_system_access_tokens.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>>(
        pointer, output, message_);
  }
 private:
  internal::CloneableMessage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_CLONEABLE_MESSAGE_MOJOM_DATA_VIEW_H_