// third_party/blink/public/mojom/mediastream/media_stream.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ApplySubCaptureTargetResult as media_mojom_ApplySubCaptureTargetResult,
  ApplySubCaptureTargetResultSpec as media_mojom_ApplySubCaptureTargetResultSpec,
  SubCaptureTargetType as media_mojom_SubCaptureTargetType,
  SubCaptureTargetTypeSpec as media_mojom_SubCaptureTargetTypeSpec,
  VideoFacingMode as media_mojom_VideoFacingMode,
  VideoFacingModeSpec as media_mojom_VideoFacingModeSpec
} from '../../../../../media/capture/mojom/video_capture_types.mojom.m.js';

import {
  AudioParameters as media_mojom_AudioParameters,
  AudioParametersSpec as media_mojom_AudioParametersSpec
} from '../../../../../media/mojo/mojom/audio_parameters.mojom.m.js';

import {
  DisplayMediaInformation as media_mojom_DisplayMediaInformation,
  DisplayMediaInformationSpec as media_mojom_DisplayMediaInformationSpec
} from '../../../../../media/mojo/mojom/display_media_information.mojom.m.js';

import {
  Token as mojoBase_mojom_Token,
  TokenSpec as mojoBase_mojom_TokenSpec
} from '../../../../../mojo/public/mojom/base/token.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaStreamTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaStreamType = {
  
  NO_SERVICE: 0,
  DEVICE_AUDIO_CAPTURE: 1,
  DEVICE_VIDEO_CAPTURE: 2,
  GUM_TAB_AUDIO_CAPTURE: 3,
  GUM_TAB_VIDEO_CAPTURE: 4,
  GUM_DESKTOP_VIDEO_CAPTURE: 5,
  GUM_DESKTOP_AUDIO_CAPTURE: 6,
  DISPLAY_VIDEO_CAPTURE: 7,
  DISPLAY_AUDIO_CAPTURE: 8,
  DISPLAY_VIDEO_CAPTURE_THIS_TAB: 9,
  DISPLAY_VIDEO_CAPTURE_SET: 10,
  NUM_MEDIA_TYPES: 11,
  MIN_VALUE: 0,
  MAX_VALUE: 11,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaStreamRequestResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaStreamRequestResult = {
  
  OK: 0,
  PERMISSION_DENIED: 1,
  PERMISSION_DISMISSED: 2,
  INVALID_STATE: 3,
  NO_HARDWARE: 4,
  INVALID_SECURITY_ORIGIN: 5,
  TAB_CAPTURE_FAILURE: 6,
  SCREEN_CAPTURE_FAILURE: 7,
  CAPTURE_FAILURE: 8,
  CONSTRAINT_NOT_SATISFIED: 9,
  TRACK_START_FAILURE_AUDIO: 10,
  TRACK_START_FAILURE_VIDEO: 11,
  NOT_SUPPORTED: 12,
  FAILED_DUE_TO_SHUTDOWN: 13,
  KILL_SWITCH_ON: 14,
  PERMISSION_DENIED_BY_SYSTEM: 15,
  DEVICE_IN_USE: 16,
  REQUEST_CANCELLED: 17,
  START_TIMEOUT: 18,
  PERMISSION_DENIED_BY_USER: 19,
  AUDIO_DEVICE_SOCKET_ERROR: 20,
  NO_TRANSIENT_ACTIVATION: 21,
  CAPTURE_NOT_ALLOWED_BY_POLICY: 22,
  INVALID_DISPLAY_CAPTURE_CONSTRAINTS: 23,
  INVALID_GUM_TAB_CAPTURE_CONSTRAINTS: 24,
  INVALID_GUM_SCREEN_CAPTURE_CONSTRAINTS: 25,
  INVALID_VIDEO_DEVICE_ID: 26,
  STREAM_NOT_FOUND_IN_REGISTRY: 27,
  ANDROID_CANT_REQUEST_PERMISSION: 28,
  MULTI_CAPTURE_NOT_SUPPORTED: 29,
  PERMISSION_DENIED_BY_EMBEDDER_CONTEXT: 30,
  DLP_PERMISSION_DENIED: 31,
  REGISTRY_REQUEST_UNVERIFIED: 32,
  NUM_MEDIA_REQUEST_RESULTS: 33,
  MIN_VALUE: 0,
  MAX_VALUE: 33,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaStreamStateChangeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaStreamStateChange = {
  
  PLAY: 0,
  PAUSE: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PreferredDisplaySurfaceSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PreferredDisplaySurface = {
  
  NO_PREFERENCE: 0,
  MONITOR: 1,
  WINDOW: 2,
  BROWSER: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CapturedSurfaceControlResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CapturedSurfaceControlResult = {
  
  kSuccess: 0,
  kUnknownError: 1,
  kNoPermissionError: 2,
  kCapturerNotFoundError: 3,
  kCapturedSurfaceNotFoundError: 4,
  kDisallowedForSelfCaptureError: 5,
  kCapturerNotFocusedError: 6,
  kMinZoomLevel: 7,
  kMaxZoomLevel: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ZoomLevelActionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ZoomLevelAction = {
  
  kIncrease: 0,
  kDecrease: 1,
  kReset: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WindowAudioPreferenceSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WindowAudioPreference = {
  
  kSystem: 0,
  kWindow: 1,
  kExclude: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaStreamDeviceObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.MediaStreamDeviceObserver', scope);
  }
}

/** @interface */
export class MediaStreamDeviceObserverInterface {
  
  /**
   * @param { !string } label
   * @param { !MediaStreamDevice } device
   */

  onDeviceStopped(label, device) {}
  
  /**
   * @param { !string } label
   * @param { !MediaStreamDevice } oldDevice
   * @param { !MediaStreamDevice } newDevice
   */

  onDeviceChanged(label, oldDevice, newDevice) {}
  
  /**
   * @param { !string } label
   * @param { !MediaStreamDevice } device
   * @param { !MediaStreamStateChange } newState
   */

  onDeviceRequestStateChange(label, device, newState) {}
  
  /**
   * @param { !string } label
   * @param { !MediaStreamDevice } device
   */

  onDeviceCaptureConfigurationChange(label, device) {}
  
  /**
   * @param { !string } label
   * @param { !MediaStreamDevice } device
   */

  onDeviceCaptureHandleChange(label, device) {}
  
  /**
   * @param { !string } label
   * @param { !MediaStreamDevice } device
   * @param { !number } zoomLevel
   */

  onZoomLevelChange(label, device, zoomLevel) {}
}

/**
 * @implements { MediaStreamDeviceObserverInterface }
 */
export class MediaStreamDeviceObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaStreamDeviceObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaStreamDeviceObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaStreamDeviceObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } label
   * @param { !MediaStreamDevice } device
   */

  onDeviceStopped(
      label,
      device) {
    this.proxy.sendMessage(
        0,
        MediaStreamDeviceObserver_OnDeviceStopped_ParamsSpec.$,
        null,
        [
          label,
          device
        ],
        false);
  }

  
  /**
   * @param { !string } label
   * @param { !MediaStreamDevice } oldDevice
   * @param { !MediaStreamDevice } newDevice
   */

  onDeviceChanged(
      label,
      oldDevice,
      newDevice) {
    this.proxy.sendMessage(
        1,
        MediaStreamDeviceObserver_OnDeviceChanged_ParamsSpec.$,
        null,
        [
          label,
          oldDevice,
          newDevice
        ],
        false);
  }

  
  /**
   * @param { !string } label
   * @param { !MediaStreamDevice } device
   * @param { !MediaStreamStateChange } newState
   */

  onDeviceRequestStateChange(
      label,
      device,
      newState) {
    this.proxy.sendMessage(
        2,
        MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsSpec.$,
        null,
        [
          label,
          device,
          newState
        ],
        false);
  }

  
  /**
   * @param { !string } label
   * @param { !MediaStreamDevice } device
   */

  onDeviceCaptureConfigurationChange(
      label,
      device) {
    this.proxy.sendMessage(
        3,
        MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_ParamsSpec.$,
        null,
        [
          label,
          device
        ],
        false);
  }

  
  /**
   * @param { !string } label
   * @param { !MediaStreamDevice } device
   */

  onDeviceCaptureHandleChange(
      label,
      device) {
    this.proxy.sendMessage(
        4,
        MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsSpec.$,
        null,
        [
          label,
          device
        ],
        false);
  }

  
  /**
   * @param { !string } label
   * @param { !MediaStreamDevice } device
   * @param { !number } zoomLevel
   */

  onZoomLevelChange(
      label,
      device,
      zoomLevel) {
    this.proxy.sendMessage(
        5,
        MediaStreamDeviceObserver_OnZoomLevelChange_ParamsSpec.$,
        null,
        [
          label,
          device,
          zoomLevel
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaStreamDeviceObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaStreamDeviceObserverReceiver {
  /**
   * @param {!MediaStreamDeviceObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaStreamDeviceObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaStreamDeviceObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaStreamDeviceObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaStreamDeviceObserver_OnDeviceStopped_ParamsSpec.$,
        null,
        impl.onDeviceStopped.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaStreamDeviceObserver_OnDeviceChanged_ParamsSpec.$,
        null,
        impl.onDeviceChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsSpec.$,
        null,
        impl.onDeviceRequestStateChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_ParamsSpec.$,
        null,
        impl.onDeviceCaptureConfigurationChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsSpec.$,
        null,
        impl.onDeviceCaptureHandleChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        MediaStreamDeviceObserver_OnZoomLevelChange_ParamsSpec.$,
        null,
        impl.onZoomLevelChange.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaStreamDeviceObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MediaStreamDeviceObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaStreamDeviceObserverRemote}
   */
  static getRemote() {
    let remote = new MediaStreamDeviceObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaStreamDeviceObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaStreamDeviceObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaStreamDeviceObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaStreamDeviceObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceStopped =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaStreamDeviceObserver_OnDeviceStopped_ParamsSpec.$,
        null,
        this.onDeviceStopped.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaStreamDeviceObserver_OnDeviceChanged_ParamsSpec.$,
        null,
        this.onDeviceChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceRequestStateChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsSpec.$,
        null,
        this.onDeviceRequestStateChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceCaptureConfigurationChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_ParamsSpec.$,
        null,
        this.onDeviceCaptureConfigurationChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceCaptureHandleChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsSpec.$,
        null,
        this.onDeviceCaptureHandleChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onZoomLevelChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        MediaStreamDeviceObserver_OnZoomLevelChange_ParamsSpec.$,
        null,
        this.onZoomLevelChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaStreamDispatcherHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.MediaStreamDispatcherHost', scope);
  }
}

/** @interface */
export class MediaStreamDispatcherHostInterface {
  
  /**
   * @param { !number } requestId
   * @param { !StreamControls } controls
   * @param { !boolean } userGesture
   * @param { !StreamSelectionInfo } audioStreamSelectionInfo
   * @return {!Promise<{
        result: !MediaStreamRequestResult,
        label: !string,
        streamDevices: ?StreamDevicesSet,
        panTiltZoomAllowed: !boolean,
   *  }>}
   */

  generateStreams(requestId, controls, userGesture, audioStreamSelectionInfo) {}
  
  /**
   * @param { !string } label
   * @param { !boolean } focus
   */

  focusCapturedSurface(label, focus) {}
  
  /**
   * @param { !number } requestId
   */

  cancelRequest(requestId) {}
  
  /**
   * @param { !string } deviceId
   * @param { ?mojoBase_mojom_UnguessableToken } sessionId
   */

  stopStreamDevice(deviceId, sessionId) {}
  
  /**
   * @param { !number } requestId
   * @param { !string } deviceId
   * @param { !MediaStreamType } type
   * @return {!Promise<{
        success: !boolean,
        label: !string,
        device: !MediaStreamDevice,
   *  }>}
   */

  openDevice(requestId, deviceId, type) {}
  
  /**
   * @param { !string } label
   */

  closeDevice(label) {}
  
  /**
   * @param { ?mojoBase_mojom_UnguessableToken } sessionId
   * @param { !MediaStreamType } type
   * @param { !boolean } isSecure
   */

  setCapturingLinkSecured(sessionId, type, isSecure) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @param { !media_mojom_SubCaptureTargetType } type
   * @param { !mojoBase_mojom_Token } subCaptureTarget
   * @param { !number } subCaptureTargetVersion
   * @return {!Promise<{
        result: !media_mojom_ApplySubCaptureTargetResult,
   *  }>}
   */

  applySubCaptureTarget(sessionId, type, subCaptureTarget, subCaptureTargetVersion) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @param { !CapturedWheelAction } action
   */

  sendWheel(sessionId, action) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @param { !ZoomLevelAction } action
   * @return {!Promise<{
        result: !CapturedSurfaceControlResult,
   *  }>}
   */

  updateZoomLevel(sessionId, action) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @return {!Promise<{
        result: !CapturedSurfaceControlResult,
   *  }>}
   */

  requestCapturedSurfaceControlPermission(sessionId) {}
  
  /**
   * @param { !number } requestId
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @param { !mojoBase_mojom_UnguessableToken } transferId
   * @return {!Promise<{
        result: !MediaStreamRequestResult,
        response: ?GetOpenDeviceResponse,
   *  }>}
   */

  getOpenDevice(requestId, sessionId, transferId) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @param { !mojoBase_mojom_UnguessableToken } transferId
   * @return {!Promise<{
        deviceFound: !boolean,
   *  }>}
   */

  keepDeviceAliveForTransfer(sessionId, transferId) {}
}

/**
 * @implements { MediaStreamDispatcherHostInterface }
 */
export class MediaStreamDispatcherHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaStreamDispatcherHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaStreamDispatcherHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaStreamDispatcherHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } requestId
   * @param { !StreamControls } controls
   * @param { !boolean } userGesture
   * @param { !StreamSelectionInfo } audioStreamSelectionInfo
   * @return {!Promise<{
        result: !MediaStreamRequestResult,
        label: !string,
        streamDevices: ?StreamDevicesSet,
        panTiltZoomAllowed: !boolean,
   *  }>}
   */

  generateStreams(
      requestId,
      controls,
      userGesture,
      audioStreamSelectionInfo) {
    return this.proxy.sendMessage(
        0,
        MediaStreamDispatcherHost_GenerateStreams_ParamsSpec.$,
        MediaStreamDispatcherHost_GenerateStreams_ResponseParamsSpec.$,
        [
          requestId,
          controls,
          userGesture,
          audioStreamSelectionInfo
        ],
        false);
  }

  
  /**
   * @param { !string } label
   * @param { !boolean } focus
   */

  focusCapturedSurface(
      label,
      focus) {
    this.proxy.sendMessage(
        1,
        MediaStreamDispatcherHost_FocusCapturedSurface_ParamsSpec.$,
        null,
        [
          label,
          focus
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   */

  cancelRequest(
      requestId) {
    this.proxy.sendMessage(
        2,
        MediaStreamDispatcherHost_CancelRequest_ParamsSpec.$,
        null,
        [
          requestId
        ],
        false);
  }

  
  /**
   * @param { !string } deviceId
   * @param { ?mojoBase_mojom_UnguessableToken } sessionId
   */

  stopStreamDevice(
      deviceId,
      sessionId) {
    this.proxy.sendMessage(
        3,
        MediaStreamDispatcherHost_StopStreamDevice_ParamsSpec.$,
        null,
        [
          deviceId,
          sessionId
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !string } deviceId
   * @param { !MediaStreamType } type
   * @return {!Promise<{
        success: !boolean,
        label: !string,
        device: !MediaStreamDevice,
   *  }>}
   */

  openDevice(
      requestId,
      deviceId,
      type) {
    return this.proxy.sendMessage(
        4,
        MediaStreamDispatcherHost_OpenDevice_ParamsSpec.$,
        MediaStreamDispatcherHost_OpenDevice_ResponseParamsSpec.$,
        [
          requestId,
          deviceId,
          type
        ],
        false);
  }

  
  /**
   * @param { !string } label
   */

  closeDevice(
      label) {
    this.proxy.sendMessage(
        5,
        MediaStreamDispatcherHost_CloseDevice_ParamsSpec.$,
        null,
        [
          label
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase_mojom_UnguessableToken } sessionId
   * @param { !MediaStreamType } type
   * @param { !boolean } isSecure
   */

  setCapturingLinkSecured(
      sessionId,
      type,
      isSecure) {
    this.proxy.sendMessage(
        6,
        MediaStreamDispatcherHost_SetCapturingLinkSecured_ParamsSpec.$,
        null,
        [
          sessionId,
          type,
          isSecure
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @param { !media_mojom_SubCaptureTargetType } type
   * @param { !mojoBase_mojom_Token } subCaptureTarget
   * @param { !number } subCaptureTargetVersion
   * @return {!Promise<{
        result: !media_mojom_ApplySubCaptureTargetResult,
   *  }>}
   */

  applySubCaptureTarget(
      sessionId,
      type,
      subCaptureTarget,
      subCaptureTargetVersion) {
    return this.proxy.sendMessage(
        7,
        MediaStreamDispatcherHost_ApplySubCaptureTarget_ParamsSpec.$,
        MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParamsSpec.$,
        [
          sessionId,
          type,
          subCaptureTarget,
          subCaptureTargetVersion
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @param { !CapturedWheelAction } action
   */

  sendWheel(
      sessionId,
      action) {
    this.proxy.sendMessage(
        8,
        MediaStreamDispatcherHost_SendWheel_ParamsSpec.$,
        null,
        [
          sessionId,
          action
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @param { !ZoomLevelAction } action
   * @return {!Promise<{
        result: !CapturedSurfaceControlResult,
   *  }>}
   */

  updateZoomLevel(
      sessionId,
      action) {
    return this.proxy.sendMessage(
        9,
        MediaStreamDispatcherHost_UpdateZoomLevel_ParamsSpec.$,
        MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParamsSpec.$,
        [
          sessionId,
          action
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @return {!Promise<{
        result: !CapturedSurfaceControlResult,
   *  }>}
   */

  requestCapturedSurfaceControlPermission(
      sessionId) {
    return this.proxy.sendMessage(
        10,
        MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ParamsSpec.$,
        MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParamsSpec.$,
        [
          sessionId
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @param { !mojoBase_mojom_UnguessableToken } transferId
   * @return {!Promise<{
        result: !MediaStreamRequestResult,
        response: ?GetOpenDeviceResponse,
   *  }>}
   */

  getOpenDevice(
      requestId,
      sessionId,
      transferId) {
    return this.proxy.sendMessage(
        11,
        MediaStreamDispatcherHost_GetOpenDevice_ParamsSpec.$,
        MediaStreamDispatcherHost_GetOpenDevice_ResponseParamsSpec.$,
        [
          requestId,
          sessionId,
          transferId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @param { !mojoBase_mojom_UnguessableToken } transferId
   * @return {!Promise<{
        deviceFound: !boolean,
   *  }>}
   */

  keepDeviceAliveForTransfer(
      sessionId,
      transferId) {
    return this.proxy.sendMessage(
        12,
        MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ParamsSpec.$,
        MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParamsSpec.$,
        [
          sessionId,
          transferId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaStreamDispatcherHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaStreamDispatcherHostReceiver {
  /**
   * @param {!MediaStreamDispatcherHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaStreamDispatcherHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaStreamDispatcherHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaStreamDispatcherHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaStreamDispatcherHost_GenerateStreams_ParamsSpec.$,
        MediaStreamDispatcherHost_GenerateStreams_ResponseParamsSpec.$,
        impl.generateStreams.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaStreamDispatcherHost_FocusCapturedSurface_ParamsSpec.$,
        null,
        impl.focusCapturedSurface.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaStreamDispatcherHost_CancelRequest_ParamsSpec.$,
        null,
        impl.cancelRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MediaStreamDispatcherHost_StopStreamDevice_ParamsSpec.$,
        null,
        impl.stopStreamDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MediaStreamDispatcherHost_OpenDevice_ParamsSpec.$,
        MediaStreamDispatcherHost_OpenDevice_ResponseParamsSpec.$,
        impl.openDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        MediaStreamDispatcherHost_CloseDevice_ParamsSpec.$,
        null,
        impl.closeDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        MediaStreamDispatcherHost_SetCapturingLinkSecured_ParamsSpec.$,
        null,
        impl.setCapturingLinkSecured.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        MediaStreamDispatcherHost_ApplySubCaptureTarget_ParamsSpec.$,
        MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParamsSpec.$,
        impl.applySubCaptureTarget.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        MediaStreamDispatcherHost_SendWheel_ParamsSpec.$,
        null,
        impl.sendWheel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        MediaStreamDispatcherHost_UpdateZoomLevel_ParamsSpec.$,
        MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParamsSpec.$,
        impl.updateZoomLevel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ParamsSpec.$,
        MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParamsSpec.$,
        impl.requestCapturedSurfaceControlPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        MediaStreamDispatcherHost_GetOpenDevice_ParamsSpec.$,
        MediaStreamDispatcherHost_GetOpenDevice_ResponseParamsSpec.$,
        impl.getOpenDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ParamsSpec.$,
        MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParamsSpec.$,
        impl.keepDeviceAliveForTransfer.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaStreamDispatcherHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MediaStreamDispatcherHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaStreamDispatcherHostRemote}
   */
  static getRemote() {
    let remote = new MediaStreamDispatcherHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaStreamDispatcherHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaStreamDispatcherHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaStreamDispatcherHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaStreamDispatcherHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.generateStreams =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaStreamDispatcherHost_GenerateStreams_ParamsSpec.$,
        MediaStreamDispatcherHost_GenerateStreams_ResponseParamsSpec.$,
        this.generateStreams.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.focusCapturedSurface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaStreamDispatcherHost_FocusCapturedSurface_ParamsSpec.$,
        null,
        this.focusCapturedSurface.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaStreamDispatcherHost_CancelRequest_ParamsSpec.$,
        null,
        this.cancelRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopStreamDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MediaStreamDispatcherHost_StopStreamDevice_ParamsSpec.$,
        null,
        this.stopStreamDevice.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MediaStreamDispatcherHost_OpenDevice_ParamsSpec.$,
        MediaStreamDispatcherHost_OpenDevice_ResponseParamsSpec.$,
        this.openDevice.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        MediaStreamDispatcherHost_CloseDevice_ParamsSpec.$,
        null,
        this.closeDevice.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCapturingLinkSecured =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        MediaStreamDispatcherHost_SetCapturingLinkSecured_ParamsSpec.$,
        null,
        this.setCapturingLinkSecured.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.applySubCaptureTarget =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        MediaStreamDispatcherHost_ApplySubCaptureTarget_ParamsSpec.$,
        MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParamsSpec.$,
        this.applySubCaptureTarget.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendWheel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        MediaStreamDispatcherHost_SendWheel_ParamsSpec.$,
        null,
        this.sendWheel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateZoomLevel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        MediaStreamDispatcherHost_UpdateZoomLevel_ParamsSpec.$,
        MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParamsSpec.$,
        this.updateZoomLevel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestCapturedSurfaceControlPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ParamsSpec.$,
        MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParamsSpec.$,
        this.requestCapturedSurfaceControlPermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getOpenDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        MediaStreamDispatcherHost_GetOpenDevice_ParamsSpec.$,
        MediaStreamDispatcherHost_GetOpenDevice_ResponseParamsSpec.$,
        this.getOpenDevice.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.keepDeviceAliveForTransfer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ParamsSpec.$,
        MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParamsSpec.$,
        this.keepDeviceAliveForTransfer.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaStreamTrackMetricsHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.MediaStreamTrackMetricsHost', scope);
  }
}

/** @interface */
export class MediaStreamTrackMetricsHostInterface {
  
  /**
   * @param { !bigint } id
   * @param { !boolean } isAudio
   * @param { !boolean } isRemote
   */

  addTrack(id, isAudio, isRemote) {}
  
  /**
   * @param { !bigint } id
   */

  removeTrack(id) {}
}

/**
 * @implements { MediaStreamTrackMetricsHostInterface }
 */
export class MediaStreamTrackMetricsHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaStreamTrackMetricsHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaStreamTrackMetricsHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaStreamTrackMetricsHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } id
   * @param { !boolean } isAudio
   * @param { !boolean } isRemote
   */

  addTrack(
      id,
      isAudio,
      isRemote) {
    this.proxy.sendMessage(
        0,
        MediaStreamTrackMetricsHost_AddTrack_ParamsSpec.$,
        null,
        [
          id,
          isAudio,
          isRemote
        ],
        false);
  }

  
  /**
   * @param { !bigint } id
   */

  removeTrack(
      id) {
    this.proxy.sendMessage(
        1,
        MediaStreamTrackMetricsHost_RemoveTrack_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaStreamTrackMetricsHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaStreamTrackMetricsHostReceiver {
  /**
   * @param {!MediaStreamTrackMetricsHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaStreamTrackMetricsHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaStreamTrackMetricsHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaStreamTrackMetricsHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaStreamTrackMetricsHost_AddTrack_ParamsSpec.$,
        null,
        impl.addTrack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaStreamTrackMetricsHost_RemoveTrack_ParamsSpec.$,
        null,
        impl.removeTrack.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaStreamTrackMetricsHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MediaStreamTrackMetricsHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaStreamTrackMetricsHostRemote}
   */
  static getRemote() {
    let remote = new MediaStreamTrackMetricsHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaStreamTrackMetricsHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaStreamTrackMetricsHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaStreamTrackMetricsHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaStreamTrackMetricsHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addTrack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaStreamTrackMetricsHost_AddTrack_ParamsSpec.$,
        null,
        this.addTrack.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeTrack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaStreamTrackMetricsHost_RemoveTrack_ParamsSpec.$,
        null,
        this.removeTrack.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SearchOnlyByDeviceIdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SearchBySessionIdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDeviceSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrackControlsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StreamControlsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GetOpenDeviceResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CapturedWheelActionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StreamDevicesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StreamDevicesSetSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDeviceObserver_OnDeviceStopped_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDeviceObserver_OnDeviceChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDeviceObserver_OnZoomLevelChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_GenerateStreams_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_GenerateStreams_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_FocusCapturedSurface_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_CancelRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_StopStreamDevice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_OpenDevice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_OpenDevice_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_CloseDevice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_SetCapturingLinkSecured_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_ApplySubCaptureTarget_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_SendWheel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_UpdateZoomLevel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_GetOpenDevice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_GetOpenDevice_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamTrackMetricsHost_AddTrack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaStreamTrackMetricsHost_RemoveTrack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const StreamSelectionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SearchOnlyByDeviceIdSpec.$,
    'SearchOnlyByDeviceId',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SearchOnlyByDeviceId {
  constructor() {
  }
}



mojo.internal.Struct(
    SearchBySessionIdSpec.$,
    'SearchBySessionId',
    [
      mojo.internal.StructField(
        'sessionIdMap', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojoBase_mojom_UnguessableTokenSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SearchBySessionId {
  constructor() {
    /** @type { !Object<!string, !mojoBase_mojom_UnguessableToken> } */
    this.sessionIdMap;
  }
}



mojo.internal.Struct(
    MediaStreamDeviceSpec.$,
    'MediaStreamDevice',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        MediaStreamTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'displayId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoFacing', 4,
        0,
        media_mojom_VideoFacingModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'groupId', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'matchedOutputDeviceId', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'input', 48,
        0,
        media_mojom_AudioParametersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionId', 56,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'displayMediaInfo', 64,
        0,
        media_mojom_DisplayMediaInformationSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class MediaStreamDevice {
  constructor() {
    /** @type { !MediaStreamType } */
    this.type;
    /** @type { !string } */
    this.id;
    /** @type { !bigint } */
    this.displayId;
    /** @type { !media_mojom_VideoFacingMode } */
    this.videoFacing;
    /** @type { (string|undefined) } */
    this.groupId;
    /** @type { (string|undefined) } */
    this.matchedOutputDeviceId;
    /** @type { !string } */
    this.name;
    /** @type { !media_mojom_AudioParameters } */
    this.input;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.sessionId;
    /** @type { (media_mojom_DisplayMediaInformation|undefined) } */
    this.displayMediaInfo;
  }
}



mojo.internal.Struct(
    TrackControlsSpec.$,
    'TrackControls',
    [
      mojo.internal.StructField(
        'streamType', 0,
        0,
        MediaStreamTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceIds', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TrackControls {
  constructor() {
    /** @type { !MediaStreamType } */
    this.streamType;
    /** @type { !Array<!string> } */
    this.deviceIds;
  }
}



mojo.internal.Struct(
    StreamControlsSpec.$,
    'StreamControls',
    [
      mojo.internal.StructField(
        'audio', 0,
        0,
        TrackControlsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'video', 8,
        0,
        TrackControlsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hotwordEnabled', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'disableLocalEcho', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'suppressLocalAudioPlayback', 16,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'restrictOwnAudio', 16,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'excludeSystemAudio', 16,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'windowAudioPreference', 20,
        0,
        WindowAudioPreferenceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'excludeSelfBrowserSurface', 16,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestPanTiltZoomPermission', 16,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestAllScreens', 16,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'preferredDisplaySurface', 24,
        0,
        PreferredDisplaySurfaceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dynamicSurfaceSwitchingRequested', 17,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'excludeMonitorTypeSurfaces', 17,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class StreamControls {
  constructor() {
    /** @type { !TrackControls } */
    this.audio;
    /** @type { !TrackControls } */
    this.video;
    /** @type { !boolean } */
    this.hotwordEnabled;
    /** @type { !boolean } */
    this.disableLocalEcho;
    /** @type { !boolean } */
    this.suppressLocalAudioPlayback;
    /** @type { !boolean } */
    this.restrictOwnAudio;
    /** @type { !boolean } */
    this.excludeSystemAudio;
    /** @type { !WindowAudioPreference } */
    this.windowAudioPreference;
    /** @type { !boolean } */
    this.excludeSelfBrowserSurface;
    /** @type { !boolean } */
    this.requestPanTiltZoomPermission;
    /** @type { !boolean } */
    this.requestAllScreens;
    /** @type { !PreferredDisplaySurface } */
    this.preferredDisplaySurface;
    /** @type { !boolean } */
    this.dynamicSurfaceSwitchingRequested;
    /** @type { !boolean } */
    this.excludeMonitorTypeSurfaces;
  }
}



mojo.internal.Struct(
    GetOpenDeviceResponseSpec.$,
    'GetOpenDeviceResponse',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'device', 8,
        0,
        MediaStreamDeviceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'panTiltZoomAllowed', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class GetOpenDeviceResponse {
  constructor() {
    /** @type { !string } */
    this.label;
    /** @type { !MediaStreamDevice } */
    this.device;
    /** @type { !boolean } */
    this.panTiltZoomAllowed;
  }
}



mojo.internal.Struct(
    CapturedWheelActionSpec.$,
    'CapturedWheelAction',
    [
      mojo.internal.StructField(
        'relativeX', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'relativeY', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wheelDeltaX', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wheelDeltaY', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CapturedWheelAction {
  constructor() {
    /** @type { !number } */
    this.relativeX;
    /** @type { !number } */
    this.relativeY;
    /** @type { !number } */
    this.wheelDeltaX;
    /** @type { !number } */
    this.wheelDeltaY;
  }
}



mojo.internal.Struct(
    StreamDevicesSpec.$,
    'StreamDevices',
    [
      mojo.internal.StructField(
        'audioDevice', 0,
        0,
        MediaStreamDeviceSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoDevice', 8,
        0,
        MediaStreamDeviceSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class StreamDevices {
  constructor() {
    /** @type { (MediaStreamDevice|undefined) } */
    this.audioDevice;
    /** @type { (MediaStreamDevice|undefined) } */
    this.videoDevice;
  }
}



mojo.internal.Struct(
    StreamDevicesSetSpec.$,
    'StreamDevicesSet',
    [
      mojo.internal.StructField(
        'streamDevices', 0,
        0,
        mojo.internal.Array(StreamDevicesSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StreamDevicesSet {
  constructor() {
    /** @type { !Array<!StreamDevices> } */
    this.streamDevices;
  }
}



mojo.internal.Struct(
    MediaStreamDeviceObserver_OnDeviceStopped_ParamsSpec.$,
    'MediaStreamDeviceObserver_OnDeviceStopped_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'device', 8,
        0,
        MediaStreamDeviceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaStreamDeviceObserver_OnDeviceStopped_Params {
  constructor() {
    /** @type { !string } */
    this.label;
    /** @type { !MediaStreamDevice } */
    this.device;
  }
}



mojo.internal.Struct(
    MediaStreamDeviceObserver_OnDeviceChanged_ParamsSpec.$,
    'MediaStreamDeviceObserver_OnDeviceChanged_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'oldDevice', 8,
        0,
        MediaStreamDeviceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newDevice', 16,
        0,
        MediaStreamDeviceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MediaStreamDeviceObserver_OnDeviceChanged_Params {
  constructor() {
    /** @type { !string } */
    this.label;
    /** @type { !MediaStreamDevice } */
    this.oldDevice;
    /** @type { !MediaStreamDevice } */
    this.newDevice;
  }
}



mojo.internal.Struct(
    MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsSpec.$,
    'MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'device', 8,
        0,
        MediaStreamDeviceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newState', 16,
        0,
        MediaStreamStateChangeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params {
  constructor() {
    /** @type { !string } */
    this.label;
    /** @type { !MediaStreamDevice } */
    this.device;
    /** @type { !MediaStreamStateChange } */
    this.newState;
  }
}



mojo.internal.Struct(
    MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_ParamsSpec.$,
    'MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'device', 8,
        0,
        MediaStreamDeviceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params {
  constructor() {
    /** @type { !string } */
    this.label;
    /** @type { !MediaStreamDevice } */
    this.device;
  }
}



mojo.internal.Struct(
    MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsSpec.$,
    'MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'device', 8,
        0,
        MediaStreamDeviceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params {
  constructor() {
    /** @type { !string } */
    this.label;
    /** @type { !MediaStreamDevice } */
    this.device;
  }
}



mojo.internal.Struct(
    MediaStreamDeviceObserver_OnZoomLevelChange_ParamsSpec.$,
    'MediaStreamDeviceObserver_OnZoomLevelChange_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'device', 8,
        0,
        MediaStreamDeviceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'zoomLevel', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MediaStreamDeviceObserver_OnZoomLevelChange_Params {
  constructor() {
    /** @type { !string } */
    this.label;
    /** @type { !MediaStreamDevice } */
    this.device;
    /** @type { !number } */
    this.zoomLevel;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_GenerateStreams_ParamsSpec.$,
    'MediaStreamDispatcherHost_GenerateStreams_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'controls', 8,
        0,
        StreamControlsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userGesture', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioStreamSelectionInfo', 16,
        0,
        StreamSelectionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_GenerateStreams_Params {
  constructor() {
    /** @type { !number } */
    this.requestId;
    /** @type { !StreamControls } */
    this.controls;
    /** @type { !boolean } */
    this.userGesture;
    /** @type { !StreamSelectionInfo } */
    this.audioStreamSelectionInfo;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_GenerateStreams_ResponseParamsSpec.$,
    'MediaStreamDispatcherHost_GenerateStreams_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        MediaStreamRequestResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'streamDevices', 16,
        0,
        StreamDevicesSetSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'panTiltZoomAllowed', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_GenerateStreams_ResponseParams {
  constructor() {
    /** @type { !MediaStreamRequestResult } */
    this.result;
    /** @type { !string } */
    this.label;
    /** @type { (StreamDevicesSet|undefined) } */
    this.streamDevices;
    /** @type { !boolean } */
    this.panTiltZoomAllowed;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_FocusCapturedSurface_ParamsSpec.$,
    'MediaStreamDispatcherHost_FocusCapturedSurface_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'focus', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_FocusCapturedSurface_Params {
  constructor() {
    /** @type { !string } */
    this.label;
    /** @type { !boolean } */
    this.focus;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_CancelRequest_ParamsSpec.$,
    'MediaStreamDispatcherHost_CancelRequest_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_CancelRequest_Params {
  constructor() {
    /** @type { !number } */
    this.requestId;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_StopStreamDevice_ParamsSpec.$,
    'MediaStreamDispatcherHost_StopStreamDevice_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_StopStreamDevice_Params {
  constructor() {
    /** @type { !string } */
    this.deviceId;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.sessionId;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_OpenDevice_ParamsSpec.$,
    'MediaStreamDispatcherHost_OpenDevice_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 4,
        0,
        MediaStreamTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_OpenDevice_Params {
  constructor() {
    /** @type { !number } */
    this.requestId;
    /** @type { !string } */
    this.deviceId;
    /** @type { !MediaStreamType } */
    this.type;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_OpenDevice_ResponseParamsSpec.$,
    'MediaStreamDispatcherHost_OpenDevice_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'device', 16,
        0,
        MediaStreamDeviceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_OpenDevice_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !string } */
    this.label;
    /** @type { !MediaStreamDevice } */
    this.device;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_CloseDevice_ParamsSpec.$,
    'MediaStreamDispatcherHost_CloseDevice_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_CloseDevice_Params {
  constructor() {
    /** @type { !string } */
    this.label;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_SetCapturingLinkSecured_ParamsSpec.$,
    'MediaStreamDispatcherHost_SetCapturingLinkSecured_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        MediaStreamTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isSecure', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_SetCapturingLinkSecured_Params {
  constructor() {
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.sessionId;
    /** @type { !MediaStreamType } */
    this.type;
    /** @type { !boolean } */
    this.isSecure;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_ApplySubCaptureTarget_ParamsSpec.$,
    'MediaStreamDispatcherHost_ApplySubCaptureTarget_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        media_mojom_SubCaptureTargetTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subCaptureTarget', 16,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subCaptureTargetVersion', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_ApplySubCaptureTarget_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.sessionId;
    /** @type { !media_mojom_SubCaptureTargetType } */
    this.type;
    /** @type { !mojoBase_mojom_Token } */
    this.subCaptureTarget;
    /** @type { !number } */
    this.subCaptureTargetVersion;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParamsSpec.$,
    'MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        media_mojom_ApplySubCaptureTargetResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams {
  constructor() {
    /** @type { !media_mojom_ApplySubCaptureTargetResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_SendWheel_ParamsSpec.$,
    'MediaStreamDispatcherHost_SendWheel_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'action', 8,
        0,
        CapturedWheelActionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_SendWheel_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.sessionId;
    /** @type { !CapturedWheelAction } */
    this.action;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_UpdateZoomLevel_ParamsSpec.$,
    'MediaStreamDispatcherHost_UpdateZoomLevel_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'action', 8,
        0,
        ZoomLevelActionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_UpdateZoomLevel_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.sessionId;
    /** @type { !ZoomLevelAction } */
    this.action;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParamsSpec.$,
    'MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CapturedSurfaceControlResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams {
  constructor() {
    /** @type { !CapturedSurfaceControlResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ParamsSpec.$,
    'MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.sessionId;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParamsSpec.$,
    'MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CapturedSurfaceControlResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams {
  constructor() {
    /** @type { !CapturedSurfaceControlResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_GetOpenDevice_ParamsSpec.$,
    'MediaStreamDispatcherHost_GetOpenDevice_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transferId', 16,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_GetOpenDevice_Params {
  constructor() {
    /** @type { !number } */
    this.requestId;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.sessionId;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.transferId;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_GetOpenDevice_ResponseParamsSpec.$,
    'MediaStreamDispatcherHost_GetOpenDevice_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        MediaStreamRequestResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'response', 8,
        0,
        GetOpenDeviceResponseSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_GetOpenDevice_ResponseParams {
  constructor() {
    /** @type { !MediaStreamRequestResult } */
    this.result;
    /** @type { (GetOpenDeviceResponse|undefined) } */
    this.response;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ParamsSpec.$,
    'MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transferId', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.sessionId;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.transferId;
  }
}



mojo.internal.Struct(
    MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParamsSpec.$,
    'MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams',
    [
      mojo.internal.StructField(
        'deviceFound', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.deviceFound;
  }
}



mojo.internal.Struct(
    MediaStreamTrackMetricsHost_AddTrack_ParamsSpec.$,
    'MediaStreamTrackMetricsHost_AddTrack_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isAudio', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isRemote', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaStreamTrackMetricsHost_AddTrack_Params {
  constructor() {
    /** @type { !bigint } */
    this.id;
    /** @type { !boolean } */
    this.isAudio;
    /** @type { !boolean } */
    this.isRemote;
  }
}



mojo.internal.Struct(
    MediaStreamTrackMetricsHost_RemoveTrack_ParamsSpec.$,
    'MediaStreamTrackMetricsHost_RemoveTrack_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaStreamTrackMetricsHost_RemoveTrack_Params {
  constructor() {
    /** @type { !bigint } */
    this.id;
  }
}

mojo.internal.Union(
    StreamSelectionInfoSpec.$, 'StreamSelectionInfo',
    {
      'searchOnlyByDeviceId': {
        'ordinal': 0,
        'type': SearchOnlyByDeviceIdSpec.$,
      },
      'searchBySessionId': {
        'ordinal': 1,
        'type': SearchBySessionIdSpec.$,
      },
    });

/**
 * @typedef { {
 *   searchOnlyByDeviceId: (!SearchOnlyByDeviceId|undefined),
 *   searchBySessionId: (!SearchBySessionId|undefined),
 * } }
 */
export const StreamSelectionInfo = {};
