// third_party/blink/public/mojom/mediastream/media_stream.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/mediastream/media_stream.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var video_capture_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/capture/mojom/video_capture_types.mojom', '../../../../../media/capture/mojom/video_capture_types.mojom.js');
  }
  var audio_parameters$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/audio_parameters.mojom', '../../../../../media/mojo/mojom/audio_parameters.mojom.js');
  }
  var display_media_information$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/display_media_information.mojom', '../../../../../media/mojo/mojom/display_media_information.mojom.js');
  }
  var token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/token.mojom', '../../../../../mojo/public/mojom/base/token.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var media_devices$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/mediastream/media_devices.mojom', 'media_devices.mojom.js');
  }


  var MediaStreamType = {};
  MediaStreamType.NO_SERVICE = 0;
  MediaStreamType.DEVICE_AUDIO_CAPTURE = 1;
  MediaStreamType.DEVICE_VIDEO_CAPTURE = 2;
  MediaStreamType.GUM_TAB_AUDIO_CAPTURE = 3;
  MediaStreamType.GUM_TAB_VIDEO_CAPTURE = 4;
  MediaStreamType.GUM_DESKTOP_VIDEO_CAPTURE = 5;
  MediaStreamType.GUM_DESKTOP_AUDIO_CAPTURE = 6;
  MediaStreamType.DISPLAY_VIDEO_CAPTURE = 7;
  MediaStreamType.DISPLAY_AUDIO_CAPTURE = 8;
  MediaStreamType.DISPLAY_VIDEO_CAPTURE_THIS_TAB = 9;
  MediaStreamType.DISPLAY_VIDEO_CAPTURE_SET = 10;
  MediaStreamType.NUM_MEDIA_TYPES = 11;
  MediaStreamType.MIN_VALUE = 0;
  MediaStreamType.MAX_VALUE = 11;

  MediaStreamType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
      return true;
    }
    return false;
  };

  MediaStreamType.toKnownEnumValue = function(value) {
    return value;
  };

  MediaStreamType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MediaStreamRequestResult = {};
  MediaStreamRequestResult.OK = 0;
  MediaStreamRequestResult.PERMISSION_DENIED = 1;
  MediaStreamRequestResult.PERMISSION_DISMISSED = 2;
  MediaStreamRequestResult.INVALID_STATE = 3;
  MediaStreamRequestResult.NO_HARDWARE = 4;
  MediaStreamRequestResult.INVALID_SECURITY_ORIGIN = 5;
  MediaStreamRequestResult.TAB_CAPTURE_FAILURE = 6;
  MediaStreamRequestResult.SCREEN_CAPTURE_FAILURE = 7;
  MediaStreamRequestResult.CAPTURE_FAILURE = 8;
  MediaStreamRequestResult.CONSTRAINT_NOT_SATISFIED = 9;
  MediaStreamRequestResult.TRACK_START_FAILURE_AUDIO = 10;
  MediaStreamRequestResult.TRACK_START_FAILURE_VIDEO = 11;
  MediaStreamRequestResult.NOT_SUPPORTED = 12;
  MediaStreamRequestResult.FAILED_DUE_TO_SHUTDOWN = 13;
  MediaStreamRequestResult.KILL_SWITCH_ON = 14;
  MediaStreamRequestResult.PERMISSION_DENIED_BY_SYSTEM = 15;
  MediaStreamRequestResult.DEVICE_IN_USE = 16;
  MediaStreamRequestResult.REQUEST_CANCELLED = 17;
  MediaStreamRequestResult.START_TIMEOUT = 18;
  MediaStreamRequestResult.PERMISSION_DENIED_BY_USER = 19;
  MediaStreamRequestResult.AUDIO_DEVICE_SOCKET_ERROR = 20;
  MediaStreamRequestResult.NO_TRANSIENT_ACTIVATION = 21;
  MediaStreamRequestResult.CAPTURE_NOT_ALLOWED_BY_POLICY = 22;
  MediaStreamRequestResult.INVALID_DISPLAY_CAPTURE_CONSTRAINTS = 23;
  MediaStreamRequestResult.INVALID_GUM_TAB_CAPTURE_CONSTRAINTS = 24;
  MediaStreamRequestResult.INVALID_GUM_SCREEN_CAPTURE_CONSTRAINTS = 25;
  MediaStreamRequestResult.INVALID_VIDEO_DEVICE_ID = 26;
  MediaStreamRequestResult.STREAM_NOT_FOUND_IN_REGISTRY = 27;
  MediaStreamRequestResult.ANDROID_CANT_REQUEST_PERMISSION = 28;
  MediaStreamRequestResult.MULTI_CAPTURE_NOT_SUPPORTED = 29;
  MediaStreamRequestResult.PERMISSION_DENIED_BY_EMBEDDER_CONTEXT = 30;
  MediaStreamRequestResult.DLP_PERMISSION_DENIED = 31;
  MediaStreamRequestResult.REGISTRY_REQUEST_UNVERIFIED = 32;
  MediaStreamRequestResult.NUM_MEDIA_REQUEST_RESULTS = 33;
  MediaStreamRequestResult.MIN_VALUE = 0;
  MediaStreamRequestResult.MAX_VALUE = 33;

  MediaStreamRequestResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
      return true;
    }
    return false;
  };

  MediaStreamRequestResult.toKnownEnumValue = function(value) {
    return value;
  };

  MediaStreamRequestResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MediaStreamStateChange = {};
  MediaStreamStateChange.PLAY = 0;
  MediaStreamStateChange.PAUSE = 1;
  MediaStreamStateChange.MIN_VALUE = 0;
  MediaStreamStateChange.MAX_VALUE = 1;

  MediaStreamStateChange.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  MediaStreamStateChange.toKnownEnumValue = function(value) {
    return value;
  };

  MediaStreamStateChange.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var PreferredDisplaySurface = {};
  PreferredDisplaySurface.NO_PREFERENCE = 0;
  PreferredDisplaySurface.MONITOR = 1;
  PreferredDisplaySurface.WINDOW = 2;
  PreferredDisplaySurface.BROWSER = 3;
  PreferredDisplaySurface.MIN_VALUE = 0;
  PreferredDisplaySurface.MAX_VALUE = 3;

  PreferredDisplaySurface.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  PreferredDisplaySurface.toKnownEnumValue = function(value) {
    return value;
  };

  PreferredDisplaySurface.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CapturedSurfaceControlResult = {};
  CapturedSurfaceControlResult.kSuccess = 0;
  CapturedSurfaceControlResult.kUnknownError = 1;
  CapturedSurfaceControlResult.kNoPermissionError = 2;
  CapturedSurfaceControlResult.kCapturerNotFoundError = 3;
  CapturedSurfaceControlResult.kCapturedSurfaceNotFoundError = 4;
  CapturedSurfaceControlResult.kDisallowedForSelfCaptureError = 5;
  CapturedSurfaceControlResult.kCapturerNotFocusedError = 6;
  CapturedSurfaceControlResult.kMinZoomLevel = 7;
  CapturedSurfaceControlResult.kMaxZoomLevel = 8;
  CapturedSurfaceControlResult.MIN_VALUE = 0;
  CapturedSurfaceControlResult.MAX_VALUE = 8;

  CapturedSurfaceControlResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
      return true;
    }
    return false;
  };

  CapturedSurfaceControlResult.toKnownEnumValue = function(value) {
    return value;
  };

  CapturedSurfaceControlResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ZoomLevelAction = {};
  ZoomLevelAction.kIncrease = 0;
  ZoomLevelAction.kDecrease = 1;
  ZoomLevelAction.kReset = 2;
  ZoomLevelAction.MIN_VALUE = 0;
  ZoomLevelAction.MAX_VALUE = 2;

  ZoomLevelAction.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ZoomLevelAction.toKnownEnumValue = function(value) {
    return value;
  };

  ZoomLevelAction.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WindowAudioPreference = {};
  WindowAudioPreference.kSystem = 0;
  WindowAudioPreference.kWindow = 1;
  WindowAudioPreference.kExclude = 2;
  WindowAudioPreference.MIN_VALUE = 0;
  WindowAudioPreference.MAX_VALUE = 2;

  WindowAudioPreference.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  WindowAudioPreference.toKnownEnumValue = function(value) {
    return value;
  };

  WindowAudioPreference.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SearchOnlyByDeviceId(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SearchOnlyByDeviceId.prototype.initDefaults_ = function() {
  };
  SearchOnlyByDeviceId.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SearchOnlyByDeviceId.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SearchOnlyByDeviceId.encodedSize = codec.kStructHeaderSize + 0;

  SearchOnlyByDeviceId.decode = function(decoder) {
    var packed;
    var val = new SearchOnlyByDeviceId();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SearchOnlyByDeviceId.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SearchOnlyByDeviceId.encodedSize);
    encoder.writeUint32(0);
  };
  function SearchBySessionId(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SearchBySessionId.prototype.initDefaults_ = function() {
    this.sessionIdMap = null;
  };
  SearchBySessionId.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SearchBySessionId.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SearchBySessionId.sessionIdMap
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.String, new codec.PointerTo(unguessable_token$.UnguessableToken), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SearchBySessionId.encodedSize = codec.kStructHeaderSize + 8;

  SearchBySessionId.decode = function(decoder) {
    var packed;
    var val = new SearchBySessionId();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sessionIdMap =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(unguessable_token$.UnguessableToken));
    return val;
  };

  SearchBySessionId.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SearchBySessionId.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(unguessable_token$.UnguessableToken), val.sessionIdMap);
  };
  function MediaStreamDevice(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDevice.prototype.initDefaults_ = function() {
    this.type = 0;
    this.videoFacing = 0;
    this.id = null;
    this.displayId = 0;
    this.groupId = null;
    this.matchedOutputDeviceId = null;
    this.name = null;
    this.input = null;
    this.sessionId = null;
    this.displayMediaInfo = null;
  };
  MediaStreamDevice.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDevice.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDevice.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, MediaStreamType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDevice.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate MediaStreamDevice.videoFacing
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, video_capture_types$.VideoFacingMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDevice.groupId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDevice.matchedOutputDeviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDevice.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDevice.input
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, audio_parameters$.AudioParameters, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDevice.sessionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDevice.displayMediaInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, display_media_information$.DisplayMediaInformation, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDevice.encodedSize = codec.kStructHeaderSize + 72;

  MediaStreamDevice.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDevice();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(MediaStreamType));
    val.videoFacing =
        decoder.decodeStruct(new codec.Enum(video_capture_types$.VideoFacingMode));
    val.id =
        decoder.decodeStruct(codec.String);
    val.displayId =
        decoder.decodeStruct(codec.Int64);
    val.groupId =
        decoder.decodeStruct(codec.String);
    val.matchedOutputDeviceId =
        decoder.decodeStruct(codec.String);
    val.name =
        decoder.decodeStruct(codec.String);
    val.input =
        decoder.decodeStructPointer(audio_parameters$.AudioParameters);
    val.sessionId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.displayMediaInfo =
        decoder.decodeStructPointer(display_media_information$.DisplayMediaInformation);
    return val;
  };

  MediaStreamDevice.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDevice.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.Int32, val.videoFacing);
    encoder.encodeStruct(codec.String, val.id);
    encoder.encodeStruct(codec.Int64, val.displayId);
    encoder.encodeStruct(codec.String, val.groupId);
    encoder.encodeStruct(codec.String, val.matchedOutputDeviceId);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStructPointer(audio_parameters$.AudioParameters, val.input);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.sessionId);
    encoder.encodeStructPointer(display_media_information$.DisplayMediaInformation, val.displayMediaInfo);
  };
  function TrackControls(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TrackControls.prototype.initDefaults_ = function() {
    this.streamType = 0;
    this.deviceIds = null;
  };
  TrackControls.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TrackControls.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrackControls.streamType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, MediaStreamType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrackControls.deviceIds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TrackControls.encodedSize = codec.kStructHeaderSize + 16;

  TrackControls.decode = function(decoder) {
    var packed;
    var val = new TrackControls();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.streamType =
        decoder.decodeStruct(new codec.Enum(MediaStreamType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.deviceIds =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  TrackControls.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TrackControls.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.streamType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.String, val.deviceIds);
  };
  function StreamControls(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StreamControls.prototype.initDefaults_ = function() {
    this.audio = null;
    this.video = null;
    this.hotwordEnabled = false;
    this.disableLocalEcho = false;
    this.suppressLocalAudioPlayback = false;
    this.restrictOwnAudio = false;
    this.excludeSystemAudio = false;
    this.excludeSelfBrowserSurface = false;
    this.requestPanTiltZoomPermission = false;
    this.requestAllScreens = false;
    this.dynamicSurfaceSwitchingRequested = false;
    this.excludeMonitorTypeSurfaces = false;
    this.windowAudioPreference = 0;
    this.preferredDisplaySurface = 0;
  };
  StreamControls.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StreamControls.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StreamControls.audio
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, TrackControls, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StreamControls.video
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, TrackControls, false);
    if (err !== validator.validationError.NONE)
        return err;







    // validate StreamControls.windowAudioPreference
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 20, WindowAudioPreference);
    if (err !== validator.validationError.NONE)
        return err;





    // validate StreamControls.preferredDisplaySurface
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, PreferredDisplaySurface);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  StreamControls.encodedSize = codec.kStructHeaderSize + 32;

  StreamControls.decode = function(decoder) {
    var packed;
    var val = new StreamControls();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.audio =
        decoder.decodeStructPointer(TrackControls);
    val.video =
        decoder.decodeStructPointer(TrackControls);
    packed = decoder.readUint8();
    val.hotwordEnabled = (packed >> 0) & 1 ? true : false;
    val.disableLocalEcho = (packed >> 1) & 1 ? true : false;
    val.suppressLocalAudioPlayback = (packed >> 2) & 1 ? true : false;
    val.restrictOwnAudio = (packed >> 3) & 1 ? true : false;
    val.excludeSystemAudio = (packed >> 4) & 1 ? true : false;
    val.excludeSelfBrowserSurface = (packed >> 5) & 1 ? true : false;
    val.requestPanTiltZoomPermission = (packed >> 6) & 1 ? true : false;
    val.requestAllScreens = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.dynamicSurfaceSwitchingRequested = (packed >> 0) & 1 ? true : false;
    val.excludeMonitorTypeSurfaces = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    val.windowAudioPreference =
        decoder.decodeStruct(new codec.Enum(WindowAudioPreference));
    val.preferredDisplaySurface =
        decoder.decodeStruct(new codec.Enum(PreferredDisplaySurface));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  StreamControls.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StreamControls.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(TrackControls, val.audio);
    encoder.encodeStructPointer(TrackControls, val.video);
    packed = 0;
    packed |= (val.hotwordEnabled & 1) << 0
    packed |= (val.disableLocalEcho & 1) << 1
    packed |= (val.suppressLocalAudioPlayback & 1) << 2
    packed |= (val.restrictOwnAudio & 1) << 3
    packed |= (val.excludeSystemAudio & 1) << 4
    packed |= (val.excludeSelfBrowserSurface & 1) << 5
    packed |= (val.requestPanTiltZoomPermission & 1) << 6
    packed |= (val.requestAllScreens & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.dynamicSurfaceSwitchingRequested & 1) << 0
    packed |= (val.excludeMonitorTypeSurfaces & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.windowAudioPreference);
    encoder.encodeStruct(codec.Int32, val.preferredDisplaySurface);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function GetOpenDeviceResponse(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GetOpenDeviceResponse.prototype.initDefaults_ = function() {
    this.label = null;
    this.device = null;
    this.panTiltZoomAllowed = false;
  };
  GetOpenDeviceResponse.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GetOpenDeviceResponse.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GetOpenDeviceResponse.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate GetOpenDeviceResponse.device
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, MediaStreamDevice, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  GetOpenDeviceResponse.encodedSize = codec.kStructHeaderSize + 24;

  GetOpenDeviceResponse.decode = function(decoder) {
    var packed;
    var val = new GetOpenDeviceResponse();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.label =
        decoder.decodeStruct(codec.String);
    val.device =
        decoder.decodeStructPointer(MediaStreamDevice);
    packed = decoder.readUint8();
    val.panTiltZoomAllowed = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  GetOpenDeviceResponse.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GetOpenDeviceResponse.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.label);
    encoder.encodeStructPointer(MediaStreamDevice, val.device);
    packed = 0;
    packed |= (val.panTiltZoomAllowed & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CapturedWheelAction(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CapturedWheelAction.prototype.initDefaults_ = function() {
    this.relativeX = 0;
    this.relativeY = 0;
    this.wheelDeltaX = 0;
    this.wheelDeltaY = 0;
  };
  CapturedWheelAction.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CapturedWheelAction.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  CapturedWheelAction.encodedSize = codec.kStructHeaderSize + 24;

  CapturedWheelAction.decode = function(decoder) {
    var packed;
    var val = new CapturedWheelAction();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.relativeX =
        decoder.decodeStruct(codec.Double);
    val.relativeY =
        decoder.decodeStruct(codec.Double);
    val.wheelDeltaX =
        decoder.decodeStruct(codec.Int32);
    val.wheelDeltaY =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  CapturedWheelAction.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CapturedWheelAction.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Double, val.relativeX);
    encoder.encodeStruct(codec.Double, val.relativeY);
    encoder.encodeStruct(codec.Int32, val.wheelDeltaX);
    encoder.encodeStruct(codec.Int32, val.wheelDeltaY);
  };
  function StreamDevices(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StreamDevices.prototype.initDefaults_ = function() {
    this.audioDevice = null;
    this.videoDevice = null;
  };
  StreamDevices.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StreamDevices.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StreamDevices.audioDevice
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, MediaStreamDevice, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StreamDevices.videoDevice
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, MediaStreamDevice, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StreamDevices.encodedSize = codec.kStructHeaderSize + 16;

  StreamDevices.decode = function(decoder) {
    var packed;
    var val = new StreamDevices();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.audioDevice =
        decoder.decodeStructPointer(MediaStreamDevice);
    val.videoDevice =
        decoder.decodeStructPointer(MediaStreamDevice);
    return val;
  };

  StreamDevices.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StreamDevices.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(MediaStreamDevice, val.audioDevice);
    encoder.encodeStructPointer(MediaStreamDevice, val.videoDevice);
  };
  function StreamDevicesSet(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StreamDevicesSet.prototype.initDefaults_ = function() {
    this.streamDevices = null;
  };
  StreamDevicesSet.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StreamDevicesSet.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StreamDevicesSet.streamDevices
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(StreamDevices), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StreamDevicesSet.encodedSize = codec.kStructHeaderSize + 8;

  StreamDevicesSet.decode = function(decoder) {
    var packed;
    var val = new StreamDevicesSet();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.streamDevices =
        decoder.decodeArrayPointer(new codec.PointerTo(StreamDevices));
    return val;
  };

  StreamDevicesSet.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StreamDevicesSet.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(StreamDevices), val.streamDevices);
  };
  function MediaStreamDeviceObserver_OnDeviceStopped_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDeviceObserver_OnDeviceStopped_Params.prototype.initDefaults_ = function() {
    this.label = null;
    this.device = null;
  };
  MediaStreamDeviceObserver_OnDeviceStopped_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDeviceObserver_OnDeviceStopped_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDeviceObserver_OnDeviceStopped_Params.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDeviceObserver_OnDeviceStopped_Params.device
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, MediaStreamDevice, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDeviceObserver_OnDeviceStopped_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaStreamDeviceObserver_OnDeviceStopped_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDeviceObserver_OnDeviceStopped_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.label =
        decoder.decodeStruct(codec.String);
    val.device =
        decoder.decodeStructPointer(MediaStreamDevice);
    return val;
  };

  MediaStreamDeviceObserver_OnDeviceStopped_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDeviceObserver_OnDeviceStopped_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.label);
    encoder.encodeStructPointer(MediaStreamDevice, val.device);
  };
  function MediaStreamDeviceObserver_OnDeviceChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDeviceObserver_OnDeviceChanged_Params.prototype.initDefaults_ = function() {
    this.label = null;
    this.oldDevice = null;
    this.newDevice = null;
  };
  MediaStreamDeviceObserver_OnDeviceChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDeviceObserver_OnDeviceChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDeviceObserver_OnDeviceChanged_Params.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDeviceObserver_OnDeviceChanged_Params.oldDevice
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, MediaStreamDevice, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDeviceObserver_OnDeviceChanged_Params.newDevice
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, MediaStreamDevice, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDeviceObserver_OnDeviceChanged_Params.encodedSize = codec.kStructHeaderSize + 24;

  MediaStreamDeviceObserver_OnDeviceChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDeviceObserver_OnDeviceChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.label =
        decoder.decodeStruct(codec.String);
    val.oldDevice =
        decoder.decodeStructPointer(MediaStreamDevice);
    val.newDevice =
        decoder.decodeStructPointer(MediaStreamDevice);
    return val;
  };

  MediaStreamDeviceObserver_OnDeviceChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDeviceObserver_OnDeviceChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.label);
    encoder.encodeStructPointer(MediaStreamDevice, val.oldDevice);
    encoder.encodeStructPointer(MediaStreamDevice, val.newDevice);
  };
  function MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params.prototype.initDefaults_ = function() {
    this.label = null;
    this.device = null;
    this.newState = 0;
  };
  MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params.device
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, MediaStreamDevice, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params.newState
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, MediaStreamStateChange);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params.encodedSize = codec.kStructHeaderSize + 24;

  MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.label =
        decoder.decodeStruct(codec.String);
    val.device =
        decoder.decodeStructPointer(MediaStreamDevice);
    val.newState =
        decoder.decodeStruct(new codec.Enum(MediaStreamStateChange));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.label);
    encoder.encodeStructPointer(MediaStreamDevice, val.device);
    encoder.encodeStruct(codec.Int32, val.newState);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params.prototype.initDefaults_ = function() {
    this.label = null;
    this.device = null;
  };
  MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params.device
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, MediaStreamDevice, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.label =
        decoder.decodeStruct(codec.String);
    val.device =
        decoder.decodeStructPointer(MediaStreamDevice);
    return val;
  };

  MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.label);
    encoder.encodeStructPointer(MediaStreamDevice, val.device);
  };
  function MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params.prototype.initDefaults_ = function() {
    this.label = null;
    this.device = null;
  };
  MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params.device
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, MediaStreamDevice, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.label =
        decoder.decodeStruct(codec.String);
    val.device =
        decoder.decodeStructPointer(MediaStreamDevice);
    return val;
  };

  MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.label);
    encoder.encodeStructPointer(MediaStreamDevice, val.device);
  };
  function MediaStreamDeviceObserver_OnZoomLevelChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDeviceObserver_OnZoomLevelChange_Params.prototype.initDefaults_ = function() {
    this.label = null;
    this.device = null;
    this.zoomLevel = 0;
  };
  MediaStreamDeviceObserver_OnZoomLevelChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDeviceObserver_OnZoomLevelChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDeviceObserver_OnZoomLevelChange_Params.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDeviceObserver_OnZoomLevelChange_Params.device
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, MediaStreamDevice, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaStreamDeviceObserver_OnZoomLevelChange_Params.encodedSize = codec.kStructHeaderSize + 24;

  MediaStreamDeviceObserver_OnZoomLevelChange_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDeviceObserver_OnZoomLevelChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.label =
        decoder.decodeStruct(codec.String);
    val.device =
        decoder.decodeStructPointer(MediaStreamDevice);
    val.zoomLevel =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaStreamDeviceObserver_OnZoomLevelChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDeviceObserver_OnZoomLevelChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.label);
    encoder.encodeStructPointer(MediaStreamDevice, val.device);
    encoder.encodeStruct(codec.Int32, val.zoomLevel);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaStreamDispatcherHost_GenerateStreams_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_GenerateStreams_Params.prototype.initDefaults_ = function() {
    this.requestId = 0;
    this.userGesture = false;
    this.controls = null;
    this.audioStreamSelectionInfo = null;
  };
  MediaStreamDispatcherHost_GenerateStreams_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_GenerateStreams_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate MediaStreamDispatcherHost_GenerateStreams_Params.controls
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, StreamControls, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate MediaStreamDispatcherHost_GenerateStreams_Params.audioStreamSelectionInfo
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, StreamSelectionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_GenerateStreams_Params.encodedSize = codec.kStructHeaderSize + 32;

  MediaStreamDispatcherHost_GenerateStreams_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_GenerateStreams_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.userGesture = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.controls =
        decoder.decodeStructPointer(StreamControls);
    val.audioStreamSelectionInfo =
        decoder.decodeStruct(StreamSelectionInfo);
    return val;
  };

  MediaStreamDispatcherHost_GenerateStreams_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_GenerateStreams_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.requestId);
    packed = 0;
    packed |= (val.userGesture & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(StreamControls, val.controls);
    encoder.encodeStruct(StreamSelectionInfo, val.audioStreamSelectionInfo);
  };
  function MediaStreamDispatcherHost_GenerateStreams_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_GenerateStreams_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.panTiltZoomAllowed = false;
    this.label = null;
    this.streamDevices = null;
  };
  MediaStreamDispatcherHost_GenerateStreams_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_GenerateStreams_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_GenerateStreams_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, MediaStreamRequestResult);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_GenerateStreams_ResponseParams.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_GenerateStreams_ResponseParams.streamDevices
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, StreamDevicesSet, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_GenerateStreams_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  MediaStreamDispatcherHost_GenerateStreams_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_GenerateStreams_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(MediaStreamRequestResult));
    packed = decoder.readUint8();
    val.panTiltZoomAllowed = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.label =
        decoder.decodeStruct(codec.String);
    val.streamDevices =
        decoder.decodeStructPointer(StreamDevicesSet);
    return val;
  };

  MediaStreamDispatcherHost_GenerateStreams_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_GenerateStreams_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    packed = 0;
    packed |= (val.panTiltZoomAllowed & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.label);
    encoder.encodeStructPointer(StreamDevicesSet, val.streamDevices);
  };
  function MediaStreamDispatcherHost_FocusCapturedSurface_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_FocusCapturedSurface_Params.prototype.initDefaults_ = function() {
    this.label = null;
    this.focus = false;
  };
  MediaStreamDispatcherHost_FocusCapturedSurface_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_FocusCapturedSurface_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_FocusCapturedSurface_Params.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_FocusCapturedSurface_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaStreamDispatcherHost_FocusCapturedSurface_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_FocusCapturedSurface_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.label =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.focus = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaStreamDispatcherHost_FocusCapturedSurface_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_FocusCapturedSurface_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.label);
    packed = 0;
    packed |= (val.focus & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaStreamDispatcherHost_CancelRequest_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_CancelRequest_Params.prototype.initDefaults_ = function() {
    this.requestId = 0;
  };
  MediaStreamDispatcherHost_CancelRequest_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_CancelRequest_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_CancelRequest_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaStreamDispatcherHost_CancelRequest_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_CancelRequest_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaStreamDispatcherHost_CancelRequest_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_CancelRequest_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.requestId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaStreamDispatcherHost_StopStreamDevice_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_StopStreamDevice_Params.prototype.initDefaults_ = function() {
    this.deviceId = null;
    this.sessionId = null;
  };
  MediaStreamDispatcherHost_StopStreamDevice_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_StopStreamDevice_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_StopStreamDevice_Params.deviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_StopStreamDevice_Params.sessionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_StopStreamDevice_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaStreamDispatcherHost_StopStreamDevice_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_StopStreamDevice_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.deviceId =
        decoder.decodeStruct(codec.String);
    val.sessionId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  MediaStreamDispatcherHost_StopStreamDevice_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_StopStreamDevice_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.deviceId);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.sessionId);
  };
  function MediaStreamDispatcherHost_OpenDevice_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_OpenDevice_Params.prototype.initDefaults_ = function() {
    this.requestId = 0;
    this.type = 0;
    this.deviceId = null;
  };
  MediaStreamDispatcherHost_OpenDevice_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_OpenDevice_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate MediaStreamDispatcherHost_OpenDevice_Params.deviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_OpenDevice_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, MediaStreamType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_OpenDevice_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaStreamDispatcherHost_OpenDevice_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_OpenDevice_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    val.type =
        decoder.decodeStruct(new codec.Enum(MediaStreamType));
    val.deviceId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MediaStreamDispatcherHost_OpenDevice_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_OpenDevice_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.requestId);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.String, val.deviceId);
  };
  function MediaStreamDispatcherHost_OpenDevice_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_OpenDevice_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
    this.label = null;
    this.device = null;
  };
  MediaStreamDispatcherHost_OpenDevice_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_OpenDevice_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate MediaStreamDispatcherHost_OpenDevice_ResponseParams.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_OpenDevice_ResponseParams.device
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, MediaStreamDevice, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_OpenDevice_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  MediaStreamDispatcherHost_OpenDevice_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_OpenDevice_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.label =
        decoder.decodeStruct(codec.String);
    val.device =
        decoder.decodeStructPointer(MediaStreamDevice);
    return val;
  };

  MediaStreamDispatcherHost_OpenDevice_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_OpenDevice_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.label);
    encoder.encodeStructPointer(MediaStreamDevice, val.device);
  };
  function MediaStreamDispatcherHost_CloseDevice_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_CloseDevice_Params.prototype.initDefaults_ = function() {
    this.label = null;
  };
  MediaStreamDispatcherHost_CloseDevice_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_CloseDevice_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_CloseDevice_Params.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_CloseDevice_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaStreamDispatcherHost_CloseDevice_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_CloseDevice_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.label =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MediaStreamDispatcherHost_CloseDevice_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_CloseDevice_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.label);
  };
  function MediaStreamDispatcherHost_SetCapturingLinkSecured_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_SetCapturingLinkSecured_Params.prototype.initDefaults_ = function() {
    this.sessionId = null;
    this.type = 0;
    this.isSecure = false;
  };
  MediaStreamDispatcherHost_SetCapturingLinkSecured_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_SetCapturingLinkSecured_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_SetCapturingLinkSecured_Params.sessionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_SetCapturingLinkSecured_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, MediaStreamType);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_SetCapturingLinkSecured_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaStreamDispatcherHost_SetCapturingLinkSecured_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_SetCapturingLinkSecured_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sessionId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.type =
        decoder.decodeStruct(new codec.Enum(MediaStreamType));
    packed = decoder.readUint8();
    val.isSecure = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaStreamDispatcherHost_SetCapturingLinkSecured_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_SetCapturingLinkSecured_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.sessionId);
    encoder.encodeStruct(codec.Int32, val.type);
    packed = 0;
    packed |= (val.isSecure & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaStreamDispatcherHost_ApplySubCaptureTarget_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_ApplySubCaptureTarget_Params.prototype.initDefaults_ = function() {
    this.sessionId = null;
    this.type = 0;
    this.subCaptureTargetVersion = 0;
    this.subCaptureTarget = null;
  };
  MediaStreamDispatcherHost_ApplySubCaptureTarget_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_ApplySubCaptureTarget_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_ApplySubCaptureTarget_Params.sessionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_ApplySubCaptureTarget_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, video_capture_types$.SubCaptureTargetType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_ApplySubCaptureTarget_Params.subCaptureTarget
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, token$.Token, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_ApplySubCaptureTarget_Params.encodedSize = codec.kStructHeaderSize + 24;

  MediaStreamDispatcherHost_ApplySubCaptureTarget_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_ApplySubCaptureTarget_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sessionId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.type =
        decoder.decodeStruct(new codec.Enum(video_capture_types$.SubCaptureTargetType));
    val.subCaptureTargetVersion =
        decoder.decodeStruct(codec.Uint32);
    val.subCaptureTarget =
        decoder.decodeStructPointer(token$.Token);
    return val;
  };

  MediaStreamDispatcherHost_ApplySubCaptureTarget_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_ApplySubCaptureTarget_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.sessionId);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.Uint32, val.subCaptureTargetVersion);
    encoder.encodeStructPointer(token$.Token, val.subCaptureTarget);
  };
  function MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, video_capture_types$.ApplySubCaptureTargetResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(video_capture_types$.ApplySubCaptureTargetResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaStreamDispatcherHost_SendWheel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_SendWheel_Params.prototype.initDefaults_ = function() {
    this.sessionId = null;
    this.action = null;
  };
  MediaStreamDispatcherHost_SendWheel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_SendWheel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_SendWheel_Params.sessionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_SendWheel_Params.action
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, CapturedWheelAction, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_SendWheel_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaStreamDispatcherHost_SendWheel_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_SendWheel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sessionId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.action =
        decoder.decodeStructPointer(CapturedWheelAction);
    return val;
  };

  MediaStreamDispatcherHost_SendWheel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_SendWheel_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.sessionId);
    encoder.encodeStructPointer(CapturedWheelAction, val.action);
  };
  function MediaStreamDispatcherHost_UpdateZoomLevel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_UpdateZoomLevel_Params.prototype.initDefaults_ = function() {
    this.sessionId = null;
    this.action = 0;
  };
  MediaStreamDispatcherHost_UpdateZoomLevel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_UpdateZoomLevel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_UpdateZoomLevel_Params.sessionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_UpdateZoomLevel_Params.action
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, ZoomLevelAction);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_UpdateZoomLevel_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaStreamDispatcherHost_UpdateZoomLevel_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_UpdateZoomLevel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sessionId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.action =
        decoder.decodeStruct(new codec.Enum(ZoomLevelAction));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaStreamDispatcherHost_UpdateZoomLevel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_UpdateZoomLevel_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.sessionId);
    encoder.encodeStruct(codec.Int32, val.action);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CapturedSurfaceControlResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(CapturedSurfaceControlResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params.prototype.initDefaults_ = function() {
    this.sessionId = null;
  };
  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params.sessionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sessionId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.sessionId);
  };
  function MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CapturedSurfaceControlResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(CapturedSurfaceControlResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaStreamDispatcherHost_GetOpenDevice_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_GetOpenDevice_Params.prototype.initDefaults_ = function() {
    this.requestId = 0;
    this.sessionId = null;
    this.transferId = null;
  };
  MediaStreamDispatcherHost_GetOpenDevice_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_GetOpenDevice_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate MediaStreamDispatcherHost_GetOpenDevice_Params.sessionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_GetOpenDevice_Params.transferId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_GetOpenDevice_Params.encodedSize = codec.kStructHeaderSize + 24;

  MediaStreamDispatcherHost_GetOpenDevice_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_GetOpenDevice_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.sessionId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.transferId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  MediaStreamDispatcherHost_GetOpenDevice_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_GetOpenDevice_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.requestId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.sessionId);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.transferId);
  };
  function MediaStreamDispatcherHost_GetOpenDevice_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_GetOpenDevice_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.response = null;
  };
  MediaStreamDispatcherHost_GetOpenDevice_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_GetOpenDevice_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_GetOpenDevice_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, MediaStreamRequestResult);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_GetOpenDevice_ResponseParams.response
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, GetOpenDeviceResponse, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_GetOpenDevice_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  MediaStreamDispatcherHost_GetOpenDevice_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_GetOpenDevice_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(MediaStreamRequestResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.response =
        decoder.decodeStructPointer(GetOpenDeviceResponse);
    return val;
  };

  MediaStreamDispatcherHost_GetOpenDevice_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_GetOpenDevice_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(GetOpenDeviceResponse, val.response);
  };
  function MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params.prototype.initDefaults_ = function() {
    this.sessionId = null;
    this.transferId = null;
  };
  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params.sessionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params.transferId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sessionId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.transferId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.sessionId);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.transferId);
  };
  function MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams.prototype.initDefaults_ = function() {
    this.deviceFound = false;
  };
  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.deviceFound = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.deviceFound & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaStreamTrackMetricsHost_AddTrack_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamTrackMetricsHost_AddTrack_Params.prototype.initDefaults_ = function() {
    this.id = 0;
    this.isAudio = false;
    this.isRemote = false;
  };
  MediaStreamTrackMetricsHost_AddTrack_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamTrackMetricsHost_AddTrack_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  MediaStreamTrackMetricsHost_AddTrack_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaStreamTrackMetricsHost_AddTrack_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamTrackMetricsHost_AddTrack_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Uint64);
    packed = decoder.readUint8();
    val.isAudio = (packed >> 0) & 1 ? true : false;
    val.isRemote = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaStreamTrackMetricsHost_AddTrack_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamTrackMetricsHost_AddTrack_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.id);
    packed = 0;
    packed |= (val.isAudio & 1) << 0
    packed |= (val.isRemote & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaStreamTrackMetricsHost_RemoveTrack_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaStreamTrackMetricsHost_RemoveTrack_Params.prototype.initDefaults_ = function() {
    this.id = 0;
  };
  MediaStreamTrackMetricsHost_RemoveTrack_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaStreamTrackMetricsHost_RemoveTrack_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaStreamTrackMetricsHost_RemoveTrack_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaStreamTrackMetricsHost_RemoveTrack_Params.decode = function(decoder) {
    var packed;
    var val = new MediaStreamTrackMetricsHost_RemoveTrack_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  MediaStreamTrackMetricsHost_RemoveTrack_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaStreamTrackMetricsHost_RemoveTrack_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.id);
  };

  function StreamSelectionInfo(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  StreamSelectionInfo.Tags = {
    searchOnlyByDeviceId: 0,
    searchBySessionId: 1,
  };

  StreamSelectionInfo.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  StreamSelectionInfo.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "searchOnlyByDeviceId",
        "searchBySessionId",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a StreamSelectionInfo member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(StreamSelectionInfo.prototype, "searchOnlyByDeviceId", {
    get: function() {
      if (this.$tag != StreamSelectionInfo.Tags.searchOnlyByDeviceId) {
        throw new ReferenceError(
            "StreamSelectionInfo.searchOnlyByDeviceId is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = StreamSelectionInfo.Tags.searchOnlyByDeviceId;
      this.$data = value;
    }
  });
  Object.defineProperty(StreamSelectionInfo.prototype, "searchBySessionId", {
    get: function() {
      if (this.$tag != StreamSelectionInfo.Tags.searchBySessionId) {
        throw new ReferenceError(
            "StreamSelectionInfo.searchBySessionId is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = StreamSelectionInfo.Tags.searchBySessionId;
      this.$data = value;
    }
  });


    StreamSelectionInfo.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case StreamSelectionInfo.Tags.searchOnlyByDeviceId:
          encoder.encodeStructPointer(SearchOnlyByDeviceId, val.searchOnlyByDeviceId);
          break;
        case StreamSelectionInfo.Tags.searchBySessionId:
          encoder.encodeStructPointer(SearchBySessionId, val.searchBySessionId);
          break;
      }
      encoder.align();
    };


    StreamSelectionInfo.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new StreamSelectionInfo();
      var tag = decoder.readUint32();
      switch (tag) {
        case StreamSelectionInfo.Tags.searchOnlyByDeviceId:
          result.searchOnlyByDeviceId = decoder.decodeStructPointer(SearchOnlyByDeviceId);
          break;
        case StreamSelectionInfo.Tags.searchBySessionId:
          result.searchBySessionId = decoder.decodeStructPointer(SearchBySessionId);
          break;
      }
      decoder.align();

      return result;
    };


    StreamSelectionInfo.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case StreamSelectionInfo.Tags.searchOnlyByDeviceId:
          

    // validate StreamSelectionInfo.searchOnlyByDeviceId
    err = messageValidator.validateStructPointer(data_offset, SearchOnlyByDeviceId, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case StreamSelectionInfo.Tags.searchBySessionId:
          

    // validate StreamSelectionInfo.searchBySessionId
    err = messageValidator.validateStructPointer(data_offset, SearchBySessionId, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  StreamSelectionInfo.encodedSize = 16;
  var kMediaStreamDeviceObserver_OnDeviceStopped_Name = 0;
  var kMediaStreamDeviceObserver_OnDeviceChanged_Name = 1;
  var kMediaStreamDeviceObserver_OnDeviceRequestStateChange_Name = 2;
  var kMediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Name = 3;
  var kMediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Name = 4;
  var kMediaStreamDeviceObserver_OnZoomLevelChange_Name = 5;

  function MediaStreamDeviceObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MediaStreamDeviceObserver,
                                                   handleOrPtrInfo);
  }

  function MediaStreamDeviceObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MediaStreamDeviceObserver, associatedInterfacePtrInfo);
  }

  MediaStreamDeviceObserverAssociatedPtr.prototype =
      Object.create(MediaStreamDeviceObserverPtr.prototype);
  MediaStreamDeviceObserverAssociatedPtr.prototype.constructor =
      MediaStreamDeviceObserverAssociatedPtr;

  function MediaStreamDeviceObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  MediaStreamDeviceObserverPtr.prototype.onDeviceStopped = function() {
    return MediaStreamDeviceObserverProxy.prototype.onDeviceStopped
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDeviceObserverProxy.prototype.onDeviceStopped = function(label, device) {
    var params_ = new MediaStreamDeviceObserver_OnDeviceStopped_Params();
    params_.label = label;
    params_.device = device;
    var builder = new codec.MessageV0Builder(
        kMediaStreamDeviceObserver_OnDeviceStopped_Name,
        codec.align(MediaStreamDeviceObserver_OnDeviceStopped_Params.encodedSize));
    builder.encodeStruct(MediaStreamDeviceObserver_OnDeviceStopped_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaStreamDeviceObserverPtr.prototype.onDeviceChanged = function() {
    return MediaStreamDeviceObserverProxy.prototype.onDeviceChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDeviceObserverProxy.prototype.onDeviceChanged = function(label, oldDevice, newDevice) {
    var params_ = new MediaStreamDeviceObserver_OnDeviceChanged_Params();
    params_.label = label;
    params_.oldDevice = oldDevice;
    params_.newDevice = newDevice;
    var builder = new codec.MessageV0Builder(
        kMediaStreamDeviceObserver_OnDeviceChanged_Name,
        codec.align(MediaStreamDeviceObserver_OnDeviceChanged_Params.encodedSize));
    builder.encodeStruct(MediaStreamDeviceObserver_OnDeviceChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaStreamDeviceObserverPtr.prototype.onDeviceRequestStateChange = function() {
    return MediaStreamDeviceObserverProxy.prototype.onDeviceRequestStateChange
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDeviceObserverProxy.prototype.onDeviceRequestStateChange = function(label, device, newState) {
    var params_ = new MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params();
    params_.label = label;
    params_.device = device;
    params_.newState = newState;
    var builder = new codec.MessageV0Builder(
        kMediaStreamDeviceObserver_OnDeviceRequestStateChange_Name,
        codec.align(MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params.encodedSize));
    builder.encodeStruct(MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaStreamDeviceObserverPtr.prototype.onDeviceCaptureConfigurationChange = function() {
    return MediaStreamDeviceObserverProxy.prototype.onDeviceCaptureConfigurationChange
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDeviceObserverProxy.prototype.onDeviceCaptureConfigurationChange = function(label, device) {
    var params_ = new MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params();
    params_.label = label;
    params_.device = device;
    var builder = new codec.MessageV0Builder(
        kMediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Name,
        codec.align(MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params.encodedSize));
    builder.encodeStruct(MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaStreamDeviceObserverPtr.prototype.onDeviceCaptureHandleChange = function() {
    return MediaStreamDeviceObserverProxy.prototype.onDeviceCaptureHandleChange
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDeviceObserverProxy.prototype.onDeviceCaptureHandleChange = function(label, device) {
    var params_ = new MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params();
    params_.label = label;
    params_.device = device;
    var builder = new codec.MessageV0Builder(
        kMediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Name,
        codec.align(MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params.encodedSize));
    builder.encodeStruct(MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaStreamDeviceObserverPtr.prototype.onZoomLevelChange = function() {
    return MediaStreamDeviceObserverProxy.prototype.onZoomLevelChange
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDeviceObserverProxy.prototype.onZoomLevelChange = function(label, device, zoomLevel) {
    var params_ = new MediaStreamDeviceObserver_OnZoomLevelChange_Params();
    params_.label = label;
    params_.device = device;
    params_.zoomLevel = zoomLevel;
    var builder = new codec.MessageV0Builder(
        kMediaStreamDeviceObserver_OnZoomLevelChange_Name,
        codec.align(MediaStreamDeviceObserver_OnZoomLevelChange_Params.encodedSize));
    builder.encodeStruct(MediaStreamDeviceObserver_OnZoomLevelChange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function MediaStreamDeviceObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  MediaStreamDeviceObserverStub.prototype.onDeviceStopped = function(label, device) {
    return this.delegate_ && this.delegate_.onDeviceStopped && this.delegate_.onDeviceStopped(label, device);
  }
  MediaStreamDeviceObserverStub.prototype.onDeviceChanged = function(label, oldDevice, newDevice) {
    return this.delegate_ && this.delegate_.onDeviceChanged && this.delegate_.onDeviceChanged(label, oldDevice, newDevice);
  }
  MediaStreamDeviceObserverStub.prototype.onDeviceRequestStateChange = function(label, device, newState) {
    return this.delegate_ && this.delegate_.onDeviceRequestStateChange && this.delegate_.onDeviceRequestStateChange(label, device, newState);
  }
  MediaStreamDeviceObserverStub.prototype.onDeviceCaptureConfigurationChange = function(label, device) {
    return this.delegate_ && this.delegate_.onDeviceCaptureConfigurationChange && this.delegate_.onDeviceCaptureConfigurationChange(label, device);
  }
  MediaStreamDeviceObserverStub.prototype.onDeviceCaptureHandleChange = function(label, device) {
    return this.delegate_ && this.delegate_.onDeviceCaptureHandleChange && this.delegate_.onDeviceCaptureHandleChange(label, device);
  }
  MediaStreamDeviceObserverStub.prototype.onZoomLevelChange = function(label, device, zoomLevel) {
    return this.delegate_ && this.delegate_.onZoomLevelChange && this.delegate_.onZoomLevelChange(label, device, zoomLevel);
  }

  MediaStreamDeviceObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaStreamDeviceObserver_OnDeviceStopped_Name:
      var params = reader.decodeStruct(MediaStreamDeviceObserver_OnDeviceStopped_Params);
      this.onDeviceStopped(params.label, params.device);
      return true;
    case kMediaStreamDeviceObserver_OnDeviceChanged_Name:
      var params = reader.decodeStruct(MediaStreamDeviceObserver_OnDeviceChanged_Params);
      this.onDeviceChanged(params.label, params.oldDevice, params.newDevice);
      return true;
    case kMediaStreamDeviceObserver_OnDeviceRequestStateChange_Name:
      var params = reader.decodeStruct(MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params);
      this.onDeviceRequestStateChange(params.label, params.device, params.newState);
      return true;
    case kMediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Name:
      var params = reader.decodeStruct(MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params);
      this.onDeviceCaptureConfigurationChange(params.label, params.device);
      return true;
    case kMediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Name:
      var params = reader.decodeStruct(MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params);
      this.onDeviceCaptureHandleChange(params.label, params.device);
      return true;
    case kMediaStreamDeviceObserver_OnZoomLevelChange_Name:
      var params = reader.decodeStruct(MediaStreamDeviceObserver_OnZoomLevelChange_Params);
      this.onZoomLevelChange(params.label, params.device, params.zoomLevel);
      return true;
    default:
      return false;
    }
  };

  MediaStreamDeviceObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateMediaStreamDeviceObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMediaStreamDeviceObserver_OnDeviceStopped_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaStreamDeviceObserver_OnDeviceStopped_Params;
      break;
      case kMediaStreamDeviceObserver_OnDeviceChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaStreamDeviceObserver_OnDeviceChanged_Params;
      break;
      case kMediaStreamDeviceObserver_OnDeviceRequestStateChange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params;
      break;
      case kMediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params;
      break;
      case kMediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params;
      break;
      case kMediaStreamDeviceObserver_OnZoomLevelChange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaStreamDeviceObserver_OnZoomLevelChange_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMediaStreamDeviceObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var MediaStreamDeviceObserver = {
    name: 'blink.mojom.MediaStreamDeviceObserver',
    kVersion: 0,
    ptrClass: MediaStreamDeviceObserverPtr,
    proxyClass: MediaStreamDeviceObserverProxy,
    stubClass: MediaStreamDeviceObserverStub,
    validateRequest: validateMediaStreamDeviceObserverRequest,
    validateResponse: null,
  };
  MediaStreamDeviceObserverStub.prototype.validator = validateMediaStreamDeviceObserverRequest;
  MediaStreamDeviceObserverProxy.prototype.validator = null;
  var kMediaStreamDispatcherHost_GenerateStreams_Name = 0;
  var kMediaStreamDispatcherHost_FocusCapturedSurface_Name = 1;
  var kMediaStreamDispatcherHost_CancelRequest_Name = 2;
  var kMediaStreamDispatcherHost_StopStreamDevice_Name = 3;
  var kMediaStreamDispatcherHost_OpenDevice_Name = 4;
  var kMediaStreamDispatcherHost_CloseDevice_Name = 5;
  var kMediaStreamDispatcherHost_SetCapturingLinkSecured_Name = 6;
  var kMediaStreamDispatcherHost_ApplySubCaptureTarget_Name = 7;
  var kMediaStreamDispatcherHost_SendWheel_Name = 8;
  var kMediaStreamDispatcherHost_UpdateZoomLevel_Name = 9;
  var kMediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Name = 10;
  var kMediaStreamDispatcherHost_GetOpenDevice_Name = 11;
  var kMediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Name = 12;

  function MediaStreamDispatcherHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MediaStreamDispatcherHost,
                                                   handleOrPtrInfo);
  }

  function MediaStreamDispatcherHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MediaStreamDispatcherHost, associatedInterfacePtrInfo);
  }

  MediaStreamDispatcherHostAssociatedPtr.prototype =
      Object.create(MediaStreamDispatcherHostPtr.prototype);
  MediaStreamDispatcherHostAssociatedPtr.prototype.constructor =
      MediaStreamDispatcherHostAssociatedPtr;

  function MediaStreamDispatcherHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  MediaStreamDispatcherHostPtr.prototype.generateStreams = function() {
    return MediaStreamDispatcherHostProxy.prototype.generateStreams
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDispatcherHostProxy.prototype.generateStreams = function(requestId, controls, userGesture, audioStreamSelectionInfo) {
    var params_ = new MediaStreamDispatcherHost_GenerateStreams_Params();
    params_.requestId = requestId;
    params_.controls = controls;
    params_.userGesture = userGesture;
    params_.audioStreamSelectionInfo = audioStreamSelectionInfo;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaStreamDispatcherHost_GenerateStreams_Name,
          codec.align(MediaStreamDispatcherHost_GenerateStreams_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaStreamDispatcherHost_GenerateStreams_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaStreamDispatcherHost_GenerateStreams_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaStreamDispatcherHostPtr.prototype.focusCapturedSurface = function() {
    return MediaStreamDispatcherHostProxy.prototype.focusCapturedSurface
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDispatcherHostProxy.prototype.focusCapturedSurface = function(label, focus) {
    var params_ = new MediaStreamDispatcherHost_FocusCapturedSurface_Params();
    params_.label = label;
    params_.focus = focus;
    var builder = new codec.MessageV0Builder(
        kMediaStreamDispatcherHost_FocusCapturedSurface_Name,
        codec.align(MediaStreamDispatcherHost_FocusCapturedSurface_Params.encodedSize));
    builder.encodeStruct(MediaStreamDispatcherHost_FocusCapturedSurface_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaStreamDispatcherHostPtr.prototype.cancelRequest = function() {
    return MediaStreamDispatcherHostProxy.prototype.cancelRequest
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDispatcherHostProxy.prototype.cancelRequest = function(requestId) {
    var params_ = new MediaStreamDispatcherHost_CancelRequest_Params();
    params_.requestId = requestId;
    var builder = new codec.MessageV0Builder(
        kMediaStreamDispatcherHost_CancelRequest_Name,
        codec.align(MediaStreamDispatcherHost_CancelRequest_Params.encodedSize));
    builder.encodeStruct(MediaStreamDispatcherHost_CancelRequest_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaStreamDispatcherHostPtr.prototype.stopStreamDevice = function() {
    return MediaStreamDispatcherHostProxy.prototype.stopStreamDevice
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDispatcherHostProxy.prototype.stopStreamDevice = function(deviceId, sessionId) {
    var params_ = new MediaStreamDispatcherHost_StopStreamDevice_Params();
    params_.deviceId = deviceId;
    params_.sessionId = sessionId;
    var builder = new codec.MessageV0Builder(
        kMediaStreamDispatcherHost_StopStreamDevice_Name,
        codec.align(MediaStreamDispatcherHost_StopStreamDevice_Params.encodedSize));
    builder.encodeStruct(MediaStreamDispatcherHost_StopStreamDevice_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaStreamDispatcherHostPtr.prototype.openDevice = function() {
    return MediaStreamDispatcherHostProxy.prototype.openDevice
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDispatcherHostProxy.prototype.openDevice = function(requestId, deviceId, type) {
    var params_ = new MediaStreamDispatcherHost_OpenDevice_Params();
    params_.requestId = requestId;
    params_.deviceId = deviceId;
    params_.type = type;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaStreamDispatcherHost_OpenDevice_Name,
          codec.align(MediaStreamDispatcherHost_OpenDevice_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaStreamDispatcherHost_OpenDevice_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaStreamDispatcherHost_OpenDevice_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaStreamDispatcherHostPtr.prototype.closeDevice = function() {
    return MediaStreamDispatcherHostProxy.prototype.closeDevice
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDispatcherHostProxy.prototype.closeDevice = function(label) {
    var params_ = new MediaStreamDispatcherHost_CloseDevice_Params();
    params_.label = label;
    var builder = new codec.MessageV0Builder(
        kMediaStreamDispatcherHost_CloseDevice_Name,
        codec.align(MediaStreamDispatcherHost_CloseDevice_Params.encodedSize));
    builder.encodeStruct(MediaStreamDispatcherHost_CloseDevice_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaStreamDispatcherHostPtr.prototype.setCapturingLinkSecured = function() {
    return MediaStreamDispatcherHostProxy.prototype.setCapturingLinkSecured
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDispatcherHostProxy.prototype.setCapturingLinkSecured = function(sessionId, type, isSecure) {
    var params_ = new MediaStreamDispatcherHost_SetCapturingLinkSecured_Params();
    params_.sessionId = sessionId;
    params_.type = type;
    params_.isSecure = isSecure;
    var builder = new codec.MessageV0Builder(
        kMediaStreamDispatcherHost_SetCapturingLinkSecured_Name,
        codec.align(MediaStreamDispatcherHost_SetCapturingLinkSecured_Params.encodedSize));
    builder.encodeStruct(MediaStreamDispatcherHost_SetCapturingLinkSecured_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaStreamDispatcherHostPtr.prototype.applySubCaptureTarget = function() {
    return MediaStreamDispatcherHostProxy.prototype.applySubCaptureTarget
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDispatcherHostProxy.prototype.applySubCaptureTarget = function(sessionId, type, subCaptureTarget, subCaptureTargetVersion) {
    var params_ = new MediaStreamDispatcherHost_ApplySubCaptureTarget_Params();
    params_.sessionId = sessionId;
    params_.type = type;
    params_.subCaptureTarget = subCaptureTarget;
    params_.subCaptureTargetVersion = subCaptureTargetVersion;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaStreamDispatcherHost_ApplySubCaptureTarget_Name,
          codec.align(MediaStreamDispatcherHost_ApplySubCaptureTarget_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaStreamDispatcherHost_ApplySubCaptureTarget_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaStreamDispatcherHostPtr.prototype.sendWheel = function() {
    return MediaStreamDispatcherHostProxy.prototype.sendWheel
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDispatcherHostProxy.prototype.sendWheel = function(sessionId, action) {
    var params_ = new MediaStreamDispatcherHost_SendWheel_Params();
    params_.sessionId = sessionId;
    params_.action = action;
    var builder = new codec.MessageV0Builder(
        kMediaStreamDispatcherHost_SendWheel_Name,
        codec.align(MediaStreamDispatcherHost_SendWheel_Params.encodedSize));
    builder.encodeStruct(MediaStreamDispatcherHost_SendWheel_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaStreamDispatcherHostPtr.prototype.updateZoomLevel = function() {
    return MediaStreamDispatcherHostProxy.prototype.updateZoomLevel
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDispatcherHostProxy.prototype.updateZoomLevel = function(sessionId, action) {
    var params_ = new MediaStreamDispatcherHost_UpdateZoomLevel_Params();
    params_.sessionId = sessionId;
    params_.action = action;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaStreamDispatcherHost_UpdateZoomLevel_Name,
          codec.align(MediaStreamDispatcherHost_UpdateZoomLevel_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaStreamDispatcherHost_UpdateZoomLevel_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaStreamDispatcherHostPtr.prototype.requestCapturedSurfaceControlPermission = function() {
    return MediaStreamDispatcherHostProxy.prototype.requestCapturedSurfaceControlPermission
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDispatcherHostProxy.prototype.requestCapturedSurfaceControlPermission = function(sessionId) {
    var params_ = new MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params();
    params_.sessionId = sessionId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Name,
          codec.align(MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaStreamDispatcherHostPtr.prototype.getOpenDevice = function() {
    return MediaStreamDispatcherHostProxy.prototype.getOpenDevice
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDispatcherHostProxy.prototype.getOpenDevice = function(requestId, sessionId, transferId) {
    var params_ = new MediaStreamDispatcherHost_GetOpenDevice_Params();
    params_.requestId = requestId;
    params_.sessionId = sessionId;
    params_.transferId = transferId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaStreamDispatcherHost_GetOpenDevice_Name,
          codec.align(MediaStreamDispatcherHost_GetOpenDevice_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaStreamDispatcherHost_GetOpenDevice_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaStreamDispatcherHost_GetOpenDevice_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaStreamDispatcherHostPtr.prototype.keepDeviceAliveForTransfer = function() {
    return MediaStreamDispatcherHostProxy.prototype.keepDeviceAliveForTransfer
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamDispatcherHostProxy.prototype.keepDeviceAliveForTransfer = function(sessionId, transferId) {
    var params_ = new MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params();
    params_.sessionId = sessionId;
    params_.transferId = transferId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Name,
          codec.align(MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function MediaStreamDispatcherHostStub(delegate) {
    this.delegate_ = delegate;
  }
  MediaStreamDispatcherHostStub.prototype.generateStreams = function(requestId, controls, userGesture, audioStreamSelectionInfo) {
    return this.delegate_ && this.delegate_.generateStreams && this.delegate_.generateStreams(requestId, controls, userGesture, audioStreamSelectionInfo);
  }
  MediaStreamDispatcherHostStub.prototype.focusCapturedSurface = function(label, focus) {
    return this.delegate_ && this.delegate_.focusCapturedSurface && this.delegate_.focusCapturedSurface(label, focus);
  }
  MediaStreamDispatcherHostStub.prototype.cancelRequest = function(requestId) {
    return this.delegate_ && this.delegate_.cancelRequest && this.delegate_.cancelRequest(requestId);
  }
  MediaStreamDispatcherHostStub.prototype.stopStreamDevice = function(deviceId, sessionId) {
    return this.delegate_ && this.delegate_.stopStreamDevice && this.delegate_.stopStreamDevice(deviceId, sessionId);
  }
  MediaStreamDispatcherHostStub.prototype.openDevice = function(requestId, deviceId, type) {
    return this.delegate_ && this.delegate_.openDevice && this.delegate_.openDevice(requestId, deviceId, type);
  }
  MediaStreamDispatcherHostStub.prototype.closeDevice = function(label) {
    return this.delegate_ && this.delegate_.closeDevice && this.delegate_.closeDevice(label);
  }
  MediaStreamDispatcherHostStub.prototype.setCapturingLinkSecured = function(sessionId, type, isSecure) {
    return this.delegate_ && this.delegate_.setCapturingLinkSecured && this.delegate_.setCapturingLinkSecured(sessionId, type, isSecure);
  }
  MediaStreamDispatcherHostStub.prototype.applySubCaptureTarget = function(sessionId, type, subCaptureTarget, subCaptureTargetVersion) {
    return this.delegate_ && this.delegate_.applySubCaptureTarget && this.delegate_.applySubCaptureTarget(sessionId, type, subCaptureTarget, subCaptureTargetVersion);
  }
  MediaStreamDispatcherHostStub.prototype.sendWheel = function(sessionId, action) {
    return this.delegate_ && this.delegate_.sendWheel && this.delegate_.sendWheel(sessionId, action);
  }
  MediaStreamDispatcherHostStub.prototype.updateZoomLevel = function(sessionId, action) {
    return this.delegate_ && this.delegate_.updateZoomLevel && this.delegate_.updateZoomLevel(sessionId, action);
  }
  MediaStreamDispatcherHostStub.prototype.requestCapturedSurfaceControlPermission = function(sessionId) {
    return this.delegate_ && this.delegate_.requestCapturedSurfaceControlPermission && this.delegate_.requestCapturedSurfaceControlPermission(sessionId);
  }
  MediaStreamDispatcherHostStub.prototype.getOpenDevice = function(requestId, sessionId, transferId) {
    return this.delegate_ && this.delegate_.getOpenDevice && this.delegate_.getOpenDevice(requestId, sessionId, transferId);
  }
  MediaStreamDispatcherHostStub.prototype.keepDeviceAliveForTransfer = function(sessionId, transferId) {
    return this.delegate_ && this.delegate_.keepDeviceAliveForTransfer && this.delegate_.keepDeviceAliveForTransfer(sessionId, transferId);
  }

  MediaStreamDispatcherHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaStreamDispatcherHost_FocusCapturedSurface_Name:
      var params = reader.decodeStruct(MediaStreamDispatcherHost_FocusCapturedSurface_Params);
      this.focusCapturedSurface(params.label, params.focus);
      return true;
    case kMediaStreamDispatcherHost_CancelRequest_Name:
      var params = reader.decodeStruct(MediaStreamDispatcherHost_CancelRequest_Params);
      this.cancelRequest(params.requestId);
      return true;
    case kMediaStreamDispatcherHost_StopStreamDevice_Name:
      var params = reader.decodeStruct(MediaStreamDispatcherHost_StopStreamDevice_Params);
      this.stopStreamDevice(params.deviceId, params.sessionId);
      return true;
    case kMediaStreamDispatcherHost_CloseDevice_Name:
      var params = reader.decodeStruct(MediaStreamDispatcherHost_CloseDevice_Params);
      this.closeDevice(params.label);
      return true;
    case kMediaStreamDispatcherHost_SetCapturingLinkSecured_Name:
      var params = reader.decodeStruct(MediaStreamDispatcherHost_SetCapturingLinkSecured_Params);
      this.setCapturingLinkSecured(params.sessionId, params.type, params.isSecure);
      return true;
    case kMediaStreamDispatcherHost_SendWheel_Name:
      var params = reader.decodeStruct(MediaStreamDispatcherHost_SendWheel_Params);
      this.sendWheel(params.sessionId, params.action);
      return true;
    default:
      return false;
    }
  };

  MediaStreamDispatcherHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaStreamDispatcherHost_GenerateStreams_Name:
      var params = reader.decodeStruct(MediaStreamDispatcherHost_GenerateStreams_Params);
      this.generateStreams(params.requestId, params.controls, params.userGesture, params.audioStreamSelectionInfo).then(function(response) {
        var responseParams =
            new MediaStreamDispatcherHost_GenerateStreams_ResponseParams();
        responseParams.result = response.result;
        responseParams.label = response.label;
        responseParams.streamDevices = response.streamDevices;
        responseParams.panTiltZoomAllowed = response.panTiltZoomAllowed;
        var builder = new codec.MessageV1Builder(
            kMediaStreamDispatcherHost_GenerateStreams_Name,
            codec.align(MediaStreamDispatcherHost_GenerateStreams_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaStreamDispatcherHost_GenerateStreams_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMediaStreamDispatcherHost_OpenDevice_Name:
      var params = reader.decodeStruct(MediaStreamDispatcherHost_OpenDevice_Params);
      this.openDevice(params.requestId, params.deviceId, params.type).then(function(response) {
        var responseParams =
            new MediaStreamDispatcherHost_OpenDevice_ResponseParams();
        responseParams.success = response.success;
        responseParams.label = response.label;
        responseParams.device = response.device;
        var builder = new codec.MessageV1Builder(
            kMediaStreamDispatcherHost_OpenDevice_Name,
            codec.align(MediaStreamDispatcherHost_OpenDevice_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaStreamDispatcherHost_OpenDevice_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMediaStreamDispatcherHost_ApplySubCaptureTarget_Name:
      var params = reader.decodeStruct(MediaStreamDispatcherHost_ApplySubCaptureTarget_Params);
      this.applySubCaptureTarget(params.sessionId, params.type, params.subCaptureTarget, params.subCaptureTargetVersion).then(function(response) {
        var responseParams =
            new MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMediaStreamDispatcherHost_ApplySubCaptureTarget_Name,
            codec.align(MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMediaStreamDispatcherHost_UpdateZoomLevel_Name:
      var params = reader.decodeStruct(MediaStreamDispatcherHost_UpdateZoomLevel_Params);
      this.updateZoomLevel(params.sessionId, params.action).then(function(response) {
        var responseParams =
            new MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMediaStreamDispatcherHost_UpdateZoomLevel_Name,
            codec.align(MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Name:
      var params = reader.decodeStruct(MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params);
      this.requestCapturedSurfaceControlPermission(params.sessionId).then(function(response) {
        var responseParams =
            new MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Name,
            codec.align(MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMediaStreamDispatcherHost_GetOpenDevice_Name:
      var params = reader.decodeStruct(MediaStreamDispatcherHost_GetOpenDevice_Params);
      this.getOpenDevice(params.requestId, params.sessionId, params.transferId).then(function(response) {
        var responseParams =
            new MediaStreamDispatcherHost_GetOpenDevice_ResponseParams();
        responseParams.result = response.result;
        responseParams.response = response.response;
        var builder = new codec.MessageV1Builder(
            kMediaStreamDispatcherHost_GetOpenDevice_Name,
            codec.align(MediaStreamDispatcherHost_GetOpenDevice_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaStreamDispatcherHost_GetOpenDevice_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Name:
      var params = reader.decodeStruct(MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params);
      this.keepDeviceAliveForTransfer(params.sessionId, params.transferId).then(function(response) {
        var responseParams =
            new MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams();
        responseParams.deviceFound = response.deviceFound;
        var builder = new codec.MessageV1Builder(
            kMediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Name,
            codec.align(MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateMediaStreamDispatcherHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMediaStreamDispatcherHost_GenerateStreams_Name:
        if (message.expectsResponse())
          paramsClass = MediaStreamDispatcherHost_GenerateStreams_Params;
      break;
      case kMediaStreamDispatcherHost_FocusCapturedSurface_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaStreamDispatcherHost_FocusCapturedSurface_Params;
      break;
      case kMediaStreamDispatcherHost_CancelRequest_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaStreamDispatcherHost_CancelRequest_Params;
      break;
      case kMediaStreamDispatcherHost_StopStreamDevice_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaStreamDispatcherHost_StopStreamDevice_Params;
      break;
      case kMediaStreamDispatcherHost_OpenDevice_Name:
        if (message.expectsResponse())
          paramsClass = MediaStreamDispatcherHost_OpenDevice_Params;
      break;
      case kMediaStreamDispatcherHost_CloseDevice_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaStreamDispatcherHost_CloseDevice_Params;
      break;
      case kMediaStreamDispatcherHost_SetCapturingLinkSecured_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaStreamDispatcherHost_SetCapturingLinkSecured_Params;
      break;
      case kMediaStreamDispatcherHost_ApplySubCaptureTarget_Name:
        if (message.expectsResponse())
          paramsClass = MediaStreamDispatcherHost_ApplySubCaptureTarget_Params;
      break;
      case kMediaStreamDispatcherHost_SendWheel_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaStreamDispatcherHost_SendWheel_Params;
      break;
      case kMediaStreamDispatcherHost_UpdateZoomLevel_Name:
        if (message.expectsResponse())
          paramsClass = MediaStreamDispatcherHost_UpdateZoomLevel_Params;
      break;
      case kMediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Name:
        if (message.expectsResponse())
          paramsClass = MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params;
      break;
      case kMediaStreamDispatcherHost_GetOpenDevice_Name:
        if (message.expectsResponse())
          paramsClass = MediaStreamDispatcherHost_GetOpenDevice_Params;
      break;
      case kMediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Name:
        if (message.expectsResponse())
          paramsClass = MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMediaStreamDispatcherHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kMediaStreamDispatcherHost_GenerateStreams_Name:
        if (message.isResponse())
          paramsClass = MediaStreamDispatcherHost_GenerateStreams_ResponseParams;
        break;
      case kMediaStreamDispatcherHost_OpenDevice_Name:
        if (message.isResponse())
          paramsClass = MediaStreamDispatcherHost_OpenDevice_ResponseParams;
        break;
      case kMediaStreamDispatcherHost_ApplySubCaptureTarget_Name:
        if (message.isResponse())
          paramsClass = MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams;
        break;
      case kMediaStreamDispatcherHost_UpdateZoomLevel_Name:
        if (message.isResponse())
          paramsClass = MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams;
        break;
      case kMediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Name:
        if (message.isResponse())
          paramsClass = MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams;
        break;
      case kMediaStreamDispatcherHost_GetOpenDevice_Name:
        if (message.isResponse())
          paramsClass = MediaStreamDispatcherHost_GetOpenDevice_ResponseParams;
        break;
      case kMediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Name:
        if (message.isResponse())
          paramsClass = MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var MediaStreamDispatcherHost = {
    name: 'blink.mojom.MediaStreamDispatcherHost',
    kVersion: 0,
    ptrClass: MediaStreamDispatcherHostPtr,
    proxyClass: MediaStreamDispatcherHostProxy,
    stubClass: MediaStreamDispatcherHostStub,
    validateRequest: validateMediaStreamDispatcherHostRequest,
    validateResponse: validateMediaStreamDispatcherHostResponse,
  };
  MediaStreamDispatcherHostStub.prototype.validator = validateMediaStreamDispatcherHostRequest;
  MediaStreamDispatcherHostProxy.prototype.validator = validateMediaStreamDispatcherHostResponse;
  var kMediaStreamTrackMetricsHost_AddTrack_Name = 0;
  var kMediaStreamTrackMetricsHost_RemoveTrack_Name = 1;

  function MediaStreamTrackMetricsHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MediaStreamTrackMetricsHost,
                                                   handleOrPtrInfo);
  }

  function MediaStreamTrackMetricsHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MediaStreamTrackMetricsHost, associatedInterfacePtrInfo);
  }

  MediaStreamTrackMetricsHostAssociatedPtr.prototype =
      Object.create(MediaStreamTrackMetricsHostPtr.prototype);
  MediaStreamTrackMetricsHostAssociatedPtr.prototype.constructor =
      MediaStreamTrackMetricsHostAssociatedPtr;

  function MediaStreamTrackMetricsHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  MediaStreamTrackMetricsHostPtr.prototype.addTrack = function() {
    return MediaStreamTrackMetricsHostProxy.prototype.addTrack
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamTrackMetricsHostProxy.prototype.addTrack = function(id, isAudio, isRemote) {
    var params_ = new MediaStreamTrackMetricsHost_AddTrack_Params();
    params_.id = id;
    params_.isAudio = isAudio;
    params_.isRemote = isRemote;
    var builder = new codec.MessageV0Builder(
        kMediaStreamTrackMetricsHost_AddTrack_Name,
        codec.align(MediaStreamTrackMetricsHost_AddTrack_Params.encodedSize));
    builder.encodeStruct(MediaStreamTrackMetricsHost_AddTrack_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaStreamTrackMetricsHostPtr.prototype.removeTrack = function() {
    return MediaStreamTrackMetricsHostProxy.prototype.removeTrack
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaStreamTrackMetricsHostProxy.prototype.removeTrack = function(id) {
    var params_ = new MediaStreamTrackMetricsHost_RemoveTrack_Params();
    params_.id = id;
    var builder = new codec.MessageV0Builder(
        kMediaStreamTrackMetricsHost_RemoveTrack_Name,
        codec.align(MediaStreamTrackMetricsHost_RemoveTrack_Params.encodedSize));
    builder.encodeStruct(MediaStreamTrackMetricsHost_RemoveTrack_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function MediaStreamTrackMetricsHostStub(delegate) {
    this.delegate_ = delegate;
  }
  MediaStreamTrackMetricsHostStub.prototype.addTrack = function(id, isAudio, isRemote) {
    return this.delegate_ && this.delegate_.addTrack && this.delegate_.addTrack(id, isAudio, isRemote);
  }
  MediaStreamTrackMetricsHostStub.prototype.removeTrack = function(id) {
    return this.delegate_ && this.delegate_.removeTrack && this.delegate_.removeTrack(id);
  }

  MediaStreamTrackMetricsHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaStreamTrackMetricsHost_AddTrack_Name:
      var params = reader.decodeStruct(MediaStreamTrackMetricsHost_AddTrack_Params);
      this.addTrack(params.id, params.isAudio, params.isRemote);
      return true;
    case kMediaStreamTrackMetricsHost_RemoveTrack_Name:
      var params = reader.decodeStruct(MediaStreamTrackMetricsHost_RemoveTrack_Params);
      this.removeTrack(params.id);
      return true;
    default:
      return false;
    }
  };

  MediaStreamTrackMetricsHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateMediaStreamTrackMetricsHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMediaStreamTrackMetricsHost_AddTrack_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaStreamTrackMetricsHost_AddTrack_Params;
      break;
      case kMediaStreamTrackMetricsHost_RemoveTrack_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaStreamTrackMetricsHost_RemoveTrack_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMediaStreamTrackMetricsHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var MediaStreamTrackMetricsHost = {
    name: 'blink.mojom.MediaStreamTrackMetricsHost',
    kVersion: 0,
    ptrClass: MediaStreamTrackMetricsHostPtr,
    proxyClass: MediaStreamTrackMetricsHostProxy,
    stubClass: MediaStreamTrackMetricsHostStub,
    validateRequest: validateMediaStreamTrackMetricsHostRequest,
    validateResponse: null,
  };
  MediaStreamTrackMetricsHostStub.prototype.validator = validateMediaStreamTrackMetricsHostRequest;
  MediaStreamTrackMetricsHostProxy.prototype.validator = null;
  exports.MediaStreamType = MediaStreamType;
  exports.MediaStreamRequestResult = MediaStreamRequestResult;
  exports.MediaStreamStateChange = MediaStreamStateChange;
  exports.PreferredDisplaySurface = PreferredDisplaySurface;
  exports.CapturedSurfaceControlResult = CapturedSurfaceControlResult;
  exports.ZoomLevelAction = ZoomLevelAction;
  exports.WindowAudioPreference = WindowAudioPreference;
  exports.SearchOnlyByDeviceId = SearchOnlyByDeviceId;
  exports.SearchBySessionId = SearchBySessionId;
  exports.MediaStreamDevice = MediaStreamDevice;
  exports.TrackControls = TrackControls;
  exports.StreamControls = StreamControls;
  exports.GetOpenDeviceResponse = GetOpenDeviceResponse;
  exports.CapturedWheelAction = CapturedWheelAction;
  exports.StreamDevices = StreamDevices;
  exports.StreamDevicesSet = StreamDevicesSet;
  exports.StreamSelectionInfo = StreamSelectionInfo;
  exports.MediaStreamDeviceObserver = MediaStreamDeviceObserver;
  exports.MediaStreamDeviceObserverPtr = MediaStreamDeviceObserverPtr;
  exports.MediaStreamDeviceObserverAssociatedPtr = MediaStreamDeviceObserverAssociatedPtr;
  exports.MediaStreamDispatcherHost = MediaStreamDispatcherHost;
  exports.MediaStreamDispatcherHostPtr = MediaStreamDispatcherHostPtr;
  exports.MediaStreamDispatcherHostAssociatedPtr = MediaStreamDispatcherHostAssociatedPtr;
  exports.MediaStreamTrackMetricsHost = MediaStreamTrackMetricsHost;
  exports.MediaStreamTrackMetricsHostPtr = MediaStreamTrackMetricsHostPtr;
  exports.MediaStreamTrackMetricsHostAssociatedPtr = MediaStreamTrackMetricsHostAssociatedPtr;
})();