// third_party/blink/public/mojom/mediastream/media_stream.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-shared-internal.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/mojo/mojom/audio_parameters.mojom-shared.h"
#include "media/mojo/mojom/display_media_information.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::MediaStreamType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::MediaStreamType> {};

template <>
struct hash<::blink::mojom::MediaStreamRequestResult>
    : public mojo::internal::EnumHashImpl<::blink::mojom::MediaStreamRequestResult> {};

template <>
struct hash<::blink::mojom::MediaStreamStateChange>
    : public mojo::internal::EnumHashImpl<::blink::mojom::MediaStreamStateChange> {};

template <>
struct hash<::blink::mojom::PreferredDisplaySurface>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PreferredDisplaySurface> {};

template <>
struct hash<::blink::mojom::CapturedSurfaceControlResult>
    : public mojo::internal::EnumHashImpl<::blink::mojom::CapturedSurfaceControlResult> {};

template <>
struct hash<::blink::mojom::ZoomLevelAction>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ZoomLevelAction> {};

template <>
struct hash<::blink::mojom::WindowAudioPreference>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WindowAudioPreference> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaStreamType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::MediaStreamType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::MediaStreamType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaStreamRequestResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::MediaStreamRequestResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::MediaStreamRequestResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaStreamStateChange, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::MediaStreamStateChange, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::MediaStreamStateChange>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PreferredDisplaySurface, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PreferredDisplaySurface, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::PreferredDisplaySurface>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CapturedSurfaceControlResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::CapturedSurfaceControlResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CapturedSurfaceControlResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ZoomLevelAction, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ZoomLevelAction, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ZoomLevelAction>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WindowAudioPreference, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WindowAudioPreference, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WindowAudioPreference>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SearchOnlyByDeviceIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SearchOnlyByDeviceIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SearchOnlyByDeviceId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::blink::mojom::internal::SearchOnlyByDeviceId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SearchOnlyByDeviceIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SearchBySessionIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SearchBySessionIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SearchBySessionId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::session_id_map(input)) in_session_id_map = Traits::session_id_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_id_map)::BaseType>
        session_id_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& session_id_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::UnguessableTokenDataView>>(
      in_session_id_map,
      session_id_map_fragment,
      &session_id_map_validate_params);

    fragment->session_id_map.Set(
        session_id_map_fragment.is_null() ? nullptr : session_id_map_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->session_id_map.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id_map in SearchBySessionId struct");
  }

  static bool Deserialize(::blink::mojom::internal::SearchBySessionId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SearchBySessionIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaStreamDeviceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MediaStreamDeviceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::MediaStreamDevice_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::MediaStreamType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in MediaStreamDevice struct");

    fragment->display_id = Traits::display_id(input);

    
    mojo::internal::Serialize<::media::mojom::VideoFacingMode>(
      Traits::video_facing(input),
      &fragment->video_facing);

    decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_id)::BaseType> group_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_group_id,
      group_id_fragment);

    fragment->group_id.Set(
        group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

    decltype(Traits::matched_output_device_id(input)) in_matched_output_device_id = Traits::matched_output_device_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->matched_output_device_id)::BaseType> matched_output_device_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_matched_output_device_id,
      matched_output_device_id_fragment);

    fragment->matched_output_device_id.Set(
        matched_output_device_id_fragment.is_null() ? nullptr : matched_output_device_id_fragment.data());

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in MediaStreamDevice struct");

    decltype(Traits::input(input)) in_input = Traits::input(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input)::BaseType> input_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
      in_input,
      input_fragment);

    fragment->input.Set(
        input_fragment.is_null() ? nullptr : input_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input in MediaStreamDevice struct");

    decltype(Traits::session_id(input)) in_session_id = Traits::session_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_id)::BaseType> session_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_session_id,
      session_id_fragment);

    fragment->session_id.Set(
        session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

    decltype(Traits::display_media_info(input)) in_display_media_info = Traits::display_media_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_media_info)::BaseType> display_media_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::DisplayMediaInformationDataView>(
      in_display_media_info,
      display_media_info_fragment);

    fragment->display_media_info.Set(
        display_media_info_fragment.is_null() ? nullptr : display_media_info_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::MediaStreamDevice_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MediaStreamDeviceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TrackControlsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TrackControlsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TrackControls_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::MediaStreamType>(
      Traits::stream_type(input),
      &fragment->stream_type);

    decltype(Traits::device_ids(input)) in_device_ids = Traits::device_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_ids)::BaseType>
        device_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& device_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_device_ids,
      device_ids_fragment,
      &device_ids_validate_params);

    fragment->device_ids.Set(
        device_ids_fragment.is_null() ? nullptr : device_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_ids in TrackControls struct");
  }

  static bool Deserialize(::blink::mojom::internal::TrackControls_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TrackControlsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::StreamControlsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::StreamControlsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::StreamControls_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::audio(input)) in_audio = Traits::audio(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->audio)::BaseType> audio_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::TrackControlsDataView>(
      in_audio,
      audio_fragment);

    fragment->audio.Set(
        audio_fragment.is_null() ? nullptr : audio_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->audio.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null audio in StreamControls struct");

    decltype(Traits::video(input)) in_video = Traits::video(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->video)::BaseType> video_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::TrackControlsDataView>(
      in_video,
      video_fragment);

    fragment->video.Set(
        video_fragment.is_null() ? nullptr : video_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->video.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null video in StreamControls struct");

    fragment->hotword_enabled = Traits::hotword_enabled(input);

    fragment->disable_local_echo = Traits::disable_local_echo(input);

    fragment->suppress_local_audio_playback = Traits::suppress_local_audio_playback(input);

    fragment->restrict_own_audio = Traits::restrict_own_audio(input);

    fragment->exclude_system_audio = Traits::exclude_system_audio(input);

    
    mojo::internal::Serialize<::blink::mojom::WindowAudioPreference>(
      Traits::window_audio_preference(input),
      &fragment->window_audio_preference);

    fragment->exclude_self_browser_surface = Traits::exclude_self_browser_surface(input);

    fragment->request_pan_tilt_zoom_permission = Traits::request_pan_tilt_zoom_permission(input);

    fragment->request_all_screens = Traits::request_all_screens(input);

    
    mojo::internal::Serialize<::blink::mojom::PreferredDisplaySurface>(
      Traits::preferred_display_surface(input),
      &fragment->preferred_display_surface);

    fragment->dynamic_surface_switching_requested = Traits::dynamic_surface_switching_requested(input);

    fragment->exclude_monitor_type_surfaces = Traits::exclude_monitor_type_surfaces(input);
  }

  static bool Deserialize(::blink::mojom::internal::StreamControls_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::StreamControlsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::GetOpenDeviceResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::GetOpenDeviceResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::GetOpenDeviceResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in GetOpenDeviceResponse struct");

    decltype(Traits::device(input)) in_device = Traits::device(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device)::BaseType> device_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
      in_device,
      device_fragment);

    fragment->device.Set(
        device_fragment.is_null() ? nullptr : device_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device in GetOpenDeviceResponse struct");

    fragment->pan_tilt_zoom_allowed = Traits::pan_tilt_zoom_allowed(input);
  }

  static bool Deserialize(::blink::mojom::internal::GetOpenDeviceResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::GetOpenDeviceResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CapturedWheelActionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CapturedWheelActionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CapturedWheelAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->relative_x = Traits::relative_x(input);

    fragment->relative_y = Traits::relative_y(input);

    fragment->wheel_delta_x = Traits::wheel_delta_x(input);

    fragment->wheel_delta_y = Traits::wheel_delta_y(input);
  }

  static bool Deserialize(::blink::mojom::internal::CapturedWheelAction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CapturedWheelActionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::StreamDevicesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::StreamDevicesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::StreamDevices_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::audio_device(input)) in_audio_device = Traits::audio_device(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->audio_device)::BaseType> audio_device_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
      in_audio_device,
      audio_device_fragment);

    fragment->audio_device.Set(
        audio_device_fragment.is_null() ? nullptr : audio_device_fragment.data());

    decltype(Traits::video_device(input)) in_video_device = Traits::video_device(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->video_device)::BaseType> video_device_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
      in_video_device,
      video_device_fragment);

    fragment->video_device.Set(
        video_device_fragment.is_null() ? nullptr : video_device_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::StreamDevices_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::StreamDevicesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::StreamDevicesSetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::StreamDevicesSetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::StreamDevicesSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::stream_devices(input)) in_stream_devices = Traits::stream_devices(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stream_devices)::BaseType>
        stream_devices_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& stream_devices_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::StreamDevicesDataView>>(
      in_stream_devices,
      stream_devices_fragment,
      &stream_devices_validate_params);

    fragment->stream_devices.Set(
        stream_devices_fragment.is_null() ? nullptr : stream_devices_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->stream_devices.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stream_devices in StreamDevicesSet struct");
  }

  static bool Deserialize(::blink::mojom::internal::StreamDevicesSet_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::StreamDevicesSetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::StreamSelectionInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::StreamSelectionInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::StreamSelectionInfo_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::StreamSelectionInfoDataView::Tag::kSearchOnlyByDeviceId: {
    decltype(Traits::search_only_by_device_id(input))
    in_search_only_by_device_id = Traits::search_only_by_device_id(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_search_only_by_device_id)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::SearchOnlyByDeviceIdDataView>(
  in_search_only_by_device_id,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null search_only_by_device_id in StreamSelectionInfo union");
    fragment->data.f_search_only_by_device_id.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::StreamSelectionInfoDataView::Tag::kSearchBySessionId: {
    decltype(Traits::search_by_session_id(input))
    in_search_by_session_id = Traits::search_by_session_id(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_search_by_session_id)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::SearchBySessionIdDataView>(
  in_search_by_session_id,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null search_by_session_id in StreamSelectionInfo union");
    fragment->data.f_search_by_session_id.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::StreamSelectionInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::StreamSelectionInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {



inline void SearchBySessionIdDataView::GetSessionIdMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::UnguessableTokenDataView>* output) {
  auto pointer = data_->session_id_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::UnguessableTokenDataView>(pointer, message_);
}


inline void MediaStreamDeviceDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDeviceDataView::GetGroupIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDeviceDataView::GetMatchedOutputDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->matched_output_device_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDeviceDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDeviceDataView::GetInputDataView(
    ::media::mojom::AudioParametersDataView* output) {
  auto pointer = data_->input.Get();
  *output = ::media::mojom::AudioParametersDataView(pointer, message_);
}
inline void MediaStreamDeviceDataView::GetSessionIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void MediaStreamDeviceDataView::GetDisplayMediaInfoDataView(
    ::media::mojom::DisplayMediaInformationDataView* output) {
  auto pointer = data_->display_media_info.Get();
  *output = ::media::mojom::DisplayMediaInformationDataView(pointer, message_);
}


inline void TrackControlsDataView::GetDeviceIdsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->device_ids.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void StreamControlsDataView::GetAudioDataView(
    TrackControlsDataView* output) {
  auto pointer = data_->audio.Get();
  *output = TrackControlsDataView(pointer, message_);
}
inline void StreamControlsDataView::GetVideoDataView(
    TrackControlsDataView* output) {
  auto pointer = data_->video.Get();
  *output = TrackControlsDataView(pointer, message_);
}


inline void GetOpenDeviceResponseDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GetOpenDeviceResponseDataView::GetDeviceDataView(
    MediaStreamDeviceDataView* output) {
  auto pointer = data_->device.Get();
  *output = MediaStreamDeviceDataView(pointer, message_);
}




inline void StreamDevicesDataView::GetAudioDeviceDataView(
    MediaStreamDeviceDataView* output) {
  auto pointer = data_->audio_device.Get();
  *output = MediaStreamDeviceDataView(pointer, message_);
}
inline void StreamDevicesDataView::GetVideoDeviceDataView(
    MediaStreamDeviceDataView* output) {
  auto pointer = data_->video_device.Get();
  *output = MediaStreamDeviceDataView(pointer, message_);
}


inline void StreamDevicesSetDataView::GetStreamDevicesDataView(
    mojo::ArrayDataView<StreamDevicesDataView>* output) {
  auto pointer = data_->stream_devices.Get();
  *output = mojo::ArrayDataView<StreamDevicesDataView>(pointer, message_);
}


inline void StreamSelectionInfoDataView::GetSearchOnlyByDeviceIdDataView(
    SearchOnlyByDeviceIdDataView* output) const {
  CHECK(is_search_only_by_device_id());
  *output = SearchOnlyByDeviceIdDataView(data_->data.f_search_only_by_device_id.Get(), message_);
}
inline void StreamSelectionInfoDataView::GetSearchBySessionIdDataView(
    SearchBySessionIdDataView* output) const {
  CHECK(is_search_by_session_id());
  *output = SearchBySessionIdDataView(data_->data.f_search_by_session_id.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::MediaStreamType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::MediaStreamType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::MediaStreamRequestResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::MediaStreamRequestResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::MediaStreamStateChange> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::MediaStreamStateChange value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::PreferredDisplaySurface> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::PreferredDisplaySurface value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::CapturedSurfaceControlResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::CapturedSurfaceControlResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ZoomLevelAction> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ZoomLevelAction value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WindowAudioPreference> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WindowAudioPreference value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_SHARED_H_