// third_party/blink/public/mojom/mediastream/media_stream.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_SHARED_INTERNAL_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "mojo/public/c/system/macros.h"
#include "media/capture/mojom/video_capture_types.mojom-shared-internal.h"
#include "media/mojo/mojom/audio_parameters.mojom-shared-internal.h"
#include "media/mojo/mojom/display_media_information.mojom-shared-internal.h"
#include "mojo/public/mojom/base/token.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace blink::mojom {
namespace internal {
class SearchOnlyByDeviceId_Data;
class SearchBySessionId_Data;
class MediaStreamDevice_Data;
class TrackControls_Data;
class StreamControls_Data;
class GetOpenDeviceResponse_Data;
class CapturedWheelAction_Data;
class StreamDevices_Data;
class StreamDevicesSet_Data;
class StreamSelectionInfo_Data;

struct MediaStreamType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct MediaStreamRequestResult_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct MediaStreamStateChange_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct PreferredDisplaySurface_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct CapturedSurfaceControlResult_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct ZoomLevelAction_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct WindowAudioPreference_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) StreamSelectionInfo_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  StreamSelectionInfo_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~StreamSelectionInfo_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<StreamSelectionInfo_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class StreamSelectionInfo_Tag : uint32_t {

    
    kSearchOnlyByDeviceId,
    
    kSearchBySessionId,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::SearchOnlyByDeviceId_Data> f_search_only_by_device_id;
    mojo::internal::Pointer<internal::SearchBySessionId_Data> f_search_by_session_id;
    uint64_t unknown;
  };

  uint32_t size;
  StreamSelectionInfo_Tag tag;
  Union_ data;
};
static_assert(sizeof(StreamSelectionInfo_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(StreamSelectionInfo_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) SearchOnlyByDeviceId_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<SearchOnlyByDeviceId_Data>;

  SearchOnlyByDeviceId_Data();
  ~SearchOnlyByDeviceId_Data() = delete;
};
static_assert(sizeof(SearchOnlyByDeviceId_Data) == 8,
              "Bad sizeof(SearchOnlyByDeviceId_Data)");
// Used by SearchOnlyByDeviceId::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SearchOnlyByDeviceId_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SearchOnlyByDeviceId_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SearchOnlyByDeviceId_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SearchOnlyByDeviceId_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SearchOnlyByDeviceId_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) SearchBySessionId_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data>>> session_id_map;

 private:
  friend class mojo::internal::MessageFragment<SearchBySessionId_Data>;

  SearchBySessionId_Data();
  ~SearchBySessionId_Data() = delete;
};
static_assert(sizeof(SearchBySessionId_Data) == 16,
              "Bad sizeof(SearchBySessionId_Data)");
// Used by SearchBySessionId::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SearchBySessionId_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SearchBySessionId_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SearchBySessionId_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SearchBySessionId_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SearchBySessionId_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDevice_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  int32_t video_facing;
  mojo::internal::Pointer<mojo::internal::String_Data> id;
  int64_t display_id;
  mojo::internal::Pointer<mojo::internal::String_Data> group_id;
  mojo::internal::Pointer<mojo::internal::String_Data> matched_output_device_id;
  mojo::internal::Pointer<mojo::internal::String_Data> name;
  mojo::internal::Pointer<::media::mojom::internal::AudioParameters_Data> input;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> session_id;
  mojo::internal::Pointer<::media::mojom::internal::DisplayMediaInformation_Data> display_media_info;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDevice_Data>;

  MediaStreamDevice_Data();
  ~MediaStreamDevice_Data() = delete;
};
static_assert(sizeof(MediaStreamDevice_Data) == 80,
              "Bad sizeof(MediaStreamDevice_Data)");
// Used by MediaStreamDevice::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct MediaStreamDevice_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  MediaStreamDevice_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~MediaStreamDevice_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<MediaStreamDevice_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    MediaStreamDevice_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TrackControls_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t stream_type;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> device_ids;

 private:
  friend class mojo::internal::MessageFragment<TrackControls_Data>;

  TrackControls_Data();
  ~TrackControls_Data() = delete;
};
static_assert(sizeof(TrackControls_Data) == 24,
              "Bad sizeof(TrackControls_Data)");
// Used by TrackControls::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TrackControls_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TrackControls_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TrackControls_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TrackControls_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TrackControls_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) StreamControls_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::TrackControls_Data> audio;
  mojo::internal::Pointer<internal::TrackControls_Data> video;
  uint8_t hotword_enabled : 1;
  uint8_t disable_local_echo : 1;
  uint8_t suppress_local_audio_playback : 1;
  uint8_t restrict_own_audio : 1;
  uint8_t exclude_system_audio : 1;
  uint8_t exclude_self_browser_surface : 1;
  uint8_t request_pan_tilt_zoom_permission : 1;
  uint8_t request_all_screens : 1;
  uint8_t dynamic_surface_switching_requested : 1;
  uint8_t exclude_monitor_type_surfaces : 1;
  uint8_t pad11_[2];
  int32_t window_audio_preference;
  int32_t preferred_display_surface;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<StreamControls_Data>;

  StreamControls_Data();
  ~StreamControls_Data() = delete;
};
static_assert(sizeof(StreamControls_Data) == 40,
              "Bad sizeof(StreamControls_Data)");
// Used by StreamControls::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct StreamControls_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  StreamControls_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~StreamControls_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<StreamControls_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    StreamControls_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) GetOpenDeviceResponse_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> label;
  mojo::internal::Pointer<internal::MediaStreamDevice_Data> device;
  uint8_t pan_tilt_zoom_allowed : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<GetOpenDeviceResponse_Data>;

  GetOpenDeviceResponse_Data();
  ~GetOpenDeviceResponse_Data() = delete;
};
static_assert(sizeof(GetOpenDeviceResponse_Data) == 32,
              "Bad sizeof(GetOpenDeviceResponse_Data)");
// Used by GetOpenDeviceResponse::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct GetOpenDeviceResponse_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  GetOpenDeviceResponse_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~GetOpenDeviceResponse_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<GetOpenDeviceResponse_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    GetOpenDeviceResponse_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) CapturedWheelAction_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  double relative_x;
  double relative_y;
  int32_t wheel_delta_x;
  int32_t wheel_delta_y;

 private:
  friend class mojo::internal::MessageFragment<CapturedWheelAction_Data>;

  CapturedWheelAction_Data();
  ~CapturedWheelAction_Data() = delete;
};
static_assert(sizeof(CapturedWheelAction_Data) == 32,
              "Bad sizeof(CapturedWheelAction_Data)");
// Used by CapturedWheelAction::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CapturedWheelAction_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CapturedWheelAction_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CapturedWheelAction_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CapturedWheelAction_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CapturedWheelAction_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) StreamDevices_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::MediaStreamDevice_Data> audio_device;
  mojo::internal::Pointer<internal::MediaStreamDevice_Data> video_device;

 private:
  friend class mojo::internal::MessageFragment<StreamDevices_Data>;

  StreamDevices_Data();
  ~StreamDevices_Data() = delete;
};
static_assert(sizeof(StreamDevices_Data) == 24,
              "Bad sizeof(StreamDevices_Data)");
// Used by StreamDevices::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct StreamDevices_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  StreamDevices_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~StreamDevices_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<StreamDevices_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    StreamDevices_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) StreamDevicesSet_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::StreamDevices_Data>>> stream_devices;

 private:
  friend class mojo::internal::MessageFragment<StreamDevicesSet_Data>;

  StreamDevicesSet_Data();
  ~StreamDevicesSet_Data() = delete;
};
static_assert(sizeof(StreamDevicesSet_Data) == 16,
              "Bad sizeof(StreamDevicesSet_Data)");
// Used by StreamDevicesSet::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct StreamDevicesSet_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  StreamDevicesSet_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~StreamDevicesSet_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<StreamDevicesSet_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    StreamDevicesSet_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_SHARED_INTERNAL_H_