// third_party/blink/public/mojom/mediastream/media_stream.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_PARAMS_DATA_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace blink::mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDeviceObserver_OnDeviceStopped_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> label;
  mojo::internal::Pointer<internal::MediaStreamDevice_Data> device;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDeviceObserver_OnDeviceStopped_Params_Data>;

  MediaStreamDeviceObserver_OnDeviceStopped_Params_Data();
  ~MediaStreamDeviceObserver_OnDeviceStopped_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDeviceObserver_OnDeviceStopped_Params_Data) == 24,
              "Bad sizeof(MediaStreamDeviceObserver_OnDeviceStopped_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDeviceObserver_OnDeviceChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> label;
  mojo::internal::Pointer<internal::MediaStreamDevice_Data> old_device;
  mojo::internal::Pointer<internal::MediaStreamDevice_Data> new_device;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDeviceObserver_OnDeviceChanged_Params_Data>;

  MediaStreamDeviceObserver_OnDeviceChanged_Params_Data();
  ~MediaStreamDeviceObserver_OnDeviceChanged_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDeviceObserver_OnDeviceChanged_Params_Data) == 32,
              "Bad sizeof(MediaStreamDeviceObserver_OnDeviceChanged_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> label;
  mojo::internal::Pointer<internal::MediaStreamDevice_Data> device;
  int32_t new_state;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params_Data>;

  MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params_Data();
  ~MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params_Data) == 32,
              "Bad sizeof(MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> label;
  mojo::internal::Pointer<internal::MediaStreamDevice_Data> device;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params_Data>;

  MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params_Data();
  ~MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params_Data) == 24,
              "Bad sizeof(MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> label;
  mojo::internal::Pointer<internal::MediaStreamDevice_Data> device;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params_Data>;

  MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params_Data();
  ~MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params_Data) == 24,
              "Bad sizeof(MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDeviceObserver_OnZoomLevelChange_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> label;
  mojo::internal::Pointer<internal::MediaStreamDevice_Data> device;
  int32_t zoom_level;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDeviceObserver_OnZoomLevelChange_Params_Data>;

  MediaStreamDeviceObserver_OnZoomLevelChange_Params_Data();
  ~MediaStreamDeviceObserver_OnZoomLevelChange_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDeviceObserver_OnZoomLevelChange_Params_Data) == 32,
              "Bad sizeof(MediaStreamDeviceObserver_OnZoomLevelChange_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_GenerateStreams_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t request_id;
  uint8_t user_gesture : 1;
  uint8_t pad1_[3];
  mojo::internal::Pointer<internal::StreamControls_Data> controls;
  internal::StreamSelectionInfo_Data audio_stream_selection_info;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_GenerateStreams_Params_Data>;

  MediaStreamDispatcherHost_GenerateStreams_Params_Data();
  ~MediaStreamDispatcherHost_GenerateStreams_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_GenerateStreams_Params_Data) == 40,
              "Bad sizeof(MediaStreamDispatcherHost_GenerateStreams_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_GenerateStreams_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t pan_tilt_zoom_allowed : 1;
  uint8_t pad1_[3];
  mojo::internal::Pointer<mojo::internal::String_Data> label;
  mojo::internal::Pointer<internal::StreamDevicesSet_Data> stream_devices;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_GenerateStreams_ResponseParams_Data>;

  MediaStreamDispatcherHost_GenerateStreams_ResponseParams_Data();
  ~MediaStreamDispatcherHost_GenerateStreams_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_GenerateStreams_ResponseParams_Data) == 32,
              "Bad sizeof(MediaStreamDispatcherHost_GenerateStreams_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_FocusCapturedSurface_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> label;
  uint8_t focus : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_FocusCapturedSurface_Params_Data>;

  MediaStreamDispatcherHost_FocusCapturedSurface_Params_Data();
  ~MediaStreamDispatcherHost_FocusCapturedSurface_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_FocusCapturedSurface_Params_Data) == 24,
              "Bad sizeof(MediaStreamDispatcherHost_FocusCapturedSurface_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_CancelRequest_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t request_id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_CancelRequest_Params_Data>;

  MediaStreamDispatcherHost_CancelRequest_Params_Data();
  ~MediaStreamDispatcherHost_CancelRequest_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_CancelRequest_Params_Data) == 16,
              "Bad sizeof(MediaStreamDispatcherHost_CancelRequest_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_StopStreamDevice_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> device_id;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> session_id;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_StopStreamDevice_Params_Data>;

  MediaStreamDispatcherHost_StopStreamDevice_Params_Data();
  ~MediaStreamDispatcherHost_StopStreamDevice_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_StopStreamDevice_Params_Data) == 24,
              "Bad sizeof(MediaStreamDispatcherHost_StopStreamDevice_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_OpenDevice_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t request_id;
  int32_t type;
  mojo::internal::Pointer<mojo::internal::String_Data> device_id;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_OpenDevice_Params_Data>;

  MediaStreamDispatcherHost_OpenDevice_Params_Data();
  ~MediaStreamDispatcherHost_OpenDevice_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_OpenDevice_Params_Data) == 24,
              "Bad sizeof(MediaStreamDispatcherHost_OpenDevice_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_OpenDevice_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t pad0_[7];
  mojo::internal::Pointer<mojo::internal::String_Data> label;
  mojo::internal::Pointer<internal::MediaStreamDevice_Data> device;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_OpenDevice_ResponseParams_Data>;

  MediaStreamDispatcherHost_OpenDevice_ResponseParams_Data();
  ~MediaStreamDispatcherHost_OpenDevice_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_OpenDevice_ResponseParams_Data) == 32,
              "Bad sizeof(MediaStreamDispatcherHost_OpenDevice_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_CloseDevice_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_CloseDevice_Params_Data>;

  MediaStreamDispatcherHost_CloseDevice_Params_Data();
  ~MediaStreamDispatcherHost_CloseDevice_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_CloseDevice_Params_Data) == 16,
              "Bad sizeof(MediaStreamDispatcherHost_CloseDevice_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_SetCapturingLinkSecured_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> session_id;
  int32_t type;
  uint8_t is_secure : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_SetCapturingLinkSecured_Params_Data>;

  MediaStreamDispatcherHost_SetCapturingLinkSecured_Params_Data();
  ~MediaStreamDispatcherHost_SetCapturingLinkSecured_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_SetCapturingLinkSecured_Params_Data) == 24,
              "Bad sizeof(MediaStreamDispatcherHost_SetCapturingLinkSecured_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_ApplySubCaptureTarget_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> session_id;
  int32_t type;
  uint32_t sub_capture_target_version;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Token_Data> sub_capture_target;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_ApplySubCaptureTarget_Params_Data>;

  MediaStreamDispatcherHost_ApplySubCaptureTarget_Params_Data();
  ~MediaStreamDispatcherHost_ApplySubCaptureTarget_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_ApplySubCaptureTarget_Params_Data) == 32,
              "Bad sizeof(MediaStreamDispatcherHost_ApplySubCaptureTarget_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams_Data>;

  MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams_Data();
  ~MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams_Data) == 16,
              "Bad sizeof(MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_SendWheel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> session_id;
  mojo::internal::Pointer<internal::CapturedWheelAction_Data> action;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_SendWheel_Params_Data>;

  MediaStreamDispatcherHost_SendWheel_Params_Data();
  ~MediaStreamDispatcherHost_SendWheel_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_SendWheel_Params_Data) == 24,
              "Bad sizeof(MediaStreamDispatcherHost_SendWheel_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_UpdateZoomLevel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> session_id;
  int32_t action;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_UpdateZoomLevel_Params_Data>;

  MediaStreamDispatcherHost_UpdateZoomLevel_Params_Data();
  ~MediaStreamDispatcherHost_UpdateZoomLevel_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_UpdateZoomLevel_Params_Data) == 24,
              "Bad sizeof(MediaStreamDispatcherHost_UpdateZoomLevel_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams_Data>;

  MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams_Data();
  ~MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams_Data) == 16,
              "Bad sizeof(MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> session_id;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params_Data>;

  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params_Data();
  ~MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params_Data) == 16,
              "Bad sizeof(MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams_Data>;

  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams_Data();
  ~MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams_Data) == 16,
              "Bad sizeof(MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_GetOpenDevice_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t request_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> session_id;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> transfer_id;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_GetOpenDevice_Params_Data>;

  MediaStreamDispatcherHost_GetOpenDevice_Params_Data();
  ~MediaStreamDispatcherHost_GetOpenDevice_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_GetOpenDevice_Params_Data) == 32,
              "Bad sizeof(MediaStreamDispatcherHost_GetOpenDevice_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_GetOpenDevice_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t pad0_[4];
  mojo::internal::Pointer<internal::GetOpenDeviceResponse_Data> response;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_GetOpenDevice_ResponseParams_Data>;

  MediaStreamDispatcherHost_GetOpenDevice_ResponseParams_Data();
  ~MediaStreamDispatcherHost_GetOpenDevice_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_GetOpenDevice_ResponseParams_Data) == 24,
              "Bad sizeof(MediaStreamDispatcherHost_GetOpenDevice_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> session_id;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> transfer_id;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params_Data>;

  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params_Data();
  ~MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params_Data) == 24,
              "Bad sizeof(MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t device_found : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams_Data>;

  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams_Data();
  ~MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams_Data) == 16,
              "Bad sizeof(MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamTrackMetricsHost_AddTrack_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t id;
  uint8_t is_audio : 1;
  uint8_t is_remote : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<MediaStreamTrackMetricsHost_AddTrack_Params_Data>;

  MediaStreamTrackMetricsHost_AddTrack_Params_Data();
  ~MediaStreamTrackMetricsHost_AddTrack_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamTrackMetricsHost_AddTrack_Params_Data) == 24,
              "Bad sizeof(MediaStreamTrackMetricsHost_AddTrack_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MediaStreamTrackMetricsHost_RemoveTrack_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t id;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamTrackMetricsHost_RemoveTrack_Params_Data>;

  MediaStreamTrackMetricsHost_RemoveTrack_Params_Data();
  ~MediaStreamTrackMetricsHost_RemoveTrack_Params_Data() = delete;
};
static_assert(sizeof(MediaStreamTrackMetricsHost_RemoveTrack_Params_Data) == 16,
              "Bad sizeof(MediaStreamTrackMetricsHost_RemoveTrack_Params_Data)");

}  // namespace internal


class MediaStreamDeviceObserver_OnDeviceStopped_ParamsDataView {
 public:
  MediaStreamDeviceObserver_OnDeviceStopped_ParamsDataView() = default;

  MediaStreamDeviceObserver_OnDeviceStopped_ParamsDataView(
      internal::MediaStreamDeviceObserver_OnDeviceStopped_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceDataView(
      MediaStreamDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevice(UserType* output) {
    
    auto* pointer = data_->device.Get();
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamDeviceDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaStreamDeviceObserver_OnDeviceStopped_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDeviceObserver_OnDeviceChanged_ParamsDataView {
 public:
  MediaStreamDeviceObserver_OnDeviceChanged_ParamsDataView() = default;

  MediaStreamDeviceObserver_OnDeviceChanged_ParamsDataView(
      internal::MediaStreamDeviceObserver_OnDeviceChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOldDeviceDataView(
      MediaStreamDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOldDevice(UserType* output) {
    
    auto* pointer = data_->old_device.Get();
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamDeviceDataView>(
        pointer, output, message_);
  }
  inline void GetNewDeviceDataView(
      MediaStreamDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewDevice(UserType* output) {
    
    auto* pointer = data_->new_device.Get();
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamDeviceDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaStreamDeviceObserver_OnDeviceChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsDataView {
 public:
  MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsDataView() = default;

  MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsDataView(
      internal::MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceDataView(
      MediaStreamDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevice(UserType* output) {
    
    auto* pointer = data_->device.Get();
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamDeviceDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNewState(UserType* output) const {
    auto data_value = data_->new_state;
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamStateChange>(
        data_value, output);
  }
  MediaStreamStateChange new_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::MediaStreamStateChange>(data_->new_state));
  }
 private:
  internal::MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_ParamsDataView {
 public:
  MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_ParamsDataView() = default;

  MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_ParamsDataView(
      internal::MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceDataView(
      MediaStreamDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevice(UserType* output) {
    
    auto* pointer = data_->device.Get();
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamDeviceDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsDataView {
 public:
  MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsDataView() = default;

  MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsDataView(
      internal::MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceDataView(
      MediaStreamDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevice(UserType* output) {
    
    auto* pointer = data_->device.Get();
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamDeviceDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDeviceObserver_OnZoomLevelChange_ParamsDataView {
 public:
  MediaStreamDeviceObserver_OnZoomLevelChange_ParamsDataView() = default;

  MediaStreamDeviceObserver_OnZoomLevelChange_ParamsDataView(
      internal::MediaStreamDeviceObserver_OnZoomLevelChange_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceDataView(
      MediaStreamDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevice(UserType* output) {
    
    auto* pointer = data_->device.Get();
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamDeviceDataView>(
        pointer, output, message_);
  }
  int32_t zoom_level() const {
    return data_->zoom_level;
  }
 private:
  internal::MediaStreamDeviceObserver_OnZoomLevelChange_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDispatcherHost_GenerateStreams_ParamsDataView {
 public:
  MediaStreamDispatcherHost_GenerateStreams_ParamsDataView() = default;

  MediaStreamDispatcherHost_GenerateStreams_ParamsDataView(
      internal::MediaStreamDispatcherHost_GenerateStreams_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t request_id() const {
    return data_->request_id;
  }
  inline void GetControlsDataView(
      StreamControlsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadControls(UserType* output) {
    
    auto* pointer = data_->controls.Get();
    return mojo::internal::Deserialize<::blink::mojom::StreamControlsDataView>(
        pointer, output, message_);
  }
  bool user_gesture() const {
    return data_->user_gesture;
  }
  inline void GetAudioStreamSelectionInfoDataView(
      StreamSelectionInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioStreamSelectionInfo(UserType* output) {
    
    auto* pointer = !data_->audio_stream_selection_info.is_null() ? &data_->audio_stream_selection_info : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::StreamSelectionInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaStreamDispatcherHost_GenerateStreams_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDispatcherHost_GenerateStreams_ResponseParamsDataView {
 public:
  MediaStreamDispatcherHost_GenerateStreams_ResponseParamsDataView() = default;

  MediaStreamDispatcherHost_GenerateStreams_ResponseParamsDataView(
      internal::MediaStreamDispatcherHost_GenerateStreams_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamRequestResult>(
        data_value, output);
  }
  MediaStreamRequestResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::MediaStreamRequestResult>(data_->result));
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStreamDevicesDataView(
      StreamDevicesSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStreamDevices(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::StreamDevicesSetDataView, UserType>(),
    "Attempting to read the optional `stream_devices` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStreamDevices` instead "
    "of `ReadStreamDevices if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->stream_devices.Get();
    return mojo::internal::Deserialize<::blink::mojom::StreamDevicesSetDataView>(
        pointer, output, message_);
  }
  bool pan_tilt_zoom_allowed() const {
    return data_->pan_tilt_zoom_allowed;
  }
 private:
  internal::MediaStreamDispatcherHost_GenerateStreams_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDispatcherHost_FocusCapturedSurface_ParamsDataView {
 public:
  MediaStreamDispatcherHost_FocusCapturedSurface_ParamsDataView() = default;

  MediaStreamDispatcherHost_FocusCapturedSurface_ParamsDataView(
      internal::MediaStreamDispatcherHost_FocusCapturedSurface_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool focus() const {
    return data_->focus;
  }
 private:
  internal::MediaStreamDispatcherHost_FocusCapturedSurface_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDispatcherHost_CancelRequest_ParamsDataView {
 public:
  MediaStreamDispatcherHost_CancelRequest_ParamsDataView() = default;

  MediaStreamDispatcherHost_CancelRequest_ParamsDataView(
      internal::MediaStreamDispatcherHost_CancelRequest_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t request_id() const {
    return data_->request_id;
  }
 private:
  internal::MediaStreamDispatcherHost_CancelRequest_Params_Data* data_ = nullptr;
};


class MediaStreamDispatcherHost_StopStreamDevice_ParamsDataView {
 public:
  MediaStreamDispatcherHost_StopStreamDevice_ParamsDataView() = default;

  MediaStreamDispatcherHost_StopStreamDevice_ParamsDataView(
      internal::MediaStreamDispatcherHost_StopStreamDevice_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceId(UserType* output) {
    
    auto* pointer = data_->device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSessionIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `session_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSessionId` instead "
    "of `ReadSessionId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaStreamDispatcherHost_StopStreamDevice_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDispatcherHost_OpenDevice_ParamsDataView {
 public:
  MediaStreamDispatcherHost_OpenDevice_ParamsDataView() = default;

  MediaStreamDispatcherHost_OpenDevice_ParamsDataView(
      internal::MediaStreamDispatcherHost_OpenDevice_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t request_id() const {
    return data_->request_id;
  }
  inline void GetDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceId(UserType* output) {
    
    auto* pointer = data_->device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamType>(
        data_value, output);
  }
  MediaStreamType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::MediaStreamType>(data_->type));
  }
 private:
  internal::MediaStreamDispatcherHost_OpenDevice_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDispatcherHost_OpenDevice_ResponseParamsDataView {
 public:
  MediaStreamDispatcherHost_OpenDevice_ResponseParamsDataView() = default;

  MediaStreamDispatcherHost_OpenDevice_ResponseParamsDataView(
      internal::MediaStreamDispatcherHost_OpenDevice_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceDataView(
      MediaStreamDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevice(UserType* output) {
    
    auto* pointer = data_->device.Get();
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamDeviceDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaStreamDispatcherHost_OpenDevice_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDispatcherHost_CloseDevice_ParamsDataView {
 public:
  MediaStreamDispatcherHost_CloseDevice_ParamsDataView() = default;

  MediaStreamDispatcherHost_CloseDevice_ParamsDataView(
      internal::MediaStreamDispatcherHost_CloseDevice_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaStreamDispatcherHost_CloseDevice_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDispatcherHost_SetCapturingLinkSecured_ParamsDataView {
 public:
  MediaStreamDispatcherHost_SetCapturingLinkSecured_ParamsDataView() = default;

  MediaStreamDispatcherHost_SetCapturingLinkSecured_ParamsDataView(
      internal::MediaStreamDispatcherHost_SetCapturingLinkSecured_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `session_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSessionId` instead "
    "of `ReadSessionId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamType>(
        data_value, output);
  }
  MediaStreamType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::MediaStreamType>(data_->type));
  }
  bool is_secure() const {
    return data_->is_secure;
  }
 private:
  internal::MediaStreamDispatcherHost_SetCapturingLinkSecured_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDispatcherHost_ApplySubCaptureTarget_ParamsDataView {
 public:
  MediaStreamDispatcherHost_ApplySubCaptureTarget_ParamsDataView() = default;

  MediaStreamDispatcherHost_ApplySubCaptureTarget_ParamsDataView(
      internal::MediaStreamDispatcherHost_ApplySubCaptureTarget_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::media::mojom::SubCaptureTargetType>(
        data_value, output);
  }
  ::media::mojom::SubCaptureTargetType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::SubCaptureTargetType>(data_->type));
  }
  inline void GetSubCaptureTargetDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubCaptureTarget(UserType* output) {
    
    auto* pointer = data_->sub_capture_target.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  uint32_t sub_capture_target_version() const {
    return data_->sub_capture_target_version;
  }
 private:
  internal::MediaStreamDispatcherHost_ApplySubCaptureTarget_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParamsDataView {
 public:
  MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParamsDataView() = default;

  MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParamsDataView(
      internal::MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::media::mojom::ApplySubCaptureTargetResult>(
        data_value, output);
  }
  ::media::mojom::ApplySubCaptureTargetResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::ApplySubCaptureTargetResult>(data_->result));
  }
 private:
  internal::MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams_Data* data_ = nullptr;
};


class MediaStreamDispatcherHost_SendWheel_ParamsDataView {
 public:
  MediaStreamDispatcherHost_SendWheel_ParamsDataView() = default;

  MediaStreamDispatcherHost_SendWheel_ParamsDataView(
      internal::MediaStreamDispatcherHost_SendWheel_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetActionDataView(
      CapturedWheelActionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) {
    
    auto* pointer = data_->action.Get();
    return mojo::internal::Deserialize<::blink::mojom::CapturedWheelActionDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaStreamDispatcherHost_SendWheel_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDispatcherHost_UpdateZoomLevel_ParamsDataView {
 public:
  MediaStreamDispatcherHost_UpdateZoomLevel_ParamsDataView() = default;

  MediaStreamDispatcherHost_UpdateZoomLevel_ParamsDataView(
      internal::MediaStreamDispatcherHost_UpdateZoomLevel_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) const {
    auto data_value = data_->action;
    return mojo::internal::Deserialize<::blink::mojom::ZoomLevelAction>(
        data_value, output);
  }
  ZoomLevelAction action() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ZoomLevelAction>(data_->action));
  }
 private:
  internal::MediaStreamDispatcherHost_UpdateZoomLevel_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParamsDataView {
 public:
  MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParamsDataView() = default;

  MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParamsDataView(
      internal::MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::blink::mojom::CapturedSurfaceControlResult>(
        data_value, output);
  }
  CapturedSurfaceControlResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::CapturedSurfaceControlResult>(data_->result));
  }
 private:
  internal::MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams_Data* data_ = nullptr;
};


class MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ParamsDataView {
 public:
  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ParamsDataView() = default;

  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ParamsDataView(
      internal::MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParamsDataView {
 public:
  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParamsDataView() = default;

  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParamsDataView(
      internal::MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::blink::mojom::CapturedSurfaceControlResult>(
        data_value, output);
  }
  CapturedSurfaceControlResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::CapturedSurfaceControlResult>(data_->result));
  }
 private:
  internal::MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams_Data* data_ = nullptr;
};


class MediaStreamDispatcherHost_GetOpenDevice_ParamsDataView {
 public:
  MediaStreamDispatcherHost_GetOpenDevice_ParamsDataView() = default;

  MediaStreamDispatcherHost_GetOpenDevice_ParamsDataView(
      internal::MediaStreamDispatcherHost_GetOpenDevice_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t request_id() const {
    return data_->request_id;
  }
  inline void GetSessionIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetTransferIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransferId(UserType* output) {
    
    auto* pointer = data_->transfer_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaStreamDispatcherHost_GetOpenDevice_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDispatcherHost_GetOpenDevice_ResponseParamsDataView {
 public:
  MediaStreamDispatcherHost_GetOpenDevice_ResponseParamsDataView() = default;

  MediaStreamDispatcherHost_GetOpenDevice_ResponseParamsDataView(
      internal::MediaStreamDispatcherHost_GetOpenDevice_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamRequestResult>(
        data_value, output);
  }
  MediaStreamRequestResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::MediaStreamRequestResult>(data_->result));
  }
  inline void GetResponseDataView(
      GetOpenDeviceResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::GetOpenDeviceResponseDataView, UserType>(),
    "Attempting to read the optional `response` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResponse` instead "
    "of `ReadResponse if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->response.Get();
    return mojo::internal::Deserialize<::blink::mojom::GetOpenDeviceResponseDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaStreamDispatcherHost_GetOpenDevice_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ParamsDataView {
 public:
  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ParamsDataView() = default;

  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ParamsDataView(
      internal::MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetTransferIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransferId(UserType* output) {
    
    auto* pointer = data_->transfer_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParamsDataView {
 public:
  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParamsDataView() = default;

  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParamsDataView(
      internal::MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool device_found() const {
    return data_->device_found;
  }
 private:
  internal::MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams_Data* data_ = nullptr;
};


class MediaStreamTrackMetricsHost_AddTrack_ParamsDataView {
 public:
  MediaStreamTrackMetricsHost_AddTrack_ParamsDataView() = default;

  MediaStreamTrackMetricsHost_AddTrack_ParamsDataView(
      internal::MediaStreamTrackMetricsHost_AddTrack_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t id() const {
    return data_->id;
  }
  bool is_audio() const {
    return data_->is_audio;
  }
  bool is_remote() const {
    return data_->is_remote;
  }
 private:
  internal::MediaStreamTrackMetricsHost_AddTrack_Params_Data* data_ = nullptr;
};


class MediaStreamTrackMetricsHost_RemoveTrack_ParamsDataView {
 public:
  MediaStreamTrackMetricsHost_RemoveTrack_ParamsDataView() = default;

  MediaStreamTrackMetricsHost_RemoveTrack_ParamsDataView(
      internal::MediaStreamTrackMetricsHost_RemoveTrack_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t id() const {
    return data_->id;
  }
 private:
  internal::MediaStreamTrackMetricsHost_RemoveTrack_Params_Data* data_ = nullptr;
};

inline void MediaStreamDeviceObserver_OnDeviceStopped_ParamsDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDeviceObserver_OnDeviceStopped_ParamsDataView::GetDeviceDataView(
    MediaStreamDeviceDataView* output) {
  auto pointer = data_->device.Get();
  *output = MediaStreamDeviceDataView(pointer, message_);
}


inline void MediaStreamDeviceObserver_OnDeviceChanged_ParamsDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDeviceObserver_OnDeviceChanged_ParamsDataView::GetOldDeviceDataView(
    MediaStreamDeviceDataView* output) {
  auto pointer = data_->old_device.Get();
  *output = MediaStreamDeviceDataView(pointer, message_);
}
inline void MediaStreamDeviceObserver_OnDeviceChanged_ParamsDataView::GetNewDeviceDataView(
    MediaStreamDeviceDataView* output) {
  auto pointer = data_->new_device.Get();
  *output = MediaStreamDeviceDataView(pointer, message_);
}


inline void MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsDataView::GetDeviceDataView(
    MediaStreamDeviceDataView* output) {
  auto pointer = data_->device.Get();
  *output = MediaStreamDeviceDataView(pointer, message_);
}


inline void MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_ParamsDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_ParamsDataView::GetDeviceDataView(
    MediaStreamDeviceDataView* output) {
  auto pointer = data_->device.Get();
  *output = MediaStreamDeviceDataView(pointer, message_);
}


inline void MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsDataView::GetDeviceDataView(
    MediaStreamDeviceDataView* output) {
  auto pointer = data_->device.Get();
  *output = MediaStreamDeviceDataView(pointer, message_);
}


inline void MediaStreamDeviceObserver_OnZoomLevelChange_ParamsDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDeviceObserver_OnZoomLevelChange_ParamsDataView::GetDeviceDataView(
    MediaStreamDeviceDataView* output) {
  auto pointer = data_->device.Get();
  *output = MediaStreamDeviceDataView(pointer, message_);
}


inline void MediaStreamDispatcherHost_GenerateStreams_ParamsDataView::GetControlsDataView(
    StreamControlsDataView* output) {
  auto pointer = data_->controls.Get();
  *output = StreamControlsDataView(pointer, message_);
}
inline void MediaStreamDispatcherHost_GenerateStreams_ParamsDataView::GetAudioStreamSelectionInfoDataView(
    StreamSelectionInfoDataView* output) {
  auto pointer = &data_->audio_stream_selection_info;
  *output = StreamSelectionInfoDataView(pointer, message_);
}


inline void MediaStreamDispatcherHost_GenerateStreams_ResponseParamsDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDispatcherHost_GenerateStreams_ResponseParamsDataView::GetStreamDevicesDataView(
    StreamDevicesSetDataView* output) {
  auto pointer = data_->stream_devices.Get();
  *output = StreamDevicesSetDataView(pointer, message_);
}


inline void MediaStreamDispatcherHost_FocusCapturedSurface_ParamsDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void MediaStreamDispatcherHost_StopStreamDevice_ParamsDataView::GetDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDispatcherHost_StopStreamDevice_ParamsDataView::GetSessionIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void MediaStreamDispatcherHost_OpenDevice_ParamsDataView::GetDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void MediaStreamDispatcherHost_OpenDevice_ResponseParamsDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDispatcherHost_OpenDevice_ResponseParamsDataView::GetDeviceDataView(
    MediaStreamDeviceDataView* output) {
  auto pointer = data_->device.Get();
  *output = MediaStreamDeviceDataView(pointer, message_);
}


inline void MediaStreamDispatcherHost_CloseDevice_ParamsDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void MediaStreamDispatcherHost_SetCapturingLinkSecured_ParamsDataView::GetSessionIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void MediaStreamDispatcherHost_ApplySubCaptureTarget_ParamsDataView::GetSessionIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void MediaStreamDispatcherHost_ApplySubCaptureTarget_ParamsDataView::GetSubCaptureTargetDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->sub_capture_target.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}




inline void MediaStreamDispatcherHost_SendWheel_ParamsDataView::GetSessionIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void MediaStreamDispatcherHost_SendWheel_ParamsDataView::GetActionDataView(
    CapturedWheelActionDataView* output) {
  auto pointer = data_->action.Get();
  *output = CapturedWheelActionDataView(pointer, message_);
}


inline void MediaStreamDispatcherHost_UpdateZoomLevel_ParamsDataView::GetSessionIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}




inline void MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ParamsDataView::GetSessionIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}




inline void MediaStreamDispatcherHost_GetOpenDevice_ParamsDataView::GetSessionIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void MediaStreamDispatcherHost_GetOpenDevice_ParamsDataView::GetTransferIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->transfer_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void MediaStreamDispatcherHost_GetOpenDevice_ResponseParamsDataView::GetResponseDataView(
    GetOpenDeviceResponseDataView* output) {
  auto pointer = data_->response.Get();
  *output = GetOpenDeviceResponseDataView(pointer, message_);
}


inline void MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ParamsDataView::GetSessionIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ParamsDataView::GetTransferIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->transfer_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}









}  // blink::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_PARAMS_DATA_H_