// third_party/blink/public/mojom/mediastream/media_devices.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  CameraAvailability as media_mojom_CameraAvailability,
  CameraAvailabilitySpec as media_mojom_CameraAvailabilitySpec,
  SubCaptureTargetType as media_mojom_SubCaptureTargetType,
  SubCaptureTargetTypeSpec as media_mojom_SubCaptureTargetTypeSpec,
  VideoCaptureControlSupport as media_mojom_VideoCaptureControlSupport,
  VideoCaptureControlSupportSpec as media_mojom_VideoCaptureControlSupportSpec,
  VideoCaptureFormat as media_mojom_VideoCaptureFormat,
  VideoCaptureFormatSpec as media_mojom_VideoCaptureFormatSpec
} from '../../../../../media/capture/mojom/video_capture_types.mojom.m.js';

import {
  AudioParameters as media_mojom_AudioParameters,
  AudioParametersSpec as media_mojom_AudioParametersSpec
} from '../../../../../media/mojo/mojom/audio_parameters.mojom.m.js';

import {
  OutputDeviceStatus as media_mojom_OutputDeviceStatus,
  OutputDeviceStatusSpec as media_mojom_OutputDeviceStatusSpec
} from '../../../../../media/mojo/mojom/media_types.mojom.m.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  CaptureHandleConfig as blink_mojom_CaptureHandleConfig,
  CaptureHandleConfigSpec as blink_mojom_CaptureHandleConfigSpec
} from '../media/capture_handle_config.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaDeviceTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaDeviceType = {
  
  kMediaAudioInput: 0,
  kMediaVideoInput: 1,
  kMediaAudioOutput: 2,
  kNumMediaDeviceTypes: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FacingModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FacingMode = {
  
  kNone: 0,
  kUser: 1,
  kEnvironment: 2,
  kLeft: 3,
  kRight: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AudioOutputStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AudioOutputStatus = {
  
  kSuccess: 0,
  kNoPermission: 1,
  kNoDevices: 2,
  kUnknown: 3,
  kDeviceNotFound: 4,
  kErrorOtherRequestInProgress: 5,
  kNotSupported: 6,
  kNoUserActivation: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaDevicesDispatcherHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.MediaDevicesDispatcherHost', scope);
  }
}

/** @interface */
export class MediaDevicesDispatcherHostInterface {
  
  /**
   * @param { !boolean } requestAudioInput
   * @param { !boolean } requestVideoInput
   * @param { !boolean } requestAudioOutput
   * @param { !boolean } requestVideoInputCapabilities
   * @param { !boolean } requestAudioInputCapabilities
   * @return {!Promise<{
        enumeration: !Array<!Array<!MediaDeviceInfo>>,
        videoInputDeviceCapabilities: !Array<!VideoInputDeviceCapabilities>,
        audioInputDeviceCapabilities: !Array<!AudioInputDeviceCapabilities>,
   *  }>}
   */

  enumerateDevices(requestAudioInput, requestVideoInput, requestAudioOutput, requestVideoInputCapabilities, requestAudioInputCapabilities) {}
  
  /**
   * @return {!Promise<{
        videoInputDeviceCapabilities: !Array<!VideoInputDeviceCapabilities>,
   *  }>}
   */

  getVideoInputCapabilities() {}
  
  /**
   * @param { !string } deviceId
   * @return {!Promise<{
        formats: !Array<!media_mojom_VideoCaptureFormat>,
   *  }>}
   */

  getAllVideoInputDeviceFormats(deviceId) {}
  
  /**
   * @param { !string } deviceId
   * @return {!Promise<{
        formats: !Array<!media_mojom_VideoCaptureFormat>,
   *  }>}
   */

  getAvailableVideoInputDeviceFormats(deviceId) {}
  
  /**
   * @return {!Promise<{
        audioInputDeviceCapabilities: !Array<!AudioInputDeviceCapabilities>,
   *  }>}
   */

  getAudioInputCapabilities() {}
  
  /**
   * @param { !boolean } subscribeAudioInput
   * @param { !boolean } subscribeVideoInput
   * @param { !boolean } subscribeAudioOutput
   * @param { !MediaDevicesListenerRemote } listener
   */

  addMediaDevicesListener(subscribeAudioInput, subscribeVideoInput, subscribeAudioOutput, listener) {}
  
  /**
   * @param { !blink_mojom_CaptureHandleConfig } config
   */

  setCaptureHandleConfig(config) {}
  
  /**
   * @param { !string } label
   */

  closeFocusWindowOfOpportunity(label) {}
  
  /**
   * @param { !media_mojom_SubCaptureTargetType } type
   * @return {!Promise<{
        id: !string,
   *  }>}
   */

  produceSubCaptureTargetId(type) {}
  
  /**
   * @param { !string } sinkId
   * @return {!Promise<{
        status: !media_mojom_OutputDeviceStatus,
   *  }>}
   */

  setPreferredSinkId(sinkId) {}
  
  /**
   * @param { !string } deviceId
   * @return {!Promise<{
        result: !SelectAudioOutputResult,
   *  }>}
   */

  selectAudioOutput(deviceId) {}
}

/**
 * @implements { MediaDevicesDispatcherHostInterface }
 */
export class MediaDevicesDispatcherHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaDevicesDispatcherHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaDevicesDispatcherHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaDevicesDispatcherHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } requestAudioInput
   * @param { !boolean } requestVideoInput
   * @param { !boolean } requestAudioOutput
   * @param { !boolean } requestVideoInputCapabilities
   * @param { !boolean } requestAudioInputCapabilities
   * @return {!Promise<{
        enumeration: !Array<!Array<!MediaDeviceInfo>>,
        videoInputDeviceCapabilities: !Array<!VideoInputDeviceCapabilities>,
        audioInputDeviceCapabilities: !Array<!AudioInputDeviceCapabilities>,
   *  }>}
   */

  enumerateDevices(
      requestAudioInput,
      requestVideoInput,
      requestAudioOutput,
      requestVideoInputCapabilities,
      requestAudioInputCapabilities) {
    return this.proxy.sendMessage(
        0,
        MediaDevicesDispatcherHost_EnumerateDevices_ParamsSpec.$,
        MediaDevicesDispatcherHost_EnumerateDevices_ResponseParamsSpec.$,
        [
          requestAudioInput,
          requestVideoInput,
          requestAudioOutput,
          requestVideoInputCapabilities,
          requestAudioInputCapabilities
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        videoInputDeviceCapabilities: !Array<!VideoInputDeviceCapabilities>,
   *  }>}
   */

  getVideoInputCapabilities() {
    return this.proxy.sendMessage(
        1,
        MediaDevicesDispatcherHost_GetVideoInputCapabilities_ParamsSpec.$,
        MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } deviceId
   * @return {!Promise<{
        formats: !Array<!media_mojom_VideoCaptureFormat>,
   *  }>}
   */

  getAllVideoInputDeviceFormats(
      deviceId) {
    return this.proxy.sendMessage(
        2,
        MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ParamsSpec.$,
        MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParamsSpec.$,
        [
          deviceId
        ],
        false);
  }

  
  /**
   * @param { !string } deviceId
   * @return {!Promise<{
        formats: !Array<!media_mojom_VideoCaptureFormat>,
   *  }>}
   */

  getAvailableVideoInputDeviceFormats(
      deviceId) {
    return this.proxy.sendMessage(
        3,
        MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ParamsSpec.$,
        MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParamsSpec.$,
        [
          deviceId
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        audioInputDeviceCapabilities: !Array<!AudioInputDeviceCapabilities>,
   *  }>}
   */

  getAudioInputCapabilities() {
    return this.proxy.sendMessage(
        4,
        MediaDevicesDispatcherHost_GetAudioInputCapabilities_ParamsSpec.$,
        MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } subscribeAudioInput
   * @param { !boolean } subscribeVideoInput
   * @param { !boolean } subscribeAudioOutput
   * @param { !MediaDevicesListenerRemote } listener
   */

  addMediaDevicesListener(
      subscribeAudioInput,
      subscribeVideoInput,
      subscribeAudioOutput,
      listener) {
    this.proxy.sendMessage(
        5,
        MediaDevicesDispatcherHost_AddMediaDevicesListener_ParamsSpec.$,
        null,
        [
          subscribeAudioInput,
          subscribeVideoInput,
          subscribeAudioOutput,
          listener
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_CaptureHandleConfig } config
   */

  setCaptureHandleConfig(
      config) {
    this.proxy.sendMessage(
        6,
        MediaDevicesDispatcherHost_SetCaptureHandleConfig_ParamsSpec.$,
        null,
        [
          config
        ],
        false);
  }

  
  /**
   * @param { !string } label
   */

  closeFocusWindowOfOpportunity(
      label) {
    this.proxy.sendMessage(
        7,
        MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_ParamsSpec.$,
        null,
        [
          label
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_SubCaptureTargetType } type
   * @return {!Promise<{
        id: !string,
   *  }>}
   */

  produceSubCaptureTargetId(
      type) {
    return this.proxy.sendMessage(
        8,
        MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ParamsSpec.$,
        MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }

  
  /**
   * @param { !string } sinkId
   * @return {!Promise<{
        status: !media_mojom_OutputDeviceStatus,
   *  }>}
   */

  setPreferredSinkId(
      sinkId) {
    return this.proxy.sendMessage(
        9,
        MediaDevicesDispatcherHost_SetPreferredSinkId_ParamsSpec.$,
        MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParamsSpec.$,
        [
          sinkId
        ],
        false);
  }

  
  /**
   * @param { !string } deviceId
   * @return {!Promise<{
        result: !SelectAudioOutputResult,
   *  }>}
   */

  selectAudioOutput(
      deviceId) {
    return this.proxy.sendMessage(
        10,
        MediaDevicesDispatcherHost_SelectAudioOutput_ParamsSpec.$,
        MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParamsSpec.$,
        [
          deviceId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaDevicesDispatcherHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaDevicesDispatcherHostReceiver {
  /**
   * @param {!MediaDevicesDispatcherHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaDevicesDispatcherHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaDevicesDispatcherHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaDevicesDispatcherHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaDevicesDispatcherHost_EnumerateDevices_ParamsSpec.$,
        MediaDevicesDispatcherHost_EnumerateDevices_ResponseParamsSpec.$,
        impl.enumerateDevices.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaDevicesDispatcherHost_GetVideoInputCapabilities_ParamsSpec.$,
        MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParamsSpec.$,
        impl.getVideoInputCapabilities.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ParamsSpec.$,
        MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParamsSpec.$,
        impl.getAllVideoInputDeviceFormats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ParamsSpec.$,
        MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParamsSpec.$,
        impl.getAvailableVideoInputDeviceFormats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MediaDevicesDispatcherHost_GetAudioInputCapabilities_ParamsSpec.$,
        MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParamsSpec.$,
        impl.getAudioInputCapabilities.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        MediaDevicesDispatcherHost_AddMediaDevicesListener_ParamsSpec.$,
        null,
        impl.addMediaDevicesListener.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        MediaDevicesDispatcherHost_SetCaptureHandleConfig_ParamsSpec.$,
        null,
        impl.setCaptureHandleConfig.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_ParamsSpec.$,
        null,
        impl.closeFocusWindowOfOpportunity.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ParamsSpec.$,
        MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParamsSpec.$,
        impl.produceSubCaptureTargetId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        MediaDevicesDispatcherHost_SetPreferredSinkId_ParamsSpec.$,
        MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParamsSpec.$,
        impl.setPreferredSinkId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        MediaDevicesDispatcherHost_SelectAudioOutput_ParamsSpec.$,
        MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParamsSpec.$,
        impl.selectAudioOutput.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaDevicesDispatcherHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MediaDevicesDispatcherHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaDevicesDispatcherHostRemote}
   */
  static getRemote() {
    let remote = new MediaDevicesDispatcherHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaDevicesDispatcherHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaDevicesDispatcherHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaDevicesDispatcherHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaDevicesDispatcherHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enumerateDevices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaDevicesDispatcherHost_EnumerateDevices_ParamsSpec.$,
        MediaDevicesDispatcherHost_EnumerateDevices_ResponseParamsSpec.$,
        this.enumerateDevices.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getVideoInputCapabilities =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaDevicesDispatcherHost_GetVideoInputCapabilities_ParamsSpec.$,
        MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParamsSpec.$,
        this.getVideoInputCapabilities.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAllVideoInputDeviceFormats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ParamsSpec.$,
        MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParamsSpec.$,
        this.getAllVideoInputDeviceFormats.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAvailableVideoInputDeviceFormats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ParamsSpec.$,
        MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParamsSpec.$,
        this.getAvailableVideoInputDeviceFormats.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAudioInputCapabilities =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MediaDevicesDispatcherHost_GetAudioInputCapabilities_ParamsSpec.$,
        MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParamsSpec.$,
        this.getAudioInputCapabilities.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addMediaDevicesListener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        MediaDevicesDispatcherHost_AddMediaDevicesListener_ParamsSpec.$,
        null,
        this.addMediaDevicesListener.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCaptureHandleConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        MediaDevicesDispatcherHost_SetCaptureHandleConfig_ParamsSpec.$,
        null,
        this.setCaptureHandleConfig.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeFocusWindowOfOpportunity =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_ParamsSpec.$,
        null,
        this.closeFocusWindowOfOpportunity.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.produceSubCaptureTargetId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ParamsSpec.$,
        MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParamsSpec.$,
        this.produceSubCaptureTargetId.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPreferredSinkId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        MediaDevicesDispatcherHost_SetPreferredSinkId_ParamsSpec.$,
        MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParamsSpec.$,
        this.setPreferredSinkId.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.selectAudioOutput =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        MediaDevicesDispatcherHost_SelectAudioOutput_ParamsSpec.$,
        MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParamsSpec.$,
        this.selectAudioOutput.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaDevicesListenerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.MediaDevicesListener', scope);
  }
}

/** @interface */
export class MediaDevicesListenerInterface {
  
  /**
   * @param { !MediaDeviceType } type
   * @param { !Array<!MediaDeviceInfo> } deviceInfos
   */

  onDevicesChanged(type, deviceInfos) {}
}

/**
 * @implements { MediaDevicesListenerInterface }
 */
export class MediaDevicesListenerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaDevicesListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaDevicesListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaDevicesListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !MediaDeviceType } type
   * @param { !Array<!MediaDeviceInfo> } deviceInfos
   */

  onDevicesChanged(
      type,
      deviceInfos) {
    this.proxy.sendMessage(
        0,
        MediaDevicesListener_OnDevicesChanged_ParamsSpec.$,
        null,
        [
          type,
          deviceInfos
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaDevicesListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaDevicesListenerReceiver {
  /**
   * @param {!MediaDevicesListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaDevicesListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaDevicesListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaDevicesListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaDevicesListener_OnDevicesChanged_ParamsSpec.$,
        null,
        impl.onDevicesChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaDevicesListener {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MediaDevicesListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaDevicesListenerRemote}
   */
  static getRemote() {
    let remote = new MediaDevicesListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaDevicesListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaDevicesListenerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaDevicesListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaDevicesListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDevicesChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaDevicesListener_OnDevicesChanged_ParamsSpec.$,
        null,
        this.onDevicesChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDeviceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoInputDeviceCapabilitiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SelectAudioOutputResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioInputDeviceCapabilitiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_EnumerateDevices_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_EnumerateDevices_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_GetVideoInputCapabilities_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_GetAudioInputCapabilities_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_AddMediaDevicesListener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_SetCaptureHandleConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_SetPreferredSinkId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_SelectAudioOutput_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaDevicesListener_OnDevicesChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    MediaDeviceInfoSpec.$,
    'MediaDeviceInfo',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'groupId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'controlSupport', 24,
        0,
        media_mojom_VideoCaptureControlSupportSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'facingMode', 32,
        0,
        FacingModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'availability_$flag', 36,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "availability_$value",
          originalFieldName: "availability",
        }
      ),
      mojo.internal.StructField(
        'availability_$value', 40,
        0,
        media_mojom_CameraAvailabilitySpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "availability",
        }
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class MediaDeviceInfo {
  constructor() {
    /** @type { !string } */
    this.deviceId;
    /** @type { !string } */
    this.label;
    /** @type { !string } */
    this.groupId;
    /** @type { !media_mojom_VideoCaptureControlSupport } */
    this.controlSupport;
    /** @type { !FacingMode } */
    this.facingMode;
    /** @type { (media_mojom_CameraAvailability|undefined) } */
    this.availability;
  }
}



mojo.internal.Struct(
    VideoInputDeviceCapabilitiesSpec.$,
    'VideoInputDeviceCapabilities',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'groupId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'controlSupport', 16,
        0,
        media_mojom_VideoCaptureControlSupportSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'formats', 24,
        0,
        mojo.internal.Array(media_mojom_VideoCaptureFormatSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'facingMode', 32,
        0,
        FacingModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'availability_$flag', 36,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "availability_$value",
          originalFieldName: "availability",
        }
      ),
      mojo.internal.StructField(
        'availability_$value', 40,
        0,
        media_mojom_CameraAvailabilitySpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "availability",
        }
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class VideoInputDeviceCapabilities {
  constructor() {
    /** @type { !string } */
    this.deviceId;
    /** @type { !string } */
    this.groupId;
    /** @type { !media_mojom_VideoCaptureControlSupport } */
    this.controlSupport;
    /** @type { !Array<!media_mojom_VideoCaptureFormat> } */
    this.formats;
    /** @type { !FacingMode } */
    this.facingMode;
    /** @type { (media_mojom_CameraAvailability|undefined) } */
    this.availability;
  }
}



mojo.internal.Struct(
    SelectAudioOutputResultSpec.$,
    'SelectAudioOutputResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        AudioOutputStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceInfo', 8,
        0,
        MediaDeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SelectAudioOutputResult {
  constructor() {
    /** @type { !AudioOutputStatus } */
    this.status;
    /** @type { !MediaDeviceInfo } */
    this.deviceInfo;
  }
}



mojo.internal.Struct(
    AudioInputDeviceCapabilitiesSpec.$,
    'AudioInputDeviceCapabilities',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'groupId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'parameters', 16,
        0,
        media_mojom_AudioParametersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isValid', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channels', 28,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sampleRate', 32,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'latency', 40,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class AudioInputDeviceCapabilities {
  constructor() {
    /** @type { !string } */
    this.deviceId;
    /** @type { !string } */
    this.groupId;
    /** @type { !media_mojom_AudioParameters } */
    this.parameters;
    /** @type { !boolean } */
    this.isValid;
    /** @type { !number } */
    this.channels;
    /** @type { !number } */
    this.sampleRate;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.latency;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_EnumerateDevices_ParamsSpec.$,
    'MediaDevicesDispatcherHost_EnumerateDevices_Params',
    [
      mojo.internal.StructField(
        'requestAudioInput', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestVideoInput', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestAudioOutput', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestVideoInputCapabilities', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestAudioInputCapabilities', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_EnumerateDevices_Params {
  constructor() {
    /** @type { !boolean } */
    this.requestAudioInput;
    /** @type { !boolean } */
    this.requestVideoInput;
    /** @type { !boolean } */
    this.requestAudioOutput;
    /** @type { !boolean } */
    this.requestVideoInputCapabilities;
    /** @type { !boolean } */
    this.requestAudioInputCapabilities;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_EnumerateDevices_ResponseParamsSpec.$,
    'MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams',
    [
      mojo.internal.StructField(
        'enumeration', 0,
        0,
        mojo.internal.Array(mojo.internal.Array(MediaDeviceInfoSpec.$, false), false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoInputDeviceCapabilities', 8,
        0,
        mojo.internal.Array(VideoInputDeviceCapabilitiesSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioInputDeviceCapabilities', 16,
        0,
        mojo.internal.Array(AudioInputDeviceCapabilitiesSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams {
  constructor() {
    /** @type { !Array<!Array<!MediaDeviceInfo>> } */
    this.enumeration;
    /** @type { !Array<!VideoInputDeviceCapabilities> } */
    this.videoInputDeviceCapabilities;
    /** @type { !Array<!AudioInputDeviceCapabilities> } */
    this.audioInputDeviceCapabilities;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_GetVideoInputCapabilities_ParamsSpec.$,
    'MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParamsSpec.$,
    'MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams',
    [
      mojo.internal.StructField(
        'videoInputDeviceCapabilities', 0,
        0,
        mojo.internal.Array(VideoInputDeviceCapabilitiesSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams {
  constructor() {
    /** @type { !Array<!VideoInputDeviceCapabilities> } */
    this.videoInputDeviceCapabilities;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ParamsSpec.$,
    'MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params {
  constructor() {
    /** @type { !string } */
    this.deviceId;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParamsSpec.$,
    'MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams',
    [
      mojo.internal.StructField(
        'formats', 0,
        0,
        mojo.internal.Array(media_mojom_VideoCaptureFormatSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams {
  constructor() {
    /** @type { !Array<!media_mojom_VideoCaptureFormat> } */
    this.formats;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ParamsSpec.$,
    'MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params {
  constructor() {
    /** @type { !string } */
    this.deviceId;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParamsSpec.$,
    'MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams',
    [
      mojo.internal.StructField(
        'formats', 0,
        0,
        mojo.internal.Array(media_mojom_VideoCaptureFormatSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams {
  constructor() {
    /** @type { !Array<!media_mojom_VideoCaptureFormat> } */
    this.formats;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_GetAudioInputCapabilities_ParamsSpec.$,
    'MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParamsSpec.$,
    'MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams',
    [
      mojo.internal.StructField(
        'audioInputDeviceCapabilities', 0,
        0,
        mojo.internal.Array(AudioInputDeviceCapabilitiesSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams {
  constructor() {
    /** @type { !Array<!AudioInputDeviceCapabilities> } */
    this.audioInputDeviceCapabilities;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_AddMediaDevicesListener_ParamsSpec.$,
    'MediaDevicesDispatcherHost_AddMediaDevicesListener_Params',
    [
      mojo.internal.StructField(
        'subscribeAudioInput', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subscribeVideoInput', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subscribeAudioOutput', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'listener', 4,
        0,
        mojo.internal.InterfaceProxy(MediaDevicesListenerRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_AddMediaDevicesListener_Params {
  constructor() {
    /** @type { !boolean } */
    this.subscribeAudioInput;
    /** @type { !boolean } */
    this.subscribeVideoInput;
    /** @type { !boolean } */
    this.subscribeAudioOutput;
    /** @type { !MediaDevicesListenerRemote } */
    this.listener;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_SetCaptureHandleConfig_ParamsSpec.$,
    'MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        blink_mojom_CaptureHandleConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params {
  constructor() {
    /** @type { !blink_mojom_CaptureHandleConfig } */
    this.config;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_ParamsSpec.$,
    'MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params {
  constructor() {
    /** @type { !string } */
    this.label;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ParamsSpec.$,
    'MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        media_mojom_SubCaptureTargetTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params {
  constructor() {
    /** @type { !media_mojom_SubCaptureTargetType } */
    this.type;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParamsSpec.$,
    'MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.id;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_SetPreferredSinkId_ParamsSpec.$,
    'MediaDevicesDispatcherHost_SetPreferredSinkId_Params',
    [
      mojo.internal.StructField(
        'sinkId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_SetPreferredSinkId_Params {
  constructor() {
    /** @type { !string } */
    this.sinkId;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParamsSpec.$,
    'MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media_mojom_OutputDeviceStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams {
  constructor() {
    /** @type { !media_mojom_OutputDeviceStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_SelectAudioOutput_ParamsSpec.$,
    'MediaDevicesDispatcherHost_SelectAudioOutput_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_SelectAudioOutput_Params {
  constructor() {
    /** @type { !string } */
    this.deviceId;
  }
}



mojo.internal.Struct(
    MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParamsSpec.$,
    'MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SelectAudioOutputResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams {
  constructor() {
    /** @type { !SelectAudioOutputResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MediaDevicesListener_OnDevicesChanged_ParamsSpec.$,
    'MediaDevicesListener_OnDevicesChanged_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        MediaDeviceTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceInfos', 8,
        0,
        mojo.internal.Array(MediaDeviceInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaDevicesListener_OnDevicesChanged_Params {
  constructor() {
    /** @type { !MediaDeviceType } */
    this.type;
    /** @type { !Array<!MediaDeviceInfo> } */
    this.deviceInfos;
  }
}

