// third_party/blink/public/mojom/mediastream/media_devices.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-shared-internal.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/mojo/mojom/audio_parameters.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/media/capture_handle_config.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::MediaDeviceType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::MediaDeviceType> {};

template <>
struct hash<::blink::mojom::FacingMode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::FacingMode> {};

template <>
struct hash<::blink::mojom::AudioOutputStatus>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AudioOutputStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaDeviceType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::MediaDeviceType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::MediaDeviceType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FacingMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::FacingMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::FacingMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AudioOutputStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AudioOutputStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AudioOutputStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaDeviceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MediaDeviceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::MediaDeviceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::device_id(input)) in_device_id = Traits::device_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_id)::BaseType> device_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_device_id,
      device_id_fragment);

    fragment->device_id.Set(
        device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in MediaDeviceInfo struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in MediaDeviceInfo struct");

    decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_id)::BaseType> group_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_group_id,
      group_id_fragment);

    fragment->group_id.Set(
        group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->group_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_id in MediaDeviceInfo struct");

    decltype(Traits::control_support(input)) in_control_support = Traits::control_support(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->control_support)::BaseType> control_support_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::VideoCaptureControlSupportDataView>(
      in_control_support,
      control_support_fragment);

    fragment->control_support.Set(
        control_support_fragment.is_null() ? nullptr : control_support_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->control_support.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null control_support in MediaDeviceInfo struct");

    
    mojo::internal::Serialize<::blink::mojom::FacingMode>(
      Traits::facing_mode(input),
      &fragment->facing_mode);
    fragment->availability_$flag = Traits::availability(input).has_value();
    if (Traits::availability(input).has_value()) {
      
      mojo::internal::Serialize<::media::mojom::CameraAvailability>(
        Traits::availability(input).value(),
        &fragment->availability_$value);
    } else {
      fragment->availability_$value =
          static_cast<int32_t>(::media::mojom::CameraAvailability::kMinValue);
    }
  }

  static bool Deserialize(::blink::mojom::internal::MediaDeviceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MediaDeviceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::VideoInputDeviceCapabilitiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::VideoInputDeviceCapabilitiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::VideoInputDeviceCapabilities_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::device_id(input)) in_device_id = Traits::device_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_id)::BaseType> device_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_device_id,
      device_id_fragment);

    fragment->device_id.Set(
        device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in VideoInputDeviceCapabilities struct");

    decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_id)::BaseType> group_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_group_id,
      group_id_fragment);

    fragment->group_id.Set(
        group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->group_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_id in VideoInputDeviceCapabilities struct");

    decltype(Traits::control_support(input)) in_control_support = Traits::control_support(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->control_support)::BaseType> control_support_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::VideoCaptureControlSupportDataView>(
      in_control_support,
      control_support_fragment);

    fragment->control_support.Set(
        control_support_fragment.is_null() ? nullptr : control_support_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->control_support.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null control_support in VideoInputDeviceCapabilities struct");

    decltype(Traits::formats(input)) in_formats = Traits::formats(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->formats)::BaseType>
        formats_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& formats_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>>(
      in_formats,
      formats_fragment,
      &formats_validate_params);

    fragment->formats.Set(
        formats_fragment.is_null() ? nullptr : formats_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->formats.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null formats in VideoInputDeviceCapabilities struct");

    
    mojo::internal::Serialize<::blink::mojom::FacingMode>(
      Traits::facing_mode(input),
      &fragment->facing_mode);
    fragment->availability_$flag = Traits::availability(input).has_value();
    if (Traits::availability(input).has_value()) {
      
      mojo::internal::Serialize<::media::mojom::CameraAvailability>(
        Traits::availability(input).value(),
        &fragment->availability_$value);
    } else {
      fragment->availability_$value =
          static_cast<int32_t>(::media::mojom::CameraAvailability::kMinValue);
    }
  }

  static bool Deserialize(::blink::mojom::internal::VideoInputDeviceCapabilities_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::VideoInputDeviceCapabilitiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SelectAudioOutputResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SelectAudioOutputResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SelectAudioOutputResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::AudioOutputStatus>(
      Traits::status(input),
      &fragment->status);

    decltype(Traits::device_info(input)) in_device_info = Traits::device_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_info)::BaseType> device_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::MediaDeviceInfoDataView>(
      in_device_info,
      device_info_fragment);

    fragment->device_info.Set(
        device_info_fragment.is_null() ? nullptr : device_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_info in SelectAudioOutputResult struct");
  }

  static bool Deserialize(::blink::mojom::internal::SelectAudioOutputResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SelectAudioOutputResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AudioInputDeviceCapabilitiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AudioInputDeviceCapabilitiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AudioInputDeviceCapabilities_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::device_id(input)) in_device_id = Traits::device_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_id)::BaseType> device_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_device_id,
      device_id_fragment);

    fragment->device_id.Set(
        device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in AudioInputDeviceCapabilities struct");

    decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_id)::BaseType> group_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_group_id,
      group_id_fragment);

    fragment->group_id.Set(
        group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->group_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_id in AudioInputDeviceCapabilities struct");

    decltype(Traits::parameters(input)) in_parameters = Traits::parameters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parameters)::BaseType> parameters_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
      in_parameters,
      parameters_fragment);

    fragment->parameters.Set(
        parameters_fragment.is_null() ? nullptr : parameters_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->parameters.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parameters in AudioInputDeviceCapabilities struct");

    fragment->is_valid = Traits::is_valid(input);

    fragment->channels = Traits::channels(input);

    fragment->sample_rate = Traits::sample_rate(input);

    decltype(Traits::latency(input)) in_latency = Traits::latency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->latency)::BaseType> latency_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_latency,
      latency_fragment);

    fragment->latency.Set(
        latency_fragment.is_null() ? nullptr : latency_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->latency.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null latency in AudioInputDeviceCapabilities struct");
  }

  static bool Deserialize(::blink::mojom::internal::AudioInputDeviceCapabilities_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AudioInputDeviceCapabilitiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void MediaDeviceInfoDataView::GetDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaDeviceInfoDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaDeviceInfoDataView::GetGroupIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaDeviceInfoDataView::GetControlSupportDataView(
    ::media::mojom::VideoCaptureControlSupportDataView* output) {
  auto pointer = data_->control_support.Get();
  *output = ::media::mojom::VideoCaptureControlSupportDataView(pointer, message_);
}


inline void VideoInputDeviceCapabilitiesDataView::GetDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void VideoInputDeviceCapabilitiesDataView::GetGroupIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void VideoInputDeviceCapabilitiesDataView::GetControlSupportDataView(
    ::media::mojom::VideoCaptureControlSupportDataView* output) {
  auto pointer = data_->control_support.Get();
  *output = ::media::mojom::VideoCaptureControlSupportDataView(pointer, message_);
}
inline void VideoInputDeviceCapabilitiesDataView::GetFormatsDataView(
    mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>* output) {
  auto pointer = data_->formats.Get();
  *output = mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>(pointer, message_);
}


inline void SelectAudioOutputResultDataView::GetDeviceInfoDataView(
    MediaDeviceInfoDataView* output) {
  auto pointer = data_->device_info.Get();
  *output = MediaDeviceInfoDataView(pointer, message_);
}


inline void AudioInputDeviceCapabilitiesDataView::GetDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AudioInputDeviceCapabilitiesDataView::GetGroupIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AudioInputDeviceCapabilitiesDataView::GetParametersDataView(
    ::media::mojom::AudioParametersDataView* output) {
  auto pointer = data_->parameters.Get();
  *output = ::media::mojom::AudioParametersDataView(pointer, message_);
}
inline void AudioInputDeviceCapabilitiesDataView::GetLatencyDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->latency.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::MediaDeviceType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::MediaDeviceType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::FacingMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::FacingMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AudioOutputStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AudioOutputStatus value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_SHARED_H_