// third_party/blink/public/mojom/mediasession/media_session.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.MediaSessionPlaybackStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.MediaSessionPlaybackState = {
  
  NONE: 0,
  PAUSED: 1,
  PLAYING: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.MediaSessionEnterPictureInPictureReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.MediaSessionEnterPictureInPictureReason = {
  
  kOther: 0,
  kUserAction: 1,
  kContentOccluded: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.MediaSessionClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.MediaSessionClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.MediaSessionClientInterface }
 */
blink.mojom.MediaSessionClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.MediaSessionClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.MediaSessionClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.MediaSessionClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mediaSession.mojom.MediaSessionAction } action
   * @param { ?blink.mojom.MediaSessionActionDetails } details
   */

  didReceiveAction(
      action,
      details) {
    this.proxy.sendMessage(
        0,
        blink.mojom.MediaSessionClient_DidReceiveAction_ParamsSpec.$,
        null,
        [
          action,
          details
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaSessionClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.MediaSessionClientReceiver = class {
  /**
   * @param {!blink.mojom.MediaSessionClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.MediaSessionClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.MediaSessionClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MediaSessionClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MediaSessionClient_DidReceiveAction_ParamsSpec.$,
        null,
        impl.didReceiveAction.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.MediaSessionClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MediaSessionClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.MediaSessionClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.MediaSessionClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MediaSessionClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.MediaSessionClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.MediaSessionClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MediaSessionClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didReceiveAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MediaSessionClient_DidReceiveAction_ParamsSpec.$,
        null,
        this.didReceiveAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.MediaSessionServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.MediaSessionService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.MediaSessionServiceInterface }
 */
blink.mojom.MediaSessionServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.MediaSessionServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.MediaSessionServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.MediaSessionServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.MediaSessionClientRemote } client
   */

  setClient(
      client) {
    this.proxy.sendMessage(
        0,
        blink.mojom.MediaSessionService_SetClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.MediaSessionPlaybackState } state
   */

  setPlaybackState(
      state) {
    this.proxy.sendMessage(
        1,
        blink.mojom.MediaSessionService_SetPlaybackState_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }

  
  /**
   * @param { ?mediaSession.mojom.MediaPosition } position
   */

  setPositionState(
      position) {
    this.proxy.sendMessage(
        2,
        blink.mojom.MediaSessionService_SetPositionState_ParamsSpec.$,
        null,
        [
          position
        ],
        false);
  }

  
  /**
   * @param { ?blink.mojom.SpecMediaMetadata } metadata
   */

  setMetadata(
      metadata) {
    this.proxy.sendMessage(
        3,
        blink.mojom.MediaSessionService_SetMetadata_ParamsSpec.$,
        null,
        [
          metadata
        ],
        false);
  }

  
  /**
   * @param { !mediaSession.mojom.MicrophoneState } microphoneState
   */

  setMicrophoneState(
      microphoneState) {
    this.proxy.sendMessage(
        4,
        blink.mojom.MediaSessionService_SetMicrophoneState_ParamsSpec.$,
        null,
        [
          microphoneState
        ],
        false);
  }

  
  /**
   * @param { !mediaSession.mojom.CameraState } cameraState
   */

  setCameraState(
      cameraState) {
    this.proxy.sendMessage(
        5,
        blink.mojom.MediaSessionService_SetCameraState_ParamsSpec.$,
        null,
        [
          cameraState
        ],
        false);
  }

  
  /**
   * @param { !mediaSession.mojom.MediaSessionAction } action
   */

  enableAction(
      action) {
    this.proxy.sendMessage(
        6,
        blink.mojom.MediaSessionService_EnableAction_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }

  
  /**
   * @param { !mediaSession.mojom.MediaSessionAction } action
   */

  disableAction(
      action) {
    this.proxy.sendMessage(
        7,
        blink.mojom.MediaSessionService_DisableAction_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaSessionService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.MediaSessionServiceReceiver = class {
  /**
   * @param {!blink.mojom.MediaSessionServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.MediaSessionServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.MediaSessionServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MediaSessionServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MediaSessionService_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.MediaSessionService_SetPlaybackState_ParamsSpec.$,
        null,
        impl.setPlaybackState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.MediaSessionService_SetPositionState_ParamsSpec.$,
        null,
        impl.setPositionState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.MediaSessionService_SetMetadata_ParamsSpec.$,
        null,
        impl.setMetadata.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.MediaSessionService_SetMicrophoneState_ParamsSpec.$,
        null,
        impl.setMicrophoneState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.MediaSessionService_SetCameraState_ParamsSpec.$,
        null,
        impl.setCameraState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.MediaSessionService_EnableAction_ParamsSpec.$,
        null,
        impl.enableAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.MediaSessionService_DisableAction_ParamsSpec.$,
        null,
        impl.disableAction.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.MediaSessionService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MediaSessionService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.MediaSessionServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.MediaSessionServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MediaSessionService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.MediaSessionServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.MediaSessionServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MediaSessionServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MediaSessionService_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPlaybackState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.MediaSessionService_SetPlaybackState_ParamsSpec.$,
        null,
        this.setPlaybackState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPositionState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.MediaSessionService_SetPositionState_ParamsSpec.$,
        null,
        this.setPositionState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMetadata =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.MediaSessionService_SetMetadata_ParamsSpec.$,
        null,
        this.setMetadata.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMicrophoneState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.MediaSessionService_SetMicrophoneState_ParamsSpec.$,
        null,
        this.setMicrophoneState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCameraState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.MediaSessionService_SetCameraState_ParamsSpec.$,
        null,
        this.setCameraState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.MediaSessionService_EnableAction_ParamsSpec.$,
        null,
        this.enableAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.disableAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.MediaSessionService_DisableAction_ParamsSpec.$,
        null,
        this.disableAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaSessionSeekToDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaSessionEnterPictureInPictureDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpecMediaMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaSessionClient_DidReceiveAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaSessionService_SetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaSessionService_SetPlaybackState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaSessionService_SetPositionState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaSessionService_SetMetadata_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaSessionService_SetMicrophoneState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaSessionService_SetCameraState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaSessionService_EnableAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaSessionService_DisableAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.MediaSessionActionDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.MediaSessionSeekToDetailsSpec.$,
    'MediaSessionSeekToDetails',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fastSeek', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.MediaSessionSeekToDetails = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.seekTime;
    /** @export { !boolean } */
    this.fastSeek;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaSessionEnterPictureInPictureDetailsSpec.$,
    'MediaSessionEnterPictureInPictureDetails',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        blink.mojom.MediaSessionEnterPictureInPictureReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaSessionEnterPictureInPictureDetails = class {
  constructor() {
    /** @export { !blink.mojom.MediaSessionEnterPictureInPictureReason } */
    this.reason;
  }
};



mojo.internal.Struct(
    blink.mojom.SpecMediaMetadataSpec.$,
    'SpecMediaMetadata',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'artist', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'album', 16,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'artwork', 24,
        0,
        mojo.internal.Array(mediaSession.mojom.MediaImageSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'chapterInfo', 32,
        0,
        mojo.internal.Array(mediaSession.mojom.ChapterInformationSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.SpecMediaMetadata = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.title;
    /** @export { !mojoBase.mojom.String16 } */
    this.artist;
    /** @export { !mojoBase.mojom.String16 } */
    this.album;
    /** @export { !Array<!mediaSession.mojom.MediaImage> } */
    this.artwork;
    /** @export { !Array<!mediaSession.mojom.ChapterInformation> } */
    this.chapterInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaSessionClient_DidReceiveAction_ParamsSpec.$,
    'MediaSessionClient_DidReceiveAction_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        mediaSession.mojom.MediaSessionActionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'details', 8,
        0,
        blink.mojom.MediaSessionActionDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.MediaSessionClient_DidReceiveAction_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSessionAction } */
    this.action;
    /** @export { (blink.mojom.MediaSessionActionDetails|undefined) } */
    this.details;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaSessionService_SetClient_ParamsSpec.$,
    'MediaSessionService_SetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.MediaSessionClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaSessionService_SetClient_Params = class {
  constructor() {
    /** @export { !blink.mojom.MediaSessionClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaSessionService_SetPlaybackState_ParamsSpec.$,
    'MediaSessionService_SetPlaybackState_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        blink.mojom.MediaSessionPlaybackStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaSessionService_SetPlaybackState_Params = class {
  constructor() {
    /** @export { !blink.mojom.MediaSessionPlaybackState } */
    this.state;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaSessionService_SetPositionState_ParamsSpec.$,
    'MediaSessionService_SetPositionState_Params',
    [
      mojo.internal.StructField(
        'position', 0,
        0,
        mediaSession.mojom.MediaPositionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaSessionService_SetPositionState_Params = class {
  constructor() {
    /** @export { (mediaSession.mojom.MediaPosition|undefined) } */
    this.position;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaSessionService_SetMetadata_ParamsSpec.$,
    'MediaSessionService_SetMetadata_Params',
    [
      mojo.internal.StructField(
        'metadata', 0,
        0,
        blink.mojom.SpecMediaMetadataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaSessionService_SetMetadata_Params = class {
  constructor() {
    /** @export { (blink.mojom.SpecMediaMetadata|undefined) } */
    this.metadata;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaSessionService_SetMicrophoneState_ParamsSpec.$,
    'MediaSessionService_SetMicrophoneState_Params',
    [
      mojo.internal.StructField(
        'microphoneState', 0,
        0,
        mediaSession.mojom.MicrophoneStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaSessionService_SetMicrophoneState_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MicrophoneState } */
    this.microphoneState;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaSessionService_SetCameraState_ParamsSpec.$,
    'MediaSessionService_SetCameraState_Params',
    [
      mojo.internal.StructField(
        'cameraState', 0,
        0,
        mediaSession.mojom.CameraStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaSessionService_SetCameraState_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.CameraState } */
    this.cameraState;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaSessionService_EnableAction_ParamsSpec.$,
    'MediaSessionService_EnableAction_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        mediaSession.mojom.MediaSessionActionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaSessionService_EnableAction_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSessionAction } */
    this.action;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaSessionService_DisableAction_ParamsSpec.$,
    'MediaSessionService_DisableAction_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        mediaSession.mojom.MediaSessionActionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaSessionService_DisableAction_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSessionAction } */
    this.action;
  }
};



mojo.internal.Union(
    blink.mojom.MediaSessionActionDetailsSpec.$, 'MediaSessionActionDetails',
    {
      'seekTo': {
        'ordinal': 0,
        'type': blink.mojom.MediaSessionSeekToDetailsSpec.$,
      },
      'enterPictureInPicture': {
        'ordinal': 1,
        'type': blink.mojom.MediaSessionEnterPictureInPictureDetailsSpec.$,
      },
    });

/**
 * @typedef { {
 *   seekTo: (!blink.mojom.MediaSessionSeekToDetails|undefined),
 *   enterPictureInPicture: (!blink.mojom.MediaSessionEnterPictureInPictureDetails|undefined),
 * } }
 */
blink.mojom.MediaSessionActionDetails;
