// third_party/blink/public/mojom/media/renderer_audio_input_stream_factory.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ReadWriteAudioDataPipe as media_mojom_ReadWriteAudioDataPipe,
  ReadWriteAudioDataPipeSpec as media_mojom_ReadWriteAudioDataPipeSpec
} from '../../../../../media/mojo/mojom/audio_data_pipe.mojom.m.js';

import {
  AudioInputStreamRemote as media_mojom_AudioInputStreamRemote,
  AudioInputStreamPendingReceiver as media_mojom_AudioInputStreamPendingReceiver,
  AudioInputStreamClientRemote as media_mojom_AudioInputStreamClientRemote,
  AudioInputStreamClientPendingReceiver as media_mojom_AudioInputStreamClientPendingReceiver
} from '../../../../../media/mojo/mojom/audio_input_stream.mojom.m.js';

import {
  AudioParameters as media_mojom_AudioParameters,
  AudioParametersSpec as media_mojom_AudioParametersSpec
} from '../../../../../media/mojo/mojom/audio_parameters.mojom.m.js';

import {
  AudioProcessingConfig as media_mojom_AudioProcessingConfig,
  AudioProcessingConfigSpec as media_mojom_AudioProcessingConfigSpec
} from '../../../../../media/mojo/mojom/audio_processing.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RendererAudioInputStreamFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.RendererAudioInputStreamFactory', scope);
  }
}

/** @interface */
export class RendererAudioInputStreamFactoryInterface {
  
  /**
   * @param { !RendererAudioInputStreamFactoryClientRemote } client
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @param { !media_mojom_AudioParameters } params
   * @param { !boolean } automaticGainControl
   * @param { !number } sharedMemoryCount
   * @param { ?media_mojom_AudioProcessingConfig } processingConfig
   */

  createStream(client, sessionId, params, automaticGainControl, sharedMemoryCount, processingConfig) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } inputStreamId
   * @param { !string } outputDeviceId
   */

  associateInputAndOutputForAec(inputStreamId, outputDeviceId) {}
}

/**
 * @implements { RendererAudioInputStreamFactoryInterface }
 */
export class RendererAudioInputStreamFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RendererAudioInputStreamFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RendererAudioInputStreamFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RendererAudioInputStreamFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !RendererAudioInputStreamFactoryClientRemote } client
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @param { !media_mojom_AudioParameters } params
   * @param { !boolean } automaticGainControl
   * @param { !number } sharedMemoryCount
   * @param { ?media_mojom_AudioProcessingConfig } processingConfig
   */

  createStream(
      client,
      sessionId,
      params,
      automaticGainControl,
      sharedMemoryCount,
      processingConfig) {
    this.proxy.sendMessage(
        0,
        RendererAudioInputStreamFactory_CreateStream_ParamsSpec.$,
        null,
        [
          client,
          sessionId,
          params,
          automaticGainControl,
          sharedMemoryCount,
          processingConfig
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } inputStreamId
   * @param { !string } outputDeviceId
   */

  associateInputAndOutputForAec(
      inputStreamId,
      outputDeviceId) {
    this.proxy.sendMessage(
        1,
        RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_ParamsSpec.$,
        null,
        [
          inputStreamId,
          outputDeviceId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RendererAudioInputStreamFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RendererAudioInputStreamFactoryReceiver {
  /**
   * @param {!RendererAudioInputStreamFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RendererAudioInputStreamFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RendererAudioInputStreamFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererAudioInputStreamFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RendererAudioInputStreamFactory_CreateStream_ParamsSpec.$,
        null,
        impl.createStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_ParamsSpec.$,
        null,
        impl.associateInputAndOutputForAec.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RendererAudioInputStreamFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RendererAudioInputStreamFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RendererAudioInputStreamFactoryRemote}
   */
  static getRemote() {
    let remote = new RendererAudioInputStreamFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RendererAudioInputStreamFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RendererAudioInputStreamFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RendererAudioInputStreamFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererAudioInputStreamFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RendererAudioInputStreamFactory_CreateStream_ParamsSpec.$,
        null,
        this.createStream.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.associateInputAndOutputForAec =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_ParamsSpec.$,
        null,
        this.associateInputAndOutputForAec.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RendererAudioInputStreamFactoryClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.RendererAudioInputStreamFactoryClient', scope);
  }
}

/** @interface */
export class RendererAudioInputStreamFactoryClientInterface {
  
  /**
   * @param { !media_mojom_AudioInputStreamRemote } stream
   * @param { !media_mojom_AudioInputStreamClientPendingReceiver } clientRequest
   * @param { !media_mojom_ReadWriteAudioDataPipe } dataPipe
   * @param { !boolean } initiallyMuted
   * @param { ?mojoBase_mojom_UnguessableToken } streamId
   */

  streamCreated(stream, clientRequest, dataPipe, initiallyMuted, streamId) {}
}

/**
 * @implements { RendererAudioInputStreamFactoryClientInterface }
 */
export class RendererAudioInputStreamFactoryClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RendererAudioInputStreamFactoryClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RendererAudioInputStreamFactoryClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RendererAudioInputStreamFactoryClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_AudioInputStreamRemote } stream
   * @param { !media_mojom_AudioInputStreamClientPendingReceiver } clientRequest
   * @param { !media_mojom_ReadWriteAudioDataPipe } dataPipe
   * @param { !boolean } initiallyMuted
   * @param { ?mojoBase_mojom_UnguessableToken } streamId
   */

  streamCreated(
      stream,
      clientRequest,
      dataPipe,
      initiallyMuted,
      streamId) {
    this.proxy.sendMessage(
        0,
        RendererAudioInputStreamFactoryClient_StreamCreated_ParamsSpec.$,
        null,
        [
          stream,
          clientRequest,
          dataPipe,
          initiallyMuted,
          streamId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RendererAudioInputStreamFactoryClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RendererAudioInputStreamFactoryClientReceiver {
  /**
   * @param {!RendererAudioInputStreamFactoryClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RendererAudioInputStreamFactoryClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RendererAudioInputStreamFactoryClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererAudioInputStreamFactoryClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RendererAudioInputStreamFactoryClient_StreamCreated_ParamsSpec.$,
        null,
        impl.streamCreated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RendererAudioInputStreamFactoryClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RendererAudioInputStreamFactoryClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RendererAudioInputStreamFactoryClientRemote}
   */
  static getRemote() {
    let remote = new RendererAudioInputStreamFactoryClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RendererAudioInputStreamFactoryClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RendererAudioInputStreamFactoryClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RendererAudioInputStreamFactoryClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererAudioInputStreamFactoryClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.streamCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RendererAudioInputStreamFactoryClient_StreamCreated_ParamsSpec.$,
        null,
        this.streamCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererAudioInputStreamFactory_CreateStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererAudioInputStreamFactoryClient_StreamCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    RendererAudioInputStreamFactory_CreateStream_ParamsSpec.$,
    'RendererAudioInputStreamFactory_CreateStream_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(RendererAudioInputStreamFactoryClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'params', 16,
        0,
        media_mojom_AudioParametersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'automaticGainControl', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sharedMemoryCount', 28,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'processingConfig', 32,
        0,
        media_mojom_AudioProcessingConfigSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class RendererAudioInputStreamFactory_CreateStream_Params {
  constructor() {
    /** @type { !RendererAudioInputStreamFactoryClientRemote } */
    this.client;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.sessionId;
    /** @type { !media_mojom_AudioParameters } */
    this.params;
    /** @type { !boolean } */
    this.automaticGainControl;
    /** @type { !number } */
    this.sharedMemoryCount;
    /** @type { (media_mojom_AudioProcessingConfig|undefined) } */
    this.processingConfig;
  }
}



mojo.internal.Struct(
    RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_ParamsSpec.$,
    'RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_Params',
    [
      mojo.internal.StructField(
        'inputStreamId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputDeviceId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.inputStreamId;
    /** @type { !string } */
    this.outputDeviceId;
  }
}



mojo.internal.Struct(
    RendererAudioInputStreamFactoryClient_StreamCreated_ParamsSpec.$,
    'RendererAudioInputStreamFactoryClient_StreamCreated_Params',
    [
      mojo.internal.StructField(
        'stream', 0,
        0,
        mojo.internal.InterfaceProxy(media_mojom_AudioInputStreamRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientRequest', 8,
        0,
        mojo.internal.InterfaceRequest(media_mojom_AudioInputStreamClientPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dataPipe', 16,
        0,
        media_mojom_ReadWriteAudioDataPipeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initiallyMuted', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'streamId', 24,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class RendererAudioInputStreamFactoryClient_StreamCreated_Params {
  constructor() {
    /** @type { !media_mojom_AudioInputStreamRemote } */
    this.stream;
    /** @type { !media_mojom_AudioInputStreamClientPendingReceiver } */
    this.clientRequest;
    /** @type { !media_mojom_ReadWriteAudioDataPipe } */
    this.dataPipe;
    /** @type { !boolean } */
    this.initiallyMuted;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.streamId;
  }
}

