// third_party/blink/public/mojom/media/capture_handle_config.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_CAPTURE_HANDLE_CONFIG_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_CAPTURE_HANDLE_CONFIG_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/media/capture_handle_config.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"




#include "third_party/blink/public/mojom/media/capture_handle_config.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CaptureHandleConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CaptureHandleConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CaptureHandleConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->expose_origin = Traits::expose_origin(input);

    decltype(Traits::capture_handle(input)) in_capture_handle = Traits::capture_handle(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->capture_handle)::BaseType> capture_handle_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_capture_handle,
      capture_handle_fragment);

    fragment->capture_handle.Set(
        capture_handle_fragment.is_null() ? nullptr : capture_handle_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->capture_handle.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null capture_handle in CaptureHandleConfig struct");

    fragment->all_origins_permitted = Traits::all_origins_permitted(input);

    decltype(Traits::permitted_origins(input)) in_permitted_origins = Traits::permitted_origins(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->permitted_origins)::BaseType>
        permitted_origins_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& permitted_origins_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
      in_permitted_origins,
      permitted_origins_fragment,
      &permitted_origins_validate_params);

    fragment->permitted_origins.Set(
        permitted_origins_fragment.is_null() ? nullptr : permitted_origins_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->permitted_origins.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null permitted_origins in CaptureHandleConfig struct");
  }

  static bool Deserialize(::blink::mojom::internal::CaptureHandleConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CaptureHandleConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void CaptureHandleConfigDataView::GetCaptureHandleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->capture_handle.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void CaptureHandleConfigDataView::GetPermittedOriginsDataView(
    mojo::ArrayDataView<::url::mojom::OriginDataView>* output) {
  auto pointer = data_->permitted_origins.Get();
  *output = mojo::ArrayDataView<::url::mojom::OriginDataView>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_CAPTURE_HANDLE_CONFIG_MOJOM_SHARED_H_