// third_party/blink/public/mojom/media/capture_handle_config.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_CAPTURE_HANDLE_CONFIG_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_CAPTURE_HANDLE_CONFIG_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/media/capture_handle_config.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/media/capture_handle_config.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/media/capture_handle_config.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "url/mojom/origin.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class PLATFORM_EXPORT CaptureHandleConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CaptureHandleConfig, T>::value>;
  using DataView = CaptureHandleConfigDataView;
  using Data_ = internal::CaptureHandleConfig_Data;

  template <typename... Args>
  static CaptureHandleConfigPtr New(Args&&... args) {
    return CaptureHandleConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CaptureHandleConfigPtr From(const U& u) {
    return mojo::TypeConverter<CaptureHandleConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CaptureHandleConfig>::Convert(*this);
  }


  CaptureHandleConfig();

  CaptureHandleConfig(
      bool expose_origin,
      const ::blink::String& capture_handle,
      bool all_origins_permitted,
      ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>> permitted_origins);


  ~CaptureHandleConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CaptureHandleConfigPtr>
  CaptureHandleConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CaptureHandleConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CaptureHandleConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CaptureHandleConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CaptureHandleConfig::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CaptureHandleConfig::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CaptureHandleConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CaptureHandleConfig_UnserializedMessageContext<
            UserType, CaptureHandleConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CaptureHandleConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CaptureHandleConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CaptureHandleConfig_UnserializedMessageContext<
            UserType, CaptureHandleConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CaptureHandleConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool expose_origin;
  
  ::blink::String capture_handle;
  
  bool all_origins_permitted;
  
  ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>> permitted_origins;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CaptureHandleConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CaptureHandleConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CaptureHandleConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CaptureHandleConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CaptureHandleConfigPtr CaptureHandleConfig::Clone() const {
  return New(
      mojo::Clone(expose_origin),
      mojo::Clone(capture_handle),
      mojo::Clone(all_origins_permitted),
      mojo::Clone(permitted_origins)
  );
}

template <typename T, CaptureHandleConfig::EnableIfSame<T>*>
bool CaptureHandleConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->expose_origin, other_struct.expose_origin))
    return false;
  if (!mojo::Equals(this->capture_handle, other_struct.capture_handle))
    return false;
  if (!mojo::Equals(this->all_origins_permitted, other_struct.all_origins_permitted))
    return false;
  if (!mojo::Equals(this->permitted_origins, other_struct.permitted_origins))
    return false;
  return true;
}

template <typename T, CaptureHandleConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.expose_origin < rhs.expose_origin)
    return true;
  if (rhs.expose_origin < lhs.expose_origin)
    return false;
  if (lhs.capture_handle < rhs.capture_handle)
    return true;
  if (rhs.capture_handle < lhs.capture_handle)
    return false;
  if (lhs.all_origins_permitted < rhs.all_origins_permitted)
    return true;
  if (rhs.all_origins_permitted < lhs.all_origins_permitted)
    return false;
  if (lhs.permitted_origins < rhs.permitted_origins)
    return true;
  if (rhs.permitted_origins < lhs.permitted_origins)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::CaptureHandleConfig::DataView,
                                         ::blink::mojom::blink::CaptureHandleConfigPtr> {
  static bool IsNull(const ::blink::mojom::blink::CaptureHandleConfigPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CaptureHandleConfigPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::CaptureHandleConfig::expose_origin) expose_origin(
      const ::blink::mojom::blink::CaptureHandleConfigPtr& input) {
    return input->expose_origin;
  }

  static const decltype(::blink::mojom::blink::CaptureHandleConfig::capture_handle)& capture_handle(
      const ::blink::mojom::blink::CaptureHandleConfigPtr& input) {
    return input->capture_handle;
  }

  static decltype(::blink::mojom::blink::CaptureHandleConfig::all_origins_permitted) all_origins_permitted(
      const ::blink::mojom::blink::CaptureHandleConfigPtr& input) {
    return input->all_origins_permitted;
  }

  static const decltype(::blink::mojom::blink::CaptureHandleConfig::permitted_origins)& permitted_origins(
      const ::blink::mojom::blink::CaptureHandleConfigPtr& input) {
    return input->permitted_origins;
  }

  static bool Read(::blink::mojom::blink::CaptureHandleConfig::DataView input, ::blink::mojom::blink::CaptureHandleConfigPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_CAPTURE_HANDLE_CONFIG_MOJOM_BLINK_H_