// third_party/blink/public/mojom/manifest/manifest_manager.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/manifest/manifest_manager.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var manifest$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/manifest/manifest.mojom', 'manifest.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function RequestManifestError(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RequestManifestError.prototype.initDefaults_ = function() {
    this.error = 0;
    this.details = null;
  };
  RequestManifestError.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RequestManifestError.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RequestManifestError.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, manifest$.ManifestRequestResult);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RequestManifestError.details
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(manifest$.ManifestError), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RequestManifestError.encodedSize = codec.kStructHeaderSize + 16;

  RequestManifestError.decode = function(decoder) {
    var packed;
    var val = new RequestManifestError();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(manifest$.ManifestRequestResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.details =
        decoder.decodeArrayPointer(new codec.PointerTo(manifest$.ManifestError));
    return val;
  };

  RequestManifestError.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RequestManifestError.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(manifest$.ManifestError), val.details);
  };
  function ManifestManager_RequestManifest_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestManager_RequestManifest_Params.prototype.initDefaults_ = function() {
  };
  ManifestManager_RequestManifest_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestManager_RequestManifest_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestManager_RequestManifest_Params.encodedSize = codec.kStructHeaderSize + 0;

  ManifestManager_RequestManifest_Params.decode = function(decoder) {
    var packed;
    var val = new ManifestManager_RequestManifest_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ManifestManager_RequestManifest_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestManager_RequestManifest_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ManifestManager_RequestManifest_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestManager_RequestManifest_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.url = null;
    this.manifest = null;
  };
  ManifestManager_RequestManifest_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestManager_RequestManifest_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestManager_RequestManifest_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, manifest$.ManifestRequestResult);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestManager_RequestManifest_ResponseParams.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestManager_RequestManifest_ResponseParams.manifest
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, manifest$.Manifest, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestManager_RequestManifest_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  ManifestManager_RequestManifest_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ManifestManager_RequestManifest_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(manifest$.ManifestRequestResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.manifest =
        decoder.decodeStructPointer(manifest$.Manifest);
    return val;
  };

  ManifestManager_RequestManifest_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestManager_RequestManifest_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(manifest$.Manifest, val.manifest);
  };
  function ManifestManager_RequestManifestAndErrors_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestManager_RequestManifestAndErrors_Params.prototype.initDefaults_ = function() {
  };
  ManifestManager_RequestManifestAndErrors_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestManager_RequestManifestAndErrors_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestManager_RequestManifestAndErrors_Params.encodedSize = codec.kStructHeaderSize + 0;

  ManifestManager_RequestManifestAndErrors_Params.decode = function(decoder) {
    var packed;
    var val = new ManifestManager_RequestManifestAndErrors_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ManifestManager_RequestManifestAndErrors_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestManager_RequestManifestAndErrors_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ManifestManager_RequestManifestAndErrors_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestManager_RequestManifestAndErrors_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  ManifestManager_RequestManifestAndErrors_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestManager_RequestManifestAndErrors_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestManager_RequestManifestAndErrors_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, ManifestManager_RequestManifestAndErrors_ResponseParam_Result, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestManager_RequestManifestAndErrors_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  ManifestManager_RequestManifestAndErrors_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ManifestManager_RequestManifestAndErrors_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(ManifestManager_RequestManifestAndErrors_ResponseParam_Result);
    return val;
  };

  ManifestManager_RequestManifestAndErrors_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestManager_RequestManifestAndErrors_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(ManifestManager_RequestManifestAndErrors_ResponseParam_Result, val.result);
  };
  function ManifestManager_RequestManifestDebugInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestManager_RequestManifestDebugInfo_Params.prototype.initDefaults_ = function() {
  };
  ManifestManager_RequestManifestDebugInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestManager_RequestManifestDebugInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestManager_RequestManifestDebugInfo_Params.encodedSize = codec.kStructHeaderSize + 0;

  ManifestManager_RequestManifestDebugInfo_Params.decode = function(decoder) {
    var packed;
    var val = new ManifestManager_RequestManifestDebugInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ManifestManager_RequestManifestDebugInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestManager_RequestManifestDebugInfo_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ManifestManager_RequestManifestDebugInfo_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestManager_RequestManifestDebugInfo_ResponseParams.prototype.initDefaults_ = function() {
    this.url = null;
    this.parsedManifest = null;
    this.debugInfo = null;
  };
  ManifestManager_RequestManifestDebugInfo_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestManager_RequestManifestDebugInfo_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestManager_RequestManifestDebugInfo_ResponseParams.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestManager_RequestManifestDebugInfo_ResponseParams.parsedManifest
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, manifest$.Manifest, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestManager_RequestManifestDebugInfo_ResponseParams.debugInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, manifest$.ManifestDebugInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestManager_RequestManifestDebugInfo_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  ManifestManager_RequestManifestDebugInfo_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ManifestManager_RequestManifestDebugInfo_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.parsedManifest =
        decoder.decodeStructPointer(manifest$.Manifest);
    val.debugInfo =
        decoder.decodeStructPointer(manifest$.ManifestDebugInfo);
    return val;
  };

  ManifestManager_RequestManifestDebugInfo_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestManager_RequestManifestDebugInfo_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(manifest$.Manifest, val.parsedManifest);
    encoder.encodeStructPointer(manifest$.ManifestDebugInfo, val.debugInfo);
  };
  function ManifestManager_ParseManifestFromString_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestManager_ParseManifestFromString_Params.prototype.initDefaults_ = function() {
    this.documentUrl = null;
    this.manifestUrl = null;
    this.manifestContent = null;
  };
  ManifestManager_ParseManifestFromString_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestManager_ParseManifestFromString_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestManager_ParseManifestFromString_Params.documentUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestManager_ParseManifestFromString_Params.manifestUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestManager_ParseManifestFromString_Params.manifestContent
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestManager_ParseManifestFromString_Params.encodedSize = codec.kStructHeaderSize + 24;

  ManifestManager_ParseManifestFromString_Params.decode = function(decoder) {
    var packed;
    var val = new ManifestManager_ParseManifestFromString_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.documentUrl =
        decoder.decodeStructPointer(url$.Url);
    val.manifestUrl =
        decoder.decodeStructPointer(url$.Url);
    val.manifestContent =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ManifestManager_ParseManifestFromString_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestManager_ParseManifestFromString_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.documentUrl);
    encoder.encodeStructPointer(url$.Url, val.manifestUrl);
    encoder.encodeStruct(codec.String, val.manifestContent);
  };
  function ManifestManager_ParseManifestFromString_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestManager_ParseManifestFromString_ResponseParams.prototype.initDefaults_ = function() {
    this.parsedManifest = null;
  };
  ManifestManager_ParseManifestFromString_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestManager_ParseManifestFromString_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestManager_ParseManifestFromString_ResponseParams.parsedManifest
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, manifest$.Manifest, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestManager_ParseManifestFromString_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ManifestManager_ParseManifestFromString_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ManifestManager_ParseManifestFromString_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.parsedManifest =
        decoder.decodeStructPointer(manifest$.Manifest);
    return val;
  };

  ManifestManager_ParseManifestFromString_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestManager_ParseManifestFromString_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(manifest$.Manifest, val.parsedManifest);
  };

  function ManifestManager_RequestManifestAndErrors_ResponseParam_Result(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  ManifestManager_RequestManifestAndErrors_ResponseParam_Result.Tags = {
    success: 0,
    failure: 1,
  };

  ManifestManager_RequestManifestAndErrors_ResponseParam_Result.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  ManifestManager_RequestManifestAndErrors_ResponseParam_Result.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "success",
        "failure",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a ManifestManager_RequestManifestAndErrors_ResponseParam_Result member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(ManifestManager_RequestManifestAndErrors_ResponseParam_Result.prototype, "success", {
    get: function() {
      if (this.$tag != ManifestManager_RequestManifestAndErrors_ResponseParam_Result.Tags.success) {
        throw new ReferenceError(
            "ManifestManager_RequestManifestAndErrors_ResponseParam_Result.success is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ManifestManager_RequestManifestAndErrors_ResponseParam_Result.Tags.success;
      this.$data = value;
    }
  });
  Object.defineProperty(ManifestManager_RequestManifestAndErrors_ResponseParam_Result.prototype, "failure", {
    get: function() {
      if (this.$tag != ManifestManager_RequestManifestAndErrors_ResponseParam_Result.Tags.failure) {
        throw new ReferenceError(
            "ManifestManager_RequestManifestAndErrors_ResponseParam_Result.failure is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ManifestManager_RequestManifestAndErrors_ResponseParam_Result.Tags.failure;
      this.$data = value;
    }
  });


    ManifestManager_RequestManifestAndErrors_ResponseParam_Result.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case ManifestManager_RequestManifestAndErrors_ResponseParam_Result.Tags.success:
          encoder.encodeStructPointer(manifest$.Manifest, val.success);
          break;
        case ManifestManager_RequestManifestAndErrors_ResponseParam_Result.Tags.failure:
          encoder.encodeStructPointer(RequestManifestError, val.failure);
          break;
      }
      encoder.align();
    };


    ManifestManager_RequestManifestAndErrors_ResponseParam_Result.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new ManifestManager_RequestManifestAndErrors_ResponseParam_Result();
      var tag = decoder.readUint32();
      switch (tag) {
        case ManifestManager_RequestManifestAndErrors_ResponseParam_Result.Tags.success:
          result.success = decoder.decodeStructPointer(manifest$.Manifest);
          break;
        case ManifestManager_RequestManifestAndErrors_ResponseParam_Result.Tags.failure:
          result.failure = decoder.decodeStructPointer(RequestManifestError);
          break;
      }
      decoder.align();

      return result;
    };


    ManifestManager_RequestManifestAndErrors_ResponseParam_Result.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case ManifestManager_RequestManifestAndErrors_ResponseParam_Result.Tags.success:
          

    // validate ManifestManager_RequestManifestAndErrors_ResponseParam_Result.success
    err = messageValidator.validateStructPointer(data_offset, manifest$.Manifest, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ManifestManager_RequestManifestAndErrors_ResponseParam_Result.Tags.failure:
          

    // validate ManifestManager_RequestManifestAndErrors_ResponseParam_Result.failure
    err = messageValidator.validateStructPointer(data_offset, RequestManifestError, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  ManifestManager_RequestManifestAndErrors_ResponseParam_Result.encodedSize = 16;
  var kManifestManager_RequestManifest_Name = 0;
  var kManifestManager_RequestManifestAndErrors_Name = 1;
  var kManifestManager_RequestManifestDebugInfo_Name = 2;
  var kManifestManager_ParseManifestFromString_Name = 3;

  function ManifestManagerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ManifestManager,
                                                   handleOrPtrInfo);
  }

  function ManifestManagerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ManifestManager, associatedInterfacePtrInfo);
  }

  ManifestManagerAssociatedPtr.prototype =
      Object.create(ManifestManagerPtr.prototype);
  ManifestManagerAssociatedPtr.prototype.constructor =
      ManifestManagerAssociatedPtr;

  function ManifestManagerProxy(receiver) {
    this.receiver_ = receiver;
  }
  ManifestManagerPtr.prototype.requestManifest = function() {
    return ManifestManagerProxy.prototype.requestManifest
        .apply(this.ptr.getProxy(), arguments);
  };

  ManifestManagerProxy.prototype.requestManifest = function() {
    var params_ = new ManifestManager_RequestManifest_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kManifestManager_RequestManifest_Name,
          codec.align(ManifestManager_RequestManifest_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ManifestManager_RequestManifest_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ManifestManager_RequestManifest_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ManifestManagerPtr.prototype.requestManifestAndErrors = function() {
    return ManifestManagerProxy.prototype.requestManifestAndErrors
        .apply(this.ptr.getProxy(), arguments);
  };

  ManifestManagerProxy.prototype.requestManifestAndErrors = function() {
    var params_ = new ManifestManager_RequestManifestAndErrors_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kManifestManager_RequestManifestAndErrors_Name,
          codec.align(ManifestManager_RequestManifestAndErrors_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ManifestManager_RequestManifestAndErrors_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ManifestManager_RequestManifestAndErrors_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ManifestManagerPtr.prototype.requestManifestDebugInfo = function() {
    return ManifestManagerProxy.prototype.requestManifestDebugInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  ManifestManagerProxy.prototype.requestManifestDebugInfo = function() {
    var params_ = new ManifestManager_RequestManifestDebugInfo_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kManifestManager_RequestManifestDebugInfo_Name,
          codec.align(ManifestManager_RequestManifestDebugInfo_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ManifestManager_RequestManifestDebugInfo_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ManifestManager_RequestManifestDebugInfo_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ManifestManagerPtr.prototype.parseManifestFromString = function() {
    return ManifestManagerProxy.prototype.parseManifestFromString
        .apply(this.ptr.getProxy(), arguments);
  };

  ManifestManagerProxy.prototype.parseManifestFromString = function(documentUrl, manifestUrl, manifestContent) {
    var params_ = new ManifestManager_ParseManifestFromString_Params();
    params_.documentUrl = documentUrl;
    params_.manifestUrl = manifestUrl;
    params_.manifestContent = manifestContent;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kManifestManager_ParseManifestFromString_Name,
          codec.align(ManifestManager_ParseManifestFromString_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ManifestManager_ParseManifestFromString_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ManifestManager_ParseManifestFromString_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function ManifestManagerStub(delegate) {
    this.delegate_ = delegate;
  }
  ManifestManagerStub.prototype.requestManifest = function() {
    return this.delegate_ && this.delegate_.requestManifest && this.delegate_.requestManifest();
  }
  ManifestManagerStub.prototype.requestManifestAndErrors = function() {
    return this.delegate_ && this.delegate_.requestManifestAndErrors && this.delegate_.requestManifestAndErrors();
  }
  ManifestManagerStub.prototype.requestManifestDebugInfo = function() {
    return this.delegate_ && this.delegate_.requestManifestDebugInfo && this.delegate_.requestManifestDebugInfo();
  }
  ManifestManagerStub.prototype.parseManifestFromString = function(documentUrl, manifestUrl, manifestContent) {
    return this.delegate_ && this.delegate_.parseManifestFromString && this.delegate_.parseManifestFromString(documentUrl, manifestUrl, manifestContent);
  }

  ManifestManagerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  ManifestManagerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kManifestManager_RequestManifest_Name:
      var params = reader.decodeStruct(ManifestManager_RequestManifest_Params);
      this.requestManifest().then(function(response) {
        var responseParams =
            new ManifestManager_RequestManifest_ResponseParams();
        responseParams.result = response.result;
        responseParams.url = response.url;
        responseParams.manifest = response.manifest;
        var builder = new codec.MessageV1Builder(
            kManifestManager_RequestManifest_Name,
            codec.align(ManifestManager_RequestManifest_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ManifestManager_RequestManifest_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kManifestManager_RequestManifestAndErrors_Name:
      var params = reader.decodeStruct(ManifestManager_RequestManifestAndErrors_Params);
      this.requestManifestAndErrors().then(function(response) {
        var responseParams =
            new ManifestManager_RequestManifestAndErrors_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kManifestManager_RequestManifestAndErrors_Name,
            codec.align(ManifestManager_RequestManifestAndErrors_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ManifestManager_RequestManifestAndErrors_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kManifestManager_RequestManifestDebugInfo_Name:
      var params = reader.decodeStruct(ManifestManager_RequestManifestDebugInfo_Params);
      this.requestManifestDebugInfo().then(function(response) {
        var responseParams =
            new ManifestManager_RequestManifestDebugInfo_ResponseParams();
        responseParams.url = response.url;
        responseParams.parsedManifest = response.parsedManifest;
        responseParams.debugInfo = response.debugInfo;
        var builder = new codec.MessageV1Builder(
            kManifestManager_RequestManifestDebugInfo_Name,
            codec.align(ManifestManager_RequestManifestDebugInfo_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ManifestManager_RequestManifestDebugInfo_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kManifestManager_ParseManifestFromString_Name:
      var params = reader.decodeStruct(ManifestManager_ParseManifestFromString_Params);
      this.parseManifestFromString(params.documentUrl, params.manifestUrl, params.manifestContent).then(function(response) {
        var responseParams =
            new ManifestManager_ParseManifestFromString_ResponseParams();
        responseParams.parsedManifest = response.parsedManifest;
        var builder = new codec.MessageV1Builder(
            kManifestManager_ParseManifestFromString_Name,
            codec.align(ManifestManager_ParseManifestFromString_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ManifestManager_ParseManifestFromString_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateManifestManagerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kManifestManager_RequestManifest_Name:
        if (message.expectsResponse())
          paramsClass = ManifestManager_RequestManifest_Params;
      break;
      case kManifestManager_RequestManifestAndErrors_Name:
        if (message.expectsResponse())
          paramsClass = ManifestManager_RequestManifestAndErrors_Params;
      break;
      case kManifestManager_RequestManifestDebugInfo_Name:
        if (message.expectsResponse())
          paramsClass = ManifestManager_RequestManifestDebugInfo_Params;
      break;
      case kManifestManager_ParseManifestFromString_Name:
        if (message.expectsResponse())
          paramsClass = ManifestManager_ParseManifestFromString_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateManifestManagerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kManifestManager_RequestManifest_Name:
        if (message.isResponse())
          paramsClass = ManifestManager_RequestManifest_ResponseParams;
        break;
      case kManifestManager_RequestManifestAndErrors_Name:
        if (message.isResponse())
          paramsClass = ManifestManager_RequestManifestAndErrors_ResponseParams;
        break;
      case kManifestManager_RequestManifestDebugInfo_Name:
        if (message.isResponse())
          paramsClass = ManifestManager_RequestManifestDebugInfo_ResponseParams;
        break;
      case kManifestManager_ParseManifestFromString_Name:
        if (message.isResponse())
          paramsClass = ManifestManager_ParseManifestFromString_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var ManifestManager = {
    name: 'blink.mojom.ManifestManager',
    kVersion: 0,
    ptrClass: ManifestManagerPtr,
    proxyClass: ManifestManagerProxy,
    stubClass: ManifestManagerStub,
    validateRequest: validateManifestManagerRequest,
    validateResponse: validateManifestManagerResponse,
  };
  ManifestManagerStub.prototype.validator = validateManifestManagerRequest;
  ManifestManagerProxy.prototype.validator = validateManifestManagerResponse;
  exports.RequestManifestError = RequestManifestError;
  exports.ManifestManager_RequestManifestAndErrors_ResponseParam_Result = ManifestManager_RequestManifestAndErrors_ResponseParam_Result;
  exports.ManifestManager = ManifestManager;
  exports.ManifestManagerPtr = ManifestManagerPtr;
  exports.ManifestManagerAssociatedPtr = ManifestManagerAssociatedPtr;
})();