// third_party/blink/public/mojom/manifest/manifest_manager.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MANAGER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MANAGER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/manifest/manifest.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/types/expected.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class ManifestManagerProxy;

template <typename ImplRefTraits>
class ManifestManagerStub;

class ManifestManagerRequestValidator;
class ManifestManagerResponseValidator;


class PLATFORM_EXPORT ManifestManager
    : public ManifestManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ManifestManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ManifestManagerInterfaceBase;
  using Proxy_ = ManifestManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ManifestManagerStub<ImplRefTraits>;

  using RequestValidator_ = ManifestManagerRequestValidator;
  using ResponseValidator_ = ManifestManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestManifestMinVersion = 0,
    kRequestManifestAndErrorsMinVersion = 0,
    kRequestManifestDebugInfoMinVersion = 0,
    kParseManifestFromStringMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestManifest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestManifestAndErrors_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestManifestDebugInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ParseManifestFromString_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ManifestManager() = default;

  using RequestManifestCallback = base::OnceCallback<void(::blink::mojom::blink::ManifestRequestResult, const ::blink::KURL&, ::blink::mojom::blink::ManifestPtr)>;
  using RequestManifestMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ManifestRequestResult, const ::blink::KURL&, ::blink::mojom::blink::ManifestPtr)>;

  virtual void RequestManifest(RequestManifestCallback callback) = 0;

  using RequestManifestAndErrorsCallback = base::OnceCallback<void(base::expected<
  ::blink::mojom::blink::ManifestPtr,
  RequestManifestErrorPtr>)>;
  using RequestManifestAndErrorsResult = base::expected<
  ::blink::mojom::blink::ManifestPtr,
  RequestManifestErrorPtr>;
  using RequestManifestAndErrorsMojoCallback = base::OnceCallback<void(ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr)>;

  virtual void RequestManifestAndErrors(RequestManifestAndErrorsCallback callback) = 0;

  using RequestManifestDebugInfoCallback = base::OnceCallback<void(const ::blink::KURL&, ::blink::mojom::blink::ManifestPtr, ::blink::mojom::blink::ManifestDebugInfoPtr)>;
  using RequestManifestDebugInfoMojoCallback = base::OnceCallback<void(const ::blink::KURL&, ::blink::mojom::blink::ManifestPtr, ::blink::mojom::blink::ManifestDebugInfoPtr)>;

  virtual void RequestManifestDebugInfo(RequestManifestDebugInfoCallback callback) = 0;

  using ParseManifestFromStringCallback = base::OnceCallback<void(::blink::mojom::blink::ManifestPtr)>;
  using ParseManifestFromStringMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ManifestPtr)>;

  virtual void ParseManifestFromString(const ::blink::KURL& document_url, const ::blink::KURL& manifest_url, const ::blink::String& manifest_content, ParseManifestFromStringCallback callback) = 0;
};



class PLATFORM_EXPORT ManifestManagerProxy
    : public ManifestManager {
 public:
  using InterfaceType = ManifestManager;

  explicit ManifestManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestManifest(RequestManifestCallback callback) final;
  
  void RequestManifestAndErrors(RequestManifestAndErrorsCallback callback) final;
  
  void RequestManifestDebugInfo(RequestManifestDebugInfoCallback callback) final;
  
  void ParseManifestFromString(const ::blink::KURL& document_url, const ::blink::KURL& manifest_url, const ::blink::String& manifest_content, ParseManifestFromStringCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT ManifestManagerStubDispatch {
 public:
  static bool Accept(ManifestManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ManifestManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ManifestManager>>
class ManifestManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ManifestManagerStub() = default;
  ~ManifestManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ManifestManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ManifestManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT ManifestManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT ManifestManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class PLATFORM_EXPORT ManifestManager_RequestManifestAndErrors_ResponseParam_Result {
 public:
  using DataView = ManifestManager_RequestManifestAndErrors_ResponseParam_ResultDataView;
  using Data_ = internal::ManifestManager_RequestManifestAndErrors_ResponseParam_Result_Data;
  using Tag = Data_::ManifestManager_RequestManifestAndErrors_ResponseParam_Result_Tag;

  template <typename... Args>
  static ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr NewSuccess(
      ::blink::mojom::blink::ManifestPtr value);
  // Construct an instance holding |failure|.
  static ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr NewFailure(
      RequestManifestErrorPtr value);

  template <typename U>
  static ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestManager_RequestManifestAndErrors_ResponseParam_Result>::Convert(*this);
  }
  ~ManifestManager_RequestManifestAndErrors_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ManifestManager_RequestManifestAndErrors_ResponseParam_Result(const ManifestManager_RequestManifestAndErrors_ResponseParam_Result& other) = delete;
  ManifestManager_RequestManifestAndErrors_ResponseParam_Result& operator=(const ManifestManager_RequestManifestAndErrors_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr>
  ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ManifestManager_RequestManifestAndErrors_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ManifestManager_RequestManifestAndErrors_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::blink::mojom::blink::ManifestPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::blink::mojom::blink::ManifestPtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(::blink::mojom::blink::ManifestPtr success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  const RequestManifestErrorPtr& get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  RequestManifestErrorPtr& get_failure() {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(RequestManifestErrorPtr failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestManager_RequestManifestAndErrors_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ManifestManager_RequestManifestAndErrors_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        ::blink::mojom::blink::ManifestPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        RequestManifestErrorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::mojom::blink::ManifestPtr success;
    RequestManifestErrorPtr failure;
  };

  ManifestManager_RequestManifestAndErrors_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      ::blink::mojom::blink::ManifestPtr value);
  ManifestManager_RequestManifestAndErrors_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      RequestManifestErrorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class PLATFORM_EXPORT RequestManifestError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RequestManifestError, T>::value>;
  using DataView = RequestManifestErrorDataView;
  using Data_ = internal::RequestManifestError_Data;

  template <typename... Args>
  static RequestManifestErrorPtr New(Args&&... args) {
    return RequestManifestErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RequestManifestErrorPtr From(const U& u) {
    return mojo::TypeConverter<RequestManifestErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequestManifestError>::Convert(*this);
  }


  RequestManifestError();

  RequestManifestError(
      ::blink::mojom::blink::ManifestRequestResult error,
      ::blink::Vector<::blink::mojom::blink::ManifestErrorPtr> details);

RequestManifestError(const RequestManifestError&) = delete;
RequestManifestError& operator=(const RequestManifestError&) = delete;

  ~RequestManifestError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RequestManifestErrorPtr>
  RequestManifestErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RequestManifestError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RequestManifestError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RequestManifestError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestManifestError::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestManifestError::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequestManifestError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RequestManifestError_UnserializedMessageContext<
            UserType, RequestManifestError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RequestManifestError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RequestManifestError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RequestManifestError_UnserializedMessageContext<
            UserType, RequestManifestError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RequestManifestError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::blink::ManifestRequestResult error;
  
  ::blink::Vector<::blink::mojom::blink::ManifestErrorPtr> details;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RequestManifestError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RequestManifestError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RequestManifestError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RequestManifestError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr ManifestManager_RequestManifestAndErrors_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ManifestManager_RequestManifestAndErrors_ResponseParam_Result>::value>::type*>
bool ManifestManager_RequestManifestAndErrors_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename StructPtrType>
RequestManifestErrorPtr RequestManifestError::Clone() const {
  return New(
      mojo::Clone(error),
      mojo::Clone(details)
  );
}

template <typename T, RequestManifestError::EnableIfSame<T>*>
bool RequestManifestError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->error, other_struct.error))
    return false;
  if (!mojo::Equals(this->details, other_struct.details))
    return false;
  return true;
}

template <typename T, RequestManifestError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.error < rhs.error)
    return true;
  if (rhs.error < lhs.error)
    return false;
  if (lhs.details < rhs.details)
    return true;
  if (rhs.details < lhs.details)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::RequestManifestError::DataView,
                                         ::blink::mojom::blink::RequestManifestErrorPtr> {
  static bool IsNull(const ::blink::mojom::blink::RequestManifestErrorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::RequestManifestErrorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::RequestManifestError::error) error(
      const ::blink::mojom::blink::RequestManifestErrorPtr& input) {
    return input->error;
  }

  static const decltype(::blink::mojom::blink::RequestManifestError::details)& details(
      const ::blink::mojom::blink::RequestManifestErrorPtr& input) {
    return input->details;
  }

  static bool Read(::blink::mojom::blink::RequestManifestError::DataView input, ::blink::mojom::blink::RequestManifestErrorPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_Result::DataView,
                                        ::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_Result::Tag GetTag(const ::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::blink::ManifestPtr& success(const ::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static const ::blink::mojom::blink::RequestManifestErrorPtr& failure(const ::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_Result::DataView input, ::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MANAGER_MOJOM_BLINK_H_