// third_party/blink/public/mojom/manifest/manifest_launch_handler.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/manifest/manifest_launch_handler.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function ManifestLaunchHandler(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  ManifestLaunchHandler.ClientMode = {};
  ManifestLaunchHandler.ClientMode.kAuto = 0;
  ManifestLaunchHandler.ClientMode.kNavigateNew = 1;
  ManifestLaunchHandler.ClientMode.kNavigateExisting = 2;
  ManifestLaunchHandler.ClientMode.kFocusExisting = 3;
  ManifestLaunchHandler.ClientMode.MIN_VALUE = 0;
  ManifestLaunchHandler.ClientMode.MAX_VALUE = 3;

  ManifestLaunchHandler.ClientMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  ManifestLaunchHandler.ClientMode.toKnownEnumValue = function(value) {
    return value;
  };

  ManifestLaunchHandler.ClientMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  ManifestLaunchHandler.prototype.initDefaults_ = function() {
    this.client_mode_$flag = false;
    this.client_mode_$value = 0;
  };
  ManifestLaunchHandler.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestLaunchHandler.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ManifestLaunchHandler.client_mode_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, ManifestLaunchHandler.ClientMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestLaunchHandler.encodedSize = codec.kStructHeaderSize + 8;

  ManifestLaunchHandler.decode = function(decoder) {
    var packed;
    var val = new ManifestLaunchHandler();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.client_mode_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.client_mode_$value =
        decoder.decodeStruct(new codec.Enum(ManifestLaunchHandler.ClientMode));
    return val;
  };

  ManifestLaunchHandler.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestLaunchHandler.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.client_mode_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.client_mode_$value);
  };
  exports.ManifestLaunchHandler = ManifestLaunchHandler;
})();