// third_party/blink/public/mojom/manifest/manifest_launch_handler.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_LAUNCH_HANDLER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_LAUNCH_HANDLER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/manifest/manifest_launch_handler.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/manifest/manifest_launch_handler.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/manifest/manifest_launch_handler.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"
#include "third_party/blink/public/common/manifest/manifest.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {





class BLINK_COMMON_EXPORT ManifestLaunchHandler {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestLaunchHandler, T>::value>;
  using DataView = ManifestLaunchHandlerDataView;
  using Data_ = internal::ManifestLaunchHandler_Data;
  using ClientMode = ManifestLaunchHandler_ClientMode;

  template <typename... Args>
  static ManifestLaunchHandlerPtr New(Args&&... args) {
    return ManifestLaunchHandlerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestLaunchHandlerPtr From(const U& u) {
    return mojo::TypeConverter<ManifestLaunchHandlerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestLaunchHandler>::Convert(*this);
  }


  ManifestLaunchHandler();

  explicit ManifestLaunchHandler(
      std::optional<ManifestLaunchHandler::ClientMode> client_mode);


  ~ManifestLaunchHandler();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestLaunchHandlerPtr>
  ManifestLaunchHandlerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestLaunchHandler::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestLaunchHandler::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestLaunchHandler::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestLaunchHandler::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestLaunchHandler::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestLaunchHandler::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestLaunchHandler_UnserializedMessageContext<
            UserType, ManifestLaunchHandler::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestLaunchHandler::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestLaunchHandler::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestLaunchHandler_UnserializedMessageContext<
            UserType, ManifestLaunchHandler::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestLaunchHandler::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<ManifestLaunchHandler::ClientMode> client_mode;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestLaunchHandler::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestLaunchHandler::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestLaunchHandler::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestLaunchHandler::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
ManifestLaunchHandlerPtr ManifestLaunchHandler::Clone() const {
  return New(
      mojo::Clone(client_mode)
  );
}

template <typename T, ManifestLaunchHandler::EnableIfSame<T>*>
bool ManifestLaunchHandler::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->client_mode, other_struct.client_mode))
    return false;
  return true;
}

template <typename T, ManifestLaunchHandler::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.client_mode < rhs.client_mode)
    return true;
  if (rhs.client_mode < lhs.client_mode)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestLaunchHandler::DataView,
                                         ::blink::mojom::ManifestLaunchHandlerPtr> {
  static bool IsNull(const ::blink::mojom::ManifestLaunchHandlerPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestLaunchHandlerPtr* output) { output->reset(); }

  static decltype(::blink::mojom::ManifestLaunchHandler::client_mode) client_mode(
      const ::blink::mojom::ManifestLaunchHandlerPtr& input) {
    return input->client_mode;
  }

  static bool Read(::blink::mojom::ManifestLaunchHandler::DataView input, ::blink::mojom::ManifestLaunchHandlerPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_LAUNCH_HANDLER_MOJOM_H_