// third_party/blink/public/mojom/manifest/manifest.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/device/public/mojom/screen_orientation_lock_types.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/display_mode.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/manifest_launch_handler.mojom-shared.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/safe_url_pattern.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"




#include "third_party/blink/public/mojom/manifest/manifest.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::TabStripMemberVisibility>
    : public mojo::internal::EnumHashImpl<::blink::mojom::TabStripMemberVisibility> {};

template <>
struct hash<::blink::mojom::ManifestRequestResult>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ManifestRequestResult> {};

template <>
struct hash<::blink::mojom::Manifest_TextDirection>
    : public mojo::internal::EnumHashImpl<::blink::mojom::Manifest_TextDirection> {};

template <>
struct hash<::blink::mojom::ManifestImageResource_Purpose>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ManifestImageResource_Purpose> {};

template <>
struct hash<::blink::mojom::ManifestScreenshot_FormFactor>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ManifestScreenshot_FormFactor> {};

template <>
struct hash<::blink::mojom::ManifestShareTarget_Method>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ManifestShareTarget_Method> {};

template <>
struct hash<::blink::mojom::ManifestShareTarget_Enctype>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ManifestShareTarget_Enctype> {};

template <>
struct hash<::blink::mojom::ManifestFileHandler_LaunchType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ManifestFileHandler_LaunchType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TabStripMemberVisibility, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::TabStripMemberVisibility, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::TabStripMemberVisibility>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestRequestResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ManifestRequestResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ManifestRequestResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::Manifest_TextDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::Manifest_TextDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Manifest_TextDirection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestImageResource_Purpose, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ManifestImageResource_Purpose, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ManifestImageResource_Purpose>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestScreenshot_FormFactor, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ManifestScreenshot_FormFactor, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ManifestScreenshot_FormFactor>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestShareTarget_Method, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ManifestShareTarget_Method, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ManifestShareTarget_Method>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestShareTarget_Enctype, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ManifestShareTarget_Enctype, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ManifestShareTarget_Enctype>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestFileHandler_LaunchType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ManifestFileHandler_LaunchType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ManifestFileHandler_LaunchType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::Manifest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::manifest_url(input)) in_manifest_url = Traits::manifest_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->manifest_url)::BaseType> manifest_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_manifest_url,
      manifest_url_fragment);

    fragment->manifest_url.Set(
        manifest_url_fragment.is_null() ? nullptr : manifest_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->manifest_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null manifest_url in Manifest struct");

    
    mojo::internal::Serialize<::blink::mojom::Manifest_TextDirection>(
      Traits::dir(input),
      &fragment->dir);

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    decltype(Traits::short_name(input)) in_short_name = Traits::short_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->short_name)::BaseType> short_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_short_name,
      short_name_fragment);

    fragment->short_name.Set(
        short_name_fragment.is_null() ? nullptr : short_name_fragment.data());

    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_description,
      description_fragment);

    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in Manifest struct");

    fragment->has_custom_id = Traits::has_custom_id(input);

    decltype(Traits::start_url(input)) in_start_url = Traits::start_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start_url)::BaseType> start_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_start_url,
      start_url_fragment);

    fragment->start_url.Set(
        start_url_fragment.is_null() ? nullptr : start_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->start_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null start_url in Manifest struct");

    fragment->has_valid_specified_start_url = Traits::has_valid_specified_start_url(input);

    
    mojo::internal::Serialize<::blink::mojom::DisplayMode>(
      Traits::display(input),
      &fragment->display);

    decltype(Traits::display_override(input)) in_display_override = Traits::display_override(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_override)::BaseType>
        display_override_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& display_override_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::DisplayMode_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::DisplayMode>>(
      in_display_override,
      display_override_fragment,
      &display_override_validate_params);

    fragment->display_override.Set(
        display_override_fragment.is_null() ? nullptr : display_override_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_override.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_override in Manifest struct");

    decltype(Traits::borderless_url_patterns(input)) in_borderless_url_patterns = Traits::borderless_url_patterns(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->borderless_url_patterns)::BaseType>
        borderless_url_patterns_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& borderless_url_patterns_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternDataView>>(
      in_borderless_url_patterns,
      borderless_url_patterns_fragment,
      &borderless_url_patterns_validate_params);

    fragment->borderless_url_patterns.Set(
        borderless_url_patterns_fragment.is_null() ? nullptr : borderless_url_patterns_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->borderless_url_patterns.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null borderless_url_patterns in Manifest struct");

    
    mojo::internal::Serialize<::device::mojom::ScreenOrientationLockType>(
      Traits::orientation(input),
      &fragment->orientation);

    decltype(Traits::icons(input)) in_icons = Traits::icons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons)::BaseType>
        icons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
      in_icons,
      icons_fragment,
      &icons_validate_params);

    fragment->icons.Set(
        icons_fragment.is_null() ? nullptr : icons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icons in Manifest struct");

    decltype(Traits::screenshots(input)) in_screenshots = Traits::screenshots(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->screenshots)::BaseType>
        screenshots_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& screenshots_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestScreenshotDataView>>(
      in_screenshots,
      screenshots_fragment,
      &screenshots_validate_params);

    fragment->screenshots.Set(
        screenshots_fragment.is_null() ? nullptr : screenshots_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->screenshots.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null screenshots in Manifest struct");

    decltype(Traits::shortcuts(input)) in_shortcuts = Traits::shortcuts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shortcuts)::BaseType>
        shortcuts_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& shortcuts_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestShortcutItemDataView>>(
      in_shortcuts,
      shortcuts_fragment,
      &shortcuts_validate_params);

    fragment->shortcuts.Set(
        shortcuts_fragment.is_null() ? nullptr : shortcuts_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->shortcuts.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shortcuts in Manifest struct");

    decltype(Traits::share_target(input)) in_share_target = Traits::share_target(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->share_target)::BaseType> share_target_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ManifestShareTargetDataView>(
      in_share_target,
      share_target_fragment);

    fragment->share_target.Set(
        share_target_fragment.is_null() ? nullptr : share_target_fragment.data());

    decltype(Traits::file_handlers(input)) in_file_handlers = Traits::file_handlers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_handlers)::BaseType>
        file_handlers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& file_handlers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestFileHandlerDataView>>(
      in_file_handlers,
      file_handlers_fragment,
      &file_handlers_validate_params);

    fragment->file_handlers.Set(
        file_handlers_fragment.is_null() ? nullptr : file_handlers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->file_handlers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file_handlers in Manifest struct");

    decltype(Traits::protocol_handlers(input)) in_protocol_handlers = Traits::protocol_handlers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->protocol_handlers)::BaseType>
        protocol_handlers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& protocol_handlers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestProtocolHandlerDataView>>(
      in_protocol_handlers,
      protocol_handlers_fragment,
      &protocol_handlers_validate_params);

    fragment->protocol_handlers.Set(
        protocol_handlers_fragment.is_null() ? nullptr : protocol_handlers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->protocol_handlers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null protocol_handlers in Manifest struct");

    decltype(Traits::scope_extensions(input)) in_scope_extensions = Traits::scope_extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scope_extensions)::BaseType>
        scope_extensions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& scope_extensions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestScopeExtensionDataView>>(
      in_scope_extensions,
      scope_extensions_fragment,
      &scope_extensions_validate_params);

    fragment->scope_extensions.Set(
        scope_extensions_fragment.is_null() ? nullptr : scope_extensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scope_extensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scope_extensions in Manifest struct");

    decltype(Traits::lock_screen(input)) in_lock_screen = Traits::lock_screen(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lock_screen)::BaseType> lock_screen_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ManifestLockScreenDataView>(
      in_lock_screen,
      lock_screen_fragment);

    fragment->lock_screen.Set(
        lock_screen_fragment.is_null() ? nullptr : lock_screen_fragment.data());

    decltype(Traits::note_taking(input)) in_note_taking = Traits::note_taking(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->note_taking)::BaseType> note_taking_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ManifestNoteTakingDataView>(
      in_note_taking,
      note_taking_fragment);

    fragment->note_taking.Set(
        note_taking_fragment.is_null() ? nullptr : note_taking_fragment.data());

    decltype(Traits::related_applications(input)) in_related_applications = Traits::related_applications(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->related_applications)::BaseType>
        related_applications_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& related_applications_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestRelatedApplicationDataView>>(
      in_related_applications,
      related_applications_fragment,
      &related_applications_validate_params);

    fragment->related_applications.Set(
        related_applications_fragment.is_null() ? nullptr : related_applications_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->related_applications.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null related_applications in Manifest struct");

    fragment->prefer_related_applications = Traits::prefer_related_applications(input);

    fragment->has_theme_color = Traits::has_theme_color(input);

    fragment->theme_color = Traits::theme_color(input);

    fragment->has_background_color = Traits::has_background_color(input);

    fragment->background_color = Traits::background_color(input);

    decltype(Traits::gcm_sender_id(input)) in_gcm_sender_id = Traits::gcm_sender_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gcm_sender_id)::BaseType> gcm_sender_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_gcm_sender_id,
      gcm_sender_id_fragment);

    fragment->gcm_sender_id.Set(
        gcm_sender_id_fragment.is_null() ? nullptr : gcm_sender_id_fragment.data());

    decltype(Traits::scope(input)) in_scope = Traits::scope(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scope)::BaseType> scope_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_scope,
      scope_fragment);

    fragment->scope.Set(
        scope_fragment.is_null() ? nullptr : scope_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scope.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scope in Manifest struct");

    decltype(Traits::permissions_policy(input)) in_permissions_policy = Traits::permissions_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->permissions_policy)::BaseType>
        permissions_policy_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& permissions_policy_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
      in_permissions_policy,
      permissions_policy_fragment,
      &permissions_policy_validate_params);

    fragment->permissions_policy.Set(
        permissions_policy_fragment.is_null() ? nullptr : permissions_policy_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->permissions_policy.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null permissions_policy in Manifest struct");

    decltype(Traits::update_manifest_url(input)) in_update_manifest_url = Traits::update_manifest_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->update_manifest_url)::BaseType> update_manifest_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_update_manifest_url,
      update_manifest_url_fragment);

    fragment->update_manifest_url.Set(
        update_manifest_url_fragment.is_null() ? nullptr : update_manifest_url_fragment.data());

    decltype(Traits::launch_handler(input)) in_launch_handler = Traits::launch_handler(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->launch_handler)::BaseType> launch_handler_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ManifestLaunchHandlerDataView>(
      in_launch_handler,
      launch_handler_fragment);

    fragment->launch_handler.Set(
        launch_handler_fragment.is_null() ? nullptr : launch_handler_fragment.data());

    decltype(Traits::translations(input)) in_translations = Traits::translations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->translations)::BaseType>
        translations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& translations_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestTranslationItemDataView>>(
      in_translations,
      translations_fragment,
      &translations_validate_params);

    fragment->translations.Set(
        translations_fragment.is_null() ? nullptr : translations_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->translations.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null translations in Manifest struct");

    fragment->has_dark_theme_color = Traits::has_dark_theme_color(input);

    fragment->dark_theme_color = Traits::dark_theme_color(input);

    fragment->has_dark_background_color = Traits::has_dark_background_color(input);

    fragment->dark_background_color = Traits::dark_background_color(input);

    decltype(Traits::tab_strip(input)) in_tab_strip = Traits::tab_strip(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tab_strip)::BaseType> tab_strip_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ManifestTabStripDataView>(
      in_tab_strip,
      tab_strip_fragment);

    fragment->tab_strip.Set(
        tab_strip_fragment.is_null() ? nullptr : tab_strip_fragment.data());

    decltype(Traits::version(input)) in_version = Traits::version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->version)::BaseType> version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_version,
      version_fragment);

    fragment->version.Set(
        version_fragment.is_null() ? nullptr : version_fragment.data());

    decltype(Traits::name_localized(input)) in_name_localized = Traits::name_localized(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name_localized)::BaseType>
        name_localized_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& name_localized_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>>(
      in_name_localized,
      name_localized_fragment,
      &name_localized_validate_params);

    fragment->name_localized.Set(
        name_localized_fragment.is_null() ? nullptr : name_localized_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name_localized.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name_localized in Manifest struct");

    decltype(Traits::short_name_localized(input)) in_short_name_localized = Traits::short_name_localized(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->short_name_localized)::BaseType>
        short_name_localized_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& short_name_localized_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>>(
      in_short_name_localized,
      short_name_localized_fragment,
      &short_name_localized_validate_params);

    fragment->short_name_localized.Set(
        short_name_localized_fragment.is_null() ? nullptr : short_name_localized_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->short_name_localized.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null short_name_localized in Manifest struct");

    decltype(Traits::description_localized(input)) in_description_localized = Traits::description_localized(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description_localized)::BaseType>
        description_localized_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& description_localized_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>>(
      in_description_localized,
      description_localized_fragment,
      &description_localized_validate_params);

    fragment->description_localized.Set(
        description_localized_fragment.is_null() ? nullptr : description_localized_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description_localized.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description_localized in Manifest struct");

    decltype(Traits::icons_localized(input)) in_icons_localized = Traits::icons_localized(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons_localized)::BaseType>
        icons_localized_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_localized_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>>(
      in_icons_localized,
      icons_localized_fragment,
      &icons_localized_validate_params);

    fragment->icons_localized.Set(
        icons_localized_fragment.is_null() ? nullptr : icons_localized_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icons_localized.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icons_localized in Manifest struct");
  }

  static bool Deserialize(::blink::mojom::internal::Manifest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestLocalizedTextObjectDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestLocalizedTextObjectDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestLocalizedTextObject_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in ManifestLocalizedTextObject struct");
    fragment->dir_$flag = Traits::dir(input).has_value();
    if (Traits::dir(input).has_value()) {
      
      mojo::internal::Serialize<::blink::mojom::Manifest_TextDirection>(
        Traits::dir(input).value(),
        &fragment->dir_$value);
    } else {
      fragment->dir_$value =
          static_cast<int32_t>(::blink::mojom::Manifest_TextDirection::kMinValue);
    }

    decltype(Traits::lang(input)) in_lang = Traits::lang(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lang)::BaseType> lang_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_lang,
      lang_fragment);

    fragment->lang.Set(
        lang_fragment.is_null() ? nullptr : lang_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::ManifestLocalizedTextObject_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestLocalizedTextObjectDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestShortcutItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestShortcutItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestShortcutItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in ManifestShortcutItem struct");

    decltype(Traits::short_name(input)) in_short_name = Traits::short_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->short_name)::BaseType> short_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_short_name,
      short_name_fragment);

    fragment->short_name.Set(
        short_name_fragment.is_null() ? nullptr : short_name_fragment.data());

    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_description,
      description_fragment);

    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ManifestShortcutItem struct");

    decltype(Traits::icons(input)) in_icons = Traits::icons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons)::BaseType>
        icons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
      in_icons,
      icons_fragment,
      &icons_validate_params);

    fragment->icons.Set(
        icons_fragment.is_null() ? nullptr : icons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icons in ManifestShortcutItem struct");

    decltype(Traits::name_localized(input)) in_name_localized = Traits::name_localized(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name_localized)::BaseType>
        name_localized_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& name_localized_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>>(
      in_name_localized,
      name_localized_fragment,
      &name_localized_validate_params);

    fragment->name_localized.Set(
        name_localized_fragment.is_null() ? nullptr : name_localized_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name_localized.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name_localized in ManifestShortcutItem struct");

    decltype(Traits::short_name_localized(input)) in_short_name_localized = Traits::short_name_localized(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->short_name_localized)::BaseType>
        short_name_localized_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& short_name_localized_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>>(
      in_short_name_localized,
      short_name_localized_fragment,
      &short_name_localized_validate_params);

    fragment->short_name_localized.Set(
        short_name_localized_fragment.is_null() ? nullptr : short_name_localized_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->short_name_localized.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null short_name_localized in ManifestShortcutItem struct");

    decltype(Traits::description_localized(input)) in_description_localized = Traits::description_localized(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description_localized)::BaseType>
        description_localized_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& description_localized_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>>(
      in_description_localized,
      description_localized_fragment,
      &description_localized_validate_params);

    fragment->description_localized.Set(
        description_localized_fragment.is_null() ? nullptr : description_localized_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description_localized.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description_localized in ManifestShortcutItem struct");

    decltype(Traits::icons_localized(input)) in_icons_localized = Traits::icons_localized(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons_localized)::BaseType>
        icons_localized_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_localized_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>>(
      in_icons_localized,
      icons_localized_fragment,
      &icons_localized_validate_params);

    fragment->icons_localized.Set(
        icons_localized_fragment.is_null() ? nullptr : icons_localized_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icons_localized.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icons_localized in ManifestShortcutItem struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestShortcutItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestShortcutItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestImageResourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestImageResourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestImageResource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::src(input)) in_src = Traits::src(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->src)::BaseType> src_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_src,
      src_fragment);

    fragment->src.Set(
        src_fragment.is_null() ? nullptr : src_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->src.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null src in ManifestImageResource struct");

    decltype(Traits::type(input)) in_type = Traits::type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->type)::BaseType> type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_type,
      type_fragment);

    fragment->type.Set(
        type_fragment.is_null() ? nullptr : type_fragment.data());

    decltype(Traits::sizes(input)) in_sizes = Traits::sizes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sizes)::BaseType>
        sizes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sizes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
      in_sizes,
      sizes_fragment,
      &sizes_validate_params);

    fragment->sizes.Set(
        sizes_fragment.is_null() ? nullptr : sizes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sizes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sizes in ManifestImageResource struct");

    decltype(Traits::purpose(input)) in_purpose = Traits::purpose(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->purpose)::BaseType>
        purpose_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& purpose_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::ManifestImageResource_Purpose_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResource_Purpose>>(
      in_purpose,
      purpose_fragment,
      &purpose_validate_params);

    fragment->purpose.Set(
        purpose_fragment.is_null() ? nullptr : purpose_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->purpose.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null purpose in ManifestImageResource struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestImageResource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestImageResourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestScreenshotDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestScreenshotDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestScreenshot_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::image(input)) in_image = Traits::image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image)::BaseType> image_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ManifestImageResourceDataView>(
      in_image,
      image_fragment);

    fragment->image.Set(
        image_fragment.is_null() ? nullptr : image_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image in ManifestScreenshot struct");

    
    mojo::internal::Serialize<::blink::mojom::ManifestScreenshot_FormFactor>(
      Traits::form_factor(input),
      &fragment->form_factor);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::ManifestScreenshot_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestScreenshotDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestFileFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestFileFilterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestFileFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    decltype(Traits::accept(input)) in_accept = Traits::accept(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accept)::BaseType>
        accept_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& accept_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
      in_accept,
      accept_fragment,
      &accept_validate_params);

    fragment->accept.Set(
        accept_fragment.is_null() ? nullptr : accept_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->accept.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accept in ManifestFileFilter struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestFileFilter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestFileFilterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestProtocolHandlerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestProtocolHandlerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestProtocolHandler_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::protocol(input)) in_protocol = Traits::protocol(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->protocol)::BaseType> protocol_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_protocol,
      protocol_fragment);

    fragment->protocol.Set(
        protocol_fragment.is_null() ? nullptr : protocol_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->protocol.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null protocol in ManifestProtocolHandler struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ManifestProtocolHandler struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestProtocolHandler_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestProtocolHandlerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestScopeExtensionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestScopeExtensionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestScopeExtension_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in ManifestScopeExtension struct");

    fragment->has_origin_wildcard = Traits::has_origin_wildcard(input);
  }

  static bool Deserialize(::blink::mojom::internal::ManifestScopeExtension_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestScopeExtensionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestLockScreenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestLockScreenDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestLockScreen_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::start_url(input)) in_start_url = Traits::start_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start_url)::BaseType> start_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_start_url,
      start_url_fragment);

    fragment->start_url.Set(
        start_url_fragment.is_null() ? nullptr : start_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->start_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null start_url in ManifestLockScreen struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestLockScreen_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestLockScreenDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestNoteTakingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestNoteTakingDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestNoteTaking_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::new_note_url(input)) in_new_note_url = Traits::new_note_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->new_note_url)::BaseType> new_note_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_new_note_url,
      new_note_url_fragment);

    fragment->new_note_url.Set(
        new_note_url_fragment.is_null() ? nullptr : new_note_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->new_note_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_note_url in ManifestNoteTaking struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestNoteTaking_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestNoteTakingDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestRelatedApplicationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestRelatedApplicationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestRelatedApplication_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::platform(input)) in_platform = Traits::platform(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->platform)::BaseType> platform_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_platform,
      platform_fragment);

    fragment->platform.Set(
        platform_fragment.is_null() ? nullptr : platform_fragment.data());

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::ManifestRelatedApplication_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestRelatedApplicationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestShareTargetParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestShareTargetParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestShareTargetParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_text,
      text_fragment);

    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    decltype(Traits::files(input)) in_files = Traits::files(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->files)::BaseType>
        files_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestFileFilterDataView>>(
      in_files,
      files_fragment,
      &files_validate_params);

    fragment->files.Set(
        files_fragment.is_null() ? nullptr : files_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::ManifestShareTargetParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestShareTargetParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestShareTargetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestShareTargetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestShareTarget_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::action(input)) in_action = Traits::action(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->action)::BaseType> action_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_action,
      action_fragment);

    fragment->action.Set(
        action_fragment.is_null() ? nullptr : action_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->action.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null action in ManifestShareTarget struct");

    
    mojo::internal::Serialize<::blink::mojom::ManifestShareTarget_Method>(
      Traits::method(input),
      &fragment->method);

    
    mojo::internal::Serialize<::blink::mojom::ManifestShareTarget_Enctype>(
      Traits::enctype(input),
      &fragment->enctype);

    decltype(Traits::params(input)) in_params = Traits::params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->params)::BaseType> params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ManifestShareTargetParamsDataView>(
      in_params,
      params_fragment);

    fragment->params.Set(
        params_fragment.is_null() ? nullptr : params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in ManifestShareTarget struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestShareTarget_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestShareTargetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestFileHandlerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestFileHandlerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestFileHandler_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::action(input)) in_action = Traits::action(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->action)::BaseType> action_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_action,
      action_fragment);

    fragment->action.Set(
        action_fragment.is_null() ? nullptr : action_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->action.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null action in ManifestFileHandler struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in ManifestFileHandler struct");

    decltype(Traits::icons(input)) in_icons = Traits::icons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons)::BaseType>
        icons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
      in_icons,
      icons_fragment,
      &icons_validate_params);

    fragment->icons.Set(
        icons_fragment.is_null() ? nullptr : icons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icons in ManifestFileHandler struct");

    decltype(Traits::accept(input)) in_accept = Traits::accept(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accept)::BaseType>
        accept_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& accept_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>>(
      in_accept,
      accept_fragment,
      &accept_validate_params);

    fragment->accept.Set(
        accept_fragment.is_null() ? nullptr : accept_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->accept.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accept in ManifestFileHandler struct");

    
    mojo::internal::Serialize<::blink::mojom::ManifestFileHandler_LaunchType>(
      Traits::launch_type(input),
      &fragment->launch_type);
  }

  static bool Deserialize(::blink::mojom::internal::ManifestFileHandler_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestFileHandlerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestTranslationItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestTranslationItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestTranslationItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    decltype(Traits::short_name(input)) in_short_name = Traits::short_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->short_name)::BaseType> short_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_short_name,
      short_name_fragment);

    fragment->short_name.Set(
        short_name_fragment.is_null() ? nullptr : short_name_fragment.data());

    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_description,
      description_fragment);

    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::ManifestTranslationItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestTranslationItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestTabStripDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestTabStripDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestTabStrip_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::home_tab(input)) in_home_tab = Traits::home_tab(input);
    mojo::internal::MessageFragment<decltype(fragment->home_tab)>
        home_tab_fragment(fragment.message());
    home_tab_fragment.Claim(&fragment->home_tab);
    
    mojo::internal::Serialize<::blink::mojom::HomeTabUnionDataView>(
      in_home_tab,
      home_tab_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->home_tab.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null home_tab in ManifestTabStrip struct");

    decltype(Traits::new_tab_button(input)) in_new_tab_button = Traits::new_tab_button(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->new_tab_button)::BaseType> new_tab_button_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::NewTabButtonParamsDataView>(
      in_new_tab_button,
      new_tab_button_fragment);

    fragment->new_tab_button.Set(
        new_tab_button_fragment.is_null() ? nullptr : new_tab_button_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->new_tab_button.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_tab_button in ManifestTabStrip struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestTabStrip_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestTabStripDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::HomeTabParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::HomeTabParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::HomeTabParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::icons(input)) in_icons = Traits::icons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons)::BaseType>
        icons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
      in_icons,
      icons_fragment,
      &icons_validate_params);

    fragment->icons.Set(
        icons_fragment.is_null() ? nullptr : icons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icons in HomeTabParams struct");

    decltype(Traits::scope_patterns(input)) in_scope_patterns = Traits::scope_patterns(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scope_patterns)::BaseType>
        scope_patterns_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& scope_patterns_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternDataView>>(
      in_scope_patterns,
      scope_patterns_fragment,
      &scope_patterns_validate_params);

    fragment->scope_patterns.Set(
        scope_patterns_fragment.is_null() ? nullptr : scope_patterns_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scope_patterns.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scope_patterns in HomeTabParams struct");
  }

  static bool Deserialize(::blink::mojom::internal::HomeTabParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::HomeTabParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NewTabButtonParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::NewTabButtonParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::NewTabButtonParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::NewTabButtonParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::NewTabButtonParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestDebugInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestDebugInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestDebugInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::errors(input)) in_errors = Traits::errors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->errors)::BaseType>
        errors_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& errors_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestErrorDataView>>(
      in_errors,
      errors_fragment,
      &errors_validate_params);

    fragment->errors.Set(
        errors_fragment.is_null() ? nullptr : errors_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->errors.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null errors in ManifestDebugInfo struct");

    decltype(Traits::raw_manifest(input)) in_raw_manifest = Traits::raw_manifest(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->raw_manifest)::BaseType> raw_manifest_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_raw_manifest,
      raw_manifest_fragment);

    fragment->raw_manifest.Set(
        raw_manifest_fragment.is_null() ? nullptr : raw_manifest_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->raw_manifest.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null raw_manifest in ManifestDebugInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestDebugInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestDebugInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestErrorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_message,
      message_fragment);

    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->message.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in ManifestError struct");

    fragment->critical = Traits::critical(input);

    fragment->line = Traits::line(input);

    fragment->column = Traits::column(input);
  }

  static bool Deserialize(::blink::mojom::internal::ManifestError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::HomeTabUnionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::HomeTabUnionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::HomeTabUnion_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::HomeTabUnionDataView::Tag::kVisibility: {
    decltype(Traits::visibility(input))
    in_visibility = Traits::visibility(input);
        
mojo::internal::Serialize<::blink::mojom::TabStripMemberVisibility>(
  in_visibility,
  &fragment->data.f_visibility);
    break;
  }
  case ::blink::mojom::HomeTabUnionDataView::Tag::kParams: {
    decltype(Traits::params(input))
    in_params = Traits::params(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_params)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::HomeTabParamsDataView>(
  in_params,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null params in HomeTabUnion union");
    fragment->data.f_params.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::HomeTabUnion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::HomeTabUnionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void ManifestDataView::GetManifestUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->manifest_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestDataView::GetShortNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->short_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestDataView::GetDescriptionDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->description.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestDataView::GetIdDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestDataView::GetStartUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->start_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestDataView::GetDisplayOverrideDataView(
    mojo::ArrayDataView<::blink::mojom::DisplayMode>* output) {
  auto pointer = data_->display_override.Get();
  *output = mojo::ArrayDataView<::blink::mojom::DisplayMode>(pointer, message_);
}
inline void ManifestDataView::GetBorderlessUrlPatternsDataView(
    mojo::ArrayDataView<::blink::mojom::SafeUrlPatternDataView>* output) {
  auto pointer = data_->borderless_url_patterns.Get();
  *output = mojo::ArrayDataView<::blink::mojom::SafeUrlPatternDataView>(pointer, message_);
}
inline void ManifestDataView::GetIconsDataView(
    mojo::ArrayDataView<ManifestImageResourceDataView>* output) {
  auto pointer = data_->icons.Get();
  *output = mojo::ArrayDataView<ManifestImageResourceDataView>(pointer, message_);
}
inline void ManifestDataView::GetScreenshotsDataView(
    mojo::ArrayDataView<ManifestScreenshotDataView>* output) {
  auto pointer = data_->screenshots.Get();
  *output = mojo::ArrayDataView<ManifestScreenshotDataView>(pointer, message_);
}
inline void ManifestDataView::GetShortcutsDataView(
    mojo::ArrayDataView<ManifestShortcutItemDataView>* output) {
  auto pointer = data_->shortcuts.Get();
  *output = mojo::ArrayDataView<ManifestShortcutItemDataView>(pointer, message_);
}
inline void ManifestDataView::GetShareTargetDataView(
    ManifestShareTargetDataView* output) {
  auto pointer = data_->share_target.Get();
  *output = ManifestShareTargetDataView(pointer, message_);
}
inline void ManifestDataView::GetFileHandlersDataView(
    mojo::ArrayDataView<ManifestFileHandlerDataView>* output) {
  auto pointer = data_->file_handlers.Get();
  *output = mojo::ArrayDataView<ManifestFileHandlerDataView>(pointer, message_);
}
inline void ManifestDataView::GetProtocolHandlersDataView(
    mojo::ArrayDataView<ManifestProtocolHandlerDataView>* output) {
  auto pointer = data_->protocol_handlers.Get();
  *output = mojo::ArrayDataView<ManifestProtocolHandlerDataView>(pointer, message_);
}
inline void ManifestDataView::GetScopeExtensionsDataView(
    mojo::ArrayDataView<ManifestScopeExtensionDataView>* output) {
  auto pointer = data_->scope_extensions.Get();
  *output = mojo::ArrayDataView<ManifestScopeExtensionDataView>(pointer, message_);
}
inline void ManifestDataView::GetLockScreenDataView(
    ManifestLockScreenDataView* output) {
  auto pointer = data_->lock_screen.Get();
  *output = ManifestLockScreenDataView(pointer, message_);
}
inline void ManifestDataView::GetNoteTakingDataView(
    ManifestNoteTakingDataView* output) {
  auto pointer = data_->note_taking.Get();
  *output = ManifestNoteTakingDataView(pointer, message_);
}
inline void ManifestDataView::GetRelatedApplicationsDataView(
    mojo::ArrayDataView<ManifestRelatedApplicationDataView>* output) {
  auto pointer = data_->related_applications.Get();
  *output = mojo::ArrayDataView<ManifestRelatedApplicationDataView>(pointer, message_);
}
inline void ManifestDataView::GetGcmSenderIdDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->gcm_sender_id.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestDataView::GetScopeDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->scope.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestDataView::GetPermissionsPolicyDataView(
    mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>* output) {
  auto pointer = data_->permissions_policy.Get();
  *output = mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>(pointer, message_);
}
inline void ManifestDataView::GetUpdateManifestUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->update_manifest_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestDataView::GetLaunchHandlerDataView(
    ::blink::mojom::ManifestLaunchHandlerDataView* output) {
  auto pointer = data_->launch_handler.Get();
  *output = ::blink::mojom::ManifestLaunchHandlerDataView(pointer, message_);
}
inline void ManifestDataView::GetTranslationsDataView(
    mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestTranslationItemDataView>* output) {
  auto pointer = data_->translations.Get();
  *output = mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestTranslationItemDataView>(pointer, message_);
}
inline void ManifestDataView::GetTabStripDataView(
    ManifestTabStripDataView* output) {
  auto pointer = data_->tab_strip.Get();
  *output = ManifestTabStripDataView(pointer, message_);
}
inline void ManifestDataView::GetVersionDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->version.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestDataView::GetNameLocalizedDataView(
    mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>* output) {
  auto pointer = data_->name_localized.Get();
  *output = mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>(pointer, message_);
}
inline void ManifestDataView::GetShortNameLocalizedDataView(
    mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>* output) {
  auto pointer = data_->short_name_localized.Get();
  *output = mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>(pointer, message_);
}
inline void ManifestDataView::GetDescriptionLocalizedDataView(
    mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>* output) {
  auto pointer = data_->description_localized.Get();
  *output = mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>(pointer, message_);
}
inline void ManifestDataView::GetIconsLocalizedDataView(
    mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<ManifestImageResourceDataView>>* output) {
  auto pointer = data_->icons_localized.Get();
  *output = mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<ManifestImageResourceDataView>>(pointer, message_);
}


inline void ManifestLocalizedTextObjectDataView::GetValueDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestLocalizedTextObjectDataView::GetLangDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->lang.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void ManifestShortcutItemDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestShortcutItemDataView::GetShortNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->short_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestShortcutItemDataView::GetDescriptionDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->description.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestShortcutItemDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestShortcutItemDataView::GetIconsDataView(
    mojo::ArrayDataView<ManifestImageResourceDataView>* output) {
  auto pointer = data_->icons.Get();
  *output = mojo::ArrayDataView<ManifestImageResourceDataView>(pointer, message_);
}
inline void ManifestShortcutItemDataView::GetNameLocalizedDataView(
    mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>* output) {
  auto pointer = data_->name_localized.Get();
  *output = mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>(pointer, message_);
}
inline void ManifestShortcutItemDataView::GetShortNameLocalizedDataView(
    mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>* output) {
  auto pointer = data_->short_name_localized.Get();
  *output = mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>(pointer, message_);
}
inline void ManifestShortcutItemDataView::GetDescriptionLocalizedDataView(
    mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>* output) {
  auto pointer = data_->description_localized.Get();
  *output = mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>(pointer, message_);
}
inline void ManifestShortcutItemDataView::GetIconsLocalizedDataView(
    mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<ManifestImageResourceDataView>>* output) {
  auto pointer = data_->icons_localized.Get();
  *output = mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<ManifestImageResourceDataView>>(pointer, message_);
}


inline void ManifestImageResourceDataView::GetSrcDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->src.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestImageResourceDataView::GetTypeDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->type.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestImageResourceDataView::GetSizesDataView(
    mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output) {
  auto pointer = data_->sizes.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::SizeDataView>(pointer, message_);
}
inline void ManifestImageResourceDataView::GetPurposeDataView(
    mojo::ArrayDataView<ManifestImageResource_Purpose>* output) {
  auto pointer = data_->purpose.Get();
  *output = mojo::ArrayDataView<ManifestImageResource_Purpose>(pointer, message_);
}


inline void ManifestScreenshotDataView::GetImageDataView(
    ManifestImageResourceDataView* output) {
  auto pointer = data_->image.Get();
  *output = ManifestImageResourceDataView(pointer, message_);
}
inline void ManifestScreenshotDataView::GetLabelDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->label.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void ManifestFileFilterDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestFileFilterDataView::GetAcceptDataView(
    mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->accept.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::String16DataView>(pointer, message_);
}


inline void ManifestProtocolHandlerDataView::GetProtocolDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->protocol.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestProtocolHandlerDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void ManifestScopeExtensionDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void ManifestLockScreenDataView::GetStartUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->start_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void ManifestNoteTakingDataView::GetNewNoteUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->new_note_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void ManifestRelatedApplicationDataView::GetPlatformDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->platform.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestRelatedApplicationDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestRelatedApplicationDataView::GetIdDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->id.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void ManifestShareTargetParamsDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestShareTargetParamsDataView::GetTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestShareTargetParamsDataView::GetUrlDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->url.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestShareTargetParamsDataView::GetFilesDataView(
    mojo::ArrayDataView<ManifestFileFilterDataView>* output) {
  auto pointer = data_->files.Get();
  *output = mojo::ArrayDataView<ManifestFileFilterDataView>(pointer, message_);
}


inline void ManifestShareTargetDataView::GetActionDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->action.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestShareTargetDataView::GetParamsDataView(
    ManifestShareTargetParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = ManifestShareTargetParamsDataView(pointer, message_);
}


inline void ManifestFileHandlerDataView::GetActionDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->action.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestFileHandlerDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestFileHandlerDataView::GetIconsDataView(
    mojo::ArrayDataView<ManifestImageResourceDataView>* output) {
  auto pointer = data_->icons.Get();
  *output = mojo::ArrayDataView<ManifestImageResourceDataView>(pointer, message_);
}
inline void ManifestFileHandlerDataView::GetAcceptDataView(
    mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>* output) {
  auto pointer = data_->accept.Get();
  *output = mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(pointer, message_);
}


inline void ManifestTranslationItemDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestTranslationItemDataView::GetShortNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->short_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestTranslationItemDataView::GetDescriptionDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->description.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void ManifestTabStripDataView::GetHomeTabDataView(
    HomeTabUnionDataView* output) {
  auto pointer = &data_->home_tab;
  *output = HomeTabUnionDataView(pointer, message_);
}
inline void ManifestTabStripDataView::GetNewTabButtonDataView(
    NewTabButtonParamsDataView* output) {
  auto pointer = data_->new_tab_button.Get();
  *output = NewTabButtonParamsDataView(pointer, message_);
}


inline void HomeTabParamsDataView::GetIconsDataView(
    mojo::ArrayDataView<ManifestImageResourceDataView>* output) {
  auto pointer = data_->icons.Get();
  *output = mojo::ArrayDataView<ManifestImageResourceDataView>(pointer, message_);
}
inline void HomeTabParamsDataView::GetScopePatternsDataView(
    mojo::ArrayDataView<::blink::mojom::SafeUrlPatternDataView>* output) {
  auto pointer = data_->scope_patterns.Get();
  *output = mojo::ArrayDataView<::blink::mojom::SafeUrlPatternDataView>(pointer, message_);
}


inline void NewTabButtonParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void ManifestDebugInfoDataView::GetErrorsDataView(
    mojo::ArrayDataView<ManifestErrorDataView>* output) {
  auto pointer = data_->errors.Get();
  *output = mojo::ArrayDataView<ManifestErrorDataView>(pointer, message_);
}
inline void ManifestDebugInfoDataView::GetRawManifestDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->raw_manifest.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ManifestErrorDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void HomeTabUnionDataView::GetParamsDataView(
    HomeTabParamsDataView* output) const {
  CHECK(is_params());
  *output = HomeTabParamsDataView(data_->data.f_params.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::TabStripMemberVisibility> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::TabStripMemberVisibility value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ManifestRequestResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ManifestRequestResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::Manifest_TextDirection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::Manifest_TextDirection value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ManifestImageResource_Purpose> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ManifestImageResource_Purpose value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ManifestScreenshot_FormFactor> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ManifestScreenshot_FormFactor value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ManifestShareTarget_Method> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ManifestShareTarget_Method value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ManifestShareTarget_Enctype> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ManifestShareTarget_Enctype value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ManifestFileHandler_LaunchType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ManifestFileHandler_LaunchType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_SHARED_H_