// third_party/blink/public/mojom/lock_screen/lock_screen.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOCK_SCREEN_LOCK_SCREEN_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOCK_SCREEN_LOCK_SCREEN_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/lock_screen/lock_screen.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/lock_screen/lock_screen.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/lock_screen/lock_screen.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class LockScreenServiceProxy;

template <typename ImplRefTraits>
class LockScreenServiceStub;

class LockScreenServiceRequestValidator;
class LockScreenServiceResponseValidator;


class BLINK_COMMON_EXPORT LockScreenService
    : public LockScreenServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.LockScreenService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LockScreenServiceInterfaceBase;
  using Proxy_ = LockScreenServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = LockScreenServiceStub<ImplRefTraits>;

  using RequestValidator_ = LockScreenServiceRequestValidator;
  using ResponseValidator_ = LockScreenServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetKeysMinVersion = 0,
    kSetDataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetKeys_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LockScreenService() = default;

  using GetKeysCallback = base::OnceCallback<void(const std::vector<std::string>&)>;
  using GetKeysMojoCallback = base::OnceCallback<void(const std::vector<std::string>&)>;

  virtual void GetKeys(GetKeysCallback callback) = 0;

  using SetDataCallback = base::OnceCallback<void(LockScreenServiceStatus)>;
  using SetDataMojoCallback = base::OnceCallback<void(LockScreenServiceStatus)>;

  virtual void SetData(const std::string& key, const std::string& data, SetDataCallback callback) = 0;
};



class BLINK_COMMON_EXPORT LockScreenServiceProxy
    : public LockScreenService {
 public:
  using InterfaceType = LockScreenService;

  explicit LockScreenServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetKeys(GetKeysCallback callback) final;
  
  void SetData(const std::string& key, const std::string& data, SetDataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT LockScreenServiceStubDispatch {
 public:
  static bool Accept(LockScreenService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LockScreenService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LockScreenService>>
class LockScreenServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LockScreenServiceStub() = default;
  ~LockScreenServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LockScreenServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LockScreenServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT LockScreenServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT LockScreenServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOCK_SCREEN_LOCK_SCREEN_MOJOM_H_