// third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_URL_LOADER_FACTORY_BUNDLE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_URL_LOADER_FACTORY_BUNDLE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/url_loader_factory.mojom-blink-forward.h"
#include "url/mojom/origin.mojom-blink.h"
#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/loader/url_loader_factory_bundle_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class PLATFORM_EXPORT URLLoaderFactoryBundle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLLoaderFactoryBundle, T>::value>;
  using DataView = URLLoaderFactoryBundleDataView;
  using Data_ = internal::URLLoaderFactoryBundle_Data;

  template <typename... Args>
  static URLLoaderFactoryBundlePtr New(Args&&... args) {
    return URLLoaderFactoryBundlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLLoaderFactoryBundlePtr From(const U& u) {
    return mojo::TypeConverter<URLLoaderFactoryBundlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLLoaderFactoryBundle>::Convert(*this);
  }


  URLLoaderFactoryBundle();

  URLLoaderFactoryBundle(
      ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> default_factory,
      ::blink::HashMap<::blink::String, ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory>> scheme_specific_factories,
      ::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory>> isolated_world_factories,
      bool bypass_redirect_checks,
      ::blink::mojom::blink::LocalResourceLoaderConfigPtr local_resource_loader_config);

URLLoaderFactoryBundle(const URLLoaderFactoryBundle&) = delete;
URLLoaderFactoryBundle& operator=(const URLLoaderFactoryBundle&) = delete;

  ~URLLoaderFactoryBundle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLLoaderFactoryBundlePtr>
  URLLoaderFactoryBundlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLLoaderFactoryBundle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, URLLoaderFactoryBundle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, URLLoaderFactoryBundle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLLoaderFactoryBundle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLLoaderFactoryBundle_UnserializedMessageContext<
            UserType, URLLoaderFactoryBundle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<URLLoaderFactoryBundle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return URLLoaderFactoryBundle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLLoaderFactoryBundle_UnserializedMessageContext<
            UserType, URLLoaderFactoryBundle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLLoaderFactoryBundle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> default_factory;
  
  ::blink::HashMap<::blink::String, ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory>> scheme_specific_factories;
  
  ::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory>> isolated_world_factories;
  
  bool bypass_redirect_checks;
  
  ::blink::mojom::blink::LocalResourceLoaderConfigPtr local_resource_loader_config;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLLoaderFactoryBundle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLLoaderFactoryBundle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLLoaderFactoryBundle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLLoaderFactoryBundle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
URLLoaderFactoryBundlePtr URLLoaderFactoryBundle::Clone() const {
  return New(
      mojo::Clone(default_factory),
      mojo::Clone(scheme_specific_factories),
      mojo::Clone(isolated_world_factories),
      mojo::Clone(bypass_redirect_checks),
      mojo::Clone(local_resource_loader_config)
  );
}

template <typename T, URLLoaderFactoryBundle::EnableIfSame<T>*>
bool URLLoaderFactoryBundle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->default_factory, other_struct.default_factory))
    return false;
  if (!mojo::Equals(this->scheme_specific_factories, other_struct.scheme_specific_factories))
    return false;
  if (!mojo::Equals(this->isolated_world_factories, other_struct.isolated_world_factories))
    return false;
  if (!mojo::Equals(this->bypass_redirect_checks, other_struct.bypass_redirect_checks))
    return false;
  if (!mojo::Equals(this->local_resource_loader_config, other_struct.local_resource_loader_config))
    return false;
  return true;
}

template <typename T, URLLoaderFactoryBundle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.default_factory < rhs.default_factory)
    return true;
  if (rhs.default_factory < lhs.default_factory)
    return false;
  if (lhs.scheme_specific_factories < rhs.scheme_specific_factories)
    return true;
  if (rhs.scheme_specific_factories < lhs.scheme_specific_factories)
    return false;
  if (lhs.isolated_world_factories < rhs.isolated_world_factories)
    return true;
  if (rhs.isolated_world_factories < lhs.isolated_world_factories)
    return false;
  if (lhs.bypass_redirect_checks < rhs.bypass_redirect_checks)
    return true;
  if (rhs.bypass_redirect_checks < lhs.bypass_redirect_checks)
    return false;
  if (lhs.local_resource_loader_config < rhs.local_resource_loader_config)
    return true;
  if (rhs.local_resource_loader_config < lhs.local_resource_loader_config)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::URLLoaderFactoryBundle::DataView,
                                         ::blink::mojom::blink::URLLoaderFactoryBundlePtr> {
  static bool IsNull(const ::blink::mojom::blink::URLLoaderFactoryBundlePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::URLLoaderFactoryBundlePtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::URLLoaderFactoryBundle::default_factory)& default_factory(
       ::blink::mojom::blink::URLLoaderFactoryBundlePtr& input) {
    return input->default_factory;
  }

  static  decltype(::blink::mojom::blink::URLLoaderFactoryBundle::scheme_specific_factories)& scheme_specific_factories(
       ::blink::mojom::blink::URLLoaderFactoryBundlePtr& input) {
    return input->scheme_specific_factories;
  }

  static  decltype(::blink::mojom::blink::URLLoaderFactoryBundle::isolated_world_factories)& isolated_world_factories(
       ::blink::mojom::blink::URLLoaderFactoryBundlePtr& input) {
    return input->isolated_world_factories;
  }

  static decltype(::blink::mojom::blink::URLLoaderFactoryBundle::bypass_redirect_checks) bypass_redirect_checks(
      const ::blink::mojom::blink::URLLoaderFactoryBundlePtr& input) {
    return input->bypass_redirect_checks;
  }

  static const decltype(::blink::mojom::blink::URLLoaderFactoryBundle::local_resource_loader_config)& local_resource_loader_config(
      const ::blink::mojom::blink::URLLoaderFactoryBundlePtr& input) {
    return input->local_resource_loader_config;
  }

  static bool Read(::blink::mojom::blink::URLLoaderFactoryBundle::DataView input, ::blink::mojom::blink::URLLoaderFactoryBundlePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_URL_LOADER_FACTORY_BUNDLE_MOJOM_BLINK_H_