// third_party/blink/public/mojom/loader/transferrable_url_loader.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_TRANSFERRABLE_URL_LOADER_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_TRANSFERRABLE_URL_LOADER_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/loader/transferrable_url_loader.mojom-shared-internal.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "third_party/blink/public/mojom/loader/transferrable_url_loader.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::TransferrableURLLoaderDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TransferrableURLLoaderDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TransferrableURLLoader_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in TransferrableURLLoader struct");

      decltype(Traits::url_loader(input)) in_url_loader = Traits::url_loader(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderInterfaceBase>>(
        in_url_loader,
        &fragment->url_loader,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->url_loader)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid url_loader in TransferrableURLLoader struct");

      decltype(Traits::url_loader_client(input)) in_url_loader_client = Traits::url_loader_client(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderClientInterfaceBase>>(
        in_url_loader_client,
        &fragment->url_loader_client,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->url_loader_client)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid url_loader_client in TransferrableURLLoader struct");

      decltype(Traits::head(input)) in_head = Traits::head(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->head)::BaseType> head_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView, send_validation>(
        in_head,
        head_fragment);

      fragment->head.Set(
          head_fragment.is_null() ? nullptr : head_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->head.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null head in TransferrableURLLoader struct");

      decltype(Traits::body(input)) in_body = Traits::body(input);

      
      mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
        in_body,
        &fragment->body,
        &fragment.message());
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_TRANSFERRABLE_URL_LOADER_MOJOM_SEND_VALIDATION_H_