// third_party/blink/public/mojom/loader/resource_load_info.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_count.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::ResourceType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::CommonNetworkInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CommonNetworkInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CommonNetworkInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->network_accessed = Traits::network_accessed(input);

      fragment->always_access_network = Traits::always_access_network(input);

      decltype(Traits::remote_endpoint(input)) in_remote_endpoint = Traits::remote_endpoint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->remote_endpoint)::BaseType> remote_endpoint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::IPEndPointDataView, send_validation>(
        in_remote_endpoint,
        remote_endpoint_fragment);

      fragment->remote_endpoint.Set(
          remote_endpoint_fragment.is_null() ? nullptr : remote_endpoint_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::RedirectInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::RedirectInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::RedirectInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::origin_of_new_url(input)) in_origin_of_new_url = Traits::origin_of_new_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin_of_new_url)::BaseType> origin_of_new_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_origin_of_new_url,
        origin_of_new_url_fragment);

      fragment->origin_of_new_url.Set(
          origin_of_new_url_fragment.is_null() ? nullptr : origin_of_new_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin_of_new_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin_of_new_url in RedirectInfo struct");

      decltype(Traits::network_info(input)) in_network_info = Traits::network_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->network_info)::BaseType> network_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::CommonNetworkInfoDataView, send_validation>(
        in_network_info,
        network_info_fragment);

      fragment->network_info.Set(
          network_info_fragment.is_null() ? nullptr : network_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->network_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null network_info in RedirectInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ResourceLoadInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ResourceLoadInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ResourceLoadInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->request_id = Traits::request_id(input);

      decltype(Traits::final_url(input)) in_final_url = Traits::final_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->final_url)::BaseType> final_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_final_url,
        final_url_fragment);

      fragment->final_url.Set(
          final_url_fragment.is_null() ? nullptr : final_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->final_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null final_url in ResourceLoadInfo struct");

      decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->referrer)::BaseType> referrer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_referrer,
        referrer_fragment);

      fragment->referrer.Set(
          referrer_fragment.is_null() ? nullptr : referrer_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->referrer.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null referrer in ResourceLoadInfo struct");

      decltype(Traits::original_url(input)) in_original_url = Traits::original_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->original_url)::BaseType> original_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_original_url,
        original_url_fragment);

      fragment->original_url.Set(
          original_url_fragment.is_null() ? nullptr : original_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->original_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null original_url in ResourceLoadInfo struct");

      decltype(Traits::method(input)) in_method = Traits::method(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->method)::BaseType> method_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_method,
        method_fragment);

      fragment->method.Set(
          method_fragment.is_null() ? nullptr : method_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->method.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method in ResourceLoadInfo struct");

      
      mojo::internal::Serialize<::network::mojom::RequestDestination>(
        Traits::request_destination(input),
        &fragment->request_destination);

      
      mojo::internal::Serialize<::network::mojom::RequestPriority>(
        Traits::request_priority(input),
        &fragment->request_priority);

      decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_mime_type,
        mime_type_fragment);

      fragment->mime_type.Set(
          mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mime_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in ResourceLoadInfo struct");

      fragment->was_cached = Traits::was_cached(input);

      decltype(Traits::network_info(input)) in_network_info = Traits::network_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->network_info)::BaseType> network_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::CommonNetworkInfoDataView, send_validation>(
        in_network_info,
        network_info_fragment);

      fragment->network_info.Set(
          network_info_fragment.is_null() ? nullptr : network_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->network_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null network_info in ResourceLoadInfo struct");

      fragment->net_error = Traits::net_error(input);

      decltype(Traits::proxy_chain(input)) in_proxy_chain = Traits::proxy_chain(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->proxy_chain)::BaseType> proxy_chain_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ProxyChainDataView, send_validation>(
        in_proxy_chain,
        proxy_chain_fragment);

      fragment->proxy_chain.Set(
          proxy_chain_fragment.is_null() ? nullptr : proxy_chain_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->proxy_chain.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null proxy_chain in ResourceLoadInfo struct");

      decltype(Traits::load_timing_info(input)) in_load_timing_info = Traits::load_timing_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->load_timing_info)::BaseType> load_timing_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::LoadTimingInfoDataView, send_validation>(
        in_load_timing_info,
        load_timing_info_fragment);

      fragment->load_timing_info.Set(
          load_timing_info_fragment.is_null() ? nullptr : load_timing_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->load_timing_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null load_timing_info in ResourceLoadInfo struct");

      decltype(Traits::raw_body_bytes(input)) in_raw_body_bytes = Traits::raw_body_bytes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->raw_body_bytes)::BaseType> raw_body_bytes_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView, send_validation>(
        in_raw_body_bytes,
        raw_body_bytes_fragment);

      fragment->raw_body_bytes.Set(
          raw_body_bytes_fragment.is_null() ? nullptr : raw_body_bytes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->raw_body_bytes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null raw_body_bytes in ResourceLoadInfo struct");

      decltype(Traits::total_received_bytes(input)) in_total_received_bytes = Traits::total_received_bytes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->total_received_bytes)::BaseType> total_received_bytes_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView, send_validation>(
        in_total_received_bytes,
        total_received_bytes_fragment);

      fragment->total_received_bytes.Set(
          total_received_bytes_fragment.is_null() ? nullptr : total_received_bytes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->total_received_bytes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null total_received_bytes in ResourceLoadInfo struct");

      decltype(Traits::redirect_info_chain(input)) in_redirect_info_chain = Traits::redirect_info_chain(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->redirect_info_chain)::BaseType>
          redirect_info_chain_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& redirect_info_chain_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::RedirectInfoDataView>, send_validation>(
        in_redirect_info_chain,
        redirect_info_chain_fragment,
        &redirect_info_chain_validate_params);

      fragment->redirect_info_chain.Set(
          redirect_info_chain_fragment.is_null() ? nullptr : redirect_info_chain_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->redirect_info_chain.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null redirect_info_chain in ResourceLoadInfo struct");

      fragment->http_status_code = Traits::http_status_code(input);

      fragment->did_use_server_http_auth = Traits::did_use_server_http_auth(input);
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_SEND_VALIDATION_H_