// third_party/blink/public/mojom/loader/resource_load_info.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');

goog.require('network.mojom.RequestDestination');
goog.require('network.mojom.RequestPriority');
goog.require('mojoBase.mojom.ByteCount');
goog.require('network.mojom.IPEndPoint');
goog.require('network.mojom.LoadTimingInfo');
goog.require('url.mojom.Origin');
goog.require('network.mojom.ProxyChain');
goog.require('url.mojom.Url');




goog.provide('blink.mojom.ResourceType');
goog.provide('blink.mojom.ResourceTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.ResourceTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.ResourceType = {
  
  kMainFrame: 0,
  kSubFrame: 1,
  kStylesheet: 2,
  kScript: 3,
  kImage: 4,
  kFontResource: 5,
  kSubResource: 6,
  kObject: 7,
  kMedia: 8,
  kWorker: 9,
  kSharedWorker: 10,
  kPrefetch: 11,
  kFavicon: 12,
  kXhr: 13,
  kPing: 14,
  kServiceWorker: 15,
  kCspReport: 16,
  kPluginResource: 17,
  kNavigationPreloadMainFrame: 19,
  kNavigationPreloadSubFrame: 20,
  kJson: 21,
  MIN_VALUE: 0,
  MAX_VALUE: 21,
};



goog.provide('blink.mojom.CommonNetworkInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CommonNetworkInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.RedirectInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RedirectInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ResourceLoadInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ResourceLoadInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.CommonNetworkInfoSpec.$,
    'CommonNetworkInfo',
    [
      mojo.internal.StructField(
        'networkAccessed', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'alwaysAccessNetwork', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteEndpoint', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.CommonNetworkInfo');

/** @record */
blink.mojom.CommonNetworkInfo = class {
  constructor() {
    /** @export { !boolean } */
    this.networkAccessed;
    /** @export { !boolean } */
    this.alwaysAccessNetwork;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.remoteEndpoint;
  }
};



mojo.internal.Struct(
    blink.mojom.RedirectInfoSpec.$,
    'RedirectInfo',
    [
      mojo.internal.StructField(
        'originOfNewUrl', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'networkInfo', 8,
        0,
        blink.mojom.CommonNetworkInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.RedirectInfo');

/** @record */
blink.mojom.RedirectInfo = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.originOfNewUrl;
    /** @export { !blink.mojom.CommonNetworkInfo } */
    this.networkInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.ResourceLoadInfoSpec.$,
    'ResourceLoadInfo',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'finalUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'referrer', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'originalUrl', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'method', 32,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestDestination', 40,
        0,
        network.mojom.RequestDestinationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestPriority', 44,
        0,
        network.mojom.RequestPrioritySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mimeType', 48,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasCached', 56,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'networkInfo', 64,
        0,
        blink.mojom.CommonNetworkInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'netError', 60,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'proxyChain', 72,
        0,
        network.mojom.ProxyChainSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'loadTimingInfo', 80,
        0,
        network.mojom.LoadTimingInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rawBodyBytes', 88,
        0,
        mojoBase.mojom.ByteCountSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'totalReceivedBytes', 96,
        0,
        mojoBase.mojom.ByteCountSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'redirectInfoChain', 104,
        0,
        mojo.internal.Array(blink.mojom.RedirectInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'httpStatusCode', 112,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'didUseServerHttpAuth', 56,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 128],]);



goog.provide('blink.mojom.ResourceLoadInfo');

/** @record */
blink.mojom.ResourceLoadInfo = class {
  constructor() {
    /** @export { !bigint } */
    this.requestId;
    /** @export { !url.mojom.Url } */
    this.finalUrl;
    /** @export { !url.mojom.Url } */
    this.referrer;
    /** @export { !url.mojom.Url } */
    this.originalUrl;
    /** @export { !string } */
    this.method;
    /** @export { !network.mojom.RequestDestination } */
    this.requestDestination;
    /** @export { !network.mojom.RequestPriority } */
    this.requestPriority;
    /** @export { !string } */
    this.mimeType;
    /** @export { !boolean } */
    this.wasCached;
    /** @export { !blink.mojom.CommonNetworkInfo } */
    this.networkInfo;
    /** @export { !number } */
    this.netError;
    /** @export { !network.mojom.ProxyChain } */
    this.proxyChain;
    /** @export { !network.mojom.LoadTimingInfo } */
    this.loadTimingInfo;
    /** @export { !mojoBase.mojom.ByteCount } */
    this.rawBodyBytes;
    /** @export { !mojoBase.mojom.ByteCount } */
    this.totalReceivedBytes;
    /** @export { !Array<!blink.mojom.RedirectInfo> } */
    this.redirectInfoChain;
    /** @export { !number } */
    this.httpStatusCode;
    /** @export { !boolean } */
    this.didUseServerHttpAuth;
  }
};

