// third_party/blink/public/mojom/loader/navigation_predictor.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  AnchorElementPointerData as blink_mojom_AnchorElementPointerData,
  AnchorElementPointerDataSpec as blink_mojom_AnchorElementPointerDataSpec
} from '../preloading/anchor_element_interaction_host.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AnchorElementUserInteractionEventForMLModelTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AnchorElementUserInteractionEventForMLModelType = {
  
  kPointerOver: 0,
  kPointerOut: 1,
  kEnteredViewport: 2,
  kLeftViewport: 3,
  kUnknown: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AnchorElementMetricsHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AnchorElementMetricsHost', scope);
  }
}

/** @interface */
export class AnchorElementMetricsHostInterface {
  
  /**
   * @param { !AnchorElementClick } clicked
   */

  reportAnchorElementClick(clicked) {}
  
  /**
   * @param { !Array<!AnchorElementMetrics> } metrics
   * @param { !Array<!number> } removedElements
   */

  reportNewAnchorElements(metrics, removedElements) {}
  
  /**
   * @param { !Array<!AnchorElementEnteredViewport> } elements
   */

  reportAnchorElementsEnteredViewport(elements) {}
  
  /**
   * @param { !Array<!AnchorElementLeftViewport> } elements
   */

  reportAnchorElementsLeftViewport(elements) {}
  
  /**
   * @param { !Array<!AnchorElementPositionUpdate> } elements
   */

  reportAnchorElementsPositionUpdate(elements) {}
  
  /**
   * @param { !AnchorElementPointerOver } pointerOverEvent
   */

  reportAnchorElementPointerOver(pointerOverEvent) {}
  
  /**
   * @param { !AnchorElementPointerOut } hoverEvent
   */

  reportAnchorElementPointerOut(hoverEvent) {}
  
  /**
   * @param { !AnchorElementPointerDown } pointerDownEvent
   */

  reportAnchorElementPointerDown(pointerDownEvent) {}
  
  /**
   * @param { !AnchorElementPointerDataOnHoverTimerFired } pointerData
   */

  reportAnchorElementPointerDataOnHoverTimerFired(pointerData) {}
  
  /**
   * @param { !AnchorElementPointerEventForMLModel } pointerEvent
   */

  processPointerEventUsingMLModel(pointerEvent) {}
  
  /**
   * @return {!Promise<{
        shouldSkipForTesting: !boolean,
   *  }>}
   */

  shouldSkipUpdateDelays() {}
}

/**
 * @implements { AnchorElementMetricsHostInterface }
 */
export class AnchorElementMetricsHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AnchorElementMetricsHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AnchorElementMetricsHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AnchorElementMetricsHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !AnchorElementClick } clicked
   */

  reportAnchorElementClick(
      clicked) {
    this.proxy.sendMessage(
        0,
        AnchorElementMetricsHost_ReportAnchorElementClick_ParamsSpec.$,
        null,
        [
          clicked
        ],
        false);
  }

  
  /**
   * @param { !Array<!AnchorElementMetrics> } metrics
   * @param { !Array<!number> } removedElements
   */

  reportNewAnchorElements(
      metrics,
      removedElements) {
    this.proxy.sendMessage(
        1,
        AnchorElementMetricsHost_ReportNewAnchorElements_ParamsSpec.$,
        null,
        [
          metrics,
          removedElements
        ],
        false);
  }

  
  /**
   * @param { !Array<!AnchorElementEnteredViewport> } elements
   */

  reportAnchorElementsEnteredViewport(
      elements) {
    this.proxy.sendMessage(
        2,
        AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_ParamsSpec.$,
        null,
        [
          elements
        ],
        false);
  }

  
  /**
   * @param { !Array<!AnchorElementLeftViewport> } elements
   */

  reportAnchorElementsLeftViewport(
      elements) {
    this.proxy.sendMessage(
        3,
        AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_ParamsSpec.$,
        null,
        [
          elements
        ],
        false);
  }

  
  /**
   * @param { !Array<!AnchorElementPositionUpdate> } elements
   */

  reportAnchorElementsPositionUpdate(
      elements) {
    this.proxy.sendMessage(
        4,
        AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_ParamsSpec.$,
        null,
        [
          elements
        ],
        false);
  }

  
  /**
   * @param { !AnchorElementPointerOver } pointerOverEvent
   */

  reportAnchorElementPointerOver(
      pointerOverEvent) {
    this.proxy.sendMessage(
        5,
        AnchorElementMetricsHost_ReportAnchorElementPointerOver_ParamsSpec.$,
        null,
        [
          pointerOverEvent
        ],
        false);
  }

  
  /**
   * @param { !AnchorElementPointerOut } hoverEvent
   */

  reportAnchorElementPointerOut(
      hoverEvent) {
    this.proxy.sendMessage(
        6,
        AnchorElementMetricsHost_ReportAnchorElementPointerOut_ParamsSpec.$,
        null,
        [
          hoverEvent
        ],
        false);
  }

  
  /**
   * @param { !AnchorElementPointerDown } pointerDownEvent
   */

  reportAnchorElementPointerDown(
      pointerDownEvent) {
    this.proxy.sendMessage(
        7,
        AnchorElementMetricsHost_ReportAnchorElementPointerDown_ParamsSpec.$,
        null,
        [
          pointerDownEvent
        ],
        false);
  }

  
  /**
   * @param { !AnchorElementPointerDataOnHoverTimerFired } pointerData
   */

  reportAnchorElementPointerDataOnHoverTimerFired(
      pointerData) {
    this.proxy.sendMessage(
        8,
        AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_ParamsSpec.$,
        null,
        [
          pointerData
        ],
        false);
  }

  
  /**
   * @param { !AnchorElementPointerEventForMLModel } pointerEvent
   */

  processPointerEventUsingMLModel(
      pointerEvent) {
    this.proxy.sendMessage(
        9,
        AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_ParamsSpec.$,
        null,
        [
          pointerEvent
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        shouldSkipForTesting: !boolean,
   *  }>}
   */

  shouldSkipUpdateDelays() {
    return this.proxy.sendMessage(
        10,
        AnchorElementMetricsHost_ShouldSkipUpdateDelays_ParamsSpec.$,
        AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AnchorElementMetricsHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AnchorElementMetricsHostReceiver {
  /**
   * @param {!AnchorElementMetricsHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AnchorElementMetricsHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AnchorElementMetricsHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AnchorElementMetricsHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AnchorElementMetricsHost_ReportAnchorElementClick_ParamsSpec.$,
        null,
        impl.reportAnchorElementClick.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AnchorElementMetricsHost_ReportNewAnchorElements_ParamsSpec.$,
        null,
        impl.reportNewAnchorElements.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_ParamsSpec.$,
        null,
        impl.reportAnchorElementsEnteredViewport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_ParamsSpec.$,
        null,
        impl.reportAnchorElementsLeftViewport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_ParamsSpec.$,
        null,
        impl.reportAnchorElementsPositionUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        AnchorElementMetricsHost_ReportAnchorElementPointerOver_ParamsSpec.$,
        null,
        impl.reportAnchorElementPointerOver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        AnchorElementMetricsHost_ReportAnchorElementPointerOut_ParamsSpec.$,
        null,
        impl.reportAnchorElementPointerOut.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        AnchorElementMetricsHost_ReportAnchorElementPointerDown_ParamsSpec.$,
        null,
        impl.reportAnchorElementPointerDown.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_ParamsSpec.$,
        null,
        impl.reportAnchorElementPointerDataOnHoverTimerFired.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_ParamsSpec.$,
        null,
        impl.processPointerEventUsingMLModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        AnchorElementMetricsHost_ShouldSkipUpdateDelays_ParamsSpec.$,
        AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParamsSpec.$,
        impl.shouldSkipUpdateDelays.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AnchorElementMetricsHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AnchorElementMetricsHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AnchorElementMetricsHostRemote}
   */
  static getRemote() {
    let remote = new AnchorElementMetricsHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AnchorElementMetricsHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AnchorElementMetricsHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AnchorElementMetricsHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AnchorElementMetricsHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAnchorElementClick =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AnchorElementMetricsHost_ReportAnchorElementClick_ParamsSpec.$,
        null,
        this.reportAnchorElementClick.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportNewAnchorElements =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AnchorElementMetricsHost_ReportNewAnchorElements_ParamsSpec.$,
        null,
        this.reportNewAnchorElements.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAnchorElementsEnteredViewport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_ParamsSpec.$,
        null,
        this.reportAnchorElementsEnteredViewport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAnchorElementsLeftViewport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_ParamsSpec.$,
        null,
        this.reportAnchorElementsLeftViewport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAnchorElementsPositionUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_ParamsSpec.$,
        null,
        this.reportAnchorElementsPositionUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAnchorElementPointerOver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        AnchorElementMetricsHost_ReportAnchorElementPointerOver_ParamsSpec.$,
        null,
        this.reportAnchorElementPointerOver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAnchorElementPointerOut =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        AnchorElementMetricsHost_ReportAnchorElementPointerOut_ParamsSpec.$,
        null,
        this.reportAnchorElementPointerOut.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAnchorElementPointerDown =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        AnchorElementMetricsHost_ReportAnchorElementPointerDown_ParamsSpec.$,
        null,
        this.reportAnchorElementPointerDown.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAnchorElementPointerDataOnHoverTimerFired =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_ParamsSpec.$,
        null,
        this.reportAnchorElementPointerDataOnHoverTimerFired.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.processPointerEventUsingMLModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_ParamsSpec.$,
        null,
        this.processPointerEventUsingMLModel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.shouldSkipUpdateDelays =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        AnchorElementMetricsHost_ShouldSkipUpdateDelays_ParamsSpec.$,
        AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParamsSpec.$,
        this.shouldSkipUpdateDelays.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementMetricsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementClickSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementPointerDataOnHoverTimerFiredSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementEnteredViewportSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementLeftViewportSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementPointerOverSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementPointerOutSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementPointerEventForMLModelSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementPointerDownSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementPositionUpdateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementMetricsHost_ReportAnchorElementClick_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementMetricsHost_ReportNewAnchorElements_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementMetricsHost_ReportAnchorElementPointerOver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementMetricsHost_ReportAnchorElementPointerOut_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementMetricsHost_ReportAnchorElementPointerDown_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementMetricsHost_ShouldSkipUpdateDelays_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AnchorElementMetricsSpec.$,
    'AnchorElementMetrics',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ratioArea', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ratioDistanceTopToVisibleTop', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ratioDistanceRootTop', 12,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isInIframe', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'containsImage', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isSameHost', 16,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isUrlIncrementedByOne', 16,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasTextSibling', 16,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fontSizePx', 20,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fontWeight', 24,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetUrl', 32,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'viewportSize', 40,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class AnchorElementMetrics {
  constructor() {
    /** @type { !number } */
    this.anchorId;
    /** @type { !number } */
    this.ratioArea;
    /** @type { !number } */
    this.ratioDistanceTopToVisibleTop;
    /** @type { !number } */
    this.ratioDistanceRootTop;
    /** @type { !boolean } */
    this.isInIframe;
    /** @type { !boolean } */
    this.containsImage;
    /** @type { !boolean } */
    this.isSameHost;
    /** @type { !boolean } */
    this.isUrlIncrementedByOne;
    /** @type { !boolean } */
    this.hasTextSibling;
    /** @type { !number } */
    this.fontSizePx;
    /** @type { !number } */
    this.fontWeight;
    /** @type { !url_mojom_Url } */
    this.targetUrl;
    /** @type { !gfx_mojom_Size } */
    this.viewportSize;
  }
}



mojo.internal.Struct(
    AnchorElementClickSpec.$,
    'AnchorElementClick',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationStartToClick', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AnchorElementClick {
  constructor() {
    /** @type { !number } */
    this.anchorId;
    /** @type { !url_mojom_Url } */
    this.targetUrl;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.navigationStartToClick;
  }
}



mojo.internal.Struct(
    AnchorElementPointerDataOnHoverTimerFiredSpec.$,
    'AnchorElementPointerDataOnHoverTimerFired',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pointerData', 8,
        0,
        blink_mojom_AnchorElementPointerDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AnchorElementPointerDataOnHoverTimerFired {
  constructor() {
    /** @type { !number } */
    this.anchorId;
    /** @type { !blink_mojom_AnchorElementPointerData } */
    this.pointerData;
  }
}



mojo.internal.Struct(
    AnchorElementEnteredViewportSpec.$,
    'AnchorElementEnteredViewport',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationStartToEnteredViewport', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AnchorElementEnteredViewport {
  constructor() {
    /** @type { !number } */
    this.anchorId;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.navigationStartToEnteredViewport;
  }
}



mojo.internal.Struct(
    AnchorElementLeftViewportSpec.$,
    'AnchorElementLeftViewport',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeInViewport', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AnchorElementLeftViewport {
  constructor() {
    /** @type { !number } */
    this.anchorId;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.timeInViewport;
  }
}



mojo.internal.Struct(
    AnchorElementPointerOverSpec.$,
    'AnchorElementPointerOver',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationStartToPointerOver', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AnchorElementPointerOver {
  constructor() {
    /** @type { !number } */
    this.anchorId;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.navigationStartToPointerOver;
  }
}



mojo.internal.Struct(
    AnchorElementPointerOutSpec.$,
    'AnchorElementPointerOut',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hoverDwellTime', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AnchorElementPointerOut {
  constructor() {
    /** @type { !number } */
    this.anchorId;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.hoverDwellTime;
  }
}



mojo.internal.Struct(
    AnchorElementPointerEventForMLModelSpec.$,
    'AnchorElementPointerEventForMLModel',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isMouse', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userInteractionEventType', 8,
        0,
        AnchorElementUserInteractionEventForMLModelTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AnchorElementPointerEventForMLModel {
  constructor() {
    /** @type { !number } */
    this.anchorId;
    /** @type { !boolean } */
    this.isMouse;
    /** @type { !AnchorElementUserInteractionEventForMLModelType } */
    this.userInteractionEventType;
  }
}



mojo.internal.Struct(
    AnchorElementPointerDownSpec.$,
    'AnchorElementPointerDown',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationStartToPointerDown', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AnchorElementPointerDown {
  constructor() {
    /** @type { !number } */
    this.anchorId;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.navigationStartToPointerDown;
  }
}



mojo.internal.Struct(
    AnchorElementPositionUpdateSpec.$,
    'AnchorElementPositionUpdate',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'verticalPositionRatio', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'distance_from_pointer_down_ratio_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "distance_from_pointer_down_ratio_$value",
          originalFieldName: "distanceFromPointerDownRatio",
        }
      ),
      mojo.internal.StructField(
        'distance_from_pointer_down_ratio_$value', 12,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "distanceFromPointerDownRatio",
        }
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AnchorElementPositionUpdate {
  constructor() {
    /** @type { !number } */
    this.anchorId;
    /** @type { !number } */
    this.verticalPositionRatio;
    /** @type { (number|undefined) } */
    this.distanceFromPointerDownRatio;
  }
}



mojo.internal.Struct(
    AnchorElementMetricsHost_ReportAnchorElementClick_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportAnchorElementClick_Params',
    [
      mojo.internal.StructField(
        'clicked', 0,
        0,
        AnchorElementClickSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AnchorElementMetricsHost_ReportAnchorElementClick_Params {
  constructor() {
    /** @type { !AnchorElementClick } */
    this.clicked;
  }
}



mojo.internal.Struct(
    AnchorElementMetricsHost_ReportNewAnchorElements_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportNewAnchorElements_Params',
    [
      mojo.internal.StructField(
        'metrics', 0,
        0,
        mojo.internal.Array(AnchorElementMetricsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'removedElements', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AnchorElementMetricsHost_ReportNewAnchorElements_Params {
  constructor() {
    /** @type { !Array<!AnchorElementMetrics> } */
    this.metrics;
    /** @type { !Array<!number> } */
    this.removedElements;
  }
}



mojo.internal.Struct(
    AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params',
    [
      mojo.internal.StructField(
        'elements', 0,
        0,
        mojo.internal.Array(AnchorElementEnteredViewportSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params {
  constructor() {
    /** @type { !Array<!AnchorElementEnteredViewport> } */
    this.elements;
  }
}



mojo.internal.Struct(
    AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params',
    [
      mojo.internal.StructField(
        'elements', 0,
        0,
        mojo.internal.Array(AnchorElementLeftViewportSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params {
  constructor() {
    /** @type { !Array<!AnchorElementLeftViewport> } */
    this.elements;
  }
}



mojo.internal.Struct(
    AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params',
    [
      mojo.internal.StructField(
        'elements', 0,
        0,
        mojo.internal.Array(AnchorElementPositionUpdateSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params {
  constructor() {
    /** @type { !Array<!AnchorElementPositionUpdate> } */
    this.elements;
  }
}



mojo.internal.Struct(
    AnchorElementMetricsHost_ReportAnchorElementPointerOver_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params',
    [
      mojo.internal.StructField(
        'pointerOverEvent', 0,
        0,
        AnchorElementPointerOverSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params {
  constructor() {
    /** @type { !AnchorElementPointerOver } */
    this.pointerOverEvent;
  }
}



mojo.internal.Struct(
    AnchorElementMetricsHost_ReportAnchorElementPointerOut_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params',
    [
      mojo.internal.StructField(
        'hoverEvent', 0,
        0,
        AnchorElementPointerOutSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params {
  constructor() {
    /** @type { !AnchorElementPointerOut } */
    this.hoverEvent;
  }
}



mojo.internal.Struct(
    AnchorElementMetricsHost_ReportAnchorElementPointerDown_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params',
    [
      mojo.internal.StructField(
        'pointerDownEvent', 0,
        0,
        AnchorElementPointerDownSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params {
  constructor() {
    /** @type { !AnchorElementPointerDown } */
    this.pointerDownEvent;
  }
}



mojo.internal.Struct(
    AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params',
    [
      mojo.internal.StructField(
        'pointerData', 0,
        0,
        AnchorElementPointerDataOnHoverTimerFiredSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params {
  constructor() {
    /** @type { !AnchorElementPointerDataOnHoverTimerFired } */
    this.pointerData;
  }
}



mojo.internal.Struct(
    AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_ParamsSpec.$,
    'AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params',
    [
      mojo.internal.StructField(
        'pointerEvent', 0,
        0,
        AnchorElementPointerEventForMLModelSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params {
  constructor() {
    /** @type { !AnchorElementPointerEventForMLModel } */
    this.pointerEvent;
  }
}



mojo.internal.Struct(
    AnchorElementMetricsHost_ShouldSkipUpdateDelays_ParamsSpec.$,
    'AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParamsSpec.$,
    'AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams',
    [
      mojo.internal.StructField(
        'shouldSkipForTesting', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.shouldSkipForTesting;
  }
}

