// third_party/blink/public/mojom/loader/navigation_predictor.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_NAVIGATION_PREDICTOR_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_NAVIGATION_PREDICTOR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::AnchorElementUserInteractionEventForMLModelType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AnchorElementUserInteractionEventForMLModelType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AnchorElementUserInteractionEventForMLModelType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AnchorElementUserInteractionEventForMLModelType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AnchorElementUserInteractionEventForMLModelType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AnchorElementMetricsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AnchorElementMetricsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AnchorElementMetrics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->anchor_id = Traits::anchor_id(input);

    fragment->ratio_area = Traits::ratio_area(input);

    fragment->ratio_distance_top_to_visible_top = Traits::ratio_distance_top_to_visible_top(input);

    fragment->ratio_distance_root_top = Traits::ratio_distance_root_top(input);

    fragment->is_in_iframe = Traits::is_in_iframe(input);

    fragment->contains_image = Traits::contains_image(input);

    fragment->is_same_host = Traits::is_same_host(input);

    fragment->is_url_incremented_by_one = Traits::is_url_incremented_by_one(input);

    fragment->has_text_sibling = Traits::has_text_sibling(input);

    fragment->font_size_px = Traits::font_size_px(input);

    fragment->font_weight = Traits::font_weight(input);

    decltype(Traits::target_url(input)) in_target_url = Traits::target_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->target_url)::BaseType> target_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_target_url,
      target_url_fragment);

    fragment->target_url.Set(
        target_url_fragment.is_null() ? nullptr : target_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->target_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null target_url in AnchorElementMetrics struct");

    decltype(Traits::viewport_size(input)) in_viewport_size = Traits::viewport_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->viewport_size)::BaseType> viewport_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_viewport_size,
      viewport_size_fragment);

    fragment->viewport_size.Set(
        viewport_size_fragment.is_null() ? nullptr : viewport_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->viewport_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null viewport_size in AnchorElementMetrics struct");
  }

  static bool Deserialize(::blink::mojom::internal::AnchorElementMetrics_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AnchorElementMetricsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AnchorElementClickDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AnchorElementClickDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AnchorElementClick_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->anchor_id = Traits::anchor_id(input);

    decltype(Traits::target_url(input)) in_target_url = Traits::target_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->target_url)::BaseType> target_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_target_url,
      target_url_fragment);

    fragment->target_url.Set(
        target_url_fragment.is_null() ? nullptr : target_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->target_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null target_url in AnchorElementClick struct");

    decltype(Traits::navigation_start_to_click(input)) in_navigation_start_to_click = Traits::navigation_start_to_click(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_start_to_click)::BaseType> navigation_start_to_click_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_navigation_start_to_click,
      navigation_start_to_click_fragment);

    fragment->navigation_start_to_click.Set(
        navigation_start_to_click_fragment.is_null() ? nullptr : navigation_start_to_click_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->navigation_start_to_click.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null navigation_start_to_click in AnchorElementClick struct");
  }

  static bool Deserialize(::blink::mojom::internal::AnchorElementClick_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AnchorElementClickDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AnchorElementPointerDataOnHoverTimerFiredDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AnchorElementPointerDataOnHoverTimerFiredDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AnchorElementPointerDataOnHoverTimerFired_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->anchor_id = Traits::anchor_id(input);

    decltype(Traits::pointer_data(input)) in_pointer_data = Traits::pointer_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pointer_data)::BaseType> pointer_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AnchorElementPointerDataDataView>(
      in_pointer_data,
      pointer_data_fragment);

    fragment->pointer_data.Set(
        pointer_data_fragment.is_null() ? nullptr : pointer_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pointer_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pointer_data in AnchorElementPointerDataOnHoverTimerFired struct");
  }

  static bool Deserialize(::blink::mojom::internal::AnchorElementPointerDataOnHoverTimerFired_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AnchorElementPointerDataOnHoverTimerFiredDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AnchorElementEnteredViewportDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AnchorElementEnteredViewportDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AnchorElementEnteredViewport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->anchor_id = Traits::anchor_id(input);

    decltype(Traits::navigation_start_to_entered_viewport(input)) in_navigation_start_to_entered_viewport = Traits::navigation_start_to_entered_viewport(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_start_to_entered_viewport)::BaseType> navigation_start_to_entered_viewport_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_navigation_start_to_entered_viewport,
      navigation_start_to_entered_viewport_fragment);

    fragment->navigation_start_to_entered_viewport.Set(
        navigation_start_to_entered_viewport_fragment.is_null() ? nullptr : navigation_start_to_entered_viewport_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->navigation_start_to_entered_viewport.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null navigation_start_to_entered_viewport in AnchorElementEnteredViewport struct");
  }

  static bool Deserialize(::blink::mojom::internal::AnchorElementEnteredViewport_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AnchorElementEnteredViewportDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AnchorElementLeftViewportDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AnchorElementLeftViewportDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AnchorElementLeftViewport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->anchor_id = Traits::anchor_id(input);

    decltype(Traits::time_in_viewport(input)) in_time_in_viewport = Traits::time_in_viewport(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->time_in_viewport)::BaseType> time_in_viewport_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_time_in_viewport,
      time_in_viewport_fragment);

    fragment->time_in_viewport.Set(
        time_in_viewport_fragment.is_null() ? nullptr : time_in_viewport_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->time_in_viewport.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null time_in_viewport in AnchorElementLeftViewport struct");
  }

  static bool Deserialize(::blink::mojom::internal::AnchorElementLeftViewport_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AnchorElementLeftViewportDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AnchorElementPointerOverDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AnchorElementPointerOverDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AnchorElementPointerOver_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->anchor_id = Traits::anchor_id(input);

    decltype(Traits::navigation_start_to_pointer_over(input)) in_navigation_start_to_pointer_over = Traits::navigation_start_to_pointer_over(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_start_to_pointer_over)::BaseType> navigation_start_to_pointer_over_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_navigation_start_to_pointer_over,
      navigation_start_to_pointer_over_fragment);

    fragment->navigation_start_to_pointer_over.Set(
        navigation_start_to_pointer_over_fragment.is_null() ? nullptr : navigation_start_to_pointer_over_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->navigation_start_to_pointer_over.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null navigation_start_to_pointer_over in AnchorElementPointerOver struct");
  }

  static bool Deserialize(::blink::mojom::internal::AnchorElementPointerOver_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AnchorElementPointerOverDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AnchorElementPointerOutDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AnchorElementPointerOutDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AnchorElementPointerOut_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->anchor_id = Traits::anchor_id(input);

    decltype(Traits::hover_dwell_time(input)) in_hover_dwell_time = Traits::hover_dwell_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hover_dwell_time)::BaseType> hover_dwell_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_hover_dwell_time,
      hover_dwell_time_fragment);

    fragment->hover_dwell_time.Set(
        hover_dwell_time_fragment.is_null() ? nullptr : hover_dwell_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hover_dwell_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hover_dwell_time in AnchorElementPointerOut struct");
  }

  static bool Deserialize(::blink::mojom::internal::AnchorElementPointerOut_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AnchorElementPointerOutDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AnchorElementPointerEventForMLModelDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AnchorElementPointerEventForMLModelDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AnchorElementPointerEventForMLModel_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->anchor_id = Traits::anchor_id(input);

    fragment->is_mouse = Traits::is_mouse(input);

    
    mojo::internal::Serialize<::blink::mojom::AnchorElementUserInteractionEventForMLModelType>(
      Traits::user_interaction_event_type(input),
      &fragment->user_interaction_event_type);
  }

  static bool Deserialize(::blink::mojom::internal::AnchorElementPointerEventForMLModel_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AnchorElementPointerEventForMLModelDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AnchorElementPointerDownDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AnchorElementPointerDownDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AnchorElementPointerDown_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->anchor_id = Traits::anchor_id(input);

    decltype(Traits::navigation_start_to_pointer_down(input)) in_navigation_start_to_pointer_down = Traits::navigation_start_to_pointer_down(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_start_to_pointer_down)::BaseType> navigation_start_to_pointer_down_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_navigation_start_to_pointer_down,
      navigation_start_to_pointer_down_fragment);

    fragment->navigation_start_to_pointer_down.Set(
        navigation_start_to_pointer_down_fragment.is_null() ? nullptr : navigation_start_to_pointer_down_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->navigation_start_to_pointer_down.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null navigation_start_to_pointer_down in AnchorElementPointerDown struct");
  }

  static bool Deserialize(::blink::mojom::internal::AnchorElementPointerDown_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AnchorElementPointerDownDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AnchorElementPositionUpdateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AnchorElementPositionUpdateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AnchorElementPositionUpdate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->anchor_id = Traits::anchor_id(input);

    fragment->vertical_position_ratio = Traits::vertical_position_ratio(input);
    fragment->distance_from_pointer_down_ratio_$flag = Traits::distance_from_pointer_down_ratio(input).has_value();
    if (Traits::distance_from_pointer_down_ratio(input).has_value()) {
      fragment->distance_from_pointer_down_ratio_$value = Traits::distance_from_pointer_down_ratio(input).value();
    }
  }

  static bool Deserialize(::blink::mojom::internal::AnchorElementPositionUpdate_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AnchorElementPositionUpdateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void AnchorElementMetricsDataView::GetTargetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->target_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AnchorElementMetricsDataView::GetViewportSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->viewport_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void AnchorElementClickDataView::GetTargetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->target_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AnchorElementClickDataView::GetNavigationStartToClickDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->navigation_start_to_click.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void AnchorElementPointerDataOnHoverTimerFiredDataView::GetPointerDataDataView(
    ::blink::mojom::AnchorElementPointerDataDataView* output) {
  auto pointer = data_->pointer_data.Get();
  *output = ::blink::mojom::AnchorElementPointerDataDataView(pointer, message_);
}


inline void AnchorElementEnteredViewportDataView::GetNavigationStartToEnteredViewportDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->navigation_start_to_entered_viewport.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void AnchorElementLeftViewportDataView::GetTimeInViewportDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->time_in_viewport.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void AnchorElementPointerOverDataView::GetNavigationStartToPointerOverDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->navigation_start_to_pointer_over.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void AnchorElementPointerOutDataView::GetHoverDwellTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->hover_dwell_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}




inline void AnchorElementPointerDownDataView::GetNavigationStartToPointerDownDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->navigation_start_to_pointer_down.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}





}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AnchorElementUserInteractionEventForMLModelType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AnchorElementUserInteractionEventForMLModelType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_NAVIGATION_PREDICTOR_MOJOM_SHARED_H_