// third_party/blink/public/mojom/loader/navigation_predictor.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_NAVIGATION_PREDICTOR_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_NAVIGATION_PREDICTOR_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom-shared.h"


namespace blink::mojom {
class AnchorElementMetricsDataView;

class AnchorElementClickDataView;

class AnchorElementPointerDataOnHoverTimerFiredDataView;

class AnchorElementEnteredViewportDataView;

class AnchorElementLeftViewportDataView;

class AnchorElementPointerOverDataView;

class AnchorElementPointerOutDataView;

class AnchorElementPointerEventForMLModelDataView;

class AnchorElementPointerDownDataView;

class AnchorElementPositionUpdateDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AnchorElementMetricsDataView> {
  using Data = ::blink::mojom::internal::AnchorElementMetrics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AnchorElementClickDataView> {
  using Data = ::blink::mojom::internal::AnchorElementClick_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AnchorElementPointerDataOnHoverTimerFiredDataView> {
  using Data = ::blink::mojom::internal::AnchorElementPointerDataOnHoverTimerFired_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AnchorElementEnteredViewportDataView> {
  using Data = ::blink::mojom::internal::AnchorElementEnteredViewport_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AnchorElementLeftViewportDataView> {
  using Data = ::blink::mojom::internal::AnchorElementLeftViewport_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AnchorElementPointerOverDataView> {
  using Data = ::blink::mojom::internal::AnchorElementPointerOver_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AnchorElementPointerOutDataView> {
  using Data = ::blink::mojom::internal::AnchorElementPointerOut_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AnchorElementPointerEventForMLModelDataView> {
  using Data = ::blink::mojom::internal::AnchorElementPointerEventForMLModel_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AnchorElementPointerDownDataView> {
  using Data = ::blink::mojom::internal::AnchorElementPointerDown_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AnchorElementPositionUpdateDataView> {
  using Data = ::blink::mojom::internal::AnchorElementPositionUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class AnchorElementUserInteractionEventForMLModelType : int32_t {
  
  kPointerOver = 0,
  
  kPointerOut = 1,
  
  kEnteredViewport = 2,
  
  kLeftViewport = 3,
  
  kUnknown = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AnchorElementUserInteractionEventForMLModelType value);
inline bool IsKnownEnumValue(AnchorElementUserInteractionEventForMLModelType value) {
  return internal::AnchorElementUserInteractionEventForMLModelType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class AnchorElementMetricsHostInterfaceBase {};

using AnchorElementMetricsHostPtrDataView =
    mojo::InterfacePtrDataView<AnchorElementMetricsHostInterfaceBase>;
using AnchorElementMetricsHostRequestDataView =
    mojo::InterfaceRequestDataView<AnchorElementMetricsHostInterfaceBase>;
using AnchorElementMetricsHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AnchorElementMetricsHostInterfaceBase>;
using AnchorElementMetricsHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AnchorElementMetricsHostInterfaceBase>;


class AnchorElementMetricsDataView {
 public:
  AnchorElementMetricsDataView() = default;

  AnchorElementMetricsDataView(
      internal::AnchorElementMetrics_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t anchor_id() const {
    return data_->anchor_id;
  }
  float ratio_area() const {
    return data_->ratio_area;
  }
  float ratio_distance_top_to_visible_top() const {
    return data_->ratio_distance_top_to_visible_top;
  }
  float ratio_distance_root_top() const {
    return data_->ratio_distance_root_top;
  }
  bool is_in_iframe() const {
    return data_->is_in_iframe;
  }
  bool contains_image() const {
    return data_->contains_image;
  }
  bool is_same_host() const {
    return data_->is_same_host;
  }
  bool is_url_incremented_by_one() const {
    return data_->is_url_incremented_by_one;
  }
  bool has_text_sibling() const {
    return data_->has_text_sibling;
  }
  uint32_t font_size_px() const {
    return data_->font_size_px;
  }
  uint32_t font_weight() const {
    return data_->font_weight;
  }
  inline void GetTargetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetUrl(UserType* output) {
    
    auto* pointer = data_->target_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetViewportSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewportSize(UserType* output) {
    
    auto* pointer = data_->viewport_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
 private:
  internal::AnchorElementMetrics_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnchorElementClickDataView {
 public:
  AnchorElementClickDataView() = default;

  AnchorElementClickDataView(
      internal::AnchorElementClick_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t anchor_id() const {
    return data_->anchor_id;
  }
  inline void GetTargetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetUrl(UserType* output) {
    
    auto* pointer = data_->target_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetNavigationStartToClickDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationStartToClick(UserType* output) {
    
    auto* pointer = data_->navigation_start_to_click.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::AnchorElementClick_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnchorElementPointerDataOnHoverTimerFiredDataView {
 public:
  AnchorElementPointerDataOnHoverTimerFiredDataView() = default;

  AnchorElementPointerDataOnHoverTimerFiredDataView(
      internal::AnchorElementPointerDataOnHoverTimerFired_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t anchor_id() const {
    return data_->anchor_id;
  }
  inline void GetPointerDataDataView(
      ::blink::mojom::AnchorElementPointerDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPointerData(UserType* output) {
    
    auto* pointer = data_->pointer_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::AnchorElementPointerDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::AnchorElementPointerDataOnHoverTimerFired_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnchorElementEnteredViewportDataView {
 public:
  AnchorElementEnteredViewportDataView() = default;

  AnchorElementEnteredViewportDataView(
      internal::AnchorElementEnteredViewport_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t anchor_id() const {
    return data_->anchor_id;
  }
  inline void GetNavigationStartToEnteredViewportDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationStartToEnteredViewport(UserType* output) {
    
    auto* pointer = data_->navigation_start_to_entered_viewport.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::AnchorElementEnteredViewport_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnchorElementLeftViewportDataView {
 public:
  AnchorElementLeftViewportDataView() = default;

  AnchorElementLeftViewportDataView(
      internal::AnchorElementLeftViewport_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t anchor_id() const {
    return data_->anchor_id;
  }
  inline void GetTimeInViewportDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeInViewport(UserType* output) {
    
    auto* pointer = data_->time_in_viewport.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::AnchorElementLeftViewport_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnchorElementPointerOverDataView {
 public:
  AnchorElementPointerOverDataView() = default;

  AnchorElementPointerOverDataView(
      internal::AnchorElementPointerOver_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t anchor_id() const {
    return data_->anchor_id;
  }
  inline void GetNavigationStartToPointerOverDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationStartToPointerOver(UserType* output) {
    
    auto* pointer = data_->navigation_start_to_pointer_over.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::AnchorElementPointerOver_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnchorElementPointerOutDataView {
 public:
  AnchorElementPointerOutDataView() = default;

  AnchorElementPointerOutDataView(
      internal::AnchorElementPointerOut_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t anchor_id() const {
    return data_->anchor_id;
  }
  inline void GetHoverDwellTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHoverDwellTime(UserType* output) {
    
    auto* pointer = data_->hover_dwell_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::AnchorElementPointerOut_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnchorElementPointerEventForMLModelDataView {
 public:
  AnchorElementPointerEventForMLModelDataView() = default;

  AnchorElementPointerEventForMLModelDataView(
      internal::AnchorElementPointerEventForMLModel_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t anchor_id() const {
    return data_->anchor_id;
  }
  bool is_mouse() const {
    return data_->is_mouse;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUserInteractionEventType(UserType* output) const {
    auto data_value = data_->user_interaction_event_type;
    return mojo::internal::Deserialize<::blink::mojom::AnchorElementUserInteractionEventForMLModelType>(
        data_value, output);
  }
  AnchorElementUserInteractionEventForMLModelType user_interaction_event_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AnchorElementUserInteractionEventForMLModelType>(data_->user_interaction_event_type));
  }
 private:
  internal::AnchorElementPointerEventForMLModel_Data* data_ = nullptr;
};


class AnchorElementPointerDownDataView {
 public:
  AnchorElementPointerDownDataView() = default;

  AnchorElementPointerDownDataView(
      internal::AnchorElementPointerDown_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t anchor_id() const {
    return data_->anchor_id;
  }
  inline void GetNavigationStartToPointerDownDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationStartToPointerDown(UserType* output) {
    
    auto* pointer = data_->navigation_start_to_pointer_down.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::AnchorElementPointerDown_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnchorElementPositionUpdateDataView {
 public:
  AnchorElementPositionUpdateDataView() = default;

  AnchorElementPositionUpdateDataView(
      internal::AnchorElementPositionUpdate_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t anchor_id() const {
    return data_->anchor_id;
  }
  float vertical_position_ratio() const {
    return data_->vertical_position_ratio;
  }
  std::optional<float> distance_from_pointer_down_ratio() const {

    return data_->distance_from_pointer_down_ratio_$flag
        ? std::make_optional(data_->distance_from_pointer_down_ratio_$value)
        : std::nullopt;
  }
 private:
  internal::AnchorElementPositionUpdate_Data* data_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_NAVIGATION_PREDICTOR_MOJOM_DATA_VIEW_H_