// third_party/blink/public/mojom/loader/navigation_predictor.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_NAVIGATION_PREDICTOR_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_NAVIGATION_PREDICTOR_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class AnchorElementMetricsHostProxy;

template <typename ImplRefTraits>
class AnchorElementMetricsHostStub;

class AnchorElementMetricsHostRequestValidator;
class AnchorElementMetricsHostResponseValidator;


class PLATFORM_EXPORT AnchorElementMetricsHost
    : public AnchorElementMetricsHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.AnchorElementMetricsHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AnchorElementMetricsHostInterfaceBase;
  using Proxy_ = AnchorElementMetricsHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = AnchorElementMetricsHostStub<ImplRefTraits>;

  using RequestValidator_ = AnchorElementMetricsHostRequestValidator;
  using ResponseValidator_ = AnchorElementMetricsHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReportAnchorElementClickMinVersion = 0,
    kReportNewAnchorElementsMinVersion = 0,
    kReportAnchorElementsEnteredViewportMinVersion = 0,
    kReportAnchorElementsLeftViewportMinVersion = 0,
    kReportAnchorElementsPositionUpdateMinVersion = 0,
    kReportAnchorElementPointerOverMinVersion = 0,
    kReportAnchorElementPointerOutMinVersion = 0,
    kReportAnchorElementPointerDownMinVersion = 0,
    kReportAnchorElementPointerDataOnHoverTimerFiredMinVersion = 0,
    kProcessPointerEventUsingMLModelMinVersion = 0,
    kShouldSkipUpdateDelaysMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ReportAnchorElementClick_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportNewAnchorElements_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportAnchorElementsEnteredViewport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportAnchorElementsLeftViewport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportAnchorElementsPositionUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportAnchorElementPointerOver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportAnchorElementPointerOut_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportAnchorElementPointerDown_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportAnchorElementPointerDataOnHoverTimerFired_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ProcessPointerEventUsingMLModel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShouldSkipUpdateDelays_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AnchorElementMetricsHost() = default;

  virtual void ReportAnchorElementClick(AnchorElementClickPtr clicked) = 0;

  virtual void ReportNewAnchorElements(::blink::Vector<AnchorElementMetricsPtr> metrics, const ::blink::Vector<uint32_t>& removed_elements) = 0;

  virtual void ReportAnchorElementsEnteredViewport(::blink::Vector<AnchorElementEnteredViewportPtr> elements) = 0;

  virtual void ReportAnchorElementsLeftViewport(::blink::Vector<AnchorElementLeftViewportPtr> elements) = 0;

  virtual void ReportAnchorElementsPositionUpdate(::blink::Vector<AnchorElementPositionUpdatePtr> elements) = 0;

  virtual void ReportAnchorElementPointerOver(AnchorElementPointerOverPtr pointer_over_event) = 0;

  virtual void ReportAnchorElementPointerOut(AnchorElementPointerOutPtr hover_event) = 0;

  virtual void ReportAnchorElementPointerDown(AnchorElementPointerDownPtr pointer_down_event) = 0;

  virtual void ReportAnchorElementPointerDataOnHoverTimerFired(AnchorElementPointerDataOnHoverTimerFiredPtr pointer_data) = 0;

  virtual void ProcessPointerEventUsingMLModel(AnchorElementPointerEventForMLModelPtr pointer_event) = 0;

  using ShouldSkipUpdateDelaysCallback = base::OnceCallback<void(bool)>;
  using ShouldSkipUpdateDelaysMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ShouldSkipUpdateDelays(ShouldSkipUpdateDelaysCallback callback) = 0;
};



class PLATFORM_EXPORT AnchorElementMetricsHostProxy
    : public AnchorElementMetricsHost {
 public:
  using InterfaceType = AnchorElementMetricsHost;

  explicit AnchorElementMetricsHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReportAnchorElementClick(AnchorElementClickPtr clicked) final;
  
  void ReportNewAnchorElements(::blink::Vector<AnchorElementMetricsPtr> metrics, const ::blink::Vector<uint32_t>& removed_elements) final;
  
  void ReportAnchorElementsEnteredViewport(::blink::Vector<AnchorElementEnteredViewportPtr> elements) final;
  
  void ReportAnchorElementsLeftViewport(::blink::Vector<AnchorElementLeftViewportPtr> elements) final;
  
  void ReportAnchorElementsPositionUpdate(::blink::Vector<AnchorElementPositionUpdatePtr> elements) final;
  
  void ReportAnchorElementPointerOver(AnchorElementPointerOverPtr pointer_over_event) final;
  
  void ReportAnchorElementPointerOut(AnchorElementPointerOutPtr hover_event) final;
  
  void ReportAnchorElementPointerDown(AnchorElementPointerDownPtr pointer_down_event) final;
  
  void ReportAnchorElementPointerDataOnHoverTimerFired(AnchorElementPointerDataOnHoverTimerFiredPtr pointer_data) final;
  
  void ProcessPointerEventUsingMLModel(AnchorElementPointerEventForMLModelPtr pointer_event) final;
  
  void ShouldSkipUpdateDelays(ShouldSkipUpdateDelaysCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT AnchorElementMetricsHostStubDispatch {
 public:
  static bool Accept(AnchorElementMetricsHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AnchorElementMetricsHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AnchorElementMetricsHost>>
class AnchorElementMetricsHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AnchorElementMetricsHostStub() = default;
  ~AnchorElementMetricsHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AnchorElementMetricsHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AnchorElementMetricsHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT AnchorElementMetricsHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT AnchorElementMetricsHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};












class PLATFORM_EXPORT AnchorElementPointerEventForMLModel {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnchorElementPointerEventForMLModel, T>::value>;
  using DataView = AnchorElementPointerEventForMLModelDataView;
  using Data_ = internal::AnchorElementPointerEventForMLModel_Data;

  template <typename... Args>
  static AnchorElementPointerEventForMLModelPtr New(Args&&... args) {
    return AnchorElementPointerEventForMLModelPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnchorElementPointerEventForMLModelPtr From(const U& u) {
    return mojo::TypeConverter<AnchorElementPointerEventForMLModelPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnchorElementPointerEventForMLModel>::Convert(*this);
  }


  AnchorElementPointerEventForMLModel();

  AnchorElementPointerEventForMLModel(
      uint32_t anchor_id,
      bool is_mouse,
      AnchorElementUserInteractionEventForMLModelType user_interaction_event_type);


  ~AnchorElementPointerEventForMLModel();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnchorElementPointerEventForMLModelPtr>
  AnchorElementPointerEventForMLModelPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnchorElementPointerEventForMLModel::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnchorElementPointerEventForMLModel::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnchorElementPointerEventForMLModel::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementPointerEventForMLModel::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementPointerEventForMLModel::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnchorElementPointerEventForMLModel::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnchorElementPointerEventForMLModel_UnserializedMessageContext<
            UserType, AnchorElementPointerEventForMLModel::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnchorElementPointerEventForMLModel::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnchorElementPointerEventForMLModel::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnchorElementPointerEventForMLModel_UnserializedMessageContext<
            UserType, AnchorElementPointerEventForMLModel::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnchorElementPointerEventForMLModel::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t anchor_id;
  
  bool is_mouse;
  
  AnchorElementUserInteractionEventForMLModelType user_interaction_event_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnchorElementPointerEventForMLModel::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnchorElementPointerEventForMLModel::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnchorElementPointerEventForMLModel::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnchorElementPointerEventForMLModel::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT AnchorElementPositionUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnchorElementPositionUpdate, T>::value>;
  using DataView = AnchorElementPositionUpdateDataView;
  using Data_ = internal::AnchorElementPositionUpdate_Data;

  template <typename... Args>
  static AnchorElementPositionUpdatePtr New(Args&&... args) {
    return AnchorElementPositionUpdatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnchorElementPositionUpdatePtr From(const U& u) {
    return mojo::TypeConverter<AnchorElementPositionUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnchorElementPositionUpdate>::Convert(*this);
  }


  AnchorElementPositionUpdate();

  AnchorElementPositionUpdate(
      uint32_t anchor_id,
      float vertical_position_ratio,
      std::optional<float> distance_from_pointer_down_ratio);


  ~AnchorElementPositionUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnchorElementPositionUpdatePtr>
  AnchorElementPositionUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnchorElementPositionUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnchorElementPositionUpdate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnchorElementPositionUpdate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementPositionUpdate::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementPositionUpdate::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnchorElementPositionUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnchorElementPositionUpdate_UnserializedMessageContext<
            UserType, AnchorElementPositionUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnchorElementPositionUpdate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnchorElementPositionUpdate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnchorElementPositionUpdate_UnserializedMessageContext<
            UserType, AnchorElementPositionUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnchorElementPositionUpdate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t anchor_id;
  
  float vertical_position_ratio;
  
  std::optional<float> distance_from_pointer_down_ratio;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnchorElementPositionUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnchorElementPositionUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnchorElementPositionUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnchorElementPositionUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class PLATFORM_EXPORT AnchorElementMetrics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnchorElementMetrics, T>::value>;
  using DataView = AnchorElementMetricsDataView;
  using Data_ = internal::AnchorElementMetrics_Data;

  template <typename... Args>
  static AnchorElementMetricsPtr New(Args&&... args) {
    return AnchorElementMetricsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnchorElementMetricsPtr From(const U& u) {
    return mojo::TypeConverter<AnchorElementMetricsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnchorElementMetrics>::Convert(*this);
  }


  AnchorElementMetrics();

  AnchorElementMetrics(
      uint32_t anchor_id,
      float ratio_area,
      float ratio_distance_top_to_visible_top,
      float ratio_distance_root_top,
      bool is_in_iframe,
      bool contains_image,
      bool is_same_host,
      bool is_url_incremented_by_one,
      bool has_text_sibling,
      uint32_t font_size_px,
      uint32_t font_weight,
      const ::blink::KURL& target_url,
      const ::gfx::Size& viewport_size);


  ~AnchorElementMetrics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnchorElementMetricsPtr>
  AnchorElementMetricsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnchorElementMetrics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnchorElementMetrics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnchorElementMetrics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementMetrics::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementMetrics::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnchorElementMetrics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnchorElementMetrics_UnserializedMessageContext<
            UserType, AnchorElementMetrics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnchorElementMetrics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnchorElementMetrics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnchorElementMetrics_UnserializedMessageContext<
            UserType, AnchorElementMetrics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnchorElementMetrics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t anchor_id;
  
  float ratio_area;
  
  float ratio_distance_top_to_visible_top;
  
  float ratio_distance_root_top;
  
  bool is_in_iframe;
  
  bool contains_image;
  
  bool is_same_host;
  
  bool is_url_incremented_by_one;
  
  bool has_text_sibling;
  
  uint32_t font_size_px;
  
  uint32_t font_weight;
  
  ::blink::KURL target_url;
  
  ::gfx::Size viewport_size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnchorElementMetrics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnchorElementMetrics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnchorElementMetrics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnchorElementMetrics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AnchorElementClick {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnchorElementClick, T>::value>;
  using DataView = AnchorElementClickDataView;
  using Data_ = internal::AnchorElementClick_Data;

  template <typename... Args>
  static AnchorElementClickPtr New(Args&&... args) {
    return AnchorElementClickPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnchorElementClickPtr From(const U& u) {
    return mojo::TypeConverter<AnchorElementClickPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnchorElementClick>::Convert(*this);
  }


  AnchorElementClick();

  AnchorElementClick(
      uint32_t anchor_id,
      const ::blink::KURL& target_url,
      ::base::TimeDelta navigation_start_to_click);


  ~AnchorElementClick();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnchorElementClickPtr>
  AnchorElementClickPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnchorElementClick::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnchorElementClick::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnchorElementClick::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementClick::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementClick::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnchorElementClick::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnchorElementClick_UnserializedMessageContext<
            UserType, AnchorElementClick::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnchorElementClick::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnchorElementClick::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnchorElementClick_UnserializedMessageContext<
            UserType, AnchorElementClick::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnchorElementClick::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t anchor_id;
  
  ::blink::KURL target_url;
  
  ::base::TimeDelta navigation_start_to_click;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnchorElementClick::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnchorElementClick::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnchorElementClick::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnchorElementClick::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AnchorElementPointerDataOnHoverTimerFired {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnchorElementPointerDataOnHoverTimerFired, T>::value>;
  using DataView = AnchorElementPointerDataOnHoverTimerFiredDataView;
  using Data_ = internal::AnchorElementPointerDataOnHoverTimerFired_Data;

  template <typename... Args>
  static AnchorElementPointerDataOnHoverTimerFiredPtr New(Args&&... args) {
    return AnchorElementPointerDataOnHoverTimerFiredPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnchorElementPointerDataOnHoverTimerFiredPtr From(const U& u) {
    return mojo::TypeConverter<AnchorElementPointerDataOnHoverTimerFiredPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnchorElementPointerDataOnHoverTimerFired>::Convert(*this);
  }


  AnchorElementPointerDataOnHoverTimerFired();

  AnchorElementPointerDataOnHoverTimerFired(
      uint32_t anchor_id,
      ::blink::mojom::blink::AnchorElementPointerDataPtr pointer_data);

AnchorElementPointerDataOnHoverTimerFired(const AnchorElementPointerDataOnHoverTimerFired&) = delete;
AnchorElementPointerDataOnHoverTimerFired& operator=(const AnchorElementPointerDataOnHoverTimerFired&) = delete;

  ~AnchorElementPointerDataOnHoverTimerFired();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnchorElementPointerDataOnHoverTimerFiredPtr>
  AnchorElementPointerDataOnHoverTimerFiredPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnchorElementPointerDataOnHoverTimerFired::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnchorElementPointerDataOnHoverTimerFired::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnchorElementPointerDataOnHoverTimerFired::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementPointerDataOnHoverTimerFired::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementPointerDataOnHoverTimerFired::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnchorElementPointerDataOnHoverTimerFired::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnchorElementPointerDataOnHoverTimerFired_UnserializedMessageContext<
            UserType, AnchorElementPointerDataOnHoverTimerFired::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnchorElementPointerDataOnHoverTimerFired::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnchorElementPointerDataOnHoverTimerFired::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnchorElementPointerDataOnHoverTimerFired_UnserializedMessageContext<
            UserType, AnchorElementPointerDataOnHoverTimerFired::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnchorElementPointerDataOnHoverTimerFired::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t anchor_id;
  
  ::blink::mojom::blink::AnchorElementPointerDataPtr pointer_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnchorElementPointerDataOnHoverTimerFired::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnchorElementPointerDataOnHoverTimerFired::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnchorElementPointerDataOnHoverTimerFired::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnchorElementPointerDataOnHoverTimerFired::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AnchorElementEnteredViewport {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnchorElementEnteredViewport, T>::value>;
  using DataView = AnchorElementEnteredViewportDataView;
  using Data_ = internal::AnchorElementEnteredViewport_Data;

  template <typename... Args>
  static AnchorElementEnteredViewportPtr New(Args&&... args) {
    return AnchorElementEnteredViewportPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnchorElementEnteredViewportPtr From(const U& u) {
    return mojo::TypeConverter<AnchorElementEnteredViewportPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnchorElementEnteredViewport>::Convert(*this);
  }


  AnchorElementEnteredViewport();

  AnchorElementEnteredViewport(
      uint32_t anchor_id,
      ::base::TimeDelta navigation_start_to_entered_viewport);


  ~AnchorElementEnteredViewport();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnchorElementEnteredViewportPtr>
  AnchorElementEnteredViewportPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnchorElementEnteredViewport::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnchorElementEnteredViewport::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnchorElementEnteredViewport::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementEnteredViewport::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementEnteredViewport::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnchorElementEnteredViewport::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnchorElementEnteredViewport_UnserializedMessageContext<
            UserType, AnchorElementEnteredViewport::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnchorElementEnteredViewport::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnchorElementEnteredViewport::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnchorElementEnteredViewport_UnserializedMessageContext<
            UserType, AnchorElementEnteredViewport::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnchorElementEnteredViewport::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t anchor_id;
  
  ::base::TimeDelta navigation_start_to_entered_viewport;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnchorElementEnteredViewport::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnchorElementEnteredViewport::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnchorElementEnteredViewport::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnchorElementEnteredViewport::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AnchorElementLeftViewport {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnchorElementLeftViewport, T>::value>;
  using DataView = AnchorElementLeftViewportDataView;
  using Data_ = internal::AnchorElementLeftViewport_Data;

  template <typename... Args>
  static AnchorElementLeftViewportPtr New(Args&&... args) {
    return AnchorElementLeftViewportPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnchorElementLeftViewportPtr From(const U& u) {
    return mojo::TypeConverter<AnchorElementLeftViewportPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnchorElementLeftViewport>::Convert(*this);
  }


  AnchorElementLeftViewport();

  AnchorElementLeftViewport(
      uint32_t anchor_id,
      ::base::TimeDelta time_in_viewport);


  ~AnchorElementLeftViewport();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnchorElementLeftViewportPtr>
  AnchorElementLeftViewportPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnchorElementLeftViewport::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnchorElementLeftViewport::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnchorElementLeftViewport::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementLeftViewport::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementLeftViewport::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnchorElementLeftViewport::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnchorElementLeftViewport_UnserializedMessageContext<
            UserType, AnchorElementLeftViewport::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnchorElementLeftViewport::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnchorElementLeftViewport::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnchorElementLeftViewport_UnserializedMessageContext<
            UserType, AnchorElementLeftViewport::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnchorElementLeftViewport::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t anchor_id;
  
  ::base::TimeDelta time_in_viewport;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnchorElementLeftViewport::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnchorElementLeftViewport::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnchorElementLeftViewport::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnchorElementLeftViewport::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AnchorElementPointerOver {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnchorElementPointerOver, T>::value>;
  using DataView = AnchorElementPointerOverDataView;
  using Data_ = internal::AnchorElementPointerOver_Data;

  template <typename... Args>
  static AnchorElementPointerOverPtr New(Args&&... args) {
    return AnchorElementPointerOverPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnchorElementPointerOverPtr From(const U& u) {
    return mojo::TypeConverter<AnchorElementPointerOverPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnchorElementPointerOver>::Convert(*this);
  }


  AnchorElementPointerOver();

  AnchorElementPointerOver(
      uint32_t anchor_id,
      ::base::TimeDelta navigation_start_to_pointer_over);


  ~AnchorElementPointerOver();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnchorElementPointerOverPtr>
  AnchorElementPointerOverPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnchorElementPointerOver::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnchorElementPointerOver::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnchorElementPointerOver::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementPointerOver::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementPointerOver::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnchorElementPointerOver::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnchorElementPointerOver_UnserializedMessageContext<
            UserType, AnchorElementPointerOver::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnchorElementPointerOver::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnchorElementPointerOver::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnchorElementPointerOver_UnserializedMessageContext<
            UserType, AnchorElementPointerOver::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnchorElementPointerOver::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t anchor_id;
  
  ::base::TimeDelta navigation_start_to_pointer_over;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnchorElementPointerOver::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnchorElementPointerOver::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnchorElementPointerOver::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnchorElementPointerOver::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AnchorElementPointerOut {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnchorElementPointerOut, T>::value>;
  using DataView = AnchorElementPointerOutDataView;
  using Data_ = internal::AnchorElementPointerOut_Data;

  template <typename... Args>
  static AnchorElementPointerOutPtr New(Args&&... args) {
    return AnchorElementPointerOutPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnchorElementPointerOutPtr From(const U& u) {
    return mojo::TypeConverter<AnchorElementPointerOutPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnchorElementPointerOut>::Convert(*this);
  }


  AnchorElementPointerOut();

  AnchorElementPointerOut(
      uint32_t anchor_id,
      ::base::TimeDelta hover_dwell_time);


  ~AnchorElementPointerOut();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnchorElementPointerOutPtr>
  AnchorElementPointerOutPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnchorElementPointerOut::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnchorElementPointerOut::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnchorElementPointerOut::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementPointerOut::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementPointerOut::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnchorElementPointerOut::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnchorElementPointerOut_UnserializedMessageContext<
            UserType, AnchorElementPointerOut::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnchorElementPointerOut::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnchorElementPointerOut::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnchorElementPointerOut_UnserializedMessageContext<
            UserType, AnchorElementPointerOut::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnchorElementPointerOut::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t anchor_id;
  
  ::base::TimeDelta hover_dwell_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnchorElementPointerOut::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnchorElementPointerOut::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnchorElementPointerOut::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnchorElementPointerOut::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT AnchorElementPointerDown {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnchorElementPointerDown, T>::value>;
  using DataView = AnchorElementPointerDownDataView;
  using Data_ = internal::AnchorElementPointerDown_Data;

  template <typename... Args>
  static AnchorElementPointerDownPtr New(Args&&... args) {
    return AnchorElementPointerDownPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnchorElementPointerDownPtr From(const U& u) {
    return mojo::TypeConverter<AnchorElementPointerDownPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnchorElementPointerDown>::Convert(*this);
  }


  AnchorElementPointerDown();

  AnchorElementPointerDown(
      uint32_t anchor_id,
      ::base::TimeDelta navigation_start_to_pointer_down);


  ~AnchorElementPointerDown();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnchorElementPointerDownPtr>
  AnchorElementPointerDownPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnchorElementPointerDown::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnchorElementPointerDown::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnchorElementPointerDown::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementPointerDown::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementPointerDown::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnchorElementPointerDown::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnchorElementPointerDown_UnserializedMessageContext<
            UserType, AnchorElementPointerDown::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnchorElementPointerDown::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnchorElementPointerDown::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnchorElementPointerDown_UnserializedMessageContext<
            UserType, AnchorElementPointerDown::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnchorElementPointerDown::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t anchor_id;
  
  ::base::TimeDelta navigation_start_to_pointer_down;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnchorElementPointerDown::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnchorElementPointerDown::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnchorElementPointerDown::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnchorElementPointerDown::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
AnchorElementMetricsPtr AnchorElementMetrics::Clone() const {
  return New(
      mojo::Clone(anchor_id),
      mojo::Clone(ratio_area),
      mojo::Clone(ratio_distance_top_to_visible_top),
      mojo::Clone(ratio_distance_root_top),
      mojo::Clone(is_in_iframe),
      mojo::Clone(contains_image),
      mojo::Clone(is_same_host),
      mojo::Clone(is_url_incremented_by_one),
      mojo::Clone(has_text_sibling),
      mojo::Clone(font_size_px),
      mojo::Clone(font_weight),
      mojo::Clone(target_url),
      mojo::Clone(viewport_size)
  );
}

template <typename T, AnchorElementMetrics::EnableIfSame<T>*>
bool AnchorElementMetrics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->anchor_id, other_struct.anchor_id))
    return false;
  if (!mojo::Equals(this->ratio_area, other_struct.ratio_area))
    return false;
  if (!mojo::Equals(this->ratio_distance_top_to_visible_top, other_struct.ratio_distance_top_to_visible_top))
    return false;
  if (!mojo::Equals(this->ratio_distance_root_top, other_struct.ratio_distance_root_top))
    return false;
  if (!mojo::Equals(this->is_in_iframe, other_struct.is_in_iframe))
    return false;
  if (!mojo::Equals(this->contains_image, other_struct.contains_image))
    return false;
  if (!mojo::Equals(this->is_same_host, other_struct.is_same_host))
    return false;
  if (!mojo::Equals(this->is_url_incremented_by_one, other_struct.is_url_incremented_by_one))
    return false;
  if (!mojo::Equals(this->has_text_sibling, other_struct.has_text_sibling))
    return false;
  if (!mojo::Equals(this->font_size_px, other_struct.font_size_px))
    return false;
  if (!mojo::Equals(this->font_weight, other_struct.font_weight))
    return false;
  if (!mojo::Equals(this->target_url, other_struct.target_url))
    return false;
  if (!mojo::Equals(this->viewport_size, other_struct.viewport_size))
    return false;
  return true;
}

template <typename T, AnchorElementMetrics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.anchor_id < rhs.anchor_id)
    return true;
  if (rhs.anchor_id < lhs.anchor_id)
    return false;
  if (lhs.ratio_area < rhs.ratio_area)
    return true;
  if (rhs.ratio_area < lhs.ratio_area)
    return false;
  if (lhs.ratio_distance_top_to_visible_top < rhs.ratio_distance_top_to_visible_top)
    return true;
  if (rhs.ratio_distance_top_to_visible_top < lhs.ratio_distance_top_to_visible_top)
    return false;
  if (lhs.ratio_distance_root_top < rhs.ratio_distance_root_top)
    return true;
  if (rhs.ratio_distance_root_top < lhs.ratio_distance_root_top)
    return false;
  if (lhs.is_in_iframe < rhs.is_in_iframe)
    return true;
  if (rhs.is_in_iframe < lhs.is_in_iframe)
    return false;
  if (lhs.contains_image < rhs.contains_image)
    return true;
  if (rhs.contains_image < lhs.contains_image)
    return false;
  if (lhs.is_same_host < rhs.is_same_host)
    return true;
  if (rhs.is_same_host < lhs.is_same_host)
    return false;
  if (lhs.is_url_incremented_by_one < rhs.is_url_incremented_by_one)
    return true;
  if (rhs.is_url_incremented_by_one < lhs.is_url_incremented_by_one)
    return false;
  if (lhs.has_text_sibling < rhs.has_text_sibling)
    return true;
  if (rhs.has_text_sibling < lhs.has_text_sibling)
    return false;
  if (lhs.font_size_px < rhs.font_size_px)
    return true;
  if (rhs.font_size_px < lhs.font_size_px)
    return false;
  if (lhs.font_weight < rhs.font_weight)
    return true;
  if (rhs.font_weight < lhs.font_weight)
    return false;
  if (lhs.target_url < rhs.target_url)
    return true;
  if (rhs.target_url < lhs.target_url)
    return false;
  if (lhs.viewport_size < rhs.viewport_size)
    return true;
  if (rhs.viewport_size < lhs.viewport_size)
    return false;
  return false;
}
template <typename StructPtrType>
AnchorElementClickPtr AnchorElementClick::Clone() const {
  return New(
      mojo::Clone(anchor_id),
      mojo::Clone(target_url),
      mojo::Clone(navigation_start_to_click)
  );
}

template <typename T, AnchorElementClick::EnableIfSame<T>*>
bool AnchorElementClick::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->anchor_id, other_struct.anchor_id))
    return false;
  if (!mojo::Equals(this->target_url, other_struct.target_url))
    return false;
  if (!mojo::Equals(this->navigation_start_to_click, other_struct.navigation_start_to_click))
    return false;
  return true;
}

template <typename T, AnchorElementClick::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.anchor_id < rhs.anchor_id)
    return true;
  if (rhs.anchor_id < lhs.anchor_id)
    return false;
  if (lhs.target_url < rhs.target_url)
    return true;
  if (rhs.target_url < lhs.target_url)
    return false;
  if (lhs.navigation_start_to_click < rhs.navigation_start_to_click)
    return true;
  if (rhs.navigation_start_to_click < lhs.navigation_start_to_click)
    return false;
  return false;
}
template <typename StructPtrType>
AnchorElementPointerDataOnHoverTimerFiredPtr AnchorElementPointerDataOnHoverTimerFired::Clone() const {
  return New(
      mojo::Clone(anchor_id),
      mojo::Clone(pointer_data)
  );
}

template <typename T, AnchorElementPointerDataOnHoverTimerFired::EnableIfSame<T>*>
bool AnchorElementPointerDataOnHoverTimerFired::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->anchor_id, other_struct.anchor_id))
    return false;
  if (!mojo::Equals(this->pointer_data, other_struct.pointer_data))
    return false;
  return true;
}

template <typename T, AnchorElementPointerDataOnHoverTimerFired::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.anchor_id < rhs.anchor_id)
    return true;
  if (rhs.anchor_id < lhs.anchor_id)
    return false;
  if (lhs.pointer_data < rhs.pointer_data)
    return true;
  if (rhs.pointer_data < lhs.pointer_data)
    return false;
  return false;
}
template <typename StructPtrType>
AnchorElementEnteredViewportPtr AnchorElementEnteredViewport::Clone() const {
  return New(
      mojo::Clone(anchor_id),
      mojo::Clone(navigation_start_to_entered_viewport)
  );
}

template <typename T, AnchorElementEnteredViewport::EnableIfSame<T>*>
bool AnchorElementEnteredViewport::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->anchor_id, other_struct.anchor_id))
    return false;
  if (!mojo::Equals(this->navigation_start_to_entered_viewport, other_struct.navigation_start_to_entered_viewport))
    return false;
  return true;
}

template <typename T, AnchorElementEnteredViewport::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.anchor_id < rhs.anchor_id)
    return true;
  if (rhs.anchor_id < lhs.anchor_id)
    return false;
  if (lhs.navigation_start_to_entered_viewport < rhs.navigation_start_to_entered_viewport)
    return true;
  if (rhs.navigation_start_to_entered_viewport < lhs.navigation_start_to_entered_viewport)
    return false;
  return false;
}
template <typename StructPtrType>
AnchorElementLeftViewportPtr AnchorElementLeftViewport::Clone() const {
  return New(
      mojo::Clone(anchor_id),
      mojo::Clone(time_in_viewport)
  );
}

template <typename T, AnchorElementLeftViewport::EnableIfSame<T>*>
bool AnchorElementLeftViewport::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->anchor_id, other_struct.anchor_id))
    return false;
  if (!mojo::Equals(this->time_in_viewport, other_struct.time_in_viewport))
    return false;
  return true;
}

template <typename T, AnchorElementLeftViewport::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.anchor_id < rhs.anchor_id)
    return true;
  if (rhs.anchor_id < lhs.anchor_id)
    return false;
  if (lhs.time_in_viewport < rhs.time_in_viewport)
    return true;
  if (rhs.time_in_viewport < lhs.time_in_viewport)
    return false;
  return false;
}
template <typename StructPtrType>
AnchorElementPointerOverPtr AnchorElementPointerOver::Clone() const {
  return New(
      mojo::Clone(anchor_id),
      mojo::Clone(navigation_start_to_pointer_over)
  );
}

template <typename T, AnchorElementPointerOver::EnableIfSame<T>*>
bool AnchorElementPointerOver::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->anchor_id, other_struct.anchor_id))
    return false;
  if (!mojo::Equals(this->navigation_start_to_pointer_over, other_struct.navigation_start_to_pointer_over))
    return false;
  return true;
}

template <typename T, AnchorElementPointerOver::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.anchor_id < rhs.anchor_id)
    return true;
  if (rhs.anchor_id < lhs.anchor_id)
    return false;
  if (lhs.navigation_start_to_pointer_over < rhs.navigation_start_to_pointer_over)
    return true;
  if (rhs.navigation_start_to_pointer_over < lhs.navigation_start_to_pointer_over)
    return false;
  return false;
}
template <typename StructPtrType>
AnchorElementPointerOutPtr AnchorElementPointerOut::Clone() const {
  return New(
      mojo::Clone(anchor_id),
      mojo::Clone(hover_dwell_time)
  );
}

template <typename T, AnchorElementPointerOut::EnableIfSame<T>*>
bool AnchorElementPointerOut::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->anchor_id, other_struct.anchor_id))
    return false;
  if (!mojo::Equals(this->hover_dwell_time, other_struct.hover_dwell_time))
    return false;
  return true;
}

template <typename T, AnchorElementPointerOut::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.anchor_id < rhs.anchor_id)
    return true;
  if (rhs.anchor_id < lhs.anchor_id)
    return false;
  if (lhs.hover_dwell_time < rhs.hover_dwell_time)
    return true;
  if (rhs.hover_dwell_time < lhs.hover_dwell_time)
    return false;
  return false;
}
template <typename StructPtrType>
AnchorElementPointerEventForMLModelPtr AnchorElementPointerEventForMLModel::Clone() const {
  return New(
      mojo::Clone(anchor_id),
      mojo::Clone(is_mouse),
      mojo::Clone(user_interaction_event_type)
  );
}

template <typename T, AnchorElementPointerEventForMLModel::EnableIfSame<T>*>
bool AnchorElementPointerEventForMLModel::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->anchor_id, other_struct.anchor_id))
    return false;
  if (!mojo::Equals(this->is_mouse, other_struct.is_mouse))
    return false;
  if (!mojo::Equals(this->user_interaction_event_type, other_struct.user_interaction_event_type))
    return false;
  return true;
}

template <typename T, AnchorElementPointerEventForMLModel::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.anchor_id < rhs.anchor_id)
    return true;
  if (rhs.anchor_id < lhs.anchor_id)
    return false;
  if (lhs.is_mouse < rhs.is_mouse)
    return true;
  if (rhs.is_mouse < lhs.is_mouse)
    return false;
  if (lhs.user_interaction_event_type < rhs.user_interaction_event_type)
    return true;
  if (rhs.user_interaction_event_type < lhs.user_interaction_event_type)
    return false;
  return false;
}
template <typename StructPtrType>
AnchorElementPointerDownPtr AnchorElementPointerDown::Clone() const {
  return New(
      mojo::Clone(anchor_id),
      mojo::Clone(navigation_start_to_pointer_down)
  );
}

template <typename T, AnchorElementPointerDown::EnableIfSame<T>*>
bool AnchorElementPointerDown::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->anchor_id, other_struct.anchor_id))
    return false;
  if (!mojo::Equals(this->navigation_start_to_pointer_down, other_struct.navigation_start_to_pointer_down))
    return false;
  return true;
}

template <typename T, AnchorElementPointerDown::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.anchor_id < rhs.anchor_id)
    return true;
  if (rhs.anchor_id < lhs.anchor_id)
    return false;
  if (lhs.navigation_start_to_pointer_down < rhs.navigation_start_to_pointer_down)
    return true;
  if (rhs.navigation_start_to_pointer_down < lhs.navigation_start_to_pointer_down)
    return false;
  return false;
}
template <typename StructPtrType>
AnchorElementPositionUpdatePtr AnchorElementPositionUpdate::Clone() const {
  return New(
      mojo::Clone(anchor_id),
      mojo::Clone(vertical_position_ratio),
      mojo::Clone(distance_from_pointer_down_ratio)
  );
}

template <typename T, AnchorElementPositionUpdate::EnableIfSame<T>*>
bool AnchorElementPositionUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->anchor_id, other_struct.anchor_id))
    return false;
  if (!mojo::Equals(this->vertical_position_ratio, other_struct.vertical_position_ratio))
    return false;
  if (!mojo::Equals(this->distance_from_pointer_down_ratio, other_struct.distance_from_pointer_down_ratio))
    return false;
  return true;
}

template <typename T, AnchorElementPositionUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.anchor_id < rhs.anchor_id)
    return true;
  if (rhs.anchor_id < lhs.anchor_id)
    return false;
  if (lhs.vertical_position_ratio < rhs.vertical_position_ratio)
    return true;
  if (rhs.vertical_position_ratio < lhs.vertical_position_ratio)
    return false;
  if (lhs.distance_from_pointer_down_ratio < rhs.distance_from_pointer_down_ratio)
    return true;
  if (rhs.distance_from_pointer_down_ratio < lhs.distance_from_pointer_down_ratio)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AnchorElementMetrics::DataView,
                                         ::blink::mojom::blink::AnchorElementMetricsPtr> {
  static bool IsNull(const ::blink::mojom::blink::AnchorElementMetricsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AnchorElementMetricsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AnchorElementMetrics::anchor_id) anchor_id(
      const ::blink::mojom::blink::AnchorElementMetricsPtr& input) {
    return input->anchor_id;
  }

  static decltype(::blink::mojom::blink::AnchorElementMetrics::ratio_area) ratio_area(
      const ::blink::mojom::blink::AnchorElementMetricsPtr& input) {
    return input->ratio_area;
  }

  static decltype(::blink::mojom::blink::AnchorElementMetrics::ratio_distance_top_to_visible_top) ratio_distance_top_to_visible_top(
      const ::blink::mojom::blink::AnchorElementMetricsPtr& input) {
    return input->ratio_distance_top_to_visible_top;
  }

  static decltype(::blink::mojom::blink::AnchorElementMetrics::ratio_distance_root_top) ratio_distance_root_top(
      const ::blink::mojom::blink::AnchorElementMetricsPtr& input) {
    return input->ratio_distance_root_top;
  }

  static decltype(::blink::mojom::blink::AnchorElementMetrics::is_in_iframe) is_in_iframe(
      const ::blink::mojom::blink::AnchorElementMetricsPtr& input) {
    return input->is_in_iframe;
  }

  static decltype(::blink::mojom::blink::AnchorElementMetrics::contains_image) contains_image(
      const ::blink::mojom::blink::AnchorElementMetricsPtr& input) {
    return input->contains_image;
  }

  static decltype(::blink::mojom::blink::AnchorElementMetrics::is_same_host) is_same_host(
      const ::blink::mojom::blink::AnchorElementMetricsPtr& input) {
    return input->is_same_host;
  }

  static decltype(::blink::mojom::blink::AnchorElementMetrics::is_url_incremented_by_one) is_url_incremented_by_one(
      const ::blink::mojom::blink::AnchorElementMetricsPtr& input) {
    return input->is_url_incremented_by_one;
  }

  static decltype(::blink::mojom::blink::AnchorElementMetrics::has_text_sibling) has_text_sibling(
      const ::blink::mojom::blink::AnchorElementMetricsPtr& input) {
    return input->has_text_sibling;
  }

  static decltype(::blink::mojom::blink::AnchorElementMetrics::font_size_px) font_size_px(
      const ::blink::mojom::blink::AnchorElementMetricsPtr& input) {
    return input->font_size_px;
  }

  static decltype(::blink::mojom::blink::AnchorElementMetrics::font_weight) font_weight(
      const ::blink::mojom::blink::AnchorElementMetricsPtr& input) {
    return input->font_weight;
  }

  static const decltype(::blink::mojom::blink::AnchorElementMetrics::target_url)& target_url(
      const ::blink::mojom::blink::AnchorElementMetricsPtr& input) {
    return input->target_url;
  }

  static const decltype(::blink::mojom::blink::AnchorElementMetrics::viewport_size)& viewport_size(
      const ::blink::mojom::blink::AnchorElementMetricsPtr& input) {
    return input->viewport_size;
  }

  static bool Read(::blink::mojom::blink::AnchorElementMetrics::DataView input, ::blink::mojom::blink::AnchorElementMetricsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AnchorElementClick::DataView,
                                         ::blink::mojom::blink::AnchorElementClickPtr> {
  static bool IsNull(const ::blink::mojom::blink::AnchorElementClickPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AnchorElementClickPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AnchorElementClick::anchor_id) anchor_id(
      const ::blink::mojom::blink::AnchorElementClickPtr& input) {
    return input->anchor_id;
  }

  static const decltype(::blink::mojom::blink::AnchorElementClick::target_url)& target_url(
      const ::blink::mojom::blink::AnchorElementClickPtr& input) {
    return input->target_url;
  }

  static const decltype(::blink::mojom::blink::AnchorElementClick::navigation_start_to_click)& navigation_start_to_click(
      const ::blink::mojom::blink::AnchorElementClickPtr& input) {
    return input->navigation_start_to_click;
  }

  static bool Read(::blink::mojom::blink::AnchorElementClick::DataView input, ::blink::mojom::blink::AnchorElementClickPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AnchorElementPointerDataOnHoverTimerFired::DataView,
                                         ::blink::mojom::blink::AnchorElementPointerDataOnHoverTimerFiredPtr> {
  static bool IsNull(const ::blink::mojom::blink::AnchorElementPointerDataOnHoverTimerFiredPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AnchorElementPointerDataOnHoverTimerFiredPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AnchorElementPointerDataOnHoverTimerFired::anchor_id) anchor_id(
      const ::blink::mojom::blink::AnchorElementPointerDataOnHoverTimerFiredPtr& input) {
    return input->anchor_id;
  }

  static const decltype(::blink::mojom::blink::AnchorElementPointerDataOnHoverTimerFired::pointer_data)& pointer_data(
      const ::blink::mojom::blink::AnchorElementPointerDataOnHoverTimerFiredPtr& input) {
    return input->pointer_data;
  }

  static bool Read(::blink::mojom::blink::AnchorElementPointerDataOnHoverTimerFired::DataView input, ::blink::mojom::blink::AnchorElementPointerDataOnHoverTimerFiredPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AnchorElementEnteredViewport::DataView,
                                         ::blink::mojom::blink::AnchorElementEnteredViewportPtr> {
  static bool IsNull(const ::blink::mojom::blink::AnchorElementEnteredViewportPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AnchorElementEnteredViewportPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AnchorElementEnteredViewport::anchor_id) anchor_id(
      const ::blink::mojom::blink::AnchorElementEnteredViewportPtr& input) {
    return input->anchor_id;
  }

  static const decltype(::blink::mojom::blink::AnchorElementEnteredViewport::navigation_start_to_entered_viewport)& navigation_start_to_entered_viewport(
      const ::blink::mojom::blink::AnchorElementEnteredViewportPtr& input) {
    return input->navigation_start_to_entered_viewport;
  }

  static bool Read(::blink::mojom::blink::AnchorElementEnteredViewport::DataView input, ::blink::mojom::blink::AnchorElementEnteredViewportPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AnchorElementLeftViewport::DataView,
                                         ::blink::mojom::blink::AnchorElementLeftViewportPtr> {
  static bool IsNull(const ::blink::mojom::blink::AnchorElementLeftViewportPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AnchorElementLeftViewportPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AnchorElementLeftViewport::anchor_id) anchor_id(
      const ::blink::mojom::blink::AnchorElementLeftViewportPtr& input) {
    return input->anchor_id;
  }

  static const decltype(::blink::mojom::blink::AnchorElementLeftViewport::time_in_viewport)& time_in_viewport(
      const ::blink::mojom::blink::AnchorElementLeftViewportPtr& input) {
    return input->time_in_viewport;
  }

  static bool Read(::blink::mojom::blink::AnchorElementLeftViewport::DataView input, ::blink::mojom::blink::AnchorElementLeftViewportPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AnchorElementPointerOver::DataView,
                                         ::blink::mojom::blink::AnchorElementPointerOverPtr> {
  static bool IsNull(const ::blink::mojom::blink::AnchorElementPointerOverPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AnchorElementPointerOverPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AnchorElementPointerOver::anchor_id) anchor_id(
      const ::blink::mojom::blink::AnchorElementPointerOverPtr& input) {
    return input->anchor_id;
  }

  static const decltype(::blink::mojom::blink::AnchorElementPointerOver::navigation_start_to_pointer_over)& navigation_start_to_pointer_over(
      const ::blink::mojom::blink::AnchorElementPointerOverPtr& input) {
    return input->navigation_start_to_pointer_over;
  }

  static bool Read(::blink::mojom::blink::AnchorElementPointerOver::DataView input, ::blink::mojom::blink::AnchorElementPointerOverPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AnchorElementPointerOut::DataView,
                                         ::blink::mojom::blink::AnchorElementPointerOutPtr> {
  static bool IsNull(const ::blink::mojom::blink::AnchorElementPointerOutPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AnchorElementPointerOutPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AnchorElementPointerOut::anchor_id) anchor_id(
      const ::blink::mojom::blink::AnchorElementPointerOutPtr& input) {
    return input->anchor_id;
  }

  static const decltype(::blink::mojom::blink::AnchorElementPointerOut::hover_dwell_time)& hover_dwell_time(
      const ::blink::mojom::blink::AnchorElementPointerOutPtr& input) {
    return input->hover_dwell_time;
  }

  static bool Read(::blink::mojom::blink::AnchorElementPointerOut::DataView input, ::blink::mojom::blink::AnchorElementPointerOutPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AnchorElementPointerEventForMLModel::DataView,
                                         ::blink::mojom::blink::AnchorElementPointerEventForMLModelPtr> {
  static bool IsNull(const ::blink::mojom::blink::AnchorElementPointerEventForMLModelPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AnchorElementPointerEventForMLModelPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AnchorElementPointerEventForMLModel::anchor_id) anchor_id(
      const ::blink::mojom::blink::AnchorElementPointerEventForMLModelPtr& input) {
    return input->anchor_id;
  }

  static decltype(::blink::mojom::blink::AnchorElementPointerEventForMLModel::is_mouse) is_mouse(
      const ::blink::mojom::blink::AnchorElementPointerEventForMLModelPtr& input) {
    return input->is_mouse;
  }

  static decltype(::blink::mojom::blink::AnchorElementPointerEventForMLModel::user_interaction_event_type) user_interaction_event_type(
      const ::blink::mojom::blink::AnchorElementPointerEventForMLModelPtr& input) {
    return input->user_interaction_event_type;
  }

  static bool Read(::blink::mojom::blink::AnchorElementPointerEventForMLModel::DataView input, ::blink::mojom::blink::AnchorElementPointerEventForMLModelPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AnchorElementPointerDown::DataView,
                                         ::blink::mojom::blink::AnchorElementPointerDownPtr> {
  static bool IsNull(const ::blink::mojom::blink::AnchorElementPointerDownPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AnchorElementPointerDownPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AnchorElementPointerDown::anchor_id) anchor_id(
      const ::blink::mojom::blink::AnchorElementPointerDownPtr& input) {
    return input->anchor_id;
  }

  static const decltype(::blink::mojom::blink::AnchorElementPointerDown::navigation_start_to_pointer_down)& navigation_start_to_pointer_down(
      const ::blink::mojom::blink::AnchorElementPointerDownPtr& input) {
    return input->navigation_start_to_pointer_down;
  }

  static bool Read(::blink::mojom::blink::AnchorElementPointerDown::DataView input, ::blink::mojom::blink::AnchorElementPointerDownPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AnchorElementPositionUpdate::DataView,
                                         ::blink::mojom::blink::AnchorElementPositionUpdatePtr> {
  static bool IsNull(const ::blink::mojom::blink::AnchorElementPositionUpdatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AnchorElementPositionUpdatePtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AnchorElementPositionUpdate::anchor_id) anchor_id(
      const ::blink::mojom::blink::AnchorElementPositionUpdatePtr& input) {
    return input->anchor_id;
  }

  static decltype(::blink::mojom::blink::AnchorElementPositionUpdate::vertical_position_ratio) vertical_position_ratio(
      const ::blink::mojom::blink::AnchorElementPositionUpdatePtr& input) {
    return input->vertical_position_ratio;
  }

  static decltype(::blink::mojom::blink::AnchorElementPositionUpdate::distance_from_pointer_down_ratio) distance_from_pointer_down_ratio(
      const ::blink::mojom::blink::AnchorElementPositionUpdatePtr& input) {
    return input->distance_from_pointer_down_ratio;
  }

  static bool Read(::blink::mojom::blink::AnchorElementPositionUpdate::DataView input, ::blink::mojom::blink::AnchorElementPositionUpdatePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_NAVIGATION_PREDICTOR_MOJOM_BLINK_H_