// third_party/blink/public/mojom/loader/local_resource_loader_config.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/loader/local_resource_loader_config.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../../../mojo/public/mojom/base/values.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }



  function LocalResourceSource(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalResourceSource.prototype.initDefaults_ = function() {
    this.headers = null;
    this.shouldReplaceI18nInJs = false;
    this.pathToResourceMap = null;
    this.replacementStrings = null;
  };
  LocalResourceSource.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalResourceSource.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalResourceSource.headers
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate LocalResourceSource.pathToResourceMap
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 16, false, codec.String, LocalResourceValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalResourceSource.replacementStrings
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 24, false, codec.String, codec.String, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalResourceSource.encodedSize = codec.kStructHeaderSize + 32;

  LocalResourceSource.decode = function(decoder) {
    var packed;
    var val = new LocalResourceSource();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.headers =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.shouldReplaceI18nInJs = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.pathToResourceMap =
        decoder.decodeMapPointer(codec.String, LocalResourceValue);
    val.replacementStrings =
        decoder.decodeMapPointer(codec.String, codec.String);
    return val;
  };

  LocalResourceSource.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalResourceSource.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.headers);
    packed = 0;
    packed |= (val.shouldReplaceI18nInJs & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeMapPointer(codec.String, LocalResourceValue, val.pathToResourceMap);
    encoder.encodeMapPointer(codec.String, codec.String, val.replacementStrings);
  };
  function LocalResourceLoaderConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalResourceLoaderConfig.prototype.initDefaults_ = function() {
    this.sources = null;
  };
  LocalResourceLoaderConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalResourceLoaderConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalResourceLoaderConfig.sources
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, new codec.PointerTo(origin$.Origin), new codec.PointerTo(LocalResourceSource), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalResourceLoaderConfig.encodedSize = codec.kStructHeaderSize + 8;

  LocalResourceLoaderConfig.decode = function(decoder) {
    var packed;
    var val = new LocalResourceLoaderConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sources =
        decoder.decodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.PointerTo(LocalResourceSource));
    return val;
  };

  LocalResourceLoaderConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalResourceLoaderConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.PointerTo(LocalResourceSource), val.sources);
  };

  function LocalResourceValue(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  LocalResourceValue.Tags = {
    resourceId: 0,
    responseBody: 1,
  };

  LocalResourceValue.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  LocalResourceValue.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "resourceId",
        "responseBody",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a LocalResourceValue member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(LocalResourceValue.prototype, "resourceId", {
    get: function() {
      if (this.$tag != LocalResourceValue.Tags.resourceId) {
        throw new ReferenceError(
            "LocalResourceValue.resourceId is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = LocalResourceValue.Tags.resourceId;
      this.$data = value;
    }
  });
  Object.defineProperty(LocalResourceValue.prototype, "responseBody", {
    get: function() {
      if (this.$tag != LocalResourceValue.Tags.responseBody) {
        throw new ReferenceError(
            "LocalResourceValue.responseBody is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = LocalResourceValue.Tags.responseBody;
      this.$data = value;
    }
  });


    LocalResourceValue.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case LocalResourceValue.Tags.resourceId:
          encoder.encodeStruct(codec.Int32, val.resourceId);
          break;
        case LocalResourceValue.Tags.responseBody:
          encoder.encodeStruct(codec.String, val.responseBody);
          break;
      }
      encoder.align();
    };


    LocalResourceValue.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new LocalResourceValue();
      var tag = decoder.readUint32();
      switch (tag) {
        case LocalResourceValue.Tags.resourceId:
          result.resourceId = decoder.decodeStruct(codec.Int32);
          break;
        case LocalResourceValue.Tags.responseBody:
          result.responseBody = decoder.decodeStruct(codec.String);
          break;
      }
      decoder.align();

      return result;
    };


    LocalResourceValue.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case LocalResourceValue.Tags.resourceId:
          

          break;
        case LocalResourceValue.Tags.responseBody:
          

    // validate LocalResourceValue.responseBody
    err = messageValidator.validateStringPointer(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  LocalResourceValue.encodedSize = 16;
  exports.LocalResourceSource = LocalResourceSource;
  exports.LocalResourceLoaderConfig = LocalResourceLoaderConfig;
  exports.LocalResourceValue = LocalResourceValue;
})();