// third_party/blink/public/mojom/loader/local_resource_loader_config.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-params-data.h"
#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-import-headers.h"
#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-test-utils.h"


namespace blink::mojom {
LocalResourceSource::LocalResourceSource()
    : headers(),
      should_replace_i18n_in_js(),
      path_to_resource_map(),
      replacement_strings() {}

LocalResourceSource::LocalResourceSource(
    const std::string& headers_in,
    bool should_replace_i18n_in_js_in,
    base::flat_map<std::string, LocalResourceValuePtr> path_to_resource_map_in,
    const base::flat_map<std::string, std::string>& replacement_strings_in)
    : headers(std::move(headers_in)),
      should_replace_i18n_in_js(std::move(should_replace_i18n_in_js_in)),
      path_to_resource_map(std::move(path_to_resource_map_in)),
      replacement_strings(std::move(replacement_strings_in)) {}

LocalResourceSource::~LocalResourceSource() = default;

void LocalResourceSource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_replace_i18n_in_js"), this->should_replace_i18n_in_js,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path_to_resource_map"), this->path_to_resource_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<std::string, LocalResourceValuePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "replacement_strings"), this->replacement_strings,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LocalResourceSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LocalResourceLoaderConfig::LocalResourceLoaderConfig()
    : sources() {}

LocalResourceLoaderConfig::LocalResourceLoaderConfig(
    base::flat_map<::url::Origin, LocalResourceSourcePtr> sources_in)
    : sources(std::move(sources_in)) {}

LocalResourceLoaderConfig::~LocalResourceLoaderConfig() = default;

void LocalResourceLoaderConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sources"), this->sources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<::url::Origin, LocalResourceSourcePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LocalResourceLoaderConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LocalResourceValuePtr
LocalResourceValue::NewResourceId(
    int32_t value) {
  return LocalResourceValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kResourceId)>,
      std::move(value));
}

LocalResourceValuePtr
LocalResourceValue::NewResponseBody(
    const std::string& value) {
  return LocalResourceValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kResponseBody)>,
      std::move(value));
}

LocalResourceValue::LocalResourceValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kResourceId)>,
    int32_t value)
    : tag_(Tag::kResourceId),
      data_(std::in_place_index<static_cast<size_t>(Tag::kResourceId)>,
            std::move(value)) {}

LocalResourceValue::LocalResourceValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kResponseBody)>,
    const std::string& value)
    : tag_(Tag::kResponseBody),
      data_(std::in_place_index<static_cast<size_t>(Tag::kResponseBody)>,
            std::move(value)) {}
LocalResourceValue::~LocalResourceValue() {
  DestroyActive();
}

void LocalResourceValue::set_resource_id(int32_t resource_id) {
  if (tag_ != Tag::kResourceId) {
    DestroyActive();
    tag_ = Tag::kResourceId;
  }
  data_.resource_id = resource_id;
}

void LocalResourceValue::set_response_body(const std::string& response_body) {
  if (tag_ == Tag::kResponseBody) {
    data_.response_body = std::move(response_body);
  } else {
    DestroyActive();
    tag_ = Tag::kResponseBody;
    new (&data_.response_body) std::string(
        std::move(response_body));
  }
}


LocalResourceValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kResourceId)>,
    int32_t value)
    : resource_id(std::move(value)) {}

LocalResourceValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kResponseBody)>,
    const std::string& value)
    : response_body(std::move(value)) {}

void LocalResourceValue::DestroyActive() {
  switch (tag_) {

    case Tag::kResourceId:
      std::destroy_at(&data_.resource_id);
      break;
    case Tag::kResponseBody:
      std::destroy_at(&data_.response_body);
      break;
  }
}
size_t LocalResourceValue::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kResourceId:
      return mojo::internal::Hash(seed, data_.resource_id);
    case Tag::kResponseBody:
      return mojo::internal::Hash(seed, data_.response_body);
    default:
      NOTREACHED();
  }
}

bool LocalResourceValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::LocalResourceSource::DataView, ::blink::mojom::LocalResourceSourcePtr>::Read(
    ::blink::mojom::LocalResourceSource::DataView input,
    ::blink::mojom::LocalResourceSourcePtr* output) {
  bool success = true;
  ::blink::mojom::LocalResourceSourcePtr result(::blink::mojom::LocalResourceSource::New());
  
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success)
        result->should_replace_i18n_in_js = input.should_replace_i18n_in_js();
      if (success && !input.ReadPathToResourceMap(&result->path_to_resource_map))
        success = false;
      if (success && !input.ReadReplacementStrings(&result->replacement_strings))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::LocalResourceLoaderConfig::DataView, ::blink::mojom::LocalResourceLoaderConfigPtr>::Read(
    ::blink::mojom::LocalResourceLoaderConfig::DataView input,
    ::blink::mojom::LocalResourceLoaderConfigPtr* output) {
  bool success = true;
  ::blink::mojom::LocalResourceLoaderConfigPtr result(::blink::mojom::LocalResourceLoaderConfig::New());
  
      if (success && !input.ReadSources(&result->sources))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::LocalResourceValue::DataView, ::blink::mojom::LocalResourceValuePtr>::Read(
    ::blink::mojom::LocalResourceValue::DataView input,
    ::blink::mojom::LocalResourceValuePtr* output) {
  using UnionType = ::blink::mojom::LocalResourceValue;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kResourceId: {
      *output = UnionType::NewResourceId(input.resource_id());
      break;
    }
    case Tag::kResponseBody: {
      std::string result_response_body{};
      if (!input.ReadResponseBody(&result_response_body))
        return false;

      *output = UnionType::NewResponseBody(
          std::move(result_response_body));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {




}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif