// third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"




#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::LocalResourceSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::LocalResourceSourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::LocalResourceSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers)::BaseType> headers_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_headers,
      headers_fragment);

    fragment->headers.Set(
        headers_fragment.is_null() ? nullptr : headers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->headers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in LocalResourceSource struct");

    fragment->should_replace_i18n_in_js = Traits::should_replace_i18n_in_js(input);

    decltype(Traits::path_to_resource_map(input)) in_path_to_resource_map = Traits::path_to_resource_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path_to_resource_map)::BaseType>
        path_to_resource_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& path_to_resource_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::blink::mojom::LocalResourceValueDataView>>(
      in_path_to_resource_map,
      path_to_resource_map_fragment,
      &path_to_resource_map_validate_params);

    fragment->path_to_resource_map.Set(
        path_to_resource_map_fragment.is_null() ? nullptr : path_to_resource_map_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->path_to_resource_map.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path_to_resource_map in LocalResourceSource struct");

    decltype(Traits::replacement_strings(input)) in_replacement_strings = Traits::replacement_strings(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->replacement_strings)::BaseType>
        replacement_strings_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& replacement_strings_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
      in_replacement_strings,
      replacement_strings_fragment,
      &replacement_strings_validate_params);

    fragment->replacement_strings.Set(
        replacement_strings_fragment.is_null() ? nullptr : replacement_strings_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->replacement_strings.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null replacement_strings in LocalResourceSource struct");
  }

  static bool Deserialize(::blink::mojom::internal::LocalResourceSource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::LocalResourceSourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::LocalResourceLoaderConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::LocalResourceLoaderConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::LocalResourceLoaderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::sources(input)) in_sources = Traits::sources(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sources)::BaseType>
        sources_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::LocalResourceSourceDataView>>(
      in_sources,
      sources_fragment,
      &sources_validate_params);

    fragment->sources.Set(
        sources_fragment.is_null() ? nullptr : sources_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sources.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sources in LocalResourceLoaderConfig struct");
  }

  static bool Deserialize(::blink::mojom::internal::LocalResourceLoaderConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::LocalResourceLoaderConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::LocalResourceValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::LocalResourceValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::LocalResourceValue_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::LocalResourceValueDataView::Tag::kResourceId: {
    decltype(Traits::resource_id(input))
    in_resource_id = Traits::resource_id(input);
    fragment->data.f_resource_id = in_resource_id;
    break;
  }
  case ::blink::mojom::LocalResourceValueDataView::Tag::kResponseBody: {
    decltype(Traits::response_body(input))
    in_response_body = Traits::response_body(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_response_body)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_response_body,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null response_body in LocalResourceValue union");
    fragment->data.f_response_body.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::LocalResourceValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::LocalResourceValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void LocalResourceSourceDataView::GetHeadersDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->headers.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LocalResourceSourceDataView::GetPathToResourceMapDataView(
    mojo::MapDataView<mojo::StringDataView, LocalResourceValueDataView>* output) {
  auto pointer = data_->path_to_resource_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, LocalResourceValueDataView>(pointer, message_);
}
inline void LocalResourceSourceDataView::GetReplacementStringsDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->replacement_strings.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, message_);
}


inline void LocalResourceLoaderConfigDataView::GetSourcesDataView(
    mojo::MapDataView<::url::mojom::OriginDataView, LocalResourceSourceDataView>* output) {
  auto pointer = data_->sources.Get();
  *output = mojo::MapDataView<::url::mojom::OriginDataView, LocalResourceSourceDataView>(pointer, message_);
}


inline void LocalResourceValueDataView::GetResponseBodyDataView(
    mojo::StringDataView* output) const {
  CHECK(is_response_body());
  *output = mojo::StringDataView(data_->data.f_response_body.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_SHARED_H_