// third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {
// static
bool LocalResourceValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const LocalResourceValue_Data* object = static_cast<const LocalResourceValue_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case LocalResourceValue_Tag::kResourceId: {

      return true;
    }
    case LocalResourceValue_Tag::kResponseBody: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_response_body, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& response_body_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_response_body, validation_context,
                                             &response_body_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in LocalResourceValue");
      return false;
    }
  }
}


// static
bool LocalResourceSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalResourceSource_Data* object =
      static_cast<const LocalResourceSource_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path_to_resource_map, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& path_to_resource_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->path_to_resource_map, validation_context,
                                         &path_to_resource_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replacement_strings, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& replacement_strings_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->replacement_strings, validation_context,
                                         &replacement_strings_validate_params)) {
    return false;
  }

  return true;
}

LocalResourceSource_Data::LocalResourceSource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalResourceLoaderConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalResourceLoaderConfig_Data* object =
      static_cast<const LocalResourceLoaderConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sources, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->sources, validation_context,
                                         &sources_validate_params)) {
    return false;
  }

  return true;
}

LocalResourceLoaderConfig_Data::LocalResourceLoaderConfig_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink