// third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"


namespace blink::mojom {
class LocalResourceSourceDataView;

class LocalResourceLoaderConfigDataView;

class LocalResourceValueDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::LocalResourceSourceDataView> {
  using Data = ::blink::mojom::internal::LocalResourceSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::LocalResourceLoaderConfigDataView> {
  using Data = ::blink::mojom::internal::LocalResourceLoaderConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::LocalResourceValueDataView> {
  using Data = ::blink::mojom::internal::LocalResourceValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class LocalResourceSourceDataView {
 public:
  LocalResourceSourceDataView() = default;

  LocalResourceSourceDataView(
      internal::LocalResourceSource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHeadersDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool should_replace_i18n_in_js() const {
    return data_->should_replace_i18n_in_js;
  }
  inline void GetPathToResourceMapDataView(
      mojo::MapDataView<mojo::StringDataView, LocalResourceValueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPathToResourceMap(UserType* output) {
    
    auto* pointer = data_->path_to_resource_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::blink::mojom::LocalResourceValueDataView>>(
        pointer, output, message_);
  }
  inline void GetReplacementStringsDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReplacementStrings(UserType* output) {
    
    auto* pointer = data_->replacement_strings.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::LocalResourceSource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LocalResourceLoaderConfigDataView {
 public:
  LocalResourceLoaderConfigDataView() = default;

  LocalResourceLoaderConfigDataView(
      internal::LocalResourceLoaderConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSourcesDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, LocalResourceSourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSources(UserType* output) {
    
    auto* pointer = data_->sources.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::LocalResourceSourceDataView>>(
        pointer, output, message_);
  }
 private:
  internal::LocalResourceLoaderConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LocalResourceValueDataView {
 public:
  using Tag = internal::LocalResourceValue_Data::LocalResourceValue_Tag;

  LocalResourceValueDataView() = default;

  LocalResourceValueDataView(
      internal::LocalResourceValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_resource_id() const { return data_->tag == Tag::kResourceId; }
  int32_t resource_id() const {
    CHECK(is_resource_id());
    return data_->data.f_resource_id;
  }
  bool is_response_body() const { return data_->tag == Tag::kResponseBody; }
  inline void GetResponseBodyDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadResponseBody(UserType* output) const {
    
    CHECK(is_response_body());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_response_body.Get(), output, message_);
  }

 private:
  internal::LocalResourceValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_DATA_VIEW_H_