// third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/values.mojom-blink-forward.h"
#include "url/mojom/origin.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {







class PLATFORM_EXPORT LocalResourceValue {
 public:
  using DataView = LocalResourceValueDataView;
  using Data_ = internal::LocalResourceValue_Data;
  using Tag = Data_::LocalResourceValue_Tag;

  template <typename... Args>
  static LocalResourceValuePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |resource_id|.
  static LocalResourceValuePtr NewResourceId(
      int32_t value);
  // Construct an instance holding |response_body|.
  static LocalResourceValuePtr NewResponseBody(
      const ::blink::String& value);

  template <typename U>
  static LocalResourceValuePtr From(const U& u) {
    return mojo::TypeConverter<LocalResourceValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LocalResourceValue>::Convert(*this);
  }
  ~LocalResourceValue();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  LocalResourceValue(const LocalResourceValue& other) = delete;
  LocalResourceValue& operator=(const LocalResourceValue& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = LocalResourceValuePtr>
  LocalResourceValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, LocalResourceValue>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, LocalResourceValue>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_resource_id() const { return tag_ == Tag::kResourceId; }
  int32_t get_resource_id() const {
    CHECK(tag_ == Tag::kResourceId);
    return data_.resource_id;
  }
  void set_resource_id(int32_t resource_id);

  bool is_response_body() const { return tag_ == Tag::kResponseBody; }
  const ::blink::String& get_response_body() const {
    CHECK(tag_ == Tag::kResponseBody);
    return data_.response_body;
  }
  ::blink::String& get_response_body() {
    CHECK(tag_ == Tag::kResponseBody);
    return data_.response_body;
  }
  void set_response_body(const ::blink::String& response_body);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LocalResourceValue::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<LocalResourceValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kResourceId)>,
        int32_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kResponseBody)>,
        const ::blink::String& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    int32_t resource_id;
    ::blink::String response_body;
  };

  LocalResourceValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kResourceId)>,
      int32_t value);
  LocalResourceValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kResponseBody)>,
      const ::blink::String& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class PLATFORM_EXPORT LocalResourceSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LocalResourceSource, T>::value>;
  using DataView = LocalResourceSourceDataView;
  using Data_ = internal::LocalResourceSource_Data;

  template <typename... Args>
  static LocalResourceSourcePtr New(Args&&... args) {
    return LocalResourceSourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LocalResourceSourcePtr From(const U& u) {
    return mojo::TypeConverter<LocalResourceSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LocalResourceSource>::Convert(*this);
  }


  LocalResourceSource();

  LocalResourceSource(
      const ::blink::String& headers,
      bool should_replace_i18n_in_js,
      ::blink::HashMap<::blink::String, LocalResourceValuePtr> path_to_resource_map,
      const ::blink::HashMap<::blink::String, ::blink::String>& replacement_strings);

LocalResourceSource(const LocalResourceSource&) = delete;
LocalResourceSource& operator=(const LocalResourceSource&) = delete;

  ~LocalResourceSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LocalResourceSourcePtr>
  LocalResourceSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LocalResourceSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LocalResourceSource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LocalResourceSource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LocalResourceSource::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LocalResourceSource::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LocalResourceSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LocalResourceSource_UnserializedMessageContext<
            UserType, LocalResourceSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LocalResourceSource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LocalResourceSource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LocalResourceSource_UnserializedMessageContext<
            UserType, LocalResourceSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LocalResourceSource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String headers;
  
  bool should_replace_i18n_in_js;
  
  ::blink::HashMap<::blink::String, LocalResourceValuePtr> path_to_resource_map;
  
  ::blink::HashMap<::blink::String, ::blink::String> replacement_strings;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LocalResourceSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LocalResourceSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LocalResourceSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LocalResourceSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT LocalResourceLoaderConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LocalResourceLoaderConfig, T>::value>;
  using DataView = LocalResourceLoaderConfigDataView;
  using Data_ = internal::LocalResourceLoaderConfig_Data;

  template <typename... Args>
  static LocalResourceLoaderConfigPtr New(Args&&... args) {
    return LocalResourceLoaderConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LocalResourceLoaderConfigPtr From(const U& u) {
    return mojo::TypeConverter<LocalResourceLoaderConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LocalResourceLoaderConfig>::Convert(*this);
  }


  LocalResourceLoaderConfig();

  explicit LocalResourceLoaderConfig(
      ::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, LocalResourceSourcePtr> sources);

LocalResourceLoaderConfig(const LocalResourceLoaderConfig&) = delete;
LocalResourceLoaderConfig& operator=(const LocalResourceLoaderConfig&) = delete;

  ~LocalResourceLoaderConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LocalResourceLoaderConfigPtr>
  LocalResourceLoaderConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LocalResourceLoaderConfig::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LocalResourceLoaderConfig::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LocalResourceLoaderConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LocalResourceLoaderConfig_UnserializedMessageContext<
            UserType, LocalResourceLoaderConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LocalResourceLoaderConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LocalResourceLoaderConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LocalResourceLoaderConfig_UnserializedMessageContext<
            UserType, LocalResourceLoaderConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LocalResourceLoaderConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, LocalResourceSourcePtr> sources;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
LocalResourceValuePtr LocalResourceValue::Clone() const {
  switch (tag_) {
    case Tag::kResourceId:
      return NewResourceId(
          mojo::Clone(data_.resource_id));
    case Tag::kResponseBody:
      return NewResponseBody(
          mojo::Clone(data_.response_body));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, LocalResourceValue>::value>::type*>
bool LocalResourceValue::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kResourceId:
      return mojo::Equals(data_.resource_id, other.data_.resource_id);
    case Tag::kResponseBody:
      return mojo::Equals(data_.response_body, other.data_.response_body);
  }

  return false;
}
template <typename StructPtrType>
LocalResourceSourcePtr LocalResourceSource::Clone() const {
  return New(
      mojo::Clone(headers),
      mojo::Clone(should_replace_i18n_in_js),
      mojo::Clone(path_to_resource_map),
      mojo::Clone(replacement_strings)
  );
}

template <typename T, LocalResourceSource::EnableIfSame<T>*>
bool LocalResourceSource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  if (!mojo::Equals(this->should_replace_i18n_in_js, other_struct.should_replace_i18n_in_js))
    return false;
  if (!mojo::Equals(this->path_to_resource_map, other_struct.path_to_resource_map))
    return false;
  if (!mojo::Equals(this->replacement_strings, other_struct.replacement_strings))
    return false;
  return true;
}

template <typename T, LocalResourceSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.headers < rhs.headers)
    return true;
  if (rhs.headers < lhs.headers)
    return false;
  if (lhs.should_replace_i18n_in_js < rhs.should_replace_i18n_in_js)
    return true;
  if (rhs.should_replace_i18n_in_js < lhs.should_replace_i18n_in_js)
    return false;
  if (lhs.path_to_resource_map < rhs.path_to_resource_map)
    return true;
  if (rhs.path_to_resource_map < lhs.path_to_resource_map)
    return false;
  if (lhs.replacement_strings < rhs.replacement_strings)
    return true;
  if (rhs.replacement_strings < lhs.replacement_strings)
    return false;
  return false;
}
template <typename StructPtrType>
LocalResourceLoaderConfigPtr LocalResourceLoaderConfig::Clone() const {
  return New(
      mojo::Clone(sources)
  );
}

template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>*>
bool LocalResourceLoaderConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sources, other_struct.sources))
    return false;
  return true;
}

template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sources < rhs.sources)
    return true;
  if (rhs.sources < lhs.sources)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::LocalResourceSource::DataView,
                                         ::blink::mojom::blink::LocalResourceSourcePtr> {
  static bool IsNull(const ::blink::mojom::blink::LocalResourceSourcePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::LocalResourceSourcePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::LocalResourceSource::headers)& headers(
      const ::blink::mojom::blink::LocalResourceSourcePtr& input) {
    return input->headers;
  }

  static decltype(::blink::mojom::blink::LocalResourceSource::should_replace_i18n_in_js) should_replace_i18n_in_js(
      const ::blink::mojom::blink::LocalResourceSourcePtr& input) {
    return input->should_replace_i18n_in_js;
  }

  static const decltype(::blink::mojom::blink::LocalResourceSource::path_to_resource_map)& path_to_resource_map(
      const ::blink::mojom::blink::LocalResourceSourcePtr& input) {
    return input->path_to_resource_map;
  }

  static const decltype(::blink::mojom::blink::LocalResourceSource::replacement_strings)& replacement_strings(
      const ::blink::mojom::blink::LocalResourceSourcePtr& input) {
    return input->replacement_strings;
  }

  static bool Read(::blink::mojom::blink::LocalResourceSource::DataView input, ::blink::mojom::blink::LocalResourceSourcePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::LocalResourceLoaderConfig::DataView,
                                         ::blink::mojom::blink::LocalResourceLoaderConfigPtr> {
  static bool IsNull(const ::blink::mojom::blink::LocalResourceLoaderConfigPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::LocalResourceLoaderConfigPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::LocalResourceLoaderConfig::sources)& sources(
      const ::blink::mojom::blink::LocalResourceLoaderConfigPtr& input) {
    return input->sources;
  }

  static bool Read(::blink::mojom::blink::LocalResourceLoaderConfig::DataView input, ::blink::mojom::blink::LocalResourceLoaderConfigPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::LocalResourceValue::DataView,
                                        ::blink::mojom::blink::LocalResourceValuePtr> {
  static bool IsNull(const ::blink::mojom::blink::LocalResourceValuePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::LocalResourceValuePtr* output) { output->reset(); }

  static ::blink::mojom::blink::LocalResourceValue::Tag GetTag(const ::blink::mojom::blink::LocalResourceValuePtr& input) {
    return input->which();
  }

  static  int32_t resource_id(const ::blink::mojom::blink::LocalResourceValuePtr& input) {
    return input->get_resource_id();
  }

  static const ::blink::String& response_body(const ::blink::mojom::blink::LocalResourceValuePtr& input) {
    return input->get_response_body();
  }

  static bool Read(::blink::mojom::blink::LocalResourceValue::DataView input, ::blink::mojom::blink::LocalResourceValuePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_BLINK_H_