// third_party/blink/public/mojom/loader/keep_alive_handle_factory.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/loader/keep_alive_handle_factory.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var keep_alive_handle$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/loader/keep_alive_handle.mojom', 'keep_alive_handle.mojom.js');
  }



  function KeepAliveHandleFactory_IssueKeepAliveHandle_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  KeepAliveHandleFactory_IssueKeepAliveHandle_Params.prototype.initDefaults_ = function() {
    this.keepAliveHandle = new bindings.InterfaceRequest();
  };
  KeepAliveHandleFactory_IssueKeepAliveHandle_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  KeepAliveHandleFactory_IssueKeepAliveHandle_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate KeepAliveHandleFactory_IssueKeepAliveHandle_Params.keepAliveHandle
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  KeepAliveHandleFactory_IssueKeepAliveHandle_Params.encodedSize = codec.kStructHeaderSize + 8;

  KeepAliveHandleFactory_IssueKeepAliveHandle_Params.decode = function(decoder) {
    var packed;
    var val = new KeepAliveHandleFactory_IssueKeepAliveHandle_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.keepAliveHandle =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  KeepAliveHandleFactory_IssueKeepAliveHandle_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(KeepAliveHandleFactory_IssueKeepAliveHandle_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.keepAliveHandle);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kKeepAliveHandleFactory_IssueKeepAliveHandle_Name = 0;

  function KeepAliveHandleFactoryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(KeepAliveHandleFactory,
                                                   handleOrPtrInfo);
  }

  function KeepAliveHandleFactoryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        KeepAliveHandleFactory, associatedInterfacePtrInfo);
  }

  KeepAliveHandleFactoryAssociatedPtr.prototype =
      Object.create(KeepAliveHandleFactoryPtr.prototype);
  KeepAliveHandleFactoryAssociatedPtr.prototype.constructor =
      KeepAliveHandleFactoryAssociatedPtr;

  function KeepAliveHandleFactoryProxy(receiver) {
    this.receiver_ = receiver;
  }
  KeepAliveHandleFactoryPtr.prototype.issueKeepAliveHandle = function() {
    return KeepAliveHandleFactoryProxy.prototype.issueKeepAliveHandle
        .apply(this.ptr.getProxy(), arguments);
  };

  KeepAliveHandleFactoryProxy.prototype.issueKeepAliveHandle = function(keepAliveHandle) {
    var params_ = new KeepAliveHandleFactory_IssueKeepAliveHandle_Params();
    params_.keepAliveHandle = keepAliveHandle;
    var builder = new codec.MessageV0Builder(
        kKeepAliveHandleFactory_IssueKeepAliveHandle_Name,
        codec.align(KeepAliveHandleFactory_IssueKeepAliveHandle_Params.encodedSize));
    builder.encodeStruct(KeepAliveHandleFactory_IssueKeepAliveHandle_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function KeepAliveHandleFactoryStub(delegate) {
    this.delegate_ = delegate;
  }
  KeepAliveHandleFactoryStub.prototype.issueKeepAliveHandle = function(keepAliveHandle) {
    return this.delegate_ && this.delegate_.issueKeepAliveHandle && this.delegate_.issueKeepAliveHandle(keepAliveHandle);
  }

  KeepAliveHandleFactoryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kKeepAliveHandleFactory_IssueKeepAliveHandle_Name:
      var params = reader.decodeStruct(KeepAliveHandleFactory_IssueKeepAliveHandle_Params);
      this.issueKeepAliveHandle(params.keepAliveHandle);
      return true;
    default:
      return false;
    }
  };

  KeepAliveHandleFactoryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateKeepAliveHandleFactoryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kKeepAliveHandleFactory_IssueKeepAliveHandle_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = KeepAliveHandleFactory_IssueKeepAliveHandle_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateKeepAliveHandleFactoryResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var KeepAliveHandleFactory = {
    name: 'blink.mojom.KeepAliveHandleFactory',
    kVersion: 0,
    ptrClass: KeepAliveHandleFactoryPtr,
    proxyClass: KeepAliveHandleFactoryProxy,
    stubClass: KeepAliveHandleFactoryStub,
    validateRequest: validateKeepAliveHandleFactoryRequest,
    validateResponse: null,
  };
  KeepAliveHandleFactoryStub.prototype.validator = validateKeepAliveHandleFactoryRequest;
  KeepAliveHandleFactoryProxy.prototype.validator = null;
  exports.KeepAliveHandleFactory = KeepAliveHandleFactory;
  exports.KeepAliveHandleFactoryPtr = KeepAliveHandleFactoryPtr;
  exports.KeepAliveHandleFactoryAssociatedPtr = KeepAliveHandleFactoryAssociatedPtr;
})();