// third_party/blink/public/mojom/loader/keep_alive_handle.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/loader/keep_alive_handle.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');




  function KeepAliveHandlePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(KeepAliveHandle,
                                                   handleOrPtrInfo);
  }

  function KeepAliveHandleAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        KeepAliveHandle, associatedInterfacePtrInfo);
  }

  KeepAliveHandleAssociatedPtr.prototype =
      Object.create(KeepAliveHandlePtr.prototype);
  KeepAliveHandleAssociatedPtr.prototype.constructor =
      KeepAliveHandleAssociatedPtr;

  function KeepAliveHandleProxy(receiver) {
    this.receiver_ = receiver;
  }

  function KeepAliveHandleStub(delegate) {
    this.delegate_ = delegate;
  }

  KeepAliveHandleStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  KeepAliveHandleStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateKeepAliveHandleRequest(messageValidator) {
    return validator.validationError.NONE;
  }

  function validateKeepAliveHandleResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var KeepAliveHandle = {
    name: 'blink.mojom.KeepAliveHandle',
    kVersion: 0,
    ptrClass: KeepAliveHandlePtr,
    proxyClass: KeepAliveHandleProxy,
    stubClass: KeepAliveHandleStub,
    validateRequest: validateKeepAliveHandleRequest,
    validateResponse: null,
  };
  KeepAliveHandleStub.prototype.validator = validateKeepAliveHandleRequest;
  KeepAliveHandleProxy.prototype.validator = null;
  exports.KeepAliveHandle = KeepAliveHandle;
  exports.KeepAliveHandlePtr = KeepAliveHandlePtr;
  exports.KeepAliveHandleAssociatedPtr = KeepAliveHandleAssociatedPtr;
})();