// third_party/blink/public/mojom/loader/javascript_framework_detection.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_JAVASCRIPT_FRAMEWORK_DETECTION_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_JAVASCRIPT_FRAMEWORK_DETECTION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/loader/javascript_framework_detection.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/javascript_framework_detection.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/javascript_framework_detection.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "third_party/blink/public/common/loader/javascript_framework_detection_mojom_traits.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT JavaScriptFrameworkDetectionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<JavaScriptFrameworkDetectionResult, T>::value>;
  using DataView = JavaScriptFrameworkDetectionResultDataView;
  using Data_ = internal::JavaScriptFrameworkDetectionResult_Data;

  template <typename... Args>
  static JavaScriptFrameworkDetectionResultPtr New(Args&&... args) {
    return JavaScriptFrameworkDetectionResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static JavaScriptFrameworkDetectionResultPtr From(const U& u) {
    return mojo::TypeConverter<JavaScriptFrameworkDetectionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, JavaScriptFrameworkDetectionResult>::Convert(*this);
  }


  JavaScriptFrameworkDetectionResult();

  explicit JavaScriptFrameworkDetectionResult(
      const base::flat_map<JavaScriptFramework, int16_t>& detected_versions);


  ~JavaScriptFrameworkDetectionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = JavaScriptFrameworkDetectionResultPtr>
  JavaScriptFrameworkDetectionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, JavaScriptFrameworkDetectionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, JavaScriptFrameworkDetectionResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, JavaScriptFrameworkDetectionResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        JavaScriptFrameworkDetectionResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        JavaScriptFrameworkDetectionResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        JavaScriptFrameworkDetectionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::JavaScriptFrameworkDetectionResult_UnserializedMessageContext<
            UserType, JavaScriptFrameworkDetectionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<JavaScriptFrameworkDetectionResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return JavaScriptFrameworkDetectionResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::JavaScriptFrameworkDetectionResult_UnserializedMessageContext<
            UserType, JavaScriptFrameworkDetectionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<JavaScriptFrameworkDetectionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<JavaScriptFramework, int16_t> detected_versions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, JavaScriptFrameworkDetectionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, JavaScriptFrameworkDetectionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, JavaScriptFrameworkDetectionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, JavaScriptFrameworkDetectionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
JavaScriptFrameworkDetectionResultPtr JavaScriptFrameworkDetectionResult::Clone() const {
  return New(
      mojo::Clone(detected_versions)
  );
}

template <typename T, JavaScriptFrameworkDetectionResult::EnableIfSame<T>*>
bool JavaScriptFrameworkDetectionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->detected_versions, other_struct.detected_versions))
    return false;
  return true;
}

template <typename T, JavaScriptFrameworkDetectionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.detected_versions < rhs.detected_versions)
    return true;
  if (rhs.detected_versions < lhs.detected_versions)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::JavaScriptFrameworkDetectionResult::DataView,
                                         ::blink::mojom::JavaScriptFrameworkDetectionResultPtr> {
  static bool IsNull(const ::blink::mojom::JavaScriptFrameworkDetectionResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::JavaScriptFrameworkDetectionResultPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::JavaScriptFrameworkDetectionResult::detected_versions)& detected_versions(
      const ::blink::mojom::JavaScriptFrameworkDetectionResultPtr& input) {
    return input->detected_versions;
  }

  static bool Read(::blink::mojom::JavaScriptFrameworkDetectionResult::DataView input, ::blink::mojom::JavaScriptFrameworkDetectionResultPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_JAVASCRIPT_FRAMEWORK_DETECTION_MOJOM_H_