// third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }
  var referrer_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/referrer_policy.mojom', '../../../../../services/network/public/mojom/referrer_policy.mojom.js');
  }


  var InsecureRequestsPolicy = {};
  InsecureRequestsPolicy.kDoNotUpgrade = 0;
  InsecureRequestsPolicy.kUpgrade = 1;
  InsecureRequestsPolicy.MIN_VALUE = 0;
  InsecureRequestsPolicy.MAX_VALUE = 1;

  InsecureRequestsPolicy.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  InsecureRequestsPolicy.toKnownEnumValue = function(value) {
    return value;
  };

  InsecureRequestsPolicy.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function FetchClientSettingsObject(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FetchClientSettingsObject.prototype.initDefaults_ = function() {
    this.referrerPolicy = 0;
    this.insecureRequestsPolicy = 0;
    this.outgoingReferrer = null;
  };
  FetchClientSettingsObject.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FetchClientSettingsObject.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchClientSettingsObject.referrerPolicy
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, referrer_policy$.ReferrerPolicy);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchClientSettingsObject.outgoingReferrer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchClientSettingsObject.insecureRequestsPolicy
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, InsecureRequestsPolicy);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FetchClientSettingsObject.encodedSize = codec.kStructHeaderSize + 16;

  FetchClientSettingsObject.decode = function(decoder) {
    var packed;
    var val = new FetchClientSettingsObject();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.referrerPolicy =
        decoder.decodeStruct(new codec.Enum(referrer_policy$.ReferrerPolicy));
    val.insecureRequestsPolicy =
        decoder.decodeStruct(new codec.Enum(InsecureRequestsPolicy));
    val.outgoingReferrer =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  FetchClientSettingsObject.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FetchClientSettingsObject.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.referrerPolicy);
    encoder.encodeStruct(codec.Int32, val.insecureRequestsPolicy);
    encoder.encodeStructPointer(url$.Url, val.outgoingReferrer);
  };
  exports.InsecureRequestsPolicy = InsecureRequestsPolicy;
  exports.FetchClientSettingsObject = FetchClientSettingsObject;
})();