// third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_FETCH_CLIENT_SETTINGS_OBJECT_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_FETCH_CLIENT_SETTINGS_OBJECT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"




#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::InsecureRequestsPolicy>
    : public mojo::internal::EnumHashImpl<::blink::mojom::InsecureRequestsPolicy> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::InsecureRequestsPolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::InsecureRequestsPolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::InsecureRequestsPolicy>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FetchClientSettingsObjectDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FetchClientSettingsObjectDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FetchClientSettingsObject_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
      Traits::referrer_policy(input),
      &fragment->referrer_policy);

    decltype(Traits::outgoing_referrer(input)) in_outgoing_referrer = Traits::outgoing_referrer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->outgoing_referrer)::BaseType> outgoing_referrer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_outgoing_referrer,
      outgoing_referrer_fragment);

    fragment->outgoing_referrer.Set(
        outgoing_referrer_fragment.is_null() ? nullptr : outgoing_referrer_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->outgoing_referrer.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null outgoing_referrer in FetchClientSettingsObject struct");

    
    mojo::internal::Serialize<::blink::mojom::InsecureRequestsPolicy>(
      Traits::insecure_requests_policy(input),
      &fragment->insecure_requests_policy);
  }

  static bool Deserialize(::blink::mojom::internal::FetchClientSettingsObject_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FetchClientSettingsObjectDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void FetchClientSettingsObjectDataView::GetOutgoingReferrerDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->outgoing_referrer.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::InsecureRequestsPolicy> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::InsecureRequestsPolicy value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_FETCH_CLIENT_SETTINGS_OBJECT_MOJOM_SHARED_H_