// third_party/blink/public/mojom/loader/content_security_notifier.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/loader/content_security_notifier.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params.prototype.initDefaults_ = function() {
  };
  ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params.encodedSize = codec.kStructHeaderSize + 0;

  ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params.decode = function(decoder) {
    var packed;
    var val = new ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params.prototype.initDefaults_ = function() {
  };
  ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params.encodedSize = codec.kStructHeaderSize + 0;

  ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params.decode = function(decoder) {
    var packed;
    var val = new ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ContentSecurityNotifier_NotifyInsecureContentRan_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ContentSecurityNotifier_NotifyInsecureContentRan_Params.prototype.initDefaults_ = function() {
    this.origin = null;
    this.insecureUrl = null;
  };
  ContentSecurityNotifier_NotifyInsecureContentRan_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ContentSecurityNotifier_NotifyInsecureContentRan_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ContentSecurityNotifier_NotifyInsecureContentRan_Params.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ContentSecurityNotifier_NotifyInsecureContentRan_Params.insecureUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ContentSecurityNotifier_NotifyInsecureContentRan_Params.encodedSize = codec.kStructHeaderSize + 16;

  ContentSecurityNotifier_NotifyInsecureContentRan_Params.decode = function(decoder) {
    var packed;
    var val = new ContentSecurityNotifier_NotifyInsecureContentRan_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origin =
        decoder.decodeStructPointer(url$.Url);
    val.insecureUrl =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  ContentSecurityNotifier_NotifyInsecureContentRan_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ContentSecurityNotifier_NotifyInsecureContentRan_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.origin);
    encoder.encodeStructPointer(url$.Url, val.insecureUrl);
  };
  var kContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Name = 0;
  var kContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Name = 1;
  var kContentSecurityNotifier_NotifyInsecureContentRan_Name = 2;

  function ContentSecurityNotifierPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ContentSecurityNotifier,
                                                   handleOrPtrInfo);
  }

  function ContentSecurityNotifierAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ContentSecurityNotifier, associatedInterfacePtrInfo);
  }

  ContentSecurityNotifierAssociatedPtr.prototype =
      Object.create(ContentSecurityNotifierPtr.prototype);
  ContentSecurityNotifierAssociatedPtr.prototype.constructor =
      ContentSecurityNotifierAssociatedPtr;

  function ContentSecurityNotifierProxy(receiver) {
    this.receiver_ = receiver;
  }
  ContentSecurityNotifierPtr.prototype.notifyContentWithCertificateErrorsRan = function() {
    return ContentSecurityNotifierProxy.prototype.notifyContentWithCertificateErrorsRan
        .apply(this.ptr.getProxy(), arguments);
  };

  ContentSecurityNotifierProxy.prototype.notifyContentWithCertificateErrorsRan = function() {
    var params_ = new ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params();
    var builder = new codec.MessageV0Builder(
        kContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Name,
        codec.align(ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params.encodedSize));
    builder.encodeStruct(ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ContentSecurityNotifierPtr.prototype.notifyContentWithCertificateErrorsDisplayed = function() {
    return ContentSecurityNotifierProxy.prototype.notifyContentWithCertificateErrorsDisplayed
        .apply(this.ptr.getProxy(), arguments);
  };

  ContentSecurityNotifierProxy.prototype.notifyContentWithCertificateErrorsDisplayed = function() {
    var params_ = new ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params();
    var builder = new codec.MessageV0Builder(
        kContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Name,
        codec.align(ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params.encodedSize));
    builder.encodeStruct(ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ContentSecurityNotifierPtr.prototype.notifyInsecureContentRan = function() {
    return ContentSecurityNotifierProxy.prototype.notifyInsecureContentRan
        .apply(this.ptr.getProxy(), arguments);
  };

  ContentSecurityNotifierProxy.prototype.notifyInsecureContentRan = function(origin, insecureUrl) {
    var params_ = new ContentSecurityNotifier_NotifyInsecureContentRan_Params();
    params_.origin = origin;
    params_.insecureUrl = insecureUrl;
    var builder = new codec.MessageV0Builder(
        kContentSecurityNotifier_NotifyInsecureContentRan_Name,
        codec.align(ContentSecurityNotifier_NotifyInsecureContentRan_Params.encodedSize));
    builder.encodeStruct(ContentSecurityNotifier_NotifyInsecureContentRan_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ContentSecurityNotifierStub(delegate) {
    this.delegate_ = delegate;
  }
  ContentSecurityNotifierStub.prototype.notifyContentWithCertificateErrorsRan = function() {
    return this.delegate_ && this.delegate_.notifyContentWithCertificateErrorsRan && this.delegate_.notifyContentWithCertificateErrorsRan();
  }
  ContentSecurityNotifierStub.prototype.notifyContentWithCertificateErrorsDisplayed = function() {
    return this.delegate_ && this.delegate_.notifyContentWithCertificateErrorsDisplayed && this.delegate_.notifyContentWithCertificateErrorsDisplayed();
  }
  ContentSecurityNotifierStub.prototype.notifyInsecureContentRan = function(origin, insecureUrl) {
    return this.delegate_ && this.delegate_.notifyInsecureContentRan && this.delegate_.notifyInsecureContentRan(origin, insecureUrl);
  }

  ContentSecurityNotifierStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Name:
      var params = reader.decodeStruct(ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params);
      this.notifyContentWithCertificateErrorsRan();
      return true;
    case kContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Name:
      var params = reader.decodeStruct(ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params);
      this.notifyContentWithCertificateErrorsDisplayed();
      return true;
    case kContentSecurityNotifier_NotifyInsecureContentRan_Name:
      var params = reader.decodeStruct(ContentSecurityNotifier_NotifyInsecureContentRan_Params);
      this.notifyInsecureContentRan(params.origin, params.insecureUrl);
      return true;
    default:
      return false;
    }
  };

  ContentSecurityNotifierStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateContentSecurityNotifierRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params;
      break;
      case kContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params;
      break;
      case kContentSecurityNotifier_NotifyInsecureContentRan_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ContentSecurityNotifier_NotifyInsecureContentRan_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateContentSecurityNotifierResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ContentSecurityNotifier = {
    name: 'blink.mojom.ContentSecurityNotifier',
    kVersion: 0,
    ptrClass: ContentSecurityNotifierPtr,
    proxyClass: ContentSecurityNotifierProxy,
    stubClass: ContentSecurityNotifierStub,
    validateRequest: validateContentSecurityNotifierRequest,
    validateResponse: null,
  };
  ContentSecurityNotifierStub.prototype.validator = validateContentSecurityNotifierRequest;
  ContentSecurityNotifierProxy.prototype.validator = null;
  exports.ContentSecurityNotifier = ContentSecurityNotifier;
  exports.ContentSecurityNotifierPtr = ContentSecurityNotifierPtr;
  exports.ContentSecurityNotifierAssociatedPtr = ContentSecurityNotifierAssociatedPtr;
})();