// third_party/blink/public/mojom/loader/code_cache.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/loader/code_cache.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/loader/code_cache.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* CodeCacheTypeToStringHelper(CodeCacheType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CodeCacheType::kJavascript:
      return "kJavascript";
    case CodeCacheType::kWebAssembly:
      return "kWebAssembly";
    default:
      return nullptr;
  }
}

std::string CodeCacheTypeToString(CodeCacheType value) {
  const char *str = CodeCacheTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CodeCacheType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CodeCacheType value) {
  return os << CodeCacheTypeToString(value);
}

namespace internal {


// static
bool CodeCacheHost_GetPendingBackend_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CodeCacheHost_GetPendingBackend_Params_Data* object =
      static_cast<const CodeCacheHost_GetPendingBackend_Params_Data*>(data);


  if (!::blink::mojom::internal::CodeCacheType_Data
        ::Validate(object->cache_type, validation_context))
    return false;

  return true;
}

CodeCacheHost_GetPendingBackend_Params_Data::CodeCacheHost_GetPendingBackend_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CodeCacheHost_GetPendingBackend_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CodeCacheHost_GetPendingBackend_ResponseParams_Data* object =
      static_cast<const CodeCacheHost_GetPendingBackend_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->pending_backend, validation_context))
    return false;

  return true;
}

CodeCacheHost_GetPendingBackend_ResponseParams_Data::CodeCacheHost_GetPendingBackend_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CodeCacheHost_DidGenerateCacheableMetadata_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CodeCacheHost_DidGenerateCacheableMetadata_Params_Data* object =
      static_cast<const CodeCacheHost_DidGenerateCacheableMetadata_Params_Data*>(data);


  if (!::blink::mojom::internal::CodeCacheType_Data
        ::Validate(object->cache_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expected_response_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expected_response_time, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

CodeCacheHost_DidGenerateCacheableMetadata_Params_Data::CodeCacheHost_DidGenerateCacheableMetadata_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CodeCacheHost_FetchCachedCode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CodeCacheHost_FetchCachedCode_Params_Data* object =
      static_cast<const CodeCacheHost_FetchCachedCode_Params_Data*>(data);


  if (!::blink::mojom::internal::CodeCacheType_Data
        ::Validate(object->cache_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

CodeCacheHost_FetchCachedCode_Params_Data::CodeCacheHost_FetchCachedCode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CodeCacheHost_FetchCachedCode_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CodeCacheHost_FetchCachedCode_ResponseParams_Data* object =
      static_cast<const CodeCacheHost_FetchCachedCode_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_time, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

CodeCacheHost_FetchCachedCode_ResponseParams_Data::CodeCacheHost_FetchCachedCode_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CodeCacheHost_ClearCodeCacheEntry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CodeCacheHost_ClearCodeCacheEntry_Params_Data* object =
      static_cast<const CodeCacheHost_ClearCodeCacheEntry_Params_Data*>(data);


  if (!::blink::mojom::internal::CodeCacheType_Data
        ::Validate(object->cache_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

CodeCacheHost_ClearCodeCacheEntry_Params_Data::CodeCacheHost_ClearCodeCacheEntry_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data* object =
      static_cast<const CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expected_response_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expected_response_time, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_storage_cache_name, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cache_storage_cache_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cache_storage_cache_name, validation_context,
                                         &cache_storage_cache_name_validate_params)) {
    return false;
  }

  return true;
}

CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data::CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CodeCacheType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::CodeCacheType value) {
  return std::move(context).WriteString(::blink::mojom::CodeCacheTypeToString(value));
}

} // namespace perfetto