// third_party/blink/public/mojom/loader/code_cache.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CodeCacheTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.CodeCacheType = {
  
  kJavascript: 0,
  kWebAssembly: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.CodeCacheHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.CodeCacheHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.CodeCacheHostInterface }
 */
blink.mojom.CodeCacheHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.CodeCacheHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.CodeCacheHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.CodeCacheHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.CodeCacheType } cacheType
   * @return {!Promise<{
        pendingBackend: ?persistentCache.mojom.PendingReadOnlyBackend,
   *  }>}
   */

  getPendingBackend(
      cacheType) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.CodeCacheHost_GetPendingBackend_ParamsSpec.$,
        blink.mojom.CodeCacheHost_GetPendingBackend_ResponseParamsSpec.$,
        [
          cacheType
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.CodeCacheType } cacheType
   * @param { !url.mojom.Url } url
   * @param { !mojoBase.mojom.Time } expectedResponseTime
   * @param { !mojoBase.mojom.BigBuffer } data
   */

  didGenerateCacheableMetadata(
      cacheType,
      url,
      expectedResponseTime,
      data) {
    this.proxy.sendMessage(
        1,
        blink.mojom.CodeCacheHost_DidGenerateCacheableMetadata_ParamsSpec.$,
        null,
        [
          cacheType,
          url,
          expectedResponseTime,
          data
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.CodeCacheType } cacheType
   * @param { !url.mojom.Url } url
   * @return {!Promise<{
        responseTime: !mojoBase.mojom.Time,
        data: !mojoBase.mojom.BigBuffer,
   *  }>}
   */

  fetchCachedCode(
      cacheType,
      url) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.CodeCacheHost_FetchCachedCode_ParamsSpec.$,
        blink.mojom.CodeCacheHost_FetchCachedCode_ResponseParamsSpec.$,
        [
          cacheType,
          url
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.CodeCacheType } cacheType
   * @param { !url.mojom.Url } url
   */

  clearCodeCacheEntry(
      cacheType,
      url) {
    this.proxy.sendMessage(
        3,
        blink.mojom.CodeCacheHost_ClearCodeCacheEntry_ParamsSpec.$,
        null,
        [
          cacheType,
          url
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !mojoBase.mojom.Time } expectedResponseTime
   * @param { !mojoBase.mojom.BigBuffer } data
   * @param { !string } cacheStorageCacheName
   */

  didGenerateCacheableMetadataInCacheStorage(
      url,
      expectedResponseTime,
      data,
      cacheStorageCacheName) {
    this.proxy.sendMessage(
        4,
        blink.mojom.CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_ParamsSpec.$,
        null,
        [
          url,
          expectedResponseTime,
          data,
          cacheStorageCacheName
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CodeCacheHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.CodeCacheHostReceiver = class {
  /**
   * @param {!blink.mojom.CodeCacheHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.CodeCacheHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.CodeCacheHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.CodeCacheHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.CodeCacheHost_GetPendingBackend_ParamsSpec.$,
        blink.mojom.CodeCacheHost_GetPendingBackend_ResponseParamsSpec.$,
        impl.getPendingBackend.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.CodeCacheHost_DidGenerateCacheableMetadata_ParamsSpec.$,
        null,
        impl.didGenerateCacheableMetadata.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.CodeCacheHost_FetchCachedCode_ParamsSpec.$,
        blink.mojom.CodeCacheHost_FetchCachedCode_ResponseParamsSpec.$,
        impl.fetchCachedCode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.CodeCacheHost_ClearCodeCacheEntry_ParamsSpec.$,
        null,
        impl.clearCodeCacheEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_ParamsSpec.$,
        null,
        impl.didGenerateCacheableMetadataInCacheStorage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.CodeCacheHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.CodeCacheHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.CodeCacheHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.CodeCacheHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CodeCacheHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.CodeCacheHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.CodeCacheHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.CodeCacheHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPendingBackend =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.CodeCacheHost_GetPendingBackend_ParamsSpec.$,
        blink.mojom.CodeCacheHost_GetPendingBackend_ResponseParamsSpec.$,
        this.getPendingBackend.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didGenerateCacheableMetadata =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.CodeCacheHost_DidGenerateCacheableMetadata_ParamsSpec.$,
        null,
        this.didGenerateCacheableMetadata.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fetchCachedCode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.CodeCacheHost_FetchCachedCode_ParamsSpec.$,
        blink.mojom.CodeCacheHost_FetchCachedCode_ResponseParamsSpec.$,
        this.fetchCachedCode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearCodeCacheEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.CodeCacheHost_ClearCodeCacheEntry_ParamsSpec.$,
        null,
        this.clearCodeCacheEntry.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didGenerateCacheableMetadataInCacheStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_ParamsSpec.$,
        null,
        this.didGenerateCacheableMetadataInCacheStorage.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CodeCacheHost_GetPendingBackend_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CodeCacheHost_GetPendingBackend_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CodeCacheHost_DidGenerateCacheableMetadata_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CodeCacheHost_FetchCachedCode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CodeCacheHost_FetchCachedCode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CodeCacheHost_ClearCodeCacheEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.CodeCacheHost_GetPendingBackend_ParamsSpec.$,
    'CodeCacheHost_GetPendingBackend_Params',
    [
      mojo.internal.StructField(
        'cacheType', 0,
        0,
        blink.mojom.CodeCacheTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.CodeCacheHost_GetPendingBackend_Params = class {
  constructor() {
    /** @export { !blink.mojom.CodeCacheType } */
    this.cacheType;
  }
};



mojo.internal.Struct(
    blink.mojom.CodeCacheHost_GetPendingBackend_ResponseParamsSpec.$,
    'CodeCacheHost_GetPendingBackend_ResponseParams',
    [
      mojo.internal.StructField(
        'pendingBackend', 0,
        0,
        persistentCache.mojom.PendingReadOnlyBackendSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.CodeCacheHost_GetPendingBackend_ResponseParams = class {
  constructor() {
    /** @export { (persistentCache.mojom.PendingReadOnlyBackend|undefined) } */
    this.pendingBackend;
  }
};



mojo.internal.Struct(
    blink.mojom.CodeCacheHost_DidGenerateCacheableMetadata_ParamsSpec.$,
    'CodeCacheHost_DidGenerateCacheableMetadata_Params',
    [
      mojo.internal.StructField(
        'cacheType', 0,
        0,
        blink.mojom.CodeCacheTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expectedResponseTime', 16,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 24,
        0,
        mojoBase.mojom.BigBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.CodeCacheHost_DidGenerateCacheableMetadata_Params = class {
  constructor() {
    /** @export { !blink.mojom.CodeCacheType } */
    this.cacheType;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !mojoBase.mojom.Time } */
    this.expectedResponseTime;
    /** @export { !mojoBase.mojom.BigBuffer } */
    this.data;
  }
};



mojo.internal.Struct(
    blink.mojom.CodeCacheHost_FetchCachedCode_ParamsSpec.$,
    'CodeCacheHost_FetchCachedCode_Params',
    [
      mojo.internal.StructField(
        'cacheType', 0,
        0,
        blink.mojom.CodeCacheTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CodeCacheHost_FetchCachedCode_Params = class {
  constructor() {
    /** @export { !blink.mojom.CodeCacheType } */
    this.cacheType;
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.CodeCacheHost_FetchCachedCode_ResponseParamsSpec.$,
    'CodeCacheHost_FetchCachedCode_ResponseParams',
    [
      mojo.internal.StructField(
        'responseTime', 0,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase.mojom.BigBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.CodeCacheHost_FetchCachedCode_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.Time } */
    this.responseTime;
    /** @export { !mojoBase.mojom.BigBuffer } */
    this.data;
  }
};



mojo.internal.Struct(
    blink.mojom.CodeCacheHost_ClearCodeCacheEntry_ParamsSpec.$,
    'CodeCacheHost_ClearCodeCacheEntry_Params',
    [
      mojo.internal.StructField(
        'cacheType', 0,
        0,
        blink.mojom.CodeCacheTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CodeCacheHost_ClearCodeCacheEntry_Params = class {
  constructor() {
    /** @export { !blink.mojom.CodeCacheType } */
    this.cacheType;
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_ParamsSpec.$,
    'CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expectedResponseTime', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 16,
        0,
        mojoBase.mojom.BigBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cacheStorageCacheName', 32,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !mojoBase.mojom.Time } */
    this.expectedResponseTime;
    /** @export { !mojoBase.mojom.BigBuffer } */
    this.data;
    /** @export { !string } */
    this.cacheStorageCacheName;
  }
};

