// third_party/blink/public/mojom/loader/code_cache.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/loader/code_cache.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/loader/code_cache.mojom-params-data.h"
#include "third_party/blink/public/mojom/loader/code_cache.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/loader/code_cache.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/loader/code_cache.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

CodeCacheHost::IPCStableHashFunction CodeCacheHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CodeCacheHost>(message.name())) {
    case messages::CodeCacheHost::kGetPendingBackend: {
      return &CodeCacheHost::GetPendingBackend_Sym::IPCStableHash;
    }
    case messages::CodeCacheHost::kDidGenerateCacheableMetadata: {
      return &CodeCacheHost::DidGenerateCacheableMetadata_Sym::IPCStableHash;
    }
    case messages::CodeCacheHost::kFetchCachedCode: {
      return &CodeCacheHost::FetchCachedCode_Sym::IPCStableHash;
    }
    case messages::CodeCacheHost::kClearCodeCacheEntry: {
      return &CodeCacheHost::ClearCodeCacheEntry_Sym::IPCStableHash;
    }
    case messages::CodeCacheHost::kDidGenerateCacheableMetadataInCacheStorage: {
      return &CodeCacheHost::DidGenerateCacheableMetadataInCacheStorage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CodeCacheHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CodeCacheHost>(message.name())) {
      case messages::CodeCacheHost::kGetPendingBackend:
            return "Receive blink::mojom::CodeCacheHost::GetPendingBackend";
      case messages::CodeCacheHost::kDidGenerateCacheableMetadata:
            return "Receive blink::mojom::CodeCacheHost::DidGenerateCacheableMetadata";
      case messages::CodeCacheHost::kFetchCachedCode:
            return "Receive blink::mojom::CodeCacheHost::FetchCachedCode";
      case messages::CodeCacheHost::kClearCodeCacheEntry:
            return "Receive blink::mojom::CodeCacheHost::ClearCodeCacheEntry";
      case messages::CodeCacheHost::kDidGenerateCacheableMetadataInCacheStorage:
            return "Receive blink::mojom::CodeCacheHost::DidGenerateCacheableMetadataInCacheStorage";
    }
  } else {
    switch (static_cast<messages::CodeCacheHost>(message.name())) {
      case messages::CodeCacheHost::kGetPendingBackend:
            return "Receive reply blink::mojom::CodeCacheHost::GetPendingBackend";
      case messages::CodeCacheHost::kDidGenerateCacheableMetadata:
            return "Receive reply blink::mojom::CodeCacheHost::DidGenerateCacheableMetadata";
      case messages::CodeCacheHost::kFetchCachedCode:
            return "Receive reply blink::mojom::CodeCacheHost::FetchCachedCode";
      case messages::CodeCacheHost::kClearCodeCacheEntry:
            return "Receive reply blink::mojom::CodeCacheHost::ClearCodeCacheEntry";
      case messages::CodeCacheHost::kDidGenerateCacheableMetadataInCacheStorage:
            return "Receive reply blink::mojom::CodeCacheHost::DidGenerateCacheableMetadataInCacheStorage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CodeCacheHost::GetPendingBackend_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4e27ddbc;  // IPCStableHash for blink::mojom::CodeCacheHost::GetPendingBackend
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CodeCacheHost::DidGenerateCacheableMetadata_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe893ae3b;  // IPCStableHash for blink::mojom::CodeCacheHost::DidGenerateCacheableMetadata
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CodeCacheHost::FetchCachedCode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc58d2602;  // IPCStableHash for blink::mojom::CodeCacheHost::FetchCachedCode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CodeCacheHost::ClearCodeCacheEntry_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x807b8b68;  // IPCStableHash for blink::mojom::CodeCacheHost::ClearCodeCacheEntry
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CodeCacheHost::DidGenerateCacheableMetadataInCacheStorage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x12f65250;  // IPCStableHash for blink::mojom::CodeCacheHost::DidGenerateCacheableMetadataInCacheStorage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CodeCacheHost_GetPendingBackend_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CodeCacheHost_GetPendingBackend_ForwardToCallback(
      CodeCacheHost::GetPendingBackendCallback callback
      ) : callback_(std::move(callback)) {
  }

  CodeCacheHost_GetPendingBackend_ForwardToCallback(const CodeCacheHost_GetPendingBackend_ForwardToCallback&) = delete;
  CodeCacheHost_GetPendingBackend_ForwardToCallback& operator=(const CodeCacheHost_GetPendingBackend_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CodeCacheHost::GetPendingBackendCallback callback_;
};

class CodeCacheHost_FetchCachedCode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CodeCacheHost_FetchCachedCode_ForwardToCallback(
      CodeCacheHost::FetchCachedCodeCallback callback
      ) : callback_(std::move(callback)) {
  }

  CodeCacheHost_FetchCachedCode_ForwardToCallback(const CodeCacheHost_FetchCachedCode_ForwardToCallback&) = delete;
  CodeCacheHost_FetchCachedCode_ForwardToCallback& operator=(const CodeCacheHost_FetchCachedCode_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CodeCacheHost::FetchCachedCodeCallback callback_;
};

CodeCacheHostProxy::CodeCacheHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CodeCacheHostProxy::GetPendingBackend(
    CodeCacheType in_cache_type, GetPendingBackendCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CodeCacheHost::GetPendingBackend", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_type"), in_cache_type,
                        "<value of type CodeCacheType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CodeCacheHost::kGetPendingBackend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CodeCacheHost_GetPendingBackend_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::CodeCacheType>(
    in_cache_type,
    &params->cache_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CodeCacheHost::Name_);
  message.set_method_name("GetPendingBackend");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CodeCacheHost_GetPendingBackend_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CodeCacheHostProxy::DidGenerateCacheableMetadata(
    CodeCacheType in_cache_type, const ::blink::KURL& in_url, ::base::Time in_expected_response_time, ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CodeCacheHost::DidGenerateCacheableMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_type"), in_cache_type,
                        "<value of type CodeCacheType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expected_response_time"), in_expected_response_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CodeCacheHost::kDidGenerateCacheableMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CodeCacheHost_DidGenerateCacheableMetadata_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::CodeCacheType>(
    in_cache_type,
    &params->cache_type);
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in CodeCacheHost.DidGenerateCacheableMetadata request");
  mojo::internal::MessageFragment<
      typename decltype(params->expected_response_time)::BaseType> expected_response_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_expected_response_time,
    expected_response_time_fragment);

  params->expected_response_time.Set(
      expected_response_time_fragment.is_null() ? nullptr : expected_response_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->expected_response_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null expected_response_time in CodeCacheHost.DidGenerateCacheableMetadata request");
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in CodeCacheHost.DidGenerateCacheableMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CodeCacheHost::Name_);
  message.set_method_name("DidGenerateCacheableMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CodeCacheHostProxy::FetchCachedCode(
    CodeCacheType in_cache_type, const ::blink::KURL& in_url, FetchCachedCodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CodeCacheHost::FetchCachedCode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_type"), in_cache_type,
                        "<value of type CodeCacheType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CodeCacheHost::kFetchCachedCode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CodeCacheHost_FetchCachedCode_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::CodeCacheType>(
    in_cache_type,
    &params->cache_type);
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in CodeCacheHost.FetchCachedCode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CodeCacheHost::Name_);
  message.set_method_name("FetchCachedCode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CodeCacheHost_FetchCachedCode_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CodeCacheHostProxy::ClearCodeCacheEntry(
    CodeCacheType in_cache_type, const ::blink::KURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CodeCacheHost::ClearCodeCacheEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_type"), in_cache_type,
                        "<value of type CodeCacheType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CodeCacheHost::kClearCodeCacheEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CodeCacheHost_ClearCodeCacheEntry_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::CodeCacheType>(
    in_cache_type,
    &params->cache_type);
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in CodeCacheHost.ClearCodeCacheEntry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CodeCacheHost::Name_);
  message.set_method_name("ClearCodeCacheEntry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CodeCacheHostProxy::DidGenerateCacheableMetadataInCacheStorage(
    const ::blink::KURL& in_url, ::base::Time in_expected_response_time, ::mojo_base::BigBuffer in_data, const ::blink::String& in_cache_storage_cache_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CodeCacheHost::DidGenerateCacheableMetadataInCacheStorage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expected_response_time"), in_expected_response_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo_base::BigBuffer>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_storage_cache_name"), in_cache_storage_cache_name,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CodeCacheHost::kDidGenerateCacheableMetadataInCacheStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in CodeCacheHost.DidGenerateCacheableMetadataInCacheStorage request");
  mojo::internal::MessageFragment<
      typename decltype(params->expected_response_time)::BaseType> expected_response_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_expected_response_time,
    expected_response_time_fragment);

  params->expected_response_time.Set(
      expected_response_time_fragment.is_null() ? nullptr : expected_response_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->expected_response_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null expected_response_time in CodeCacheHost.DidGenerateCacheableMetadataInCacheStorage request");
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in CodeCacheHost.DidGenerateCacheableMetadataInCacheStorage request");
  mojo::internal::MessageFragment<
      typename decltype(params->cache_storage_cache_name)::BaseType> cache_storage_cache_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_cache_storage_cache_name,
    cache_storage_cache_name_fragment);

  params->cache_storage_cache_name.Set(
      cache_storage_cache_name_fragment.is_null() ? nullptr : cache_storage_cache_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cache_storage_cache_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cache_storage_cache_name in CodeCacheHost.DidGenerateCacheableMetadataInCacheStorage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CodeCacheHost::Name_);
  message.set_method_name("DidGenerateCacheableMetadataInCacheStorage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class CodeCacheHost_GetPendingBackend_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CodeCacheHost::GetPendingBackendCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CodeCacheHost_GetPendingBackend_ProxyToResponder> proxy(
        new CodeCacheHost_GetPendingBackend_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CodeCacheHost_GetPendingBackend_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CodeCacheHost_GetPendingBackend_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CodeCacheHost_GetPendingBackend_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CodeCacheHost::GetPendingBackendCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::persistent_cache::PendingBackend> in_pending_backend);
};

bool CodeCacheHost_GetPendingBackend_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CodeCacheHost_GetPendingBackend_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CodeCacheHost_GetPendingBackend_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CodeCacheHost.0
  bool success = true;
  std::optional<::persistent_cache::PendingBackend> p_pending_backend{};
  CodeCacheHost_GetPendingBackend_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPendingBackend(&p_pending_backend))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CodeCacheHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_pending_backend));
  }
  return true;
}

void CodeCacheHost_GetPendingBackend_ProxyToResponder::Run(
    std::optional<::persistent_cache::PendingBackend> in_pending_backend) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CodeCacheHost::GetPendingBackend", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pending_backend"), in_pending_backend,
                        "<value of type std::optional<::persistent_cache::PendingBackend>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CodeCacheHost::kGetPendingBackend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CodeCacheHost_GetPendingBackend_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pending_backend)::BaseType> pending_backend_fragment(
          params.message());
  
  mojo::internal::Serialize<::persistent_cache::mojom::PendingReadOnlyBackendDataView>(
    in_pending_backend,
    pending_backend_fragment);

  params->pending_backend.Set(
      pending_backend_fragment.is_null() ? nullptr : pending_backend_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CodeCacheHost::Name_);
  message.set_method_name("GetPendingBackend");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CodeCacheHost_FetchCachedCode_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CodeCacheHost::FetchCachedCodeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CodeCacheHost_FetchCachedCode_ProxyToResponder> proxy(
        new CodeCacheHost_FetchCachedCode_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CodeCacheHost_FetchCachedCode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CodeCacheHost_FetchCachedCode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CodeCacheHost_FetchCachedCode_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CodeCacheHost::FetchCachedCodeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Time in_response_time, ::mojo_base::BigBuffer in_data);
};

bool CodeCacheHost_FetchCachedCode_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CodeCacheHost_FetchCachedCode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CodeCacheHost_FetchCachedCode_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CodeCacheHost.2
  bool success = true;
  ::base::Time p_response_time{};
  ::mojo_base::BigBuffer p_data{};
  CodeCacheHost_FetchCachedCode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResponseTime(&p_response_time))
    success = false;
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CodeCacheHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_response_time), 
std::move(p_data));
  }
  return true;
}

void CodeCacheHost_FetchCachedCode_ProxyToResponder::Run(
    ::base::Time in_response_time, ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CodeCacheHost::FetchCachedCode", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_time"), in_response_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CodeCacheHost::kFetchCachedCode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CodeCacheHost_FetchCachedCode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response_time)::BaseType> response_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_response_time,
    response_time_fragment);

  params->response_time.Set(
      response_time_fragment.is_null() ? nullptr : response_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response_time in ");
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CodeCacheHost::Name_);
  message.set_method_name("FetchCachedCode");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CodeCacheHostStubDispatch::Accept(
    CodeCacheHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CodeCacheHost>(message->header()->name)) {
    case messages::CodeCacheHost::kGetPendingBackend: {
      break;
    }
    case messages::CodeCacheHost::kDidGenerateCacheableMetadata: {
      DCHECK(message->is_serialized());
      internal::CodeCacheHost_DidGenerateCacheableMetadata_Params_Data* params =
          reinterpret_cast<internal::CodeCacheHost_DidGenerateCacheableMetadata_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CodeCacheHost.1
      bool success = true;
      CodeCacheType p_cache_type{};
      ::blink::KURL p_url{};
      ::base::Time p_expected_response_time{};
      ::mojo_base::BigBuffer p_data{};
      CodeCacheHost_DidGenerateCacheableMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCacheType(&p_cache_type))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadExpectedResponseTime(&p_expected_response_time))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CodeCacheHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidGenerateCacheableMetadata(        
        std::move(p_cache_type), 
        std::move(p_url), 
        std::move(p_expected_response_time), 
        std::move(p_data));
      return true;
    }
    case messages::CodeCacheHost::kFetchCachedCode: {
      break;
    }
    case messages::CodeCacheHost::kClearCodeCacheEntry: {
      DCHECK(message->is_serialized());
      internal::CodeCacheHost_ClearCodeCacheEntry_Params_Data* params =
          reinterpret_cast<internal::CodeCacheHost_ClearCodeCacheEntry_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CodeCacheHost.3
      bool success = true;
      CodeCacheType p_cache_type{};
      ::blink::KURL p_url{};
      CodeCacheHost_ClearCodeCacheEntry_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCacheType(&p_cache_type))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CodeCacheHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearCodeCacheEntry(        
        std::move(p_cache_type), 
        std::move(p_url));
      return true;
    }
    case messages::CodeCacheHost::kDidGenerateCacheableMetadataInCacheStorage: {
      DCHECK(message->is_serialized());
      internal::CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data* params =
          reinterpret_cast<internal::CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CodeCacheHost.4
      bool success = true;
      ::blink::KURL p_url{};
      ::base::Time p_expected_response_time{};
      ::mojo_base::BigBuffer p_data{};
      ::blink::String p_cache_storage_cache_name{};
      CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadExpectedResponseTime(&p_expected_response_time))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success && !input_data_view.ReadCacheStorageCacheName(&p_cache_storage_cache_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CodeCacheHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidGenerateCacheableMetadataInCacheStorage(        
        std::move(p_url), 
        std::move(p_expected_response_time), 
        std::move(p_data), 
        std::move(p_cache_storage_cache_name));
      return true;
    }
  }
  return false;
}

// static
bool CodeCacheHostStubDispatch::AcceptWithResponder(
    CodeCacheHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CodeCacheHost>(message->header()->name)) {
    case messages::CodeCacheHost::kGetPendingBackend: {
      internal::CodeCacheHost_GetPendingBackend_Params_Data* params =
          reinterpret_cast<
              internal::CodeCacheHost_GetPendingBackend_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CodeCacheHost.0
      bool success = true;
      CodeCacheType p_cache_type{};
      CodeCacheHost_GetPendingBackend_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCacheType(&p_cache_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CodeCacheHost::Name_, 0, false);
        return false;
      }
      auto callback =
          CodeCacheHost_GetPendingBackend_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPendingBackend(        
        std::move(p_cache_type), std::move(callback));
      return true;
    }
    case messages::CodeCacheHost::kDidGenerateCacheableMetadata: {
      break;
    }
    case messages::CodeCacheHost::kFetchCachedCode: {
      internal::CodeCacheHost_FetchCachedCode_Params_Data* params =
          reinterpret_cast<
              internal::CodeCacheHost_FetchCachedCode_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CodeCacheHost.2
      bool success = true;
      CodeCacheType p_cache_type{};
      ::blink::KURL p_url{};
      CodeCacheHost_FetchCachedCode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCacheType(&p_cache_type))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CodeCacheHost::Name_, 2, false);
        return false;
      }
      auto callback =
          CodeCacheHost_FetchCachedCode_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FetchCachedCode(        
        std::move(p_cache_type), 
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::CodeCacheHost::kClearCodeCacheEntry: {
      break;
    }
    case messages::CodeCacheHost::kDidGenerateCacheableMetadataInCacheStorage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCodeCacheHostValidationInfo[] = {
    { &internal::CodeCacheHost_GetPendingBackend_Params_Data::Validate,
     &internal::CodeCacheHost_GetPendingBackend_ResponseParams_Data::Validate},
    { &internal::CodeCacheHost_DidGenerateCacheableMetadata_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CodeCacheHost_FetchCachedCode_Params_Data::Validate,
     &internal::CodeCacheHost_FetchCachedCode_ResponseParams_Data::Validate},
    { &internal::CodeCacheHost_ClearCodeCacheEntry_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data::Validate,
     nullptr /* no response */},
};

bool CodeCacheHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::CodeCacheHost::Name_,
    kCodeCacheHostValidationInfo);
}

bool CodeCacheHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::CodeCacheHost::Name_,
    kCodeCacheHostValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void CodeCacheHostInterceptorForTesting::GetPendingBackend(CodeCacheType cache_type, GetPendingBackendCallback callback) {
  GetForwardingInterface()->GetPendingBackend(
    std::move(cache_type)
    , std::move(callback));
}
void CodeCacheHostInterceptorForTesting::DidGenerateCacheableMetadata(CodeCacheType cache_type, const ::blink::KURL& url, ::base::Time expected_response_time, ::mojo_base::BigBuffer data) {
  GetForwardingInterface()->DidGenerateCacheableMetadata(
    std::move(cache_type)
    , 
    std::move(url)
    , 
    std::move(expected_response_time)
    , 
    std::move(data)
    );
}
void CodeCacheHostInterceptorForTesting::FetchCachedCode(CodeCacheType cache_type, const ::blink::KURL& url, FetchCachedCodeCallback callback) {
  GetForwardingInterface()->FetchCachedCode(
    std::move(cache_type)
    , 
    std::move(url)
    , std::move(callback));
}
void CodeCacheHostInterceptorForTesting::ClearCodeCacheEntry(CodeCacheType cache_type, const ::blink::KURL& url) {
  GetForwardingInterface()->ClearCodeCacheEntry(
    std::move(cache_type)
    , 
    std::move(url)
    );
}
void CodeCacheHostInterceptorForTesting::DidGenerateCacheableMetadataInCacheStorage(const ::blink::KURL& url, ::base::Time expected_response_time, ::mojo_base::BigBuffer data, const ::blink::String& cache_storage_cache_name) {
  GetForwardingInterface()->DidGenerateCacheableMetadataInCacheStorage(
    std::move(url)
    , 
    std::move(expected_response_time)
    , 
    std::move(data)
    , 
    std::move(cache_storage_cache_name)
    );
}
CodeCacheHostAsyncWaiter::CodeCacheHostAsyncWaiter(
    CodeCacheHost* proxy) : proxy_(proxy) {}

CodeCacheHostAsyncWaiter::~CodeCacheHostAsyncWaiter() = default;


void CodeCacheHostAsyncWaiter::GetPendingBackend(
    CodeCacheType cache_type, std::optional<::persistent_cache::PendingBackend>* out_pending_backend) {
  base::RunLoop loop;
  proxy_->GetPendingBackend(
      std::move(cache_type),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::persistent_cache::PendingBackend>* out_pending_backend
,
             std::optional<::persistent_cache::PendingBackend> pending_backend) {*out_pending_backend = std::move(pending_backend);
            loop->Quit();
          },
          &loop,
          out_pending_backend));
  loop.Run();
}

std::optional<::persistent_cache::PendingBackend> CodeCacheHostAsyncWaiter::GetPendingBackend(
    CodeCacheType cache_type) {
  std::optional<::persistent_cache::PendingBackend> async_wait_result;
  GetPendingBackend(std::move(cache_type),&async_wait_result);
  return async_wait_result;
}

void CodeCacheHostAsyncWaiter::FetchCachedCode(
    CodeCacheType cache_type, const ::blink::KURL& url, ::base::Time* out_response_time, ::mojo_base::BigBuffer* out_data) {
  base::RunLoop loop;
  proxy_->FetchCachedCode(
      std::move(cache_type),
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::Time* out_response_time
,
             ::mojo_base::BigBuffer* out_data
,
             ::base::Time response_time,
             ::mojo_base::BigBuffer data) {*out_response_time = std::move(response_time);*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_response_time,
          out_data));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif