// third_party/blink/public/mojom/link_to_text/link_to_text.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const LinkGenerationReadyStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const LinkGenerationReadyStatus = {
  
  kRequestedBeforeReady: 0,
  kRequestedAfterReady: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const LinkGenerationErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const LinkGenerationError = {
  
  kNone: -1,
  kIncorrectSelector: 0,
  kNoRange: 1,
  kNoContext: 2,
  kContextExhausted: 3,
  kContextLimitReached: 4,
  kEmptySelection: 5,
  kTabHidden: 6,
  kOmniboxNavigation: 7,
  kTabCrash: 8,
  kUnknown: 9,
  kIFrame: 10,
  kTimeout: 11,
  kBlockList: 12,
  kNoRemoteConnection: 13,
  kNotGenerated: 14,
  MIN_VALUE: -1,
  MAX_VALUE: 14,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TextFragmentReceiverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.TextFragmentReceiver', scope);
  }
}

/** @interface */
export class TextFragmentReceiverInterface {
  
  /**
   */

  cancel() {}
  
  /**
   * @return {!Promise<{
        selector: !string,
        error: !LinkGenerationError,
        readyStatus: !LinkGenerationReadyStatus,
   *  }>}
   */

  requestSelector() {}
  
  /**
   */

  removeFragments() {}
  
  /**
   * @return {!Promise<{
        text: !Array<!string>,
   *  }>}
   */

  extractTextFragmentsMatches() {}
  
  /**
   * @return {!Promise<{
        selectors: !Array<!string>,
   *  }>}
   */

  getExistingSelectors() {}
  
  /**
   * @return {!Promise<{
        bounds: !gfx_mojom_Rect,
   *  }>}
   */

  extractFirstFragmentRect() {}
}

/**
 * @implements { TextFragmentReceiverInterface }
 */
export class TextFragmentReceiverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TextFragmentReceiverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TextFragmentReceiverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TextFragmentReceiverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  cancel() {
    this.proxy.sendMessage(
        0,
        TextFragmentReceiver_Cancel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        selector: !string,
        error: !LinkGenerationError,
        readyStatus: !LinkGenerationReadyStatus,
   *  }>}
   */

  requestSelector() {
    return this.proxy.sendMessage(
        1,
        TextFragmentReceiver_RequestSelector_ParamsSpec.$,
        TextFragmentReceiver_RequestSelector_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   */

  removeFragments() {
    this.proxy.sendMessage(
        2,
        TextFragmentReceiver_RemoveFragments_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        text: !Array<!string>,
   *  }>}
   */

  extractTextFragmentsMatches() {
    return this.proxy.sendMessage(
        3,
        TextFragmentReceiver_ExtractTextFragmentsMatches_ParamsSpec.$,
        TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        selectors: !Array<!string>,
   *  }>}
   */

  getExistingSelectors() {
    return this.proxy.sendMessage(
        4,
        TextFragmentReceiver_GetExistingSelectors_ParamsSpec.$,
        TextFragmentReceiver_GetExistingSelectors_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        bounds: !gfx_mojom_Rect,
   *  }>}
   */

  extractFirstFragmentRect() {
    return this.proxy.sendMessage(
        5,
        TextFragmentReceiver_ExtractFirstFragmentRect_ParamsSpec.$,
        TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TextFragmentReceiver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TextFragmentReceiverReceiver {
  /**
   * @param {!TextFragmentReceiverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TextFragmentReceiverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TextFragmentReceiverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextFragmentReceiverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TextFragmentReceiver_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        TextFragmentReceiver_RequestSelector_ParamsSpec.$,
        TextFragmentReceiver_RequestSelector_ResponseParamsSpec.$,
        impl.requestSelector.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        TextFragmentReceiver_RemoveFragments_ParamsSpec.$,
        null,
        impl.removeFragments.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        TextFragmentReceiver_ExtractTextFragmentsMatches_ParamsSpec.$,
        TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParamsSpec.$,
        impl.extractTextFragmentsMatches.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        TextFragmentReceiver_GetExistingSelectors_ParamsSpec.$,
        TextFragmentReceiver_GetExistingSelectors_ResponseParamsSpec.$,
        impl.getExistingSelectors.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        TextFragmentReceiver_ExtractFirstFragmentRect_ParamsSpec.$,
        TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParamsSpec.$,
        impl.extractFirstFragmentRect.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TextFragmentReceiver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.TextFragmentReceiver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TextFragmentReceiverRemote}
   */
  static getRemote() {
    let remote = new TextFragmentReceiverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TextFragmentReceiver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TextFragmentReceiverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TextFragmentReceiverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextFragmentReceiverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TextFragmentReceiver_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestSelector =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TextFragmentReceiver_RequestSelector_ParamsSpec.$,
        TextFragmentReceiver_RequestSelector_ResponseParamsSpec.$,
        this.requestSelector.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeFragments =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        TextFragmentReceiver_RemoveFragments_ParamsSpec.$,
        null,
        this.removeFragments.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.extractTextFragmentsMatches =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        TextFragmentReceiver_ExtractTextFragmentsMatches_ParamsSpec.$,
        TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParamsSpec.$,
        this.extractTextFragmentsMatches.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getExistingSelectors =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        TextFragmentReceiver_GetExistingSelectors_ParamsSpec.$,
        TextFragmentReceiver_GetExistingSelectors_ResponseParamsSpec.$,
        this.getExistingSelectors.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.extractFirstFragmentRect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        TextFragmentReceiver_ExtractFirstFragmentRect_ParamsSpec.$,
        TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParamsSpec.$,
        this.extractFirstFragmentRect.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextFragmentReceiver_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextFragmentReceiver_RequestSelector_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextFragmentReceiver_RequestSelector_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextFragmentReceiver_RemoveFragments_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextFragmentReceiver_ExtractTextFragmentsMatches_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextFragmentReceiver_GetExistingSelectors_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextFragmentReceiver_GetExistingSelectors_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextFragmentReceiver_ExtractFirstFragmentRect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    TextFragmentReceiver_Cancel_ParamsSpec.$,
    'TextFragmentReceiver_Cancel_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class TextFragmentReceiver_Cancel_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    TextFragmentReceiver_RequestSelector_ParamsSpec.$,
    'TextFragmentReceiver_RequestSelector_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class TextFragmentReceiver_RequestSelector_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    TextFragmentReceiver_RequestSelector_ResponseParamsSpec.$,
    'TextFragmentReceiver_RequestSelector_ResponseParams',
    [
      mojo.internal.StructField(
        'selector', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        LinkGenerationErrorSpec.$,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'readyStatus', 12,
        0,
        LinkGenerationReadyStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TextFragmentReceiver_RequestSelector_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.selector;
    /** @type { !LinkGenerationError } */
    this.error;
    /** @type { !LinkGenerationReadyStatus } */
    this.readyStatus;
  }
}



mojo.internal.Struct(
    TextFragmentReceiver_RemoveFragments_ParamsSpec.$,
    'TextFragmentReceiver_RemoveFragments_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class TextFragmentReceiver_RemoveFragments_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    TextFragmentReceiver_ExtractTextFragmentsMatches_ParamsSpec.$,
    'TextFragmentReceiver_ExtractTextFragmentsMatches_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class TextFragmentReceiver_ExtractTextFragmentsMatches_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParamsSpec.$,
    'TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams {
  constructor() {
    /** @type { !Array<!string> } */
    this.text;
  }
}



mojo.internal.Struct(
    TextFragmentReceiver_GetExistingSelectors_ParamsSpec.$,
    'TextFragmentReceiver_GetExistingSelectors_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class TextFragmentReceiver_GetExistingSelectors_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    TextFragmentReceiver_GetExistingSelectors_ResponseParamsSpec.$,
    'TextFragmentReceiver_GetExistingSelectors_ResponseParams',
    [
      mojo.internal.StructField(
        'selectors', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextFragmentReceiver_GetExistingSelectors_ResponseParams {
  constructor() {
    /** @type { !Array<!string> } */
    this.selectors;
  }
}



mojo.internal.Struct(
    TextFragmentReceiver_ExtractFirstFragmentRect_ParamsSpec.$,
    'TextFragmentReceiver_ExtractFirstFragmentRect_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class TextFragmentReceiver_ExtractFirstFragmentRect_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParamsSpec.$,
    'TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams',
    [
      mojo.internal.StructField(
        'bounds', 0,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams {
  constructor() {
    /** @type { !gfx_mojom_Rect } */
    this.bounds;
  }
}

