// third_party/blink/public/mojom/link_to_text/link_to_text.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('gfx.mojom.Rect');




goog.provide('blink.mojom.LinkGenerationReadyStatus');
goog.provide('blink.mojom.LinkGenerationReadyStatusSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.LinkGenerationReadyStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.LinkGenerationReadyStatus = {
  
  kRequestedBeforeReady: 0,
  kRequestedAfterReady: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('blink.mojom.LinkGenerationError');
goog.provide('blink.mojom.LinkGenerationErrorSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.LinkGenerationErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.LinkGenerationError = {
  
  kNone: -1,
  kIncorrectSelector: 0,
  kNoRange: 1,
  kNoContext: 2,
  kContextExhausted: 3,
  kContextLimitReached: 4,
  kEmptySelection: 5,
  kTabHidden: 6,
  kOmniboxNavigation: 7,
  kTabCrash: 8,
  kUnknown: 9,
  kIFrame: 10,
  kTimeout: 11,
  kBlockList: 12,
  kNoRemoteConnection: 13,
  kNotGenerated: 14,
  MIN_VALUE: -1,
  MAX_VALUE: 14,
};



goog.provide('blink.mojom.TextFragmentReceiver');
goog.provide('blink.mojom.TextFragmentReceiverReceiver');
goog.provide('blink.mojom.TextFragmentReceiverCallbackRouter');
goog.provide('blink.mojom.TextFragmentReceiverInterface');
goog.provide('blink.mojom.TextFragmentReceiverRemote');
goog.provide('blink.mojom.TextFragmentReceiverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.TextFragmentReceiverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.TextFragmentReceiver.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.TextFragmentReceiverInterface = class {
  
  /**
   */

  cancel() {}
  
  /**
   * @return {!Promise<{
        selector: !string,
        error: !blink.mojom.LinkGenerationError,
        readyStatus: !blink.mojom.LinkGenerationReadyStatus,
   *  }>}
   */

  requestSelector() {}
  
  /**
   */

  removeFragments() {}
  
  /**
   * @return {!Promise<{
        text: !Array<!string>,
   *  }>}
   */

  extractTextFragmentsMatches() {}
  
  /**
   * @return {!Promise<{
        selectors: !Array<!string>,
   *  }>}
   */

  getExistingSelectors() {}
  
  /**
   * @return {!Promise<{
        bounds: !gfx.mojom.Rect,
   *  }>}
   */

  extractFirstFragmentRect() {}
};

/**
 * @export
 * @implements { blink.mojom.TextFragmentReceiverInterface }
 */
blink.mojom.TextFragmentReceiverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.TextFragmentReceiverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.TextFragmentReceiverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.TextFragmentReceiverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  cancel() {
    this.proxy.sendMessage(
        0,
        blink.mojom.TextFragmentReceiver_Cancel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        selector: !string,
        error: !blink.mojom.LinkGenerationError,
        readyStatus: !blink.mojom.LinkGenerationReadyStatus,
   *  }>}
   */

  requestSelector() {
    return this.proxy.sendMessage(
        1,
        blink.mojom.TextFragmentReceiver_RequestSelector_ParamsSpec.$,
        blink.mojom.TextFragmentReceiver_RequestSelector_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   */

  removeFragments() {
    this.proxy.sendMessage(
        2,
        blink.mojom.TextFragmentReceiver_RemoveFragments_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        text: !Array<!string>,
   *  }>}
   */

  extractTextFragmentsMatches() {
    return this.proxy.sendMessage(
        3,
        blink.mojom.TextFragmentReceiver_ExtractTextFragmentsMatches_ParamsSpec.$,
        blink.mojom.TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        selectors: !Array<!string>,
   *  }>}
   */

  getExistingSelectors() {
    return this.proxy.sendMessage(
        4,
        blink.mojom.TextFragmentReceiver_GetExistingSelectors_ParamsSpec.$,
        blink.mojom.TextFragmentReceiver_GetExistingSelectors_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        bounds: !gfx.mojom.Rect,
   *  }>}
   */

  extractFirstFragmentRect() {
    return this.proxy.sendMessage(
        5,
        blink.mojom.TextFragmentReceiver_ExtractFirstFragmentRect_ParamsSpec.$,
        blink.mojom.TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TextFragmentReceiver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.TextFragmentReceiverReceiver = class {
  /**
   * @param {!blink.mojom.TextFragmentReceiverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.TextFragmentReceiverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.TextFragmentReceiverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.TextFragmentReceiverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.TextFragmentReceiver_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.TextFragmentReceiver_RequestSelector_ParamsSpec.$,
        blink.mojom.TextFragmentReceiver_RequestSelector_ResponseParamsSpec.$,
        impl.requestSelector.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.TextFragmentReceiver_RemoveFragments_ParamsSpec.$,
        null,
        impl.removeFragments.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.TextFragmentReceiver_ExtractTextFragmentsMatches_ParamsSpec.$,
        blink.mojom.TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParamsSpec.$,
        impl.extractTextFragmentsMatches.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.TextFragmentReceiver_GetExistingSelectors_ParamsSpec.$,
        blink.mojom.TextFragmentReceiver_GetExistingSelectors_ResponseParamsSpec.$,
        impl.getExistingSelectors.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.TextFragmentReceiver_ExtractFirstFragmentRect_ParamsSpec.$,
        blink.mojom.TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParamsSpec.$,
        impl.extractFirstFragmentRect.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.TextFragmentReceiver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.TextFragmentReceiver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.TextFragmentReceiverRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.TextFragmentReceiverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TextFragmentReceiver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.TextFragmentReceiverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.TextFragmentReceiverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.TextFragmentReceiverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.TextFragmentReceiver_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestSelector =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.TextFragmentReceiver_RequestSelector_ParamsSpec.$,
        blink.mojom.TextFragmentReceiver_RequestSelector_ResponseParamsSpec.$,
        this.requestSelector.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeFragments =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.TextFragmentReceiver_RemoveFragments_ParamsSpec.$,
        null,
        this.removeFragments.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.extractTextFragmentsMatches =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.TextFragmentReceiver_ExtractTextFragmentsMatches_ParamsSpec.$,
        blink.mojom.TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParamsSpec.$,
        this.extractTextFragmentsMatches.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getExistingSelectors =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.TextFragmentReceiver_GetExistingSelectors_ParamsSpec.$,
        blink.mojom.TextFragmentReceiver_GetExistingSelectors_ResponseParamsSpec.$,
        this.getExistingSelectors.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.extractFirstFragmentRect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.TextFragmentReceiver_ExtractFirstFragmentRect_ParamsSpec.$,
        blink.mojom.TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParamsSpec.$,
        this.extractFirstFragmentRect.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.TextFragmentReceiver_Cancel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextFragmentReceiver_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TextFragmentReceiver_RequestSelector_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextFragmentReceiver_RequestSelector_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TextFragmentReceiver_RequestSelector_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextFragmentReceiver_RequestSelector_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TextFragmentReceiver_RemoveFragments_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextFragmentReceiver_RemoveFragments_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TextFragmentReceiver_ExtractTextFragmentsMatches_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextFragmentReceiver_ExtractTextFragmentsMatches_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TextFragmentReceiver_GetExistingSelectors_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextFragmentReceiver_GetExistingSelectors_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TextFragmentReceiver_GetExistingSelectors_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextFragmentReceiver_GetExistingSelectors_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TextFragmentReceiver_ExtractFirstFragmentRect_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextFragmentReceiver_ExtractFirstFragmentRect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.TextFragmentReceiver_Cancel_ParamsSpec.$,
    'TextFragmentReceiver_Cancel_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.TextFragmentReceiver_Cancel_Params');

/** @record */
blink.mojom.TextFragmentReceiver_Cancel_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.TextFragmentReceiver_RequestSelector_ParamsSpec.$,
    'TextFragmentReceiver_RequestSelector_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.TextFragmentReceiver_RequestSelector_Params');

/** @record */
blink.mojom.TextFragmentReceiver_RequestSelector_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.TextFragmentReceiver_RequestSelector_ResponseParamsSpec.$,
    'TextFragmentReceiver_RequestSelector_ResponseParams',
    [
      mojo.internal.StructField(
        'selector', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        blink.mojom.LinkGenerationErrorSpec.$,
        -1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'readyStatus', 12,
        0,
        blink.mojom.LinkGenerationReadyStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.TextFragmentReceiver_RequestSelector_ResponseParams');

/** @record */
blink.mojom.TextFragmentReceiver_RequestSelector_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.selector;
    /** @export { !blink.mojom.LinkGenerationError } */
    this.error;
    /** @export { !blink.mojom.LinkGenerationReadyStatus } */
    this.readyStatus;
  }
};



mojo.internal.Struct(
    blink.mojom.TextFragmentReceiver_RemoveFragments_ParamsSpec.$,
    'TextFragmentReceiver_RemoveFragments_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.TextFragmentReceiver_RemoveFragments_Params');

/** @record */
blink.mojom.TextFragmentReceiver_RemoveFragments_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.TextFragmentReceiver_ExtractTextFragmentsMatches_ParamsSpec.$,
    'TextFragmentReceiver_ExtractTextFragmentsMatches_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.TextFragmentReceiver_ExtractTextFragmentsMatches_Params');

/** @record */
blink.mojom.TextFragmentReceiver_ExtractTextFragmentsMatches_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParamsSpec.$,
    'TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams');

/** @record */
blink.mojom.TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.text;
  }
};



mojo.internal.Struct(
    blink.mojom.TextFragmentReceiver_GetExistingSelectors_ParamsSpec.$,
    'TextFragmentReceiver_GetExistingSelectors_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.TextFragmentReceiver_GetExistingSelectors_Params');

/** @record */
blink.mojom.TextFragmentReceiver_GetExistingSelectors_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.TextFragmentReceiver_GetExistingSelectors_ResponseParamsSpec.$,
    'TextFragmentReceiver_GetExistingSelectors_ResponseParams',
    [
      mojo.internal.StructField(
        'selectors', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.TextFragmentReceiver_GetExistingSelectors_ResponseParams');

/** @record */
blink.mojom.TextFragmentReceiver_GetExistingSelectors_ResponseParams = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.selectors;
  }
};



mojo.internal.Struct(
    blink.mojom.TextFragmentReceiver_ExtractFirstFragmentRect_ParamsSpec.$,
    'TextFragmentReceiver_ExtractFirstFragmentRect_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.TextFragmentReceiver_ExtractFirstFragmentRect_Params');

/** @record */
blink.mojom.TextFragmentReceiver_ExtractFirstFragmentRect_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParamsSpec.$,
    'TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams',
    [
      mojo.internal.StructField(
        'bounds', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams');

/** @record */
blink.mojom.TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.bounds;
  }
};

