// third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_KEYBOARD_LOCK_KEYBOARD_LOCK_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_KEYBOARD_LOCK_KEYBOARD_LOCK_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class KeyboardLockServiceProxy;

template <typename ImplRefTraits>
class KeyboardLockServiceStub;

class KeyboardLockServiceRequestValidator;
class KeyboardLockServiceResponseValidator;


class BLINK_COMMON_EXPORT KeyboardLockService
    : public KeyboardLockServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.KeyboardLockService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = KeyboardLockServiceInterfaceBase;
  using Proxy_ = KeyboardLockServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = KeyboardLockServiceStub<ImplRefTraits>;

  using RequestValidator_ = KeyboardLockServiceRequestValidator;
  using ResponseValidator_ = KeyboardLockServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestKeyboardLockMinVersion = 0,
    kCancelKeyboardLockMinVersion = 0,
    kGetKeyboardLayoutMapMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestKeyboardLock_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelKeyboardLock_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetKeyboardLayoutMap_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~KeyboardLockService() = default;

  using RequestKeyboardLockCallback = base::OnceCallback<void(KeyboardLockRequestResult)>;
  using RequestKeyboardLockMojoCallback = base::OnceCallback<void(KeyboardLockRequestResult)>;

  virtual void RequestKeyboardLock(const std::vector<std::string>& key_codes, RequestKeyboardLockCallback callback) = 0;

  virtual void CancelKeyboardLock() = 0;

  using GetKeyboardLayoutMapCallback = base::OnceCallback<void(GetKeyboardLayoutMapResultPtr)>;
  using GetKeyboardLayoutMapMojoCallback = base::OnceCallback<void(GetKeyboardLayoutMapResultPtr)>;

  virtual void GetKeyboardLayoutMap(GetKeyboardLayoutMapCallback callback) = 0;
};



class BLINK_COMMON_EXPORT KeyboardLockServiceProxy
    : public KeyboardLockService {
 public:
  using InterfaceType = KeyboardLockService;

  explicit KeyboardLockServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestKeyboardLock(const std::vector<std::string>& key_codes, RequestKeyboardLockCallback callback) final;
  
  void CancelKeyboardLock() final;
  
  void GetKeyboardLayoutMap(GetKeyboardLayoutMapCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT KeyboardLockServiceStubDispatch {
 public:
  static bool Accept(KeyboardLockService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      KeyboardLockService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<KeyboardLockService>>
class KeyboardLockServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  KeyboardLockServiceStub() = default;
  ~KeyboardLockServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return KeyboardLockServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return KeyboardLockServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT KeyboardLockServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT KeyboardLockServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT GetKeyboardLayoutMapResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GetKeyboardLayoutMapResult, T>::value>;
  using DataView = GetKeyboardLayoutMapResultDataView;
  using Data_ = internal::GetKeyboardLayoutMapResult_Data;

  template <typename... Args>
  static GetKeyboardLayoutMapResultPtr New(Args&&... args) {
    return GetKeyboardLayoutMapResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GetKeyboardLayoutMapResultPtr From(const U& u) {
    return mojo::TypeConverter<GetKeyboardLayoutMapResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetKeyboardLayoutMapResult>::Convert(*this);
  }


  GetKeyboardLayoutMapResult();

  GetKeyboardLayoutMapResult(
      GetKeyboardLayoutMapStatus status,
      const base::flat_map<std::string, std::string>& layout_map);


  ~GetKeyboardLayoutMapResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GetKeyboardLayoutMapResultPtr>
  GetKeyboardLayoutMapResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GetKeyboardLayoutMapResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GetKeyboardLayoutMapResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GetKeyboardLayoutMapResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetKeyboardLayoutMapResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetKeyboardLayoutMapResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetKeyboardLayoutMapResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GetKeyboardLayoutMapResult_UnserializedMessageContext<
            UserType, GetKeyboardLayoutMapResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GetKeyboardLayoutMapResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GetKeyboardLayoutMapResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GetKeyboardLayoutMapResult_UnserializedMessageContext<
            UserType, GetKeyboardLayoutMapResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GetKeyboardLayoutMapResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  GetKeyboardLayoutMapStatus status;
  
  base::flat_map<std::string, std::string> layout_map;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GetKeyboardLayoutMapResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GetKeyboardLayoutMapResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GetKeyboardLayoutMapResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GetKeyboardLayoutMapResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
GetKeyboardLayoutMapResultPtr GetKeyboardLayoutMapResult::Clone() const {
  return New(
      mojo::Clone(status),
      mojo::Clone(layout_map)
  );
}

template <typename T, GetKeyboardLayoutMapResult::EnableIfSame<T>*>
bool GetKeyboardLayoutMapResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->layout_map, other_struct.layout_map))
    return false;
  return true;
}

template <typename T, GetKeyboardLayoutMapResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  if (lhs.layout_map < rhs.layout_map)
    return true;
  if (rhs.layout_map < lhs.layout_map)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::GetKeyboardLayoutMapResult::DataView,
                                         ::blink::mojom::GetKeyboardLayoutMapResultPtr> {
  static bool IsNull(const ::blink::mojom::GetKeyboardLayoutMapResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::GetKeyboardLayoutMapResultPtr* output) { output->reset(); }

  static decltype(::blink::mojom::GetKeyboardLayoutMapResult::status) status(
      const ::blink::mojom::GetKeyboardLayoutMapResultPtr& input) {
    return input->status;
  }

  static const decltype(::blink::mojom::GetKeyboardLayoutMapResult::layout_map)& layout_map(
      const ::blink::mojom::GetKeyboardLayoutMapResultPtr& input) {
    return input->layout_map;
  }

  static bool Read(::blink::mojom::GetKeyboardLayoutMapResult::DataView input, ::blink::mojom::GetKeyboardLayoutMapResultPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_KEYBOARD_LOCK_KEYBOARD_LOCK_MOJOM_H_